#include "SkydomeHimmel.h"
#include <osgDB/ReadFile>
osg::ref_ptr<osg::Texture2D> osgCloudyDay::SkydomeHimmel::m_glare=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::SkydomeHimmel::m_transmittance=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::SkydomeHimmel::m_irradiance=0;
osg::ref_ptr<osg::Texture3D> osgCloudyDay::SkydomeHimmel::m_inscatter=0;

osgCloudyDay::SkydomeHimmel::SkydomeHimmel(void) : Skydome()
{
	osg::ref_ptr<osg::Image> img_glare (osgDB::readImageFile("../data/textures/atmosphere/sunglare.bmp"));
	osg::Texture2D* glare_tex = (new osg::Texture2D);
	glare_tex->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP);
	glare_tex->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP);
	glare_tex->setInternalFormat(GL_RGBA8);
	glare_tex->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	glare_tex->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);
	glare_tex->setImage(img_glare.get());
	m_glare = glare_tex;
}


osgCloudyDay::SkydomeHimmel::~SkydomeHimmel(void)
{
}

void osgCloudyDay::SkydomeHimmel::SetupUniform(osg::StateSet* nodess4)
{
	//std::cout << "SETUP Uniform" << std::endl;
	nodess4->addUniform(new osg::Uniform("transmittanceSampler", 9));			
	nodess4->addUniform(new osg::Uniform("skyIrradianceSampler", 10));			
	nodess4->addUniform(new osg::Uniform("inscatterSampler", 11));							
	nodess4->addUniform(new osg::Uniform("glareSampler", 12));	

	nodess4->setTextureAttributeAndModes(9, m_transmittance);		
	nodess4->setTextureAttributeAndModes(10, m_irradiance);		
	nodess4->setTextureAttributeAndModes(11, m_inscatter);		
	nodess4->setTextureAttributeAndModes(12, m_glare);		
	//std::cout << "SETUP Uniform done" << std::endl;
}