#include "Scene.h"
osg::ref_ptr<osg::Camera> osgCloudyDay::Scene::m_LightCamera=0;
osg::ref_ptr<osg::Camera> osgCloudyDay::Scene::m_ViewCamera=0;
osg::ref_ptr<osg::Camera> osgCloudyDay::Scene::m_ViewDepthCamera=0;	
osg::ref_ptr<osg::Camera> osgCloudyDay::Scene::m_ViewCameraDepthOnly=0;	
osgCloudyDay::Skydome* osgCloudyDay::Scene::m_skydome=0;

osg::FrameBufferObject* osgCloudyDay::Scene::fbo_scene_viewer;
osg::FrameBufferObject* osgCloudyDay::Scene::fbo_vert_linear_blur2;
osg::FrameBufferObject* osgCloudyDay::Scene::fbo_hori_linear_blur2;

osg::ref_ptr<osg::Program> osgCloudyDay::Scene::shadowProg;
osg::ref_ptr<osg::Program> osgCloudyDay::Scene::lightningProg;
osg::ref_ptr<osg::Program> osgCloudyDay::Scene::debugProg;

osg::ref_ptr<osg::Texture2D> osgCloudyDay::Scene::fbo_light_texture2;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::Scene::fbo_scene_texture;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::Scene::fbo_goodrays;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::Scene::fbo_scene_depth;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::Scene::fbo_blur_texture;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::Scene::fbo_light_depth;

osg::ref_ptr<osg::Texture2D> osgCloudyDay::Scene::fbo_hud_texture;

int osgCloudyDay::Scene::m_width=800;
int osgCloudyDay::Scene::m_height=600;

osgCloudyDay::Scene::Scene(int width, int height)
{	
	m_width = width;
	m_height = height;

	debugProg  = new osg::Program();
	osg::ref_ptr<osg::Shader> debugvertShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/debug_shad.vert"));
	osg::ref_ptr<osg::Shader> debugfragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/debug_shad.frag"));		
	debugProg->addShader(debugvertShader.get());
	debugProg->addShader(debugfragShader.get());	
	debugProg->addBindFragDataLocation("out_color", 0);
	debugProg->addBindFragDataLocation("out_color2", 1);

	shadowProg  = new osg::Program();
	osg::ref_ptr<osg::Shader> shadowvertShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/shadow.vert"));
	osg::ref_ptr<osg::Shader> shadowfragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/shadow.frag"));		
	shadowProg->addShader(shadowvertShader.get());
	shadowProg->addShader(shadowfragShader.get());	
	shadowProg->addBindFragDataLocation("out_color", 0);


	lightningProg  = new osg::Program();
#ifdef SHADOW_MAPPING
	osg::ref_ptr<osg::Shader> lightningvertShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/lighting.vert"));
	osg::ref_ptr<osg::Shader> lightningfragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/lighting.frag"));
#else
	osg::ref_ptr<osg::Shader> lightningvertShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/lighting_WO_SHAD.vert"));
	osg::ref_ptr<osg::Shader> lightningfragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/lighting_WO_SHAD.frag"));
#endif

	//Binding the box shaders to its program
	lightningProg->addShader(lightningvertShader.get());
	lightningProg->addShader(lightningfragShader.get());	
	lightningProg->addBindFragDataLocation("out_color", 0);
	lightningProg->addBindFragDataLocation("out_color2", 1);
	
	fbo_light_depth = new osg::Texture2D();
	fbo_light_depth->setBorderWidth(0);
	fbo_light_depth->setTextureSize(1024,1024);
	fbo_light_depth->setFilter(osg::Texture::MIN_FILTER, osg::Texture::NEAREST);
	fbo_light_depth->setFilter(osg::Texture::MAG_FILTER, osg::Texture::NEAREST);
	fbo_light_depth->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_light_depth->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);	
	fbo_light_depth->setSourceFormat(GL_DEPTH_COMPONENT);
	fbo_light_depth->setInternalFormat(GL_DEPTH_COMPONENT32F);
	fbo_light_depth->setSourceType(GL_FLOAT);
	//fbo_light_depth->setMaxAnisotropy(8.f);
	//RenderInformation::cloud_depth = fbo_light_depth;

	fbo_light_texture2 = new osg::Texture2D();
	fbo_light_texture2->setBorderWidth(0);
	fbo_light_texture2->setTextureSize(1024,1024);
	fbo_light_texture2->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);
	fbo_light_texture2->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_light_texture2->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_light_texture2->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);	
	fbo_light_texture2->setSourceFormat(GL_RGBA);
	fbo_light_texture2->setInternalFormat(GL_RGBA32F);
	fbo_light_texture2->setSourceType(GL_FLOAT);
	fbo_light_texture2->setMaxAnisotropy(8.f);

	fbo_blur_texture = new osg::Texture2D();
	fbo_blur_texture->setBorderWidth(0);
	fbo_blur_texture->setTextureSize(1024,1024);
	fbo_blur_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::NEAREST);
	fbo_blur_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::NEAREST);
	fbo_blur_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_blur_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_blur_texture->setInternalFormat(GL_RGBA32F);
	fbo_blur_texture->setSourceFormat(GL_RGBA);
	fbo_blur_texture->setSourceType(GL_FLOAT);
	//RenderInformation::blur_texture = fbo_blur_texture;
	
	
	fbo_scene_texture = new osg::Texture2D();
	fbo_scene_texture->setBorderWidth(0);
	fbo_scene_texture->setTextureSize(m_width,m_height);
	fbo_scene_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_scene_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_scene_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_scene_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_scene_texture->setInternalFormat(GL_RGBA32F);
	fbo_scene_texture->setSourceFormat(GL_RGBA);
	fbo_scene_texture->setSourceType(GL_FLOAT);

	fbo_scene_depth = new osg::Texture2D();
	fbo_scene_depth->setBorderWidth(0);
	fbo_scene_depth->setTextureSize(m_width,m_height);
	fbo_scene_depth->setFilter(osg::Texture::MIN_FILTER, osg::Texture::NEAREST);
	fbo_scene_depth->setFilter(osg::Texture::MAG_FILTER, osg::Texture::NEAREST);
	fbo_scene_depth->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_scene_depth->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_scene_depth->setSourceFormat(GL_DEPTH_COMPONENT);
	fbo_scene_depth->setInternalFormat(GL_DEPTH_COMPONENT32F);	
	fbo_scene_depth->setSourceType(GL_FLOAT);	

	fbo_goodrays = new osg::Texture2D();
	fbo_goodrays->setBorderWidth(0);
	fbo_goodrays->setTextureSize(m_width,m_height);
	fbo_goodrays->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_goodrays->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_goodrays->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_goodrays->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_goodrays->setInternalFormat(GL_RGBA);
	fbo_goodrays->setSourceFormat(GL_RGBA);
	fbo_goodrays->setSourceType(GL_FLOAT);


	fbo_hud_texture = new osg::Texture2D();
	fbo_hud_texture->setBorderWidth(0);
	fbo_hud_texture->setTextureSize(m_width,m_height);
	fbo_hud_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::NEAREST);
	fbo_hud_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::NEAREST);
	fbo_hud_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_hud_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_hud_texture->setInternalFormat(GL_RGBA32F/*GL_SRGB8_ALPHA8_EXT*/);
	fbo_hud_texture->setSourceFormat(GL_RGBA);
	fbo_hud_texture->setSourceType(GL_FLOAT);		
	//fbo_hud_texture->setUseHardwareMipMapGeneration(true);

	fbo_scene_viewer = new osg::FrameBufferObject();
	fbo_scene_viewer->setAttachment(osg::Camera::DEPTH_BUFFER, osg::FrameBufferAttachment(Scene::fbo_scene_depth));
	fbo_scene_viewer->setAttachment(osg::Camera::COLOR_BUFFER0, osg::FrameBufferAttachment(Scene::fbo_scene_texture));
	fbo_scene_viewer->setAttachment(osg::Camera::COLOR_BUFFER1, osg::FrameBufferAttachment(Scene::fbo_goodrays));	

	
	fbo_vert_linear_blur2 = new osg::FrameBufferObject();
	fbo_hori_linear_blur2 = new osg::FrameBufferObject();	
#ifdef SHADOW_MAPPING	
	fbo_vert_linear_blur2->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(Scene::fbo_blur_texture));
	fbo_hori_linear_blur2->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(Scene::fbo_light_texture2));
#endif	
	
	////////////////////////////

	CreateViewDepthCamera();
	CreateLightCamera();
}

osgCloudyDay::Scene::~Scene(void)
{
}

int osgCloudyDay::Scene::GetWidth()
{
	return m_width;
}
int osgCloudyDay::Scene::GetHeight()
{
	return m_height;
}

osg::ref_ptr<osg::Texture2D> osgCloudyDay::Scene::GetShadowTexture()
{
	return fbo_light_texture2;
}
osg::ref_ptr<osg::Texture2D> osgCloudyDay::Scene::GetShadowDepthTexture()
{
	return fbo_light_depth;
}

osg::ref_ptr<osg::Texture2D> osgCloudyDay::Scene::GetSceneDepthTexture()
{
	return fbo_scene_depth;
}

osg::ref_ptr<osg::Texture2D> osgCloudyDay::Scene::GetSceneTexture()
{
	return fbo_scene_texture;
}

osg::ref_ptr<osg::Texture2D> osgCloudyDay::Scene::GetGoodRayTexture()
{
	return fbo_goodrays;
}
osg::ref_ptr<osg::Texture2D> osgCloudyDay::Scene::GetHUDTexture()
{
	return fbo_hud_texture;
}

osg::ref_ptr<osg::Texture2D> osgCloudyDay::Scene::GetBlurTexture()
{
	return fbo_blur_texture;
}

osg::ref_ptr<osg::Program> osgCloudyDay::Scene::GetShadowProgram()
{
	return shadowProg;
}

osg::ref_ptr<osg::Program> osgCloudyDay::Scene::GetShadingProgram()
{
	return lightningProg;
}

osg::ref_ptr<osg::Program> osgCloudyDay::Scene::GetDebugProgram()
{
	return debugProg;
}

void osgCloudyDay::Scene::CreateLightCamera()
{
	osg::Vec3 binm = osg::Vec3(0.f, 1.f, 0.f);
	osg::Vec3 dir = osg::Vec3(-100.0f,0,5000.0f);
	binm.normalize();
	osg::Vec3 h = binm^dir;
	h.normalize();

	osg::Matrixd light_view = osg::Matrixd::lookAt(osg::Vec3(-100.0f,0,5000.0f), osg::Vec3(0.0f, 0.0f, 0.f), h);
	osg::Matrixd light_projection = osg::Matrixd::ortho(-10000.f, 10000.f, -10000.f, 10000.f, 1.f, 20000.0f);	
	//osg::Matrix light_view = osg::Matrixd().lookAt(osg::Vec3(2.0, 0.0, 50000.0), osg::Vec3(0.f, 0.f ,0.f), osg::Vec3(0.f, 0.f, 1.f));
	//osg::Matrix light_projection = osg::Matrixd().perspective(10.0, 1.f, 8000.0, 100000.0);	

	osg::ref_ptr<osg::GraphicsContext::Traits> traits2 = new osg::GraphicsContext::Traits;
	traits2->x = 50;
	traits2->y = 50;
	traits2->width = 1024;
	traits2->height = 1024;
	traits2->windowDecoration = true;
	traits2->doubleBuffer = true;
	traits2->sharedContext = 0;

	m_LightCamera = new osg::Camera;
	m_LightCamera->setViewMatrix(light_view);
	m_LightCamera->setProjectionMatrix(light_projection);
	m_LightCamera->setGraphicsContext(osg::GraphicsContext::createGraphicsContext(traits2.get()));
	m_LightCamera->setViewport(new osg::Viewport(0,0, 1024,1024));
	GLenum buffer = traits2->doubleBuffer ? GL_BACK : GL_FRONT;
	m_LightCamera->setDrawBuffer(buffer);
	m_LightCamera->setReadBuffer(buffer);
	m_LightCamera->setClearColor(osg::Vec4(10000.0, 10000.0, 10000.0, 1.0));
	m_LightCamera->setClearDepth(1.0);
	m_LightCamera->setAllowEventFocus(false);
	m_LightCamera->setReferenceFrame(osg::Transform::ABSOLUTE_RF);
	m_LightCamera->setClearMask(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
	m_LightCamera->setRenderOrder(osg::Camera::PRE_RENDER,0);
	m_LightCamera->setComputeNearFarMode( osgUtil::CullVisitor::DO_NOT_COMPUTE_NEAR_FAR );
	m_LightCamera->attach(osg::Camera::DEPTH_BUFFER, Scene::fbo_light_depth);
	m_LightCamera->attach(osg::Camera::COLOR_BUFFER, Scene::fbo_light_texture2);	
	m_LightCamera->setRenderTargetImplementation(osg::Camera::FRAME_BUFFER_OBJECT);
	m_LightCamera->setImplicitBufferAttachmentMask(osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT, osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT);
	m_LightCamera->setCullingActive(false);
	m_LightCamera->getOrCreateStateSet()->setMode(GL_LIGHTING, osg::StateAttribute::OFF);
	m_LightCamera->setUpdateCallback(new CullCallBackViewCamera3);
	
	//RenderInformation::cam_light = m_LightCamera;
}

void osgCloudyDay::Scene::CreateViewDepthCamera()
{
	osg::Matrix view = osg::Matrixd().lookAt(osg::Vec3(20.0f, 500.f, 5000.0f), osg::Vec3(20.0f, 500.f, 5000.0f), osg::Vec3(0.f, 0.f, 1.f));
	osg::Matrix projection = osg::Matrixd().perspective(70.0, (double)(m_width)/(double)(m_height), 1.0, 50000.0);	

	osg::ref_ptr<osg::GraphicsContext::Traits> traits = new osg::GraphicsContext::Traits;
	traits->x = 50;
	traits->y = 50;
	traits->width = m_width;
	traits->height = m_height;
	traits->windowDecoration = true;
	traits->doubleBuffer = true;
	traits->sharedContext = 0;

	osg::ref_ptr<osg::GraphicsContext> gc = osg::GraphicsContext::createGraphicsContext(traits.get());

	m_ViewDepthCamera = new osg::Camera;
	m_ViewDepthCamera->setViewMatrix(view);
	m_ViewDepthCamera->setProjectionMatrix(projection);
	m_ViewDepthCamera->setGraphicsContext(gc.get());
	m_ViewDepthCamera->setViewport(new osg::Viewport(0,0, traits->width, traits->height));
	GLenum buffer = traits->doubleBuffer ? GL_BACK : GL_FRONT;
	m_ViewDepthCamera->setDrawBuffer(buffer);
	m_ViewDepthCamera->setReadBuffer(buffer);
	m_ViewDepthCamera->setClearColor(osg::Vec4(0.0, 0.0, 0.0, 0.0));
	//m_ViewCamera->setAllowEventFocus(false);
	m_ViewDepthCamera->setComputeNearFarMode( osgUtil::CullVisitor::DO_NOT_COMPUTE_NEAR_FAR );
	m_ViewDepthCamera->setReferenceFrame(osg::Transform::ABSOLUTE_RF);
	m_ViewDepthCamera->setClearMask( GL_COLOR_BUFFER_BIT);
	m_ViewDepthCamera->setRenderOrder(osg::Camera::NESTED_RENDER,0);
	m_ViewDepthCamera->attach(osg::Camera::DEPTH_BUFFER, Scene::fbo_scene_depth);
	m_ViewDepthCamera->attach(osg::Camera::COLOR_BUFFER0, Scene::fbo_scene_texture);	
	m_ViewDepthCamera->attach(osg::Camera::COLOR_BUFFER1, Scene::fbo_goodrays);	
	m_ViewDepthCamera->setRenderTargetImplementation(osg::Camera::FRAME_BUFFER_OBJECT);
	m_ViewDepthCamera->setImplicitBufferAttachmentMask(osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT, osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT);
	m_ViewDepthCamera->setUpdateCallback(new CullCallBackViewCamera2);
	m_ViewDepthCamera->setCullCallback(new CullCallBackViewCamera2);
	m_ViewDepthCamera->setCullingActive(false);
}

void osgCloudyDay::Scene::CreateViewCamera()
{
	osg::Matrix view = osg::Matrixd().lookAt(osg::Vec3(20.0f, 500.f, 5000.0f), osg::Vec3(0.f, 500.f ,5000.0f), osg::Vec3(0.f, 0.f, 1.f));
	osg::Matrix projection = osg::Matrixd().perspective(70.0, (double)(m_width)/(double)(m_height), 1.0, 100000.0);	

	osg::ref_ptr<osg::GraphicsContext::Traits> traits = new osg::GraphicsContext::Traits;
	traits->x = 50;
	traits->y = 50;
	traits->width = m_width;
	traits->height = m_height;
	traits->windowDecoration = true;
	traits->doubleBuffer = true;
	traits->sharedContext = 0;

	osg::ref_ptr<osg::GraphicsContext> gc = osg::GraphicsContext::createGraphicsContext(traits.get());

	m_ViewCamera = new osg::Camera;
	m_ViewCamera->setViewMatrix(view);
	m_ViewCamera->setProjectionMatrix(projection);
	m_ViewCamera->setGraphicsContext(gc.get());
	m_ViewCamera->setViewport(new osg::Viewport(0,0, traits->width, traits->height));
	GLenum buffer = traits->doubleBuffer ? GL_BACK : GL_FRONT;
	m_ViewCamera->setAllowEventFocus(false);
	m_ViewCamera->setDrawBuffer(buffer);
	m_ViewCamera->setReadBuffer(buffer);
	m_ViewCamera->setReferenceFrame(osg::Transform::ABSOLUTE_RF);
	m_ViewCamera->setClearColor(osg::Vec4(0.0, 0.0, 0.0, 0.0));
	m_ViewCamera->setAllowEventFocus(false);
	m_ViewCamera->setComputeNearFarMode( osgUtil::CullVisitor::DO_NOT_COMPUTE_NEAR_FAR );
	m_ViewCamera->setRenderOrder(osg::Camera::POST_RENDER,4);
	m_ViewCamera->attach(osg::Camera::DEPTH_BUFFER, Scene::fbo_scene_depth);
	m_ViewCamera->attach(osg::Camera::COLOR_BUFFER0, Scene::fbo_scene_texture);	
	m_ViewCamera->attach(osg::Camera::COLOR_BUFFER1, Scene::fbo_goodrays);	
	m_ViewCamera->setRenderTargetImplementation(osg::Camera::FRAME_BUFFER_OBJECT);
	m_ViewCamera->setClearMask( GL_COLOR_BUFFER_BIT );
	m_ViewCamera->setCullingActive(false);
	m_ViewCamera->setImplicitBufferAttachmentMask(osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT, osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT);
	m_ViewCamera->setUpdateCallback(new CullCallBackViewCamera);
	m_ViewCamera->setCullCallback(new CullCallBackViewCamera6);

	m_ViewCameraDepthOnly = new osg::Camera;
	m_ViewCameraDepthOnly->setViewMatrix(view);
	m_ViewCameraDepthOnly->setProjectionMatrix(projection);
	m_ViewCameraDepthOnly->setGraphicsContext(gc.get());
	m_ViewCameraDepthOnly->setViewport(new osg::Viewport(0,0, traits->width, traits->height));
	m_ViewCameraDepthOnly->setAllowEventFocus(false);
	m_ViewCameraDepthOnly->setDrawBuffer(buffer);
	m_ViewCameraDepthOnly->setReadBuffer(buffer);
	m_ViewCameraDepthOnly->setReferenceFrame(osg::Transform::ABSOLUTE_RF);
	m_ViewCameraDepthOnly->setClearColor(osg::Vec4(0.0, 0.0, 0.0, 0.0));
	m_ViewCameraDepthOnly->setAllowEventFocus(false);
	m_ViewCameraDepthOnly->setComputeNearFarMode( osgUtil::CullVisitor::DO_NOT_COMPUTE_NEAR_FAR );
	m_ViewCameraDepthOnly->setRenderOrder(osg::Camera::PRE_RENDER,1);
	//m_ViewCameraDepthOnly->attach(osg::Camera::COLOR_BUFFER0, Scene::fbo_scene_texture);	
	//m_ViewCameraDepthOnly->attach(osg::Camera::COLOR_BUFFER1, Scene::fbo_goodrays);	
	m_ViewCameraDepthOnly->attach(osg::Camera::DEPTH_BUFFER, Scene::fbo_scene_depth);	
	m_ViewCameraDepthOnly->setRenderTargetImplementation(osg::Camera::FRAME_BUFFER_OBJECT);
	m_ViewCameraDepthOnly->setClearMask(GL_DEPTH_BUFFER_BIT  );
	m_ViewCameraDepthOnly->setCullingActive(false);
	m_ViewCameraDepthOnly->setImplicitBufferAttachmentMask(osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT, osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT);
	m_ViewCameraDepthOnly->setUpdateCallback(new CullCallBackViewCamera4);
	m_ViewCameraDepthOnly->setCullCallback(new CullCallBackViewCamera5);
	
}


osg::Matrix& osgCloudyDay::Scene::GetViewMatrix_View()
{
	return m_ViewDepthCamera->getViewMatrix();
}

/*osg::Matrix& osgCloudyDay::Scene::GetViewMatrix_Light()
{
	return m_LightCamera->getViewMatrix();	
}*/

osg::Matrix& osgCloudyDay::Scene::GetProjectionMatrix_View()
{
	return m_ViewDepthCamera->getProjectionMatrix();
}

osg::Matrix& osgCloudyDay::Scene::GetProjectionMatrix_Light()
{
	return m_LightCamera->getProjectionMatrix();
}

void osgCloudyDay::Scene::SetLightCamera(osg::ref_ptr<osg::Camera> c)
{
	m_LightCamera = c;
}

void osgCloudyDay::Scene::SetViewCamera(osg::ref_ptr<osg::Camera> c)
{
	m_ViewCamera = c;
}

osg::ref_ptr<osg::Camera> osgCloudyDay::Scene::GetLightCamera()
{
	return m_LightCamera;
}

osg::ref_ptr<osg::Camera> osgCloudyDay::Scene::GetViewCamera()
{
	return m_ViewCamera;
}

osg::ref_ptr<osg::Camera> osgCloudyDay::Scene::GetViewCamera2()
{
	return m_ViewCameraDepthOnly;
}

osg::ref_ptr<osg::Camera> osgCloudyDay::Scene::GetViewDepthCamera()
{
	return m_ViewDepthCamera;
}