#include "ReflectionCamera.h"


osgCloudyDay::ReflectionCamera::ReflectionCamera(void) : camera_plane_cubemap(0)
{
}


osgCloudyDay::ReflectionCamera::~ReflectionCamera(void)
{
//	for(int i = 0; i < 6; i++)
//		delete camera_plane_cubemap[i];
	delete[] camera_plane_cubemap;
}

void osgCloudyDay::ReflectionCamera::AddObject(osg::ref_ptr<osg::Geode> geo)
{
	for(int i = 0; i < 6; i++)
	{
		osg::ref_ptr<osg::Geode> athmosphere2(new osg::Geode(*geo, osg::CopyOp::DEEP_COPY_ALL));
		athmosphere2->addCullCallback(new ViewerLightCallbackTest);
		camera_plane_cubemap[i]->addChild(athmosphere2.get());
	}
}

void osgCloudyDay::ReflectionCamera::Initialize()
{
	fbo_plane_cube = new osg::TextureCubeMap();
	fbo_plane_cube->setBorderWidth(0);
	fbo_plane_cube->setTextureSize(128,128);
	fbo_plane_cube->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_plane_cube->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_plane_cube->setWrap(osg::Texture::WRAP_R, osg::Texture::CLAMP_TO_EDGE);
	fbo_plane_cube->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_plane_cube->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);	
	fbo_plane_cube->setInternalFormat(GL_RGBA32F);
	fbo_plane_cube->setSourceFormat(GL_RGBA);
	fbo_plane_cube->setSourceType(GL_FLOAT);		

	fbo_plane_cube_depth = new osg::TextureCubeMap();
	fbo_plane_cube_depth->setBorderWidth(0);
	fbo_plane_cube_depth->setTextureSize(128,128);
	fbo_plane_cube_depth->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_plane_cube_depth->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_plane_cube_depth->setWrap(osg::Texture::WRAP_R, osg::Texture::CLAMP_TO_EDGE);
	fbo_plane_cube_depth->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_plane_cube_depth->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);	
	fbo_plane_cube_depth->setInternalFormat(GL_DEPTH_COMPONENT32F);
	fbo_plane_cube_depth->setSourceFormat(GL_DEPTH_COMPONENT);
	fbo_plane_cube_depth->setSourceType(GL_FLOAT);		

	camera_plane_cubemap = new osg::Camera*[6];		

	osg::ref_ptr<osg::GraphicsContext::Traits> traits3 = new osg::GraphicsContext::Traits;
	traits3->x = 0;
	traits3->y = 0;
	traits3->width = 128;
	traits3->height = 128;
	traits3->windowDecoration = true;
	traits3->doubleBuffer = true;
	traits3->sharedContext = 0;

	GLenum buffer = traits3->doubleBuffer ? GL_BACK : GL_FRONT;

	osg::Vec3 center(0.f, 0.f, 14200.f);

	for(int i = 0; i < 6; i++)
	{
		camera_plane_cubemap[i] = new osg::Camera;
		switch(i)
		{
		case osg::TextureCubeMap::POSITIVE_X:
			camera_plane_cubemap[i]->setViewMatrix(osg::Matrix::lookAt(center, center+osg::Vec3(1.f, 0.f, 0.f), osg::Vec3(0.f,-1.f, 0.f)));
			break;
		case osg::TextureCubeMap::NEGATIVE_X:
			camera_plane_cubemap[i]->setViewMatrix(osg::Matrix::lookAt(center, center+osg::Vec3(-1.f, 0.f, 0.f), osg::Vec3(0.f,-1.f, 0.f)));
			break;
		case osg::TextureCubeMap::POSITIVE_Y:
			camera_plane_cubemap[i]->setViewMatrix(osg::Matrix::lookAt(center, center+osg::Vec3(0.f, 1.f, 0.f), osg::Vec3(0.f, 0.f, 1.f)));
			break;
		case osg::TextureCubeMap::NEGATIVE_Y:
			camera_plane_cubemap[i]->setViewMatrix(osg::Matrix::lookAt(center, center+osg::Vec3(0.f,-1.f, 0.f), osg::Vec3(0.f, 0.f,-1.f)));
			break;
		case osg::TextureCubeMap::POSITIVE_Z:
			camera_plane_cubemap[i]->setViewMatrix(osg::Matrix::lookAt(center, center+osg::Vec3(0.f, 0.f, 1.f), osg::Vec3(0.f, -1.f, 0.f)));
			break;
		case osg::TextureCubeMap::NEGATIVE_Z:
			camera_plane_cubemap[i]->setViewMatrix(osg::Matrix::lookAt(center, center+osg::Vec3(0.f, 0.f, -1.f), osg::Vec3(0.f,-1.f, 0.f)));
			break;
		}
		camera_plane_cubemap[i]->setProjectionMatrix(osg::Matrixd().perspective(90.0, 1.f, 1.0, 500000.0));
		camera_plane_cubemap[i]->setGraphicsContext(osg::GraphicsContext::createGraphicsContext(traits3.get()));
		camera_plane_cubemap[i]->setViewport(new osg::Viewport(0,0, 128, 128));	
		camera_plane_cubemap[i]->setDrawBuffer(buffer);
		camera_plane_cubemap[i]->setReadBuffer(buffer);
		camera_plane_cubemap[i]->setClearColor(osg::Vec4(0.0, 0.0, 0.0, 0.0));		
		camera_plane_cubemap[i]->setAllowEventFocus(false);		
		camera_plane_cubemap[i]->setReferenceFrame(osg::Transform::ABSOLUTE_RF);
		camera_plane_cubemap[i]->setComputeNearFarMode( osgUtil::CullVisitor::DO_NOT_COMPUTE_NEAR_FAR );
		camera_plane_cubemap[i]->setRenderOrder(osg::Camera::PRE_RENDER,3+i);
		camera_plane_cubemap[i]->attach(osg::Camera::DEPTH_BUFFER, fbo_plane_cube_depth, 0, i, true);
		camera_plane_cubemap[i]->attach(osg::Camera::COLOR_BUFFER0, fbo_plane_cube, 0, i, true);	
		//camera_plane_cubemap->attach(osg::Camera::COLOR_BUFFER1, fbo_goodrays);	
		camera_plane_cubemap[i]->setRenderTargetImplementation(osg::Camera::FRAME_BUFFER_OBJECT);
		camera_plane_cubemap[i]->setImplicitBufferAttachmentMask(osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT, osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT);		
		camera_plane_cubemap[i]->setCullingActive(false);
		camera_plane_cubemap[i]->setClearMask(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
	}

}

osg::Camera**& osgCloudyDay::ReflectionCamera::GetCamera()
{
	return camera_plane_cubemap;
}