#include "Rain.h"
#include <osg/BlendFunc>
#include <osg/Depth>
#include <string>
#include <sstream>


osg::ref_ptr<osg::Program> osgCloudyDay::Rain::m_rain_shader=0;
osg::ref_ptr<osg::Texture3D> osgCloudyDay::Rain::m_rain_texture=0;

osgCloudyDay::Rain::Rain(void) : m_geode(0), m_vertices(0), m_velocity(0), m_information(0)
{
}


osgCloudyDay::Rain::~Rain(void)
{
}

osg::ref_ptr<osg::Geode> osgCloudyDay::Rain::GetGeode()
{
	return m_geode;
}

void osgCloudyDay::Rain::CreateShader()
{
	std::cout << "Rain::CreateShader()" << std::endl;
	m_rain_shader = new osg::Program();
	osg::ref_ptr<osg::Shader> cloudvertexShader(osg::Shader::readShaderFile (osg::Shader::VERTEX,		"shaders/rain.vert"));
	osg::ref_ptr<osg::Shader> cloudgeometryShader(osg::Shader::readShaderFile (osg::Shader::GEOMETRY,	"shaders/rain.geom"));
	osg::ref_ptr<osg::Shader> cloudfragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT,		"shaders/rain.frag"));
	m_rain_shader->addShader(cloudvertexShader.get());
	m_rain_shader->addShader(cloudgeometryShader.get());
	m_rain_shader->addShader(cloudfragShader.get());

	m_rain_shader->addBindFragDataLocation("out_color", 0);
	m_rain_shader->addBindFragDataLocation("out_color2", 1);	
}

void osgCloudyDay::Rain::CreateTexture()
{
	std::cout << "Rain::CreateTexture()" << std::endl;

	int n = 0;
	m_rain_texture = (new osg::Texture3D);
	for(int i = 0; i < 9; i++)
	{
		for(int j = 0; j < 9; j++)
		{
			//Bind the image to a 2D texture object
			std::stringstream ss;
			ss << "../data/textures/rain/cv0_v"<<(i+1)*10<<"_h"<<(10+20*j)<<"_osc0.bmp";			
			std::string str = ss.str();
		
			std::cout << "LOAD: " << str << std::endl;
			osg::ref_ptr<osg::Image> img_clouds (osgDB::readImageFile(str.c_str()));
			m_rain_texture->setImage(n,img_clouds.get());
			n++;
		}
	}
		
	m_rain_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	m_rain_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	m_rain_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP);
	m_rain_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP);
	m_rain_texture->setWrap(osg::Texture::WRAP_R, osg::Texture::CLAMP);
	m_rain_texture->setInternalFormat(GL_RGB);	
}

float osgCloudyDay::Rain::frand()
{
	return rand() / (float) RAND_MAX;
}

void osgCloudyDay::Rain::Initialize(RainState* rainstate)
{
	std::cout << "Rain start" << std::endl;

	m_vertices = new osg::Vec3Array();
	m_velocity = new osg::Vec4Array();
	m_information = new osg::Vec4Array();
	m_index.clear();
	for(unsigned int i = 0; i < rainstate->GetNumberOfParticles(); i++)
	{		
		float rnd = frand();
		m_vertices->push_back(osg::Vec3((frand()-0.5f)*rainstate->GetSize().x() + rainstate->GetPosition().x(), (frand()-0.5f)*rainstate->GetSize().y() + rainstate->GetPosition().y(), rnd*rainstate->GetSize().z() + + rainstate->GetPosition().z()));
		m_velocity->push_back(osg::Vec4(rainstate->GetVelocity().x(), rainstate->GetVelocity().y(), rainstate->GetVelocity().z(), rnd));
		m_information->push_back(osg::Vec4(0.f, 0.f, 0.f, 0.f));
		m_index.push_back(i);

		//std::cout << "vertices: " << m_vertices->at(i).x() << " " << m_vertices->at(i).y() << " "  << m_vertices->at(i).z() << std::endl;
	}

	osg::ref_ptr<osg::Geometry> m_geometry(new osg::Geometry());
	//m_geometry->setVertexArray(m_vertices.get());
	m_geometry->setVertexAttribArray(0, m_vertices.get());
	m_geometry->setVertexAttribArray(1, m_velocity.get());
	m_geometry->setVertexAttribArray(2, m_information.get());		

	m_geometry->setVertexAttribBinding(0, osg::Geometry::BIND_PER_VERTEX);
	m_geometry->setVertexAttribBinding(1, osg::Geometry::BIND_PER_VERTEX);
	m_geometry->setVertexAttribBinding(2, osg::Geometry::BIND_PER_VERTEX);	

	m_geometry->addPrimitiveSet(new osg::DrawElementsUInt(osg::PrimitiveSet::POINTS,m_index.size(), &m_index[0]));		
	m_geometry->getPrimitiveSet(m_geometry->getNumPrimitiveSets()-1)->getDrawElements()->setDataVariance(osg::Object::DYNAMIC);		

	m_geometry->setUseDisplayList(false);
	m_geometry->setUseVertexBufferObjects(true);	

	m_geode = new osg::Geode();
	m_geode->addDrawable(m_geometry);
	m_geode->addCullCallback(new RainCallback());
		
	
	osg::CullFace* cull2 = new osg::CullFace();
	cull2->setMode(osg::CullFace::BACK);	

	osg::Depth* depth = new osg::Depth(osg::Depth::LEQUAL, 0.0, 1.0, false);

	osg::ref_ptr<osg::StateSet> nodess = m_geode->getOrCreateStateSet();

	nodess->setAttributeAndModes(cull2, osg::StateAttribute::OFF);	
	nodess->setAttributeAndModes(depth);	

	nodess->addUniform(new osg::Uniform("ModelMatrix", osg::Matrix()));
	nodess->addUniform(new osg::Uniform("ViewMatrix", Scene::GetViewMatrix_View()));
	nodess->addUniform(new osg::Uniform("ProjectionMatrix", Scene::GetProjectionMatrix_View()));		
	nodess->addUniform(new osg::Uniform("light_proj_matrix", Scene::GetProjectionMatrix_Light()));
	nodess->addUniform(new osg::Uniform("light_mv_matrix", Scene::GetLightCamera()->getViewMatrix()));

	nodess->addUniform(new osg::Uniform("rain_tex", 0));
	nodess->setTextureAttributeAndModes(0, m_rain_texture.get());

	osg::BlendFunc* bf = new osg::BlendFunc(osg::BlendFunc::ONE, osg::BlendFunc::ONE_MINUS_SRC_ALPHA);
	nodess->setAttributeAndModes(bf);

	nodess->setAttribute(m_rain_shader.get());
		

	std::cout << "Rain initialized" << std::endl;
}