#include "PostProcess.h"
#include "shaders/common.h"

osgCloudyDay::PostProcess::PostProcess(int hdr_mapping, bool use_avglum, bool bloom, bool star): m_HDRMapping(hdr_mapping), m_use_AVGLuminance(use_avglum), m_bloom(bloom), m_star(star)
{
	renderorder = 7;

	osg::ref_ptr<osg::Image> im3d(osgDB::readImageFile("../data/lud/neutralLUT.bmp"));	
	osg::ref_ptr<osg::Image> im3d2(new osg::Image());	

	im3d2->allocateImage(32,32,32,  im3d->getPixelFormat(),im3d->getDataType());  
	for(int i = 0; i < 32; i++)
	{		
		osg::Image* image_0 = new osg::Image();
		switch(im3d->getPixelFormat())
		{
		case GL_RGB:
			image_0->setImage(32,32,1, im3d->getInternalTextureFormat(), im3d->getPixelFormat(), GL_UNSIGNED_BYTE, (unsigned char*)im3d->getDataPointer()+(3*32*32*i), osg::Image::USE_NEW_DELETE);
			break;
		case GL_RGBA:
			image_0->setImage(32,32,1, im3d->getInternalTextureFormat(), im3d->getPixelFormat(), GL_UNSIGNED_BYTE, (unsigned char*)im3d->getDataPointer()+(4*32*32*i), osg::Image::USE_NEW_DELETE);
			break;
		}
		im3d2->copySubImage(0,0,i,image_0);  
	}
	im3d2->setInternalTextureFormat(im3d->getInternalTextureFormat());

	tex3dlud = new osg::Texture3D(im3d2);
	tex3dlud->setTextureWidth(32);
	tex3dlud->setTextureDepth(32);
	tex3dlud->setTextureHeight(32);
	tex3dlud->setFilter(osg::Texture3D::MIN_FILTER,osg::Texture3D::LINEAR);  
    tex3dlud->setFilter(osg::Texture3D::MAG_FILTER,osg::Texture3D::LINEAR);  
	tex3dlud->setWrap(osg::Texture3D::WRAP_R,osg::Texture3D::CLAMP_TO_EDGE);  
	tex3dlud->setWrap(osg::Texture3D::WRAP_S,osg::Texture3D::CLAMP_TO_EDGE);  
	tex3dlud->setWrap(osg::Texture3D::WRAP_T,osg::Texture3D::CLAMP_TO_EDGE);  
}

osgCloudyDay::PostProcess::~PostProcess(void)
{
}

void osgCloudyDay::PostProcess::AddLUD(std::string path)
{
	osg::ref_ptr<osg::Image> im3d(osgDB::readImageFile(path));	
	osg::ref_ptr<osg::Image> im3d2(new osg::Image());	

	im3d2->allocateImage(32,32,32,  im3d->getPixelFormat(),im3d->getDataType());  
	for(int i = 0; i < 32; i++)
	{		
		osg::Image* image_0 = new osg::Image();
		switch(im3d->getPixelFormat())
		{
		case GL_RGB:
			image_0->setImage(32,32,1, im3d->getInternalTextureFormat(), im3d->getPixelFormat(), GL_UNSIGNED_BYTE, (unsigned char*)im3d->getDataPointer()+(3*32*32*i), osg::Image::USE_NEW_DELETE);
			break;
		case GL_RGBA:
			image_0->setImage(32,32,1, im3d->getInternalTextureFormat(), im3d->getPixelFormat(), GL_UNSIGNED_BYTE, (unsigned char*)im3d->getDataPointer()+(4*32*32*i), osg::Image::USE_NEW_DELETE);
			break;
		}
		im3d2->copySubImage(0,0,i,image_0);  
	}
	im3d2->setInternalTextureFormat(im3d->getInternalTextureFormat());

	m_lods.push_back(new osg::Texture3D(im3d2));
	m_lods[m_lods.size()-1]->setTextureWidth(32);
	m_lods[m_lods.size()-1]->setTextureDepth(32);
	m_lods[m_lods.size()-1]->setTextureHeight(32);
	m_lods[m_lods.size()-1]->setFilter(osg::Texture3D::MIN_FILTER,osg::Texture3D::LINEAR);  
    m_lods[m_lods.size()-1]->setFilter(osg::Texture3D::MAG_FILTER,osg::Texture3D::LINEAR);  
	m_lods[m_lods.size()-1]->setWrap(osg::Texture3D::WRAP_R,osg::Texture3D::CLAMP_TO_EDGE);  
	m_lods[m_lods.size()-1]->setWrap(osg::Texture3D::WRAP_S,osg::Texture3D::CLAMP_TO_EDGE);  
	m_lods[m_lods.size()-1]->setWrap(osg::Texture3D::WRAP_T,osg::Texture3D::CLAMP_TO_EDGE);  
}

void osgCloudyDay::PostProcess::SetupTextures(osg::ref_ptr<osg::StateSet> nodessP)
{
	nodessP->setTextureAttributeAndModes(0,  Scene::GetHUDTexture().get());		
	nodessP->setTextureAttributeAndModes(1,  fbo_glare_texture.get());		
	nodessP->setTextureAttributeAndModes(2,  fbo_blurH1_texture.get());		
	nodessP->setTextureAttributeAndModes(3,  fbo_blurH2_texture.get());		
	nodessP->setTextureAttributeAndModes(4,  fbo_blurH3_texture.get());		
	nodessP->setTextureAttributeAndModes(5,  fbo_blurH4_texture.get());		
	nodessP->setTextureAttributeAndModes(6,  HUD::fbo_lum4_texture.get());		
	nodessP->setTextureAttributeAndModes(7,  fbo_star1_texture.get());		
	nodessP->setTextureAttributeAndModes(8,  fbo_star2_texture.get());		
	nodessP->setTextureAttributeAndModes(9,  fbo_star3_texture.get());		
	nodessP->setTextureAttributeAndModes(10, fbo_star4_texture.get());			
	//nodessP->setTextureAttributeAndModes(11, tex3dlud);	
	nodessP->setTextureAttributeAndModes(11, m_lods[0]);		
	for(unsigned int i = 0; i < m_lods.size(); i++)
	{
		nodessP->setTextureAttributeAndModes(11+i+1, m_lods[i]);
	}
}

void osgCloudyDay::PostProcess::SetupUniform(osg::ref_ptr<osg::StateSet> nodessP)
{
	planeProg =(new osg::Program);
	osg::ref_ptr<osg::Shader> planevertexShader2(new osg::Shader(osg::Shader::VERTEX, GetGLSLVertexShader()));
	osg::ref_ptr<osg::Shader> planefragShader2(new osg::Shader(osg::Shader::FRAGMENT, GetGLSLFragmentShader()));
	
	//Binding the box shaders to its program
	planeProg->addShader(planevertexShader2.get());
	planeProg->addShader(planefragShader2.get());
	planeProg->addBindAttribLocation("vertex", 0);
	planeProg->addBindFragDataLocation("out_color", 0);

	nodessP->setAttribute(planeProg.get());
	nodessP->addUniform(new osg::Uniform("color_tex", 0));
	nodessP->addUniform(new osg::Uniform("glare_tex", 1));
	nodessP->addUniform(new osg::Uniform("glare1_tex", 2));
	nodessP->addUniform(new osg::Uniform("glare2_tex", 3));
	nodessP->addUniform(new osg::Uniform("glare3_tex", 4));
	nodessP->addUniform(new osg::Uniform("glare4_tex", 5));
	nodessP->addUniform(new osg::Uniform("avg_tex", 6));
	nodessP->addUniform(new osg::Uniform("star1_tex", 7));
	nodessP->addUniform(new osg::Uniform("star2_tex", 8));
	nodessP->addUniform(new osg::Uniform("star3_tex", 9));
	nodessP->addUniform(new osg::Uniform("star4_tex", 10));

	nodessP->addUniform(new osg::Uniform("lud_tex", 11));

	nodessP->addUniform(new osg::Uniform("un_width", Scene::GetWidth()));
	nodessP->addUniform(new osg::Uniform("un_height", Scene::GetHeight()));

	

	//AUS IRGENDEINEN GRUND HAT DIE SCHLEIFE ZU NEN FEHLER GEFHRT. IST HALT SEHR SUBOPTIMAL SO, ABER ICH WILL FERTIG WERDEN...
	if(0 < m_lods.size()) nodessP->addUniform(new osg::Uniform("lud_tex0", 12));
	if(1 < m_lods.size()) nodessP->addUniform(new osg::Uniform("lud_tex1", 13));
	if(2 < m_lods.size()) nodessP->addUniform(new osg::Uniform("lud_tex2", 14));
	if(3 < m_lods.size()) nodessP->addUniform(new osg::Uniform("lud_tex3", 15));
	if(4 < m_lods.size()) nodessP->addUniform(new osg::Uniform("lud_tex4", 16));
	if(5 < m_lods.size()) nodessP->addUniform(new osg::Uniform("lud_tex5", 17));
	if(6 < m_lods.size()) nodessP->addUniform(new osg::Uniform("lud_tex6", 18));
	if(7 < m_lods.size()) nodessP->addUniform(new osg::Uniform("lud_tex7", 19));

	/*for(unsigned int i = 0; i < m_lods.size(); i++)
	{		
		std::stringstream ss;
		ss << "lud_tex" << i;
		std::string str = ss.str();

		nodessP->addUniform(new osg::Uniform(str.c_str(), (12+i)));
	}*/

	nodessP->addUniform(new osg::Uniform("ProjectionMatrix", osg::Matrixd()));
	nodessP->addUniform(new osg::Uniform("ModelViewMatrix", osg::Matrixd()));
	nodessP->addUniform(new osg::Uniform("ViewMatrix", osg::Matrixd()));	
	nodessP->addUniform(new osg::Uniform("un_lightPos", Scene::m_skydome->GetLightPosition()));
	//nodessP->setMode(GL_FRAMEBUFFER_SRGB_EXT , osg::StateAttribute::ON); 
}

void osgCloudyDay::PostProcess::CreateCamera()
{
	osg::ref_ptr<osg::GraphicsContext::Traits> traits = new osg::GraphicsContext::Traits;
	traits->x = 20;
	traits->y = 20;
	traits->width = osgCloudyDay::Scene::GetWidth();
	traits->height = osgCloudyDay::Scene::GetHeight();
	traits->windowDecoration = true;
	traits->doubleBuffer = true;
	traits->sharedContext = 0;
	osg::ref_ptr<osg::GraphicsContext> gc = osg::GraphicsContext::createGraphicsContext(traits.get());

	cam_hud = new osg::Camera;
	cam_hud->setViewMatrix(osg::Matrixd().lookAt(osg::Vec3(2.0, 0.0, 0.0), osg::Vec3(0.f, 0.f ,0.f), osg::Vec3(0.f, 0.f, 1.f)));
	cam_hud->setProjectionMatrix(osg::Matrixd().ortho(-0.5f, 0.5f, -0.5f, 0.5f, 1.f, 100.f));
	cam_hud->setGraphicsContext(gc.get());
	cam_hud->setViewport(new osg::Viewport(0,0, traits->width, traits->height));

	GLenum buffer = traits->doubleBuffer ? GL_BACK : GL_FRONT;
	cam_hud->setDrawBuffer(buffer);
	cam_hud->setReadBuffer(buffer);
	cam_hud->setReferenceFrame(osg::Transform::ABSOLUTE_RF);
	cam_hud->setClearMask(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
	cam_hud->setRenderOrder(osg::Camera::POST_RENDER,renderorder+1);
	cam_hud->setAllowEventFocus(false);
	cam_hud->getOrCreateStateSet()->setMode(GL_LIGHTING, osg::StateAttribute::OFF);
}

const std::string osgCloudyDay::PostProcess::GetGLSLFragmentUncharted()
{
	static const std::string source(
		PRAGMA_ONCE(vignette(),				
			"float A = 0.15;\n"
			"float B = 0.50;\n"
			"float C = 0.10;\n"
			"float D = 0.20;\n"
			"float E = 0.02;\n"
			"float F = 0.30;\n"
			"float W = 11.2;\n"
			"\n"
			"vec3 Uncharted2Tonemap(vec3 x)\n"
			"{\n"
			"	return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;\n"
			"}\n"
		));	

	return source;
}

const std::string osgCloudyDay::PostProcess::GetGLSLVertexShader()
{
	static const std::string source(
	PRAGMA_ONCE(const_VertexPostProcessShader,	
	"#version 330 core\n"
	"in vec4 vertex;\n"
	"\n"
	"// vertex-shader output variables (passed to fragment-shader)\n"
	"out vec4 ex_texcoords;\n"
	"\n"
	"void main()\n"
	"{\n"
	"	gl_Position = vertex;\n"
	"	gl_Position.xyz *= vec3(2.0);\n"
	"	gl_Position.w = 1.0;\n"
	"}\n"	
	));

	return source;
}

const std::string osgCloudyDay::PostProcess::GetGLSLFragmentVignetteFunc()
{
	static const std::string source(
		PRAGMA_ONCE(vignette(),				
			"float vignette(vec2 pos, float inner, float outer)\n"
			"{\n"
			"	float r = length(pos);\n"
			"	r = 1.0 - smoothstep(inner, outer, r);\n"
			"	return r;\n"
			"}\n"
		));	

	return source;
}


const std::string osgCloudyDay::PostProcess::GetGLSLFragmentMainFunc()
{
	static const std::string source(
		PRAGMA_ONCE(postprocessmain(),				
			"void main()\n"
			"{ \n"
			"	vec2 texCoord = gl_FragCoord.st / vec2(float(un_width), float(un_height));\n"
			"	vec4 helper = texture(color_tex, texCoord);	\n"
			));
	return source;
}

const std::string osgCloudyDay::PostProcess::GetGLSLFragmentHeader()
{
	static const std::string source(
		PRAGMA_ONCE(const_FragmentPostProcessShaderHeader,	
			"#version 330 core\n"
			"\n"
			"out vec4 out_color;\n"
			"\n"
			"uniform mat4 ModelViewMatrix;\n"
			"uniform mat4 ViewMatrix;\n"
			"uniform mat4 ProjectionMatrix;\n"
			"\n"
			"uniform sampler2D color_tex;\n"
			"uniform sampler2D glare_tex;\n"
			"uniform sampler2D glare1_tex;\n"
			"uniform sampler2D glare2_tex;\n"
			"uniform sampler2D glare3_tex;\n"
			"uniform sampler2D glare4_tex;\n"
			"uniform sampler2D avg_tex;\n"	
			"uniform sampler2D star1_tex;\n"
			"uniform sampler2D star2_tex;\n"
			"uniform sampler2D star3_tex;\n"
			"uniform sampler2D star4_tex;\n"
			"uniform int un_width;\n"
			"uniform int un_height;\n"
			));

	return source;
}


const std::string osgCloudyDay::PostProcess::GetHDRMapping()
{
	switch(m_HDRMapping)
	{
	case HDRM_Linear:
	{
		static const std::string source(
		PRAGMA_ONCE(HDR_Linear,				
			//"	vec4 avg4 = textureLod(color_tex, texCoord, 10.0);"
			"	vec4 avg4 = texture(avg_tex, texCoord);"			
			"	float avg = exp(avg4.w);\n"
			"	float act =  (helper.r*0.2126 + helper.g*0.7152 + helper.b*0.0722);\n"
			"	float l_scaled = act/avg*0.50;//*max(0.1, 1.5- 1.5/(avg*0.1+1.0));\n"
			"	helper *=  1.0*l_scaled / l_scaled;\n"
			));
		return source;		
	}
	case HDRM_Reinhard:
	{
		static const std::string source(
		PRAGMA_ONCE(HDR_Reinhard,				
			//"	vec4 avg4 = (textureLod(color_tex, vec2(0.25,0.25), 9.0) + textureLod(color_tex, vec2(0.75,0.25), 9.0) + textureLod(color_tex, vec2(0.25,0.75), 9.0) + textureLod(color_tex, vec2(0.75,0.75), 9.0)) /4.0;"
			"	vec4 avg4 = texture(avg_tex, texCoord);"			
			"	float avg = exp(avg4.w);\n"
			"	float act =  (helper.r*0.2126 + helper.g*0.7152 + helper.b*0.0722);\n"
			"	float l_scaled = act/avg*(max(0.0, 1.5- 1.5/(avg*0.1+1.0))+0.1);\n"
			"	helper *=  l_scaled / (l_scaled+1.0);\n"
			//"   if(texCoord.x > 0.8) helper = vec4(avg4.w); \n"
			));
		return source;
	}
	case HDRM_ReinhardModified:
	{
		static const std::string source(
		PRAGMA_ONCE(HDR_ReinhardModified,				
			//"	vec4 avg4 = (textureLod(color_tex, vec2(0.25,0.25), 9.0) + textureLod(color_tex, vec2(0.75,0.25), 9.0) + textureLod(color_tex, vec2(0.25,0.75), 9.0) + textureLod(color_tex, vec2(0.75,0.75), 9.0)) /4.0;"
			"	vec4 avg4 = texture(avg_tex, texCoord);"			
			"	float avg = exp(avg4.w);\n"
			"	float act =  (helper.r*0.2126 + helper.g*0.7152 + helper.b*0.0722);\n"
			"	float l_scaled = act/avg*(max(0.0, 1.5- 1.5/(avg*0.1+1.0))+0.1);\n"
			"	helper *= (l_scaled*(1.0+l_scaled/pow(2.5,2.0)))/(l_scaled+1.0);\n"
			//"   if(texCoord.x > 0.8) helper = vec4(avg4.w); \n"
			));
		return source;
	}
	case HDRM_Uncharted:
	{
		static const std::string source(
		PRAGMA_ONCE(HDR_Uncharted,	
			//"	vec4 avg4 = textureLod(color_tex, texCoord, 10.0);"
			"	vec4 avg4 = texture(avg_tex, texCoord);"			
			"	float avg = exp(avg4.w);\n"
			"	float act =  (helper.r*0.2126 + helper.g*0.7152 + helper.b*0.0722);\n"
			"	float l_scaled = act/avg*max(0.1, 1.5- 1.5/(avg*0.1+1.0));\n"
			"   float ExposureBias = 2.0;\n"
			/*"	vec3 curr = Uncharted2Tonemap(ExposureBias*helper.xyz*1.0); */
			"	vec3 curr = Uncharted2Tonemap(ExposureBias*vec3(l_scaled)*1.0);\n"
			"	vec3 whiteScale = vec3(1.0)/Uncharted2Tonemap(vec3(W, W, W));\n"
			"	helper.xyz *= curr.x*whiteScale.x;\n"		
			));
		return source;
	}
	}	

	static const std::string source(
		PRAGMA_ONCE(HDR_Linear,				
			));
	return source;
}

const std::string osgCloudyDay::PostProcess::GetGlare()
{
	if(m_bloom || m_star)
	{
		if(m_bloom && m_star)
		{		
			static const std::string source(
				PRAGMA_ONCE(AssignGlare,	
					"	vec4 glare	=  texture(glare1_tex, texCoord) \n"
					"				+  texture(glare2_tex, texCoord) \n"
					"				+  texture(glare3_tex, texCoord) \n"
					"				+  texture(glare4_tex, texCoord);\n"
					"	helper.xyz += vec3(glare.y);\n"						
					"	vec4 star	=  texture(star1_tex, texCoord) \n"
					"				+  texture(star2_tex, texCoord) \n"
					"				+  texture(star3_tex, texCoord) \n"
					"				+  texture(star4_tex, texCoord);\n"				
					"	helper.xyz += vec3(star.y);\n"
					));
			return source;
		}
		else if(m_bloom)
		{
			static const std::string source(
				PRAGMA_ONCE(AssignGlare,	
					"	vec4 glare	=  texture(glare1_tex, texCoord) \n"
					"				+  texture(glare2_tex, texCoord) \n"
					"				+  texture(glare3_tex, texCoord) \n"
					"				+  texture(glare4_tex, texCoord);\n"
					"	helper.xyz += vec3(glare.y);\n"											
					));
			return source;
		}
		else
		{		
			static const std::string source(
				PRAGMA_ONCE(AssignGlare,						
					"	vec4 star	=  texture(star1_tex, texCoord) \n"
					"				+  texture(star2_tex, texCoord) \n"
					"				+  texture(star3_tex, texCoord) \n"
					"				+  texture(star4_tex, texCoord);\n"				
					"	helper.xyz += vec3(star.y);\n"
					));
			return source;
		}
	}	

	static const std::string source(
		PRAGMA_ONCE(AssignGlare,					
			"	\n"
			));
	return source;	
}

const std::string osgCloudyDay::PostProcess::GetVignette()
{
	if(m_use_vignette)
	{
		static const std::string source(
			PRAGMA_ONCE(AssignVignette,	
				"\n" 
				//"	helper.xyz *= vignette(texCoord*2-1, 0.7, 1.5);	 \n"				
				));
		return source;
	}	

	static const std::string source(
		PRAGMA_ONCE(AssignGlare,					
			"	\n"
			));
	return source;	
}

const std::string osgCloudyDay::PostProcess::GetSRGB()
{	
	static const std::string source(
		PRAGMA_ONCE(AssignSRGB,					
			"	helper.xyz = pow(helper.xyz,vec3(1.0/2.2));	//LUT darf nicht gamma sein.\n"
			"	helper.xyz = clamp(helper.xyz,vec3(0.0), vec3(1.0));\n"				
			));
	return source;	
}

const std::string osgCloudyDay::PostProcess::GetGLSLUniformLUD()
{
	std::string uniforms="";
	for(unsigned int i = 0; i < m_lods.size(); i++)
	{		
		std::stringstream ss;
		ss << i;
		std::string str = ss.str();
		uniforms = uniforms + "uniform sampler3D lud_tex"+str+"; \n";		
	}
	uniforms = uniforms + "uniform sampler3D lud_tex; \n";
	static const std::string source(uniforms);	
	return source;
}

const std::string osgCloudyDay::PostProcess::GetGLSLAssignLUD()
{	

	std::string code  = "";
	code =		"	vec3 h = helper.xyz;\n";
	code +=		"	h.x = h.x*(1.0-1.0/(2.0*32.0) - (1.0/(2.0*32.0)))+ (1.0/(2.0*32.0));\n";
	code +=		"	h.y = h.y*(1.0-1.0/(2.0*32.0) - (1.0/(2.0*32.0)))+ (1.0/(2.0*32.0));\n";
	code +=		"	h.z = h.z*(1.0-1.0/(2.0*32.0) - (1.0/(2.0*32.0)))+ (1.0/(2.0*32.0));\n";
	code +=		"	vec4 tmp=vec4(0.0);";

	if(m_lods.size() > 0)
	{
		code +=		"int value = int(floor(texture(glare_tex, texCoord).x+0.5));\n";
	}

	
	for(unsigned int i = 0; i < m_lods.size(); i++)
	{		
		std::stringstream ss;
		ss << i;
		std::string str = ss.str();

		if(i > 0)	code +=		"else ";
		
		code +=		"if(value <= " + str + "){\n";
		code +=		"	tmp = texture(lud_tex" + str + ", h.rgb);\n";	
		code +=		"}\n";
	}
	if(m_lods.size() > 0)	code +=		"	else{\n";
	
	code +=		"	tmp = texture(lud_tex, h.rgb);\n";
	
	if(m_lods.size() > 0)	code +=		"	}\n";	
	
	code +=		"	helper.rgb = tmp.rgb;\n";

	static const std::string source(code);	
	return source;
}

const std::string osgCloudyDay::PostProcess::GetGLSLFragmentShader()
{
	num_lods = 1+m_lods.size();
	static const std::string source(
		GetGLSLFragmentHeader()
	+	GetGLSLUniformLUD()
	+	GetGLSLFragmentUncharted()
	+	GetGLSLFragmentVignetteFunc()
	+	GetGLSLFragmentMainFunc()	
	+	GetGlare()
	+	GetHDRMapping()		
	+	GetVignette()
	+	GetSRGB()
	+	GetGLSLAssignLUD()
	+	PRAGMA_ONCE(AssignFragmentEnd,			
		"	out_color.xyz = helper.xyz;\n"
		"	out_color.w = 1.0;\n"	
		"	//if( texCoord.x < 0.24)		out_color.xyz = glare.xyz;\n"
		"}\n"
		)
	);
	
	return source;
}