#include "PerlinNoiseCloud.h"


osgCloudyDay::PerlinNoiseCloud::PerlinNoiseCloud(void)
{
	Initialize();
}


osgCloudyDay::PerlinNoiseCloud::~PerlinNoiseCloud(void)
{
}

void osgCloudyDay::PerlinNoiseCloud::Initialize()
{
	//std::cout << "SET GEOMETRY" << std::endl;
	SetGeometry();

	//std::cout << "SET TEXTURE" << std::endl;
	osg::Image* perlinImg = new osg::Image();
	osg::Image* perlinNormalImg = new osg::Image();
	CreatePerlinTexture2D(32*8,32*8, perlinImg, perlinNormalImg);
	/*/

	osg::Image* perlinImg  = osgDB::readImageFile( "../data/textures/cloud2d/Clouds_Perlin_Turbulence.bmp" );
	osg::Image* perlinNormalImg  = osgDB::readImageFile( "../data/textures/cloud2d/Clouds_Perlin_Turbulence_Normal.bmp" );
	//*/
	
	Create(geode, perlinImg, perlinNormalImg);

	//std::cout << "READY" << std::endl;
}

void osgCloudyDay::PerlinNoiseCloud::SetupGeometry(osg::Vec3 position, osg::Vec2 size, osg::Vec3Array* coords, osg::Vec2Array* tcoords, osg::UIntArray* indices)
{
	float Size = size.x();

	osg::Vec2 offset = osg::Vec2(70.f*PI/180.f, 70.f*PI/180.f);		
	float scale = 40.f*PI/180.f;
	float r = Size*2.f;
	float tex_scale = 1.f;
		
	for(int t = 0; t < 100; t++)
	{				
		float tf = (float)(t)/100.f;

		for(int s = 0; s < 100; s++)
		{			
			float sf = (float)(s)/100.f;				
				
			coords->at(t*100+s) = osg::Vec3(r*sinf(sf*scale+offset.x())*cosf(tf*scale+offset.y())*3.f, 
											r*cosf(sf*scale+offset.x())*3.f,
											r*sinf(sf*scale+offset.x())*sinf(tf*scale+offset.y()) 
												) 
												+ osg::Vec3(0.f, 0.f, -r/1.35f)
												+ position;
			tcoords->at(t*100+s) = (osg::Vec2(sf*tex_scale, tf*tex_scale));

			if(t > 0 && s > 0)
			{
				indices->at( (6*(t-1)*99)+((s-1)*6)+0) = ((s-1)+((t-1)*100));
				indices->at( (6*(t-1)*99)+((s-1)*6)+1) = (s+((t-1)*100));
				indices->at( (6*(t-1)*99)+((s-1)*6)+2) = (s+(t*100));

				indices->at( (6*(t-1)*99)+((s-1)*6)+3) = ((s-1)+((t-1)*100));
				indices->at( (6*(t-1)*99)+((s-1)*6)+4) = (s+(t*100));
				indices->at( (6*(t-1)*99)+((s-1)*6)+5) = ((s-1)+(t*100));
			}
		}
	}
}

long HexToLong(std::string s)
{
    char * p;
    long n = strtol( s.c_str(), & p, 16 );
    if ( * p != 0 )	return 0;    
    else	return n;
    
}

float osgCloudyDay::PerlinNoiseCloud::Noise(int x, int y)
{
	/*int random = rand() % 5000;

	int n = x + y * 57 + random * 131;
    n = (n<<13) ^ n;
    return (1.0f - ( (n * (n * n * 15731 + 789221) +
            1376312589)&0x7fffffff)* 0.000000000931322574615478515625f);	
	/*/
	float r = (float)rand() / (float) RAND_MAX;

	return r*2.f-1.f;//*/
}

float osgCloudyDay::PerlinNoiseCloud::SmoothedNoise(float x, float y)
{
    float corners = ( Noise(x-1.f, y-1.f)+Noise(x+1.f, y-1.f)+Noise(x-1.f, y+1.f)+Noise(x+1.f, y+1.f) ) / 16.f;
    float sides   = ( Noise(x-1.f, y)  +Noise(x+1.f, y)  +Noise(x, y-1.f)  +Noise(x, y+1.f) ) /  8.f;
    float center  =  Noise(x, y) / 4.f;
    return corners + sides + center;
 }

float osgCloudyDay::PerlinNoiseCloud::Cosine_Interpolate(float a, float b, float x)
{
	float ft = x * 3.1415927f;
	float f = (1.f - cosf(ft)) * .5f;

	return  a*(1.f-f) + b*f;
}

float osgCloudyDay::PerlinNoiseCloud::InterpolatedNoise(float x, float y)
{
      int integer_X    = int(x);
      float fractional_X = x - (float)(integer_X);

      int integer_Y    = int(y);
      float fractional_Y = y - (float)(integer_Y);

      float v1 = SmoothedNoise(integer_X,     integer_Y);
      float v2 = SmoothedNoise(integer_X + 1, integer_Y);
      float v3 = SmoothedNoise(integer_X,     integer_Y + 1);
      float v4 = SmoothedNoise(integer_X + 1, integer_Y + 1);

      float i1 = Cosine_Interpolate(v1 , v2 , fractional_X);
      float i2 = Cosine_Interpolate(v3 , v4 , fractional_X);

      return Cosine_Interpolate(i1 , i2 , fractional_Y);
}

float osgCloudyDay::PerlinNoiseCloud::PerlinNoise(float x, float y)
{
	int Number_Of_Octaves = 8;
	float persistence = 1.f/sqrt(2.f);
	//persistence = 0.25f;

    float total = 0.f;
    for(int i = 0; i < Number_Of_Octaves; i++)
	{
		float frequency = powf(2.f, i);
		float amplitude = powf(persistence, i);

		total = total + InterpolatedNoise(x * frequency, y * frequency) * amplitude;
	}

	return total;
}

float CloudExpCurve(float v)
{
	float CloudCover = 0.5f;
	float CloudSharpness = 0.1f;

#if 0
	float c = v - CloudCover;
	if(c < 0.f) c=0.f;
	float CloudDensity = 1.f - (powf(CloudSharpness,c));
#else
	float CloudDensity = 1.f - exp(-(v - CloudCover) * CloudSharpness);
	if(CloudDensity < 0.f) CloudDensity=0.f;
#endif

	return CloudDensity;
}

#if 0
void PerlinNoiseCloud::CreatePerlinTexture2D(int width, int height, osg::Image* color, osg::Image* normal)
{		
	int length=1; 

	float* fdata = new float[width*height];
	unsigned int* data = new unsigned int[width*height];
	unsigned int* data2 = new unsigned int[width*height*3];	

	float minp =  999999.f;
	float maxp = -999999.f;

	for(int y = 0; y < height; y++)	
		for(int x = 0; x < width; x++)
		{
			float p = PerlinNoise((float)x/(float)width, (float)y/(float)height);

			fdata[(y*width+x)] = p;

			if(p < minp) minp = p;
			if(p > maxp) maxp = p;
		}

	for(int y = 0; y < height; y++)
		for(int x = 0; x < width; x++)
		{
			float p = fdata[(y*width+x)];
			p = (p-minp)/(maxp-minp);

			p = CloudExpCurve(p);
			fdata[(y*width+x)] = p;	

			if(p < minp) minp = p;
			if(p > maxp) maxp = p;
		}

	minp =  999999.f;
	maxp = -999999.f;
	for(int y = 0; y < height; y++)	
		for(int x = 0; x < width; x++)
		{
			float p = fdata[(y*width+x)];
			p = (p-minp)/(maxp-minp);
			data[y*width + x] = p*255;						
		}
	

	//Create NormalMap
	float* du = new float[width*height];
	float* dv = new float[width*height];

	float* kernel1 = new float[3*3];
	kernel1[(0*3)+0] = 0.f;	kernel1[(0*3)+1] = 0.f;	kernel1[(0*3)+2] = 0.f;
	kernel1[(1*3)+0] =-1.f;	kernel1[(1*3)+1] = 0.f;	kernel1[(1*3)+2] = 1.f;
	kernel1[(2*3)+0] = 0.f;	kernel1[(2*3)+1] = 0.f;	kernel1[(2*3)+2] = 0.f;
	float* kernel2 = new float[3*3];
	kernel2[(0*3)+0] = 0.f;	kernel2[(0*3)+1] =-1.f;	kernel2[(0*3)+2] = 0.f;
	kernel2[(1*3)+0] = 0.f;	kernel2[(1*3)+1] = 0.f;	kernel2[(1*3)+2] = 0.f;
	kernel2[(2*3)+0] = 0.f;	kernel2[(2*3)+1] = 1.f;	kernel2[(2*3)+2] = 0.f;

	for(int y = 1; y < height-1; y++)
	{
		for(int x = 1; x < width-1; x++)
		{
			du[y*height+x] = 0.f;
			dv[y*height+x] = 0.f;

			for(int y1 = -1; y1 < 1; y1++)
			{
				for(int x1 = -1; x1 < 1; x1++)
				{
					du[y*height+x] += fdata[(y+y1)*height+(x+x1)] * kernel1[y1*3+x1];
					dv[y*height+x] += fdata[(y+y1)*height+(x+x1)] * kernel2[y1*3+x1];
				}
			}
		}
	}	

	float* normalmap = new float[width*height*3];
	for(int y = 0; y < height; y++)	
		for(int x = 0; x < width; x++)	
			for(int i = 0; i < 3; i++)	
				normalmap[(height*y*3)+ (x*3) + i] = 0.f;			

	for(int y = 1; y < height-1; y++)
	{
		for(int x = 1; x < width-1; x++)
		{
			float norm_factor = sqrt(powf(du[(height*y)+x],2.f) + 
									 powf(dv[(height*y)+x],2.f) + 
									 1.f);

			normalmap[(height*y*3)+ (x*3) + 0] = du[(height*y)+x]/norm_factor;
			normalmap[(height*y*3)+ (x*3) + 1] = dv[(height*y)+x]/norm_factor;
			normalmap[(height*y*3)+ (x*3) + 2] = 1.f			 /norm_factor;
		}
	}

	for(int y = 1; y < height-1; y++)	
		for(int x = 1; x < width-1; x++)		
			for(int i = 0; i < 3; i++)			
				normalmap[(height*y*3)+ (x*3) + i] = (normalmap[(height*y*3)+ (x*3) + i]+1.f)/2.f;
			
	for(int y = 0; y < height; y++)	
		for(int x = 0; x < width; x++)		
			for(int i = 0; i < 3; i++)			
				data2[y*width*3 + x*3 + i] = normalmap[(y*width*3+x*3+i)]*255;							

	delete[] fdata;
	delete[] normalmap;
	delete[] du;
	delete[] dv;
	
	color->allocateImage(width, height, 1,  GL_LUMINANCE, GL_UNSIGNED_INT); 
	color->setOrigin(osg::Image::BOTTOM_LEFT);
	color->setImage(width, height, 1, GL_LUMINANCE,GL_LUMINANCE,GL_UNSIGNED_INT, (unsigned char*)data,osg::Image::NO_DELETE); 

	normal->allocateImage(width, height, 1,  GL_RGB, GL_UNSIGNED_INT); 
	normal->setOrigin(osg::Image::BOTTOM_LEFT);
	normal->setImage(width, height, 1, GL_RGB,GL_RGB,GL_UNSIGNED_INT, (unsigned char*)data2,osg::Image::NO_DELETE); 

	delete[] data;
	delete[] data2;
}
#else

void osgCloudyDay::PerlinNoiseCloud::SetNoise(float  *map)
{
	float temp[34][34];
	for (int y=1; y<33; y++) 
	{
		for (int x=1; x<33; x++)
		{
			temp[x][y] = 128.0f + Noise(x,  y)*128.0f;
		}
	}

	for (int x=1; x<33; x++)
	{
		temp[0][x] = temp[32][x];
		temp[33][x] = temp[1][x];
		temp[x][0] = temp[x][32];
		temp[x][33] = temp[x][1];
	}

	temp[0][0] = temp[32][32];
	temp[33][33] = temp[1][1];
	temp[0][33] = temp[32][1];
	temp[33][0] = temp[1][32];

	for (int y=1; y<33; y++)
	{
	    for (int x=1; x<33; x++)
		{
			float center = temp[x][y]/4.0f;
			float sides = (temp[x+1][y] + temp[x-1][y] + temp[x][y+1] + temp[x][y-1])/8.0f;
			float corners = (temp[x+1][y+1] + temp[x+1][y-1] + temp[x-1][y+1] + temp[x-1][y-1])/16.0f;

			map[((x-1)*32) + (y-1)] = center + sides + corners;
		}
	}
}

float Interpolate(float x, float y, float  *map)
{
	int Xint = (int)x;
	int Yint = (int)y;

	float Xfrac = x - Xint;
	float Yfrac = y - Yint;

	int X0 = Xint % 32;
	int Y0 = Yint % 32;
	int X1 = (Xint + 1) % 32;
	int Y1 = (Yint + 1) % 32;

	float bot = map[X0*32 + Y0] + Xfrac * (map[X1*32 + Y0] - map[X0*32 + Y0]);
	float top = map[X0*32 + Y1] + Xfrac * (map[X1*32 +  Y1] - map[X0*32 + Y1]);

	return (bot + Yfrac * (top - bot));
}

void OverlapOctaves(float  *map32, float  *map256, int width, int height)
{
	for (int x=0; x<width*height; x++) map256[x] = 0.f;
	
	for (int octave=0; octave<4; octave++)
	{
		for (int x=0; x<width; x++)
		{
			for (int y=0; y<height; y++)
			{
				float scale = 1.f / powf(2.f, 3.f-(float)octave);
				float noise = Interpolate(x*scale, y*scale , map32);
				map256[(y*width) + x] += noise / powf(2.f, (float)octave);
			}
		}
	}
}

void ExpFilter(float  *map, int width, int height)
{
	float cover = 25.0f;
	float sharpness = 0.95f;

	for (int x=0; x < (width*height); x++)
	{
		float c = map[x] - (255.0f-cover);
		if (c<0.0f)  c = 0.0f;
		map[x] = 1.0f - ((float)(pow(sharpness, c)));
		map[x] *= 255.0f;
	}
}

void osgCloudyDay::PerlinNoiseCloud::CreatePerlinTexture2D(int width, int height, osg::Image* color, osg::Image* normal)
{				
	width = 256;
	height = 256;

	float* map32 = new float[32 * 32];
	float* fdata = new float[width * height];
	
	SetNoise(map32);	
	OverlapOctaves(map32, fdata, width, height);
	delete[] map32;	
	ExpFilter(fdata, width, height);	
	for(int i = 0; i < width*height; i++)	fdata[i] = fdata[i]/256.f;


	//Create NormalMap	
	float* du = new float[width*height];
	float* dv = new float[width*height];
	for(int i = 0; i < height*width; i++)
		du[i] = dv[i] = 0.f;	

	float* normalmap = new float[width*height*3];
	for(int i = 0; i < height*width*3; i++)		
		normalmap[i] = 0.f;			

	float* kernel1 = new float[3*3];
	float* kernel2 = new float[3*3];
	kernel1[(0*3)+0] =-1.f;	kernel1[(0*3)+1] =-2.f;	kernel1[(0*3)+2] =-1.f;
	kernel1[(1*3)+0] = 0.f;	kernel1[(1*3)+1] = 0.f;	kernel1[(1*3)+2] = 0.f;
	kernel1[(2*3)+0] = 1.f;	kernel1[(2*3)+1] = 2.f;	kernel1[(2*3)+2] = 1.f;	

	kernel2[(0*3)+0] = kernel1[(0*3)+0];	kernel2[(0*3)+1] = kernel1[(1*3)+0];	kernel2[(0*3)+2] = kernel1[(2*3)+0];
	kernel2[(1*3)+0] = kernel1[(0*3)+1];	kernel2[(1*3)+1] = kernel1[(1*3)+1];	kernel2[(1*3)+2] = kernel1[(2*3)+1];
	kernel2[(2*3)+0] = kernel1[(0*3)+2];	kernel2[(2*3)+1] = kernel1[(1*3)+2];	kernel2[(2*3)+2] = kernel1[(2*3)+2];

	for(int y = 1; y < height-1; y++)
	{
		for(int x = 1; x < width-1; x++)
		{			
			for(int y1 = -1; y1 <= 1; y1++)
			{
				for(int x1 = -1; x1 <= 1; x1++)
				{
					du[(y*height)+x] += (fdata[((y+y1)*height)+(x+x1)]) * 0.5f * kernel1[(y1*3)+x1 +4];
					dv[(y*height)+x] += (fdata[((y+y1)*height)+(x+x1)]) * 0.5f * kernel2[(y1*3)+x1 +4];					
				}
			}

			du[(y*height)+x] = (du[(y*height)+x]);
			dv[(y*height)+x] = (dv[(y*height)+x]);
		}
	}	

	for(int y = 1; y < height-1; y++)
	{
		for(int x = 1; x < width-1; x++)
		{
			float norm_factor = sqrt(powf(du[(height*y)+x],2.f) +  powf(dv[(height*y)+x],2.f) + 1.f);
			normalmap[(height*y*3)+ (x*3) + 0] = du[(height*y)+x]/norm_factor;
			normalmap[(height*y*3)+ (x*3) + 1] = dv[(height*y)+x]/norm_factor;
			normalmap[(height*y*3)+ (x*3) + 2] = 1.f	 /norm_factor;
			//std::cout << "N: " << normalmap[(height*y*3)+ (x*3) + 0] << " " << normalmap[(height*y*3)+ (x*3) + 1] << " " << normalmap[(height*y*3)+ (x*3) + 2] << std::endl;								  
		}
	}
			
	for(int i = 0; i < height*width*3; i++)			
		normalmap[i] = (normalmap[i]+1.f)/2.f;	
	
	//delete[] fdata;
	//delete[] normalmap;
	delete[] du;
	delete[] dv;	
	

	//std::cout << "COLOR TEX" << std::endl;
	color->allocateImage(width, height, 1,  GL_LUMINANCE, GL_FLOAT); 
	color->setOrigin(osg::Image::BOTTOM_LEFT);
	color->setImage(width, height, 1, GL_LUMINANCE,GL_LUMINANCE,GL_FLOAT, (unsigned char*)fdata,osg::Image::NO_DELETE); 

	//std::cout << "NORMAL TEX" << std::endl;
	normal->allocateImage(width, height, 1,  GL_RGB, GL_FLOAT); 
	normal->setOrigin(osg::Image::BOTTOM_LEFT);
	normal->setImage(width, height, 1, GL_RGB,GL_RGB,GL_FLOAT, (unsigned char*)normalmap,osg::Image::NO_DELETE); 


}
#endif