#include "ObjectModel.h"
#include "CloudScene.h"

osgCloudyDay::ObjectModel::ObjectModel(void) : lightView_scene (new osg::Group), scene(0), trans(0), trans2(0)
{
}


osgCloudyDay::ObjectModel::~ObjectModel(void)
{
}


void osgCloudyDay::ViewerLightCallbackTransform::operator()(osg::Node* node, osg::NodeVisitor* nv)
{
	float times = 0.f;

	osgUtil::CullVisitor* cv = dynamic_cast<osgUtil::CullVisitor*>(nv);	   
	osg::ref_ptr<osg::Geode> geometry = dynamic_cast<osg::Geode*> (node);

	if(geometry && cv)
	{
		osg::Matrixd view(cv->getCurrentCamera()->getViewMatrix());
		osg::Matrixd invViewMatrix = osg::Matrixd::inverse(view);
			
		osg::Matrixd model(*cv->getModelViewMatrix());
		model = model*invViewMatrix;
		osg::Matrixd proj(cv->getCurrentCamera()->getProjectionMatrix());

		geometry->getOrCreateStateSet()->getUniform("ModelMatrix")->set(model);
		geometry->getOrCreateStateSet()->getUniform("ViewMatrix")->set(view);
		geometry->getOrCreateStateSet()->getUniform("ProjectionMatrix")->set(proj);	
			
#ifdef SHADOW_MAPPING
		geometry->getOrCreateStateSet()->getUniform("light_proj_matrix")->set(Scene::GetProjectionMatrix_Light());
		geometry->getOrCreateStateSet()->getUniform("light_mv_matrix")->set(Scene::GetLightCamera()->getViewMatrix());
#endif
	}
	traverse(node, nv);
}

void osgCloudyDay::ObjectModel::Initialize(int id, std::string path, std::string path_tex, osg::ref_ptr<osg::TextureCubeMap>& fbo_plane_cube)
{	
	m_id = id;
	osg::Node* terrain_obj = osgDB::readNodeFile(path);
	//osg::Node* terrain_obj = osgDB::readNodeFile("box.obj");

	osg::ref_ptr<osg::Image> img_ortho (osgDB::readImageFile(path_tex));
	osg::ref_ptr<osg::Texture2D> tex_ortho = (new osg::Texture2D);
	tex_ortho->setImage(img_ortho.get());


	osg::ref_ptr<osg::Group> shadow_group = new osg::Group();
	osg::ref_ptr<osg::Group> terrain_group = terrain_obj->asGroup();

	for(unsigned int i = 0; i < terrain_group->getNumChildren(); i++)
	{
		osg::ref_ptr<osg::Geode> geode = terrain_group->getChild(i)->asGeode();
		osg::ref_ptr<osg::Group> terrain_group2 = terrain_group->getChild(i)->asGroup();
		
		for(unsigned int j = 0; terrain_group2 != 0 && j < terrain_group2->getNumChildren(); j++)
		{
			osg::ref_ptr<osg::Geode> geode = terrain_group2->getChild(j)->asGeode();		

			if(geode)
			{
				for(unsigned int k = 0; k < geode->getNumDrawables(); k++)
				{
					osg::Geometry* geo = geode->getDrawable(k)->asGeometry();					

					if(geo)
					{
						geo->setUseDisplayList(false);
						osg::Array* tcoords = geo->getTexCoordArray(0);
						osg::Array* norms = geo->getNormalArray();
						geo->setVertexAttribData( 1, osg::Geometry::ArrayData( tcoords, osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );
						geo->setVertexAttribData( 2, osg::Geometry::ArrayData( norms, osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );	
					}
				}

				osg::Geode* geode2 = new osg::Geode(*geode, osg::CopyOp::DEEP_COPY_ALL);				
				geode2->addCullCallback(new ViewerLightCallbackTransform);
				osg::StateSet* stateset = geode2->getOrCreateStateSet();				
				stateset->addUniform(new osg::Uniform("ProjectionMatrix", Scene::GetProjectionMatrix_View()));
				stateset->addUniform(new osg::Uniform("ViewMatrix", Scene::GetViewMatrix_View()));
				stateset->addUniform(new osg::Uniform("ModelMatrix", osg::Matrixd()));	
				stateset->addUniform(new osg::Uniform("light_proj_matrix", Scene::GetProjectionMatrix_Light()));	
				stateset->addUniform(new osg::Uniform("light_mv_matrix", Scene::GetLightCamera()->getViewMatrix()));					
				stateset->addUniform(new osg::Uniform("v3LightPos",		Scene::m_skydome->GetLightPosition()));

				Scene::m_skydome->SetupUniform(stateset);
				
				stateset->setAttribute(Scene::GetShadingProgram().get());
				stateset->setTextureAttributeAndModes(0,tex_ortho,osg::StateAttribute::ON);
				stateset->setTextureAttributeAndModes(1,osgCloudyDay::CloudScene::fbo_light_texture,osg::StateAttribute::ON);
				shadow_group->addChild(geode2);				

#if 1
				geode->addCullCallback(new ViewerLightCallbackTransform);
				
				osg::StateSet* heightmap_state = geode->getOrCreateStateSet();
				//heightmap_state->setTextureAttributeAndModes(0,tex_ortho,osg::StateAttribute::ON);			
				heightmap_state->addUniform(new osg::Uniform("ProjectionMatrix", Scene::GetProjectionMatrix_View()));
				heightmap_state->addUniform(new osg::Uniform("ViewMatrix", Scene::GetViewMatrix_View()));
				heightmap_state->addUniform(new osg::Uniform("ModelMatrix", osg::Matrixd()));	
				heightmap_state->addUniform(new osg::Uniform("light_proj_matrix", Scene::GetProjectionMatrix_Light()));	
				heightmap_state->addUniform(new osg::Uniform("light_mv_matrix", Scene::GetLightCamera()->getViewMatrix()));	
				heightmap_state->addUniform(new osg::Uniform("tex0", 0));
				heightmap_state->addUniform(new osg::Uniform("shadow_tex", 1));	
				heightmap_state->addUniform(new osg::Uniform("cube_tex", 2));	
				heightmap_state->addUniform(new osg::Uniform("id", m_id));	
				heightmap_state->setAttribute(Scene::GetShadingProgram().get());


				heightmap_state->addUniform(new osg::Uniform("v3LightPos", Scene::m_skydome->GetLightPosition()));
				Scene::m_skydome->SetupUniform(heightmap_state);
				
				heightmap_state->setTextureAttributeAndModes(0,tex_ortho,osg::StateAttribute::ON);
				heightmap_state->setTextureAttributeAndModes(1,osgCloudyDay::CloudScene::fbo_light_texture,osg::StateAttribute::ON);
				heightmap_state->setTextureAttributeAndModes(2,fbo_plane_cube,osg::StateAttribute::ON);
#endif
			}
		}
				
		if(geode)
		{
			for(unsigned int j = 0; j < geode->getNumDrawables(); j++)
			{
				osg::Geometry* geo = geode->getDrawable(j)->asGeometry();
				
				if(geo)
				{
					geo->setUseDisplayList(false);
					osg::Array* tcoords = geo->getTexCoordArray(0);
					osg::Array* norms = geo->getNormalArray();
					geo->setVertexAttribData( 1, osg::Geometry::ArrayData( tcoords, osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );
					geo->setVertexAttribData( 2, osg::Geometry::ArrayData( norms, osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );	
				}
			}

			osg::Geode* geode2 = new osg::Geode(*geode);				
			geode2->addCullCallback(new ViewerLightCallbackTransform);
				
			osg::StateSet* stateset = geode2->getOrCreateStateSet();				
			stateset->addUniform(new osg::Uniform("ProjectionMatrix", Scene::GetProjectionMatrix_View()));
			stateset->addUniform(new osg::Uniform("ViewMatrix", Scene::GetViewMatrix_View()));
			stateset->addUniform(new osg::Uniform("ModelMatrix", osg::Matrixd()));	
			stateset->addUniform(new osg::Uniform("light_proj_matrix", Scene::GetProjectionMatrix_Light()));	
			stateset->addUniform(new osg::Uniform("light_mv_matrix", Scene::GetLightCamera()->getViewMatrix()));	


			stateset->addUniform(new osg::Uniform("v3LightPos", Scene::m_skydome->GetLightPosition()));

			Scene::m_skydome->SetupUniform(stateset);			

			stateset->setAttribute(Scene::GetShadingProgram().get());
			stateset->setTextureAttributeAndModes(0,tex_ortho,osg::StateAttribute::ON);
			stateset->setTextureAttributeAndModes(1,osgCloudyDay::CloudScene::fbo_light_texture,osg::StateAttribute::ON);
			shadow_group->addChild(geode2);

#if 1
			geode->addCullCallback(new ViewerLightCallbackTransform);			

			osg::StateSet* heightmap_state = geode->getOrCreateStateSet();
			heightmap_state->addUniform(new osg::Uniform("ProjectionMatrix", Scene::GetProjectionMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ViewMatrix", Scene::GetViewMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ModelMatrix", osg::Matrixd()));	
			heightmap_state->addUniform(new osg::Uniform("light_proj_matrix", Scene::GetProjectionMatrix_Light()));	
			heightmap_state->addUniform(new osg::Uniform("light_mv_matrix", Scene::GetLightCamera()->getViewMatrix()));	
			heightmap_state->addUniform(new osg::Uniform("tex0", 0));
			heightmap_state->addUniform(new osg::Uniform("shadow_tex", 1));	
			heightmap_state->addUniform(new osg::Uniform("cube_tex", 2));	
			heightmap_state->addUniform(new osg::Uniform("id", m_id));	

			heightmap_state->addUniform(new osg::Uniform("v3LightPos", Scene::m_skydome->GetLightPosition()));
			Scene::m_skydome->SetupUniform(heightmap_state);			

			heightmap_state->setAttribute(Scene::GetShadingProgram().get());			

			heightmap_state->setTextureAttributeAndModes(0,tex_ortho,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(1,osgCloudyDay::CloudScene::fbo_light_texture,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(2,fbo_plane_cube,osg::StateAttribute::ON);
#endif
		}
	}

	std::cout << "Initialize 6" << std::endl;
	
	trans = new osg::MatrixTransform(osg::Matrixd(100.f, 0.f, 0.f, 0.f, 
										  		  0.f, 100.f, 0.f, 0.f, 
									 			  0.f, 0.f, 100.f, 0.f, 
										 		  2000.f, 0.f, 1000.f, 1.f));
	trans->addChild(terrain_obj);	

	trans2 = new osg::MatrixTransform(osg::Matrixd(100.f, 0.f, 0.f, 0.f, 
			 							  		   0.f, 100.f, 0.f, 0.f, 
									 			   0.f, 0.f, 100.f, 0.f, 
										 		   2000.f, 0.f, 1000.f, 1.f));
	trans2->addChild(shadow_group);		

	std::cout << "<Initialize>" << std::endl;
}

osg::ref_ptr<osg::MatrixTransform> osgCloudyDay::ObjectModel::LightNode()
{
	return trans2;
}

osg::ref_ptr<osg::MatrixTransform> osgCloudyDay::ObjectModel::ViewNode()
{
	return trans;
}