#include "ObjCloud.h"


osgCloudyDay::ObjCloud::ObjCloud(std::string path, osg::Vec3 pos, int type, osg::Vec4 layer) : CloudGenerator(layer), m_middlepos(pos)
{
	volume = new CloudCreateVolume();
	volume->LoadingVolume(path);

	m_category = type;
}


osgCloudyDay::ObjCloud::~ObjCloud(void)
{
	delete volume;
}

bool osgCloudyDay::ObjCloud::Update()
{
	return false;
}

void osgCloudyDay::ObjCloud::Initialize()
{
	osg::Vec3 sizes = osg::Vec3(10, 10, 10);
	//osg::Vec3 jitter_sizes = osg::Vec3(2.0f,2.0f,2.0f);
	osg::Vec3 jitter_sizes = osg::Vec3(2.0f,0.0f,2.0f);


	for(unsigned int i = 0; i < volume->m_aabb_boundbox.size(); i++)
	{
		osg::Vec3 minaabb = volume->m_aabb_boundbox[i].first;
		osg::Vec3 maxaabb = volume->m_aabb_boundbox[i].second;
		osg::Vec3 centeraabb = (minaabb+maxaabb)/2.f;
	
		AddCloudBox(volume, i, centeraabb, sizes, maxaabb-centeraabb, jitter_sizes, false, m_density);
	}

	EliminateRedudantSprites();	

	/*
	std::cout << "______________" << std::endl;
	std::cout << "EXPORT CLOUDS" << std::endl;
	Export* ex = new Export();
	ex->AddCloud(m_cloud->vertices, m_cloud->rotation, m_cloud->center, m_cloud->ids, m_cloud->box_centers, diffuselight_h, diffuselight_t, ambientlight_color, 6);
	ex->Perform();

	std::cout << "______________" << std::endl;
	std::cout << "IMPORT CLOUDS" << std::endl;
	ImportExport* im = new ImportClouds();
	im->Perform();
	std::cout << "______________" << std::endl;

	osg::ref_ptr<osg::Vec3Array> vertices2;
	osg::ref_ptr<osg::Vec4Array> rotation2;
	osg::ref_ptr<osg::Vec4Array> center2; 
	osg::ref_ptr<osg::Vec4Array> ids2;
	im->GetData(0, vertices2, rotation2, center2, ids2);
	*/
}