#include "Night.h"
#include "CloudScene.h"

osg::ref_ptr<osg::Program> osgCloudyDay::Night::m_cloudProg=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::Night::tex_tree=0;

osgCloudyDay::Night::Night()  : m_num_stars(1000)
{
	std::cout << "NIGHT" << std::endl;
}

osgCloudyDay::Night::~Night()
{

}

void osgCloudyDay::Night::Initialize()
{
	SetArrays();	
	
	geometry = new osg::Geometry();
	geometry->setVertexAttribArray(0, m_vertices.get());
	geometry->setVertexAttribBinding(0, osg::Geometry::BIND_PER_VERTEX);
	geometry->setUseDisplayList(false);
	geometry->setUseVertexBufferObjects(true);

	geometry->addPrimitiveSet(
		new osg::DrawElementsUInt(osg::PrimitiveSet::POINTS,
								m_indices->size(),
								&m_indices->at(0)));		
	geometry->getPrimitiveSet(geometry->getNumPrimitiveSets()-1)->getDrawElements()->setDataVariance(osg::Object::DYNAMIC);		


	osg::ref_ptr<osg::BlendFunc> blending = new osg::BlendFunc(osg::BlendFunc::SRC_ALPHA, osg::BlendFunc::ONE_MINUS_SRC_ALPHA);
	osg::ref_ptr<osg::Depth> depth = new osg::Depth(osg::Depth::LEQUAL, 0.0, 1.0, true);

	geode = (new osg::Geode());	
	geode->addDrawable(geometry.get());
	geode->setCullingActive(false); //wars ned		
	geode->getOrCreateStateSet()->setAttributeAndModes(new osg::CullFace(), osg::StateAttribute::OFF); 
	geode->addCullCallback(new NightLightCallback());
	//geode->getOrCreateStateSet()->setAttributeAndModes(blending, osg::StateAttribute::ON);
	geode->getOrCreateStateSet()->setAttributeAndModes(depth, osg::StateAttribute::ON);
	osg::ref_ptr<osg::StateSet> nodess4 = (geode->getOrCreateStateSet());			

	SetUniforms(nodess4);
}

void osgCloudyDay::Night::CreateShader()
{
	m_cloudProg=(new osg::Program);
	osg::ref_ptr<osg::Shader> forestVertexShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/night.vert"));
	osg::ref_ptr<osg::Shader> forestGeomShader(osg::Shader::readShaderFile (osg::Shader::GEOMETRY, "shaders/night.geom"));
	osg::ref_ptr<osg::Shader> forestFragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/night.frag"));
	
	//Binding the box shaders to its program
	m_cloudProg->addShader(forestVertexShader.get());
	m_cloudProg->addShader(forestGeomShader.get());
	m_cloudProg->addShader(forestFragShader.get());
	m_cloudProg->addBindFragDataLocation("out_color", 0);
	m_cloudProg->addBindFragDataLocation("out_color2", 1);
}

void osgCloudyDay::Night::SetArrays()
{
	std::cout << "SETUP Arrays - start" << std::endl;
	m_vertices = new osg::Vec3Array();
	m_information = new osg::Vec4Array();
	m_indices = new osg::UIntArray();
	
	osg::ref_ptr<osg::Vec3Array> vertices(new osg::Vec3Array());
	osg::ref_ptr<osg::Vec4Array> information(new osg::Vec4Array());
	osg::ref_ptr<osg::UIntArray> indices(new osg::UIntArray());
	
	float r = 5000.f;
	for(int i = 0; i < m_num_stars; i++)
	{	
		float phi1 = (float)(rand()) / (float) RAND_MAX * 3.14789f;
		float phi2 = (float)(rand()) / (float) RAND_MAX * 3.14789f*2.f;

		float x = r * sinf(phi1) * cosf(phi2);
		float y = r * sinf(phi1) * sinf(phi2);
		float z = abs(r * cosf(phi1));

		vertices->push_back(osg::Vec3(x,y,z));	
		information->push_back(osg::Vec4());
		indices->push_back(i);
	}

//	vertices->push_back(osg::Vec3(100.f,1000.f,100.f);			
//	information->push_back(osg::Vec4());
//	indices->push_back(index);

	m_vertices->insert(	m_vertices->end(),	vertices->begin(), vertices->end()); 
	m_information->insert(	m_information->end(),	information->begin(), information->end()); 
	m_indices->insert(	m_indices->end(),	indices->begin(), indices->end()); 

	std::cout << "SETUP Arrays - end" << std::endl;
}

void osgCloudyDay::Night::CreateTexture()
{
	osg::ref_ptr<osg::Image> img_ortho (osgDB::readImageFile("../data/textures/night/541moon.tga"));
	tex_tree = (new osg::Texture2D);
	tex_tree->setInternalFormat(GL_SRGB8_ALPHA8);
	tex_tree->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_tree->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);
	tex_tree->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP);
	tex_tree->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP);
	tex_tree->setImage(img_ortho.get());	
}

void osgCloudyDay::Night::SetUniforms(osg::ref_ptr<osg::StateSet> nodess4)
{
	nodess4->setAttribute(m_cloudProg.get());			
	
	nodess4->addUniform(new osg::Uniform("ProjectionMatrix", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("ViewMatrix", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("ModelMatrix", osg::Matrixd()));

	nodess4->addUniform(new osg::Uniform("light_mv_matrix", osg::Matrixd()));	
	nodess4->addUniform(new osg::Uniform("light_proj_matrix", osg::Matrixd()));	
	nodess4->addUniform(new osg::Uniform("inv_project_light", osg::Matrixd()));		
	
	nodess4->addUniform(new osg::Uniform("viewMatrixInv", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("viewMatrixInv_light", osg::Matrixd()));

	nodess4->addUniform(new osg::Uniform("color_tex", 0));



	osgCloudyDay::Scene::m_skydome->SetupUniform(nodess4);

	nodess4->setTextureAttributeAndModes(0,tex_tree,osg::StateAttribute::ON);
	nodess4->setTextureAttributeAndModes(1,osgCloudyDay::CloudScene::fbo_light_texture,osg::StateAttribute::ON);
}


osg::Geode* osgCloudyDay::Night::GetGeode()
{
	return geode;
}