#include "LuminanceCalculation.h"


osgCloudyDay::LuminanceCalculation::LuminanceCalculation(void)
{
	renderorder = 6;
}


osgCloudyDay::LuminanceCalculation::~LuminanceCalculation(void)
{
}


void osgCloudyDay::LuminanceCalculation::SetupTextures(osg::ref_ptr<osg::StateSet> nodessP)
{
	nodessP->setTextureAttributeAndModes(0, Scene::GetSceneTexture().get());		
}

void osgCloudyDay::LuminanceCalculation::SetupUniform(osg::ref_ptr<osg::StateSet> nodessP)
{	
	nodessP->setAttribute(sh_lum.get());
	nodessP->addUniform(new osg::Uniform("color_tex", 0));
	nodessP->setTextureAttributeAndModes(0, Scene::GetSceneTexture().get());		

	uniform_avg_texsize = new osg::Uniform("texsize", 256.f);
	uniform_avg_texsize->setUpdateCallback(new UniformBlurTexsize());
	nodessP->addUniform(uniform_avg_texsize);
}

void osgCloudyDay::LuminanceCalculation::CreateCamera()
{
	osg::ref_ptr<osg::GraphicsContext::Traits> traits = new osg::GraphicsContext::Traits;
	traits->x = 20;
	traits->y = 20;
	traits->width = osgCloudyDay::Scene::GetWidth();
	traits->height = osgCloudyDay::Scene::GetHeight();
	traits->windowDecoration = true;
	traits->doubleBuffer = true;
	traits->sharedContext = 0;
	osg::ref_ptr<osg::GraphicsContext> gc = osg::GraphicsContext::createGraphicsContext(traits.get());

	cam_hud = new osg::Camera;
	cam_hud->setViewMatrix(osg::Matrixd().lookAt(osg::Vec3(2.0, 0.0, 0.0), osg::Vec3(0.f, 0.f ,0.f), osg::Vec3(0.f, 0.f, 1.f)));
	cam_hud->setProjectionMatrix(osg::Matrixd().ortho(-0.5f, 0.5f, -0.5f, 0.5f, 1.f, 100.f));
	cam_hud->setGraphicsContext(gc.get());
	cam_hud->setViewport(new osg::Viewport(0,0, traits->width, traits->height));

	GLenum buffer = traits->doubleBuffer ? GL_BACK : GL_FRONT;
	cam_hud->setDrawBuffer(buffer);
	cam_hud->setReadBuffer(buffer);
	cam_hud->setReferenceFrame(osg::Transform::ABSOLUTE_RF);
	cam_hud->setClearMask(GL_COLOR_BUFFER_BIT);
	cam_hud->setRenderOrder(osg::Camera::POST_RENDER,renderorder+1);
	cam_hud->setAllowEventFocus(false);
	//cam_hud->attach(osg::Camera::COLOR_BUFFER0, Scene::fbo_blurH1_texture);	
	cam_hud->getOrCreateStateSet()->setMode(GL_LIGHTING, osg::StateAttribute::OFF);
	cam_hud->setRenderTargetImplementation(osg::Camera::FRAME_BUFFER_OBJECT);
	cam_hud->setImplicitBufferAttachmentMask(osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT, osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT);
	cam_hud->setCullingActive(false);
}