#include "GL/glew.h"
#include <osg/GL>
#include <gl/GL.h>
#include <gl/GLU.h>
#include <osg/BlendEquation>
#include <osg/GLExtensions>
#include <osg/State>
#include <osg/Notify>
#include <osg/buffered_value> 

#include "LightShaftGeometry.h"
#include <iostream>
#include <osg/BlendEquation>

osgCloudyDay::LightShaftGeometry::LightShaftGeometry(void)
{	
	osg::setGLExtensionFuncPtr(_glBlendEquationi, "glBlendEquationi", "glBlendEquationiARB");
}

osgCloudyDay::LightShaftGeometry::LightShaftGeometry(Geometry& geo) : Geometry(geo, osg::CopyOp::DEEP_COPY_ALL)
{	
	osg::setGLExtensionFuncPtr(_glBlendEquationi, "glBlendEquationi", "glBlendEquationiARB");
}


osgCloudyDay::LightShaftGeometry::~LightShaftGeometry(void)
{
}

osgCloudyDay::LightShaftGeometry::GLBlendEquationiProc osgCloudyDay::LightShaftGeometry::_glBlendEquationi = 0;


void osgCloudyDay::LightShaftGeometry::drawImplementation(osg::RenderInfo& renderInfo) const
{			
	//std::cout << "void osg::LightShaftGeometry::drawImplementation(osg::RenderInfo& renderInfo) const" << std::endl;
	if(_glBlendEquationi == 0) 
		osg::setGLExtensionFuncPtr(_glBlendEquationi, "glBlendEquationi", "glBlendEquationiARB");

    if (_internalOptimizedGeometry.valid())
    {
        _internalOptimizedGeometry->drawImplementation(renderInfo);
        return;
    }

    osg::State& state = *renderInfo.getState();

    bool checkForGLErrors = state.getCheckForGLErrors()==osg::State::ONCE_PER_ATTRIBUTE;
    if (checkForGLErrors) state.checkGLErrors("start of Geometry::drawImplementation()");
    
    bool useFastPath = areFastPathsUsed();
    // useFastPath = false;

    bool usingVertexBufferObjects = _useVertexBufferObjects && state.isVertexBufferObjectSupported();
    bool handleVertexAttributes = !_vertexAttribList.empty();

    osg::ArrayDispatchers& arrayDispatchers = state.getArrayDispatchers();

    arrayDispatchers.reset();
    arrayDispatchers.setUseVertexAttribAlias(useFastPath && state.getUseVertexAttributeAliasing());
    arrayDispatchers.setUseGLBeginEndAdapter(!useFastPath);

    arrayDispatchers.activateNormalArray(_normalData.binding, _normalData.array.get(), _normalData.indices.get());
    arrayDispatchers.activateColorArray(_colorData.binding, _colorData.array.get(), _colorData.indices.get());
    arrayDispatchers.activateSecondaryColorArray(_secondaryColorData.binding, _secondaryColorData.array.get(), _secondaryColorData.indices.get());
    arrayDispatchers.activateFogCoordArray(_fogCoordData.binding, _fogCoordData.array.get(), _fogCoordData.indices.get());

    if (handleVertexAttributes)
    {
        for(unsigned int unit=0;unit<_vertexAttribList.size();++unit)
        {
            arrayDispatchers.activateVertexAttribArray(_vertexAttribList[unit].binding, unit, _vertexAttribList[unit].array.get(), _vertexAttribList[unit].indices.get());
        }
    }

    // dispatch any attributes that are bound overall
    arrayDispatchers.dispatch(BIND_OVERALL,0);

    state.lazyDisablingOfVertexAttributes();

    if (useFastPath)
    {
        // set up arrays
        if( _vertexData.array.valid() )
            state.setVertexPointer(_vertexData.array.get());

        if (_normalData.binding==BIND_PER_VERTEX && _normalData.array.valid())
            state.setNormalPointer(_normalData.array.get());

        if (_colorData.binding==BIND_PER_VERTEX && _colorData.array.valid())
            state.setColorPointer(_colorData.array.get());

        if (_secondaryColorData.binding==BIND_PER_VERTEX && _secondaryColorData.array.valid())
            state.setSecondaryColorPointer(_secondaryColorData.array.get());

        if (_fogCoordData.binding==BIND_PER_VERTEX && _fogCoordData.array.valid())
            state.setFogCoordPointer(_fogCoordData.array.get());

        for(unsigned int unit=0;unit<_texCoordList.size();++unit)
        {
            const osg::Array* array = _texCoordList[unit].array.get();
            if (array) state.setTexCoordPointer(unit,array);
        }

        if( handleVertexAttributes )
        {
            for(unsigned int index = 0; index < _vertexAttribList.size(); ++index )
            {
                const osg::Array* array = _vertexAttribList[index].array.get();
                const AttributeBinding ab = _vertexAttribList[index].binding;
                if( ab == BIND_PER_VERTEX && array )
                {
                    state.setVertexAttribPointer( index, array, _vertexAttribList[index].normalize );
                }
            }
        }
    }
    else
    {
        for(unsigned int unit=0;unit<_texCoordList.size();++unit)
        {
            arrayDispatchers.activateTexCoordArray(BIND_PER_VERTEX, unit, _texCoordList[unit].array.get(), _texCoordList[unit].indices.get());
        }

        arrayDispatchers.activateVertexArray(BIND_PER_VERTEX, _vertexData.array.get(), _vertexData.indices.get());
    }

    state.applyDisablingOfVertexAttributes();

    bool bindPerPrimitiveSetActive = arrayDispatchers.active(BIND_PER_PRIMITIVE_SET);
    bool bindPerPrimitiveActive = arrayDispatchers.active(BIND_PER_PRIMITIVE);

    unsigned int primitiveNum = 0;

    if (checkForGLErrors) state.checkGLErrors("Geometry::drawImplementation() after vertex arrays setup.");
	
	glClearColor(0.f, 0.f, 0.f, 0.f);
	glClear(GL_COLOR_BUFFER_BIT);

    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //
    // draw the primitives themselves.
    //				
	
	for(unsigned int primitiveSetNum=0; primitiveSetNum!= _primitives.size(); ++primitiveSetNum)
	{
		// dispatch any attributes that are bound per primitive
		if (bindPerPrimitiveSetActive) 
		{
			arrayDispatchers.dispatch(BIND_PER_PRIMITIVE_SET, primitiveSetNum);
		}

		const osg::PrimitiveSet* primitiveset = _primitives[primitiveSetNum].get();												

		_glBlendEquationi(0, GL_FUNC_ADD);
		_glBlendEquationi(1, GL_MAX);
		glBlendFunc(GL_ONE, GL_ONE);
		glDepthMask(GL_FALSE);
		glEnable(GL_DEPTH_TEST);
		glDepthFunc(GL_LEQUAL);
		glDisable(GL_CULL_FACE);

		glEnable(GL_BLEND);
		primitiveset->draw(state, usingVertexBufferObjects);        	
		glEnable(GL_CULL_FACE);
		glDisable(GL_BLEND);									
		
		_glBlendEquationi(0, GL_FUNC_ADD);
		_glBlendEquationi(1, GL_FUNC_ADD);
	}

    // unbind the VBO's if any are used.
    state.unbindVertexBufferObject();
    state.unbindElementBufferObject();
	
    if (checkForGLErrors) state.checkGLErrors("end of Geometry::drawImplementation().");
}