#include "LightShaft2.h"
#include "CloudScene.h"

osgCloudyDay::LightShaft2::LightShaft2() :  geode(0), geometry(0), m_vertices(0), m_indices(0), m_forestProg(0)
{

}

osgCloudyDay::LightShaft2::~LightShaft2()
{

}

osg::Geode* osgCloudyDay::LightShaft2::GetGeode()
{
	return geode;
}

void osgCloudyDay::LightShaft2::Initialize()
{
	int index = 200;

	geode = new osg::Geode();
	geometry = new osg::Geometry();
	m_vertices = new osg::Vec3Array(index);
	m_indices = new osg::UIntArray(index);	

	for(int i = 0; i < index; i++)
	{
		m_vertices->at(i) = osg::Vec3f(0.f, 0.f, (float)(index-1-i)/(float)(index-1));		
		m_indices->at(i) = i;
	}

	geometry->setVertexAttribArray(0, m_vertices.get());
	geometry->setVertexAttribBinding(0, osg::Geometry::BIND_PER_VERTEX);
	geometry->setUseDisplayList(false);
	geometry->setUseVertexBufferObjects(true);

	geometry->addPrimitiveSet(new osg::DrawElementsUInt(osg::PrimitiveSet::POINTS, index, &m_indices->at(0)));		
	geometry->getPrimitiveSet(geometry->getNumPrimitiveSets()-1)->getDrawElements()->setDataVariance(osg::Object::DYNAMIC);		

	osg::ref_ptr<osg::BlendFunc> blending = new osg::BlendFunc(osg::BlendFunc::SRC_ALPHA, osg::BlendFunc::ONE_MINUS_SRC_ALPHA);
	osg::ref_ptr<osg::Depth> depth = new osg::Depth(osg::Depth::LEQUAL, 0.0, 1.0, false);

	geode->addDrawable(geometry.get());
	geode->setCullingActive(false); //wars ned		
	geode->getOrCreateStateSet()->setAttributeAndModes(new osg::CullFace(), osg::StateAttribute::OFF); 
	geode->addCullCallback(new LightShaft2Callback());
	geode->getOrCreateStateSet()->setAttributeAndModes(blending, osg::StateAttribute::ON);
	geode->getOrCreateStateSet()->setAttributeAndModes(depth, osg::StateAttribute::ON);
	osg::ref_ptr<osg::StateSet> nodess4 = (geode->getOrCreateStateSet());			

	SetUniforms(nodess4);
}

void osgCloudyDay::LightShaft2::SetUniforms(osg::ref_ptr<osg::StateSet> nodess4)
{
	m_forestProg=(new osg::Program);
	osg::ref_ptr<osg::Shader> forestVertexShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/lightshaft3.vert"));
	osg::ref_ptr<osg::Shader> forestGeomShader(osg::Shader::readShaderFile (osg::Shader::GEOMETRY, "shaders/lightshaft3.geom"));
	osg::ref_ptr<osg::Shader> forestFragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/lightshaft3.frag"));
	
	//Binding the box shaders to its program
	m_forestProg->addShader(forestVertexShader.get());
	m_forestProg->addShader(forestGeomShader.get());
	m_forestProg->addShader(forestFragShader.get());
	m_forestProg->addBindFragDataLocation("out_color", 0);
	m_forestProg->addBindFragDataLocation("out_color2", 1);

	nodess4->setAttribute(m_forestProg.get());			
	
	nodess4->addUniform(new osg::Uniform("ProjectionMatrix", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("ViewMatrix", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("ModelMatrix", osg::Matrixd()));

	nodess4->addUniform(new osg::Uniform("light_mv_matrix", osg::Matrixd()));	
	nodess4->addUniform(new osg::Uniform("light_proj_matrix", osg::Matrixd()));	
	nodess4->addUniform(new osg::Uniform("inv_project_light", osg::Matrixd()));		
	nodess4->addUniform(new osg::Uniform("viewMatrixInv", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("viewMatrixInv_light", osg::Matrixd()));


	nodess4->addUniform(new osg::Uniform("planeLBN", osg::Vec4f(0.f, 0.f, 0.f, 1.f))); 
	nodess4->addUniform(new osg::Uniform("planeRBN", osg::Vec4f(0.f, 0.f, 0.f, 1.f)));
	nodess4->addUniform(new osg::Uniform("planeLTN", osg::Vec4f(0.f, 0.f, 0.f, 1.f)));
	nodess4->addUniform(new osg::Uniform("planeRTN", osg::Vec4f(0.f, 0.f, 0.f, 1.f)));
	
	nodess4->addUniform(new osg::Uniform("planeLBT", osg::Vec4f(0.f, 0.f, 0.f, 1.f)));
	nodess4->addUniform(new osg::Uniform("planeRBT", osg::Vec4f(0.f, 0.f, 0.f, 1.f)));
	nodess4->addUniform(new osg::Uniform("planeLTT", osg::Vec4f(0.f, 0.f, 0.f, 1.f)));
	nodess4->addUniform(new osg::Uniform("planeRTT", osg::Vec4f(0.f, 0.f, 0.f, 1.f)));


	nodess4->addUniform(new osg::Uniform("shadow_tex", 0));		

	nodess4->setTextureAttributeAndModes(0,osgCloudyDay::CloudScene::fbo_light_texture,osg::StateAttribute::ON);
}