#include "LightShaft.h"
#include <osg/Depth>
#include <osg/BlendEquation>

osgCloudyDay::LightShaft::LightShaft(void) : fbo_lightshaft1(0), fbo_lightshaft2(0), fbo_lightshaft_d(0), camera_lightshaft(0)
{
}


osgCloudyDay::LightShaft::~LightShaft(void)
{
}

unsigned int GetOppositeIndex(GLushort* oldindices, unsigned int face, std::pair<unsigned int, unsigned int> e)
{
    for (unsigned int i = 0 ; i < 3 ; i++) 
	{
        unsigned int Index = oldindices[face*3+i];

        if (Index != e.first && Index != e.second) 
		{
            return Index;
        }
    }
       
    //assert(0);      

    return 0;
}

osg::ref_ptr<osg::Texture2D> osgCloudyDay::LightShaft::GetLightshaft1()
{
	return fbo_lightshaft1;
}

osg::ref_ptr<osg::Texture2D> osgCloudyDay::LightShaft::GetLightshaft2()
{
	return fbo_lightshaft2;
}

void osgCloudyDay::LightShaft::Initialize()
{
	osg::ref_ptr<osg::GraphicsContext::Traits> traits = new osg::GraphicsContext::Traits;
	traits->x = 0;
	traits->y = 0;
	traits->width = osgCloudyDay::Scene::GetWidth();
	traits->height = osgCloudyDay::Scene::GetHeight();
	traits->windowDecoration = true;
	traits->doubleBuffer = true;
	traits->sharedContext = 0;

	osg::ref_ptr<osg::GraphicsContext> gc = osg::GraphicsContext::createGraphicsContext(traits.get());

	fbo_lightshaft_d = new osg::Texture2D();
	fbo_lightshaft_d->setBorderWidth(0);
	fbo_lightshaft_d->setTextureSize(osgCloudyDay::Scene::GetWidth(),osgCloudyDay::Scene::GetHeight());
	fbo_lightshaft_d->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_lightshaft_d->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_lightshaft_d->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_lightshaft_d->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_lightshaft_d->setInternalFormat(GL_DEPTH_COMPONENT32F);
	fbo_lightshaft_d->setSourceFormat(GL_DEPTH_COMPONENT);
	fbo_lightshaft_d->setSourceType(GL_FLOAT);

	fbo_lightshaft1 = new osg::Texture2D();
	fbo_lightshaft1->setBorderWidth(0);
	fbo_lightshaft1->setTextureSize(osgCloudyDay::Scene::GetWidth(),osgCloudyDay::Scene::GetHeight());
	fbo_lightshaft1->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_lightshaft1->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_lightshaft1->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_lightshaft1->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_lightshaft1->setInternalFormat(GL_RGB32F_ARB);
	fbo_lightshaft1->setSourceFormat(GL_RGB);
	fbo_lightshaft1->setSourceType(GL_FLOAT);

	fbo_lightshaft2 = new osg::Texture2D();
	fbo_lightshaft2->setBorderWidth(0);
	fbo_lightshaft2->setTextureSize(osgCloudyDay::Scene::GetWidth(),osgCloudyDay::Scene::GetHeight());
	fbo_lightshaft2->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_lightshaft2->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_lightshaft2->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_lightshaft2->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_lightshaft2->setInternalFormat(GL_RGB32F_ARB);
	fbo_lightshaft2->setSourceFormat(GL_RGB);
	fbo_lightshaft2->setSourceType(GL_FLOAT);
	
	camera_lightshaft = new osg::Camera;
	camera_lightshaft->setViewMatrix(Scene::GetViewMatrix_View());
	camera_lightshaft->setProjectionMatrix(Scene::GetProjectionMatrix_View());
	camera_lightshaft->setGraphicsContext(gc.get());
	camera_lightshaft->setViewport(new osg::Viewport(0,0, osgCloudyDay::Scene::GetWidth(),osgCloudyDay::Scene::GetHeight()));	
	GLenum buffer = traits->doubleBuffer ? GL_BACK : GL_FRONT;
	camera_lightshaft->setDrawBuffer(buffer);
	camera_lightshaft->setReadBuffer(buffer);
	camera_lightshaft->setClearColor(osg::Vec4(1.0, 1.0, 1.0, 1.0));
	camera_lightshaft->setClearDepth(1.0);
	camera_lightshaft->setAllowEventFocus(false);
	camera_lightshaft->setReferenceFrame(osg::Transform::ABSOLUTE_RF);
	camera_lightshaft->setClearMask( GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);	
	camera_lightshaft->setRenderOrder(osg::Camera::PRE_RENDER,2);
	camera_lightshaft->setComputeNearFarMode( osgUtil::CullVisitor::DO_NOT_COMPUTE_NEAR_FAR );		
	camera_lightshaft->attach(osg::Camera::DEPTH_BUFFER, fbo_lightshaft_d);	
	camera_lightshaft->attach(osg::Camera::COLOR_BUFFER0, fbo_lightshaft1);	
	camera_lightshaft->attach(osg::Camera::COLOR_BUFFER1, fbo_lightshaft2);	

	camera_lightshaft->setRenderTargetImplementation(osg::Camera::FRAME_BUFFER_OBJECT);
	camera_lightshaft->setImplicitBufferAttachmentMask(osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT, osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT);
	camera_lightshaft->setCullingActive(false);
	camera_lightshaft->getOrCreateStateSet()->setMode(GL_LIGHTING, osg::StateAttribute::OFF);



	osg::ref_ptr<osg::Shader> lightshaftvertShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/lightshaft.vert"));
	osg::ref_ptr<osg::Shader> lightshaftgeomShader(osg::Shader::readShaderFile (osg::Shader::GEOMETRY, "shaders/lightshaft.geom"));
	osg::ref_ptr<osg::Shader> lightshaftfragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/lightshaft.frag"));

	//Binding the box shaders to its program
	osg::ref_ptr<osg::Program> lightshaftProg (new osg::Program);
	lightshaftProg->addShader(lightshaftvertShader.get());
	lightshaftProg->addShader(lightshaftgeomShader.get());	
	lightshaftProg->addShader(lightshaftfragShader.get());	
	lightshaftProg->addBindAttribLocation("in_position", 0);
	lightshaftProg->addBindFragDataLocation("out_color", 0);
	lightshaftProg->addBindFragDataLocation("out_color2", 1);			
		
	osg::Node* terrain_obj = osgDB::readNodeFile("../data/terrain/mountains-Copy.obj");		
	if(terrain_obj == 0) 
	{
		std::cerr << "ERROR" << std::endl;
	}
	osg::Group* terrain_group = terrain_obj->asGroup();

	osg::BlendFunc* bf = new osg::BlendFunc(osg::BlendFunc::ONE, osg::BlendFunc::ZERO );
	terrain_group->getOrCreateStateSet()->setAttributeAndModes(bf);

    //terrain_group->getOrCreateStateSet()->setRenderingHint(osg::StateSet::TRANSPARENT_BIN);
	terrain_group->getOrCreateStateSet()->setAttribute(new osg::Depth(osg::Depth::LEQUAL, 0.0, 1.0, false));	

	for(unsigned int n = 0; terrain_group != 0 && n < terrain_group->getNumChildren(); n++)
	{
		osg::ref_ptr<osg::Geode> geode = terrain_group->getChild(n)->asGeode();		
		if(geode)
		{						
			for(unsigned int m = 0; m < geode->getNumDrawables(); m++)
			{
				osgCloudyDay::LightShaftGeometry* geo = new osgCloudyDay::LightShaftGeometry(*geode->getDrawable(m)->asGeometry());

				geode->removeDrawables(0,1);
				geode->addDrawable(geo);
				geode->addCullCallback(new ViewerLightCallback2);
				geo->setUseDisplayList(false);
				//geode->getDrawable(m)->asGeometry()->setUseDisplayList(false);

				//osg::LightShaftGeometry* geo = static_cast<osg::LightShaftGeometry*>(geode->getDrawable(m)->asGeometry());
				//geo->test = true;
				if(geo)
				{	
					for(unsigned int k = 0; k < geo->getNumPrimitiveSets(); k++)
					{											
						if(geo->getPrimitiveSet(k)->getMode() == 5 && geo->getPrimitiveSet(k)->getType()==4)
						{																					
							GLushort* oldindices = (GLushort*)(geo->getPrimitiveSet(k)->getDataPointer());							
							GLushort* indices = new GLushort[(geo->getPrimitiveSet(k)->getNumIndices()-2)*3];
							for(unsigned int l = 2; l < geo->getPrimitiveSet(k)->getNumIndices(); l++)
							{
								if(l % 2 == 1)
								{																											
									indices[((l-2)*3)+0] = oldindices[l-2];
									indices[((l-2)*3)+1] = oldindices[l-0];
									indices[((l-2)*3)+2] = oldindices[l-1];
								}
								else
								{
									indices[((l-2)*3)+0] = oldindices[l-2];
									indices[((l-2)*3)+1] = oldindices[l-1];
									indices[((l-2)*3)+2] = oldindices[l-0];
								}
							}

							geo->setPrimitiveSet(k, new osg::DrawElementsUShort( osg::PrimitiveSet::TRIANGLES, (geo->getPrimitiveSet(k)->getNumIndices()-2)*3, indices));
						}							
					}

					unsigned int num_indices = 0;
					for(unsigned int k = 0; k < geo->getNumPrimitiveSets(); k++)
						if(geo->getPrimitiveSet(k)->getMode() == 4)
							num_indices += geo->getPrimitiveSet(k)->getNumIndices();

					std::cout << "num_indices: " << num_indices<< std::endl;
					GLushort* indices = new GLushort[num_indices];
										
					unsigned int n = 0;
					for(unsigned int k = 0; k < geo->getNumPrimitiveSets(); k++)
					{
						if(geo->getPrimitiveSet(k)->getMode() == 4)
						{							
							GLushort* oldindices = (GLushort*)(geo->getPrimitiveSet(k)->getDataPointer());							
							for(unsigned int l = 0; l < geo->getPrimitiveSet(k)->getNumIndices(); l++)
							{						
								indices[n] = oldindices[l];	
								n++;							
							}						
						}
					}
					
					geo->removePrimitiveSet(0, geo->getNumPrimitiveSets());
					geo->addPrimitiveSet(new osg::DrawElementsUShort( osg::PrimitiveSet::TRIANGLES, num_indices, indices));
					
					std::vector<GLushort> Indices;		
					std::map<std::pair<GLushort, GLushort>, std::pair<GLushort, GLushort>> m_indexMap;

					for(GLushort k = 0; k < geo->getNumPrimitiveSets(); k++)
					{
						if(geo->getPrimitiveSet(k)->getMode() == 4)
						{	
							GLushort* oldindices = (GLushort*)(geo->getPrimitiveSet(k)->getDataPointer());							

							// Step 1 - find the two triangles that share every edge
							for (GLushort i = 0 ; i < geo->getPrimitiveSet(k)->getNumIndices()/3 ; i++) 
							{						
								std::pair<GLushort, GLushort> e1(oldindices[i*3+0], oldindices[i*3+1]);
								std::pair<GLushort, GLushort> e2(oldindices[i*3+1], oldindices[i*3+2]);
								std::pair<GLushort, GLushort> e3(oldindices[i*3+2], oldindices[i*3+0]);
        
								if(m_indexMap.count(e1) <= 0)	m_indexMap.insert(std::pair<std::pair<GLushort, GLushort>, std::pair<GLushort, GLushort>>(e1, std::pair<GLushort, GLushort>(i, i)));
								else	m_indexMap[e1] = std::pair<GLushort, GLushort>(m_indexMap[e1].first, i);								
														
								if(m_indexMap.count(e2) <= 0)	m_indexMap.insert(std::pair<std::pair<GLushort, GLushort>, std::pair<GLushort, GLushort>>(e2, std::pair<GLushort, GLushort>(i, i)));							
								else	m_indexMap[e2] = std::pair<GLushort, GLushort>(m_indexMap[e2].first, i);
								
								if(m_indexMap.count(e3) <= 0)	m_indexMap.insert(std::pair<std::pair<GLushort, GLushort>, std::pair<GLushort, GLushort>>(e3, std::pair<GLushort, GLushort>(i, i)));
								else	m_indexMap[e3] = std::pair<GLushort, GLushort>(m_indexMap[e3].first, i);							
							}   
						
							// Step 2 - build the index buffer with the adjacency info
							for (GLushort i = 0 ; i < geo->getPrimitiveSet(k)->getNumIndices()/3 ; i++) 
							{                
								for (GLushort j = 0 ; j < 3 ; j++) 
								{            
									std::pair<GLushort, GLushort> e(oldindices[i*3+j], oldindices[i*3+((j + 1) % 3)]);
								
									//assert(m_indexMap.find(e) != m_indexMap.end());
								
									std::pair<GLushort, GLushort> n = m_indexMap[e];
									GLushort OtherTri = 0;
									if(n.first == i)	OtherTri = n.second;
									else				OtherTri = n.first;
            
									if (OtherTri == -1)	OtherTri = 0;
            
									GLushort OppositeIndex = GetOppositeIndex(oldindices, OtherTri, e);
         
									Indices.push_back(oldindices[i*3+j]);
									Indices.push_back(OppositeIndex); 
								}
								//std::cout << std::endl;
							}   					

							GLushort* indices = new GLushort[Indices.size()];
							for(unsigned int i = 0; i < Indices.size(); i++)
								indices[i] = Indices[i];
							geo->setPrimitiveSet(k, new osg::DrawElementsUShort( osg::PrimitiveSet::TRIANGLES_ADJACENCY, Indices.size(), indices));							
							geo->setUseDisplayList(false);							
						}
					}							
				}
			}

			geode->addCullCallback(new ViewerLightCallback2);
			geode->addUpdateCallback(new ViewerLightCallback2);
				
			osg::StateSet* heightmap_state = geode->getOrCreateStateSet();
			heightmap_state->addUniform(new osg::Uniform("ModelMatrix", Scene::GetViewMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ProjectionMatrix", Scene::GetProjectionMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ViewMatrix", Scene::GetViewMatrix_View()));						
			
			heightmap_state->addUniform(new osg::Uniform("light_proj_matrix", Scene::GetProjectionMatrix_Light()));	
			heightmap_state->addUniform(new osg::Uniform("light_mv_matrix", Scene::GetLightCamera()->getViewMatrix()));	
								
			
			heightmap_state->setMode(GL_BLEND,osg::StateAttribute::ON);
			
//			osg::CullFace* cull = new osg::CullFace();
//			cull->setMode(osg::CullFace::FRONT); //ACHTUNG GENDERT
			//heightmap_state->setAttributeAndModes(cull, osg::StateAttribute::ON);
		
	
			heightmap_state->setAttribute(lightshaftProg.get());			
		}
	}

	terrain_group->setCullingActive(false); 

	osg::MatrixTransform* trans = new osg::MatrixTransform( osg::Matrixd(3000.f, 0.f, 0.f, 0.f, 
														  0.f, 3000.f, 0.f, 0.f, 
														  0.f, 0.f,1250.f, 0.f, 
														  0.f, 0.f,-1250.f, 1.f));	

	trans->addChild(terrain_obj);
	trans->setCullingActive(false);
	camera_lightshaft->addChild(trans);
}

osg::ref_ptr<osg::Camera> osgCloudyDay::LightShaft::GetCamera()
{
	return camera_lightshaft;
}