#include "ImportExport.h"


osgCloudyDay::ImportExport::ImportExport(void)
{
}


osgCloudyDay::ImportExport::~ImportExport(void)
{
}

void osgCloudyDay::ImportExport::AddCloud(Cloud c)
{
	m_cloud.push_back(c);
}

unsigned int osgCloudyDay::ImportExport::NumClouds()
{
	return m_cloud.size();
}

void osgCloudyDay::ImportExport::AddCloud(osg::ref_ptr<osg::Vec3Array> vertices, osg::ref_ptr<osg::Vec4Array> rotation, osg::ref_ptr<osg::Vec4Array> color, osg::ref_ptr<osg::Vec4Array> center, osg::ref_ptr<osg::Vec4Array> ids, osg::ref_ptr<osg::Vec4Array> box_centers, int num_boxes)
{
	osg::ref_ptr<osg::Vec3Array> ambientlight_h = new osg::Vec3Array();
	ambientlight_h->push_back(osg::Vec3(0.2f, 0.2f, 0.2f));
	ambientlight_h->push_back(osg::Vec3(0.8f, 0.8f, 0.8f));

	osg::ref_ptr<osg::Vec3Array> ambientlight_t = new osg::Vec3Array();
	ambientlight_t->push_back(osg::Vec3(0.1f, 0.1f, 0.1f));
	ambientlight_t->push_back(osg::Vec3(0.8f, 0.8f, 0.8f));

	osg::ref_ptr<osg::Vec3Array> diffuselight = new osg::Vec3Array();
	diffuselight->push_back(osg::Vec3(0.1f, 0.1f, 0.1f));
	diffuselight->push_back(osg::Vec3(0.5f, 0.5f, 0.5f));
	diffuselight->push_back(osg::Vec3(1.0f, 1.0f, 1.0f));

	Cloud cloud;

	std::vector<Box> boxes;
	boxes.resize(num_boxes);

	cloud.num_boxes = num_boxes;
	for(int i = 0; i < num_boxes; i++) 
	{
		boxes[i].vertices = new osg::Vec3Array();
		boxes[i].rotation = new osg::Vec4Array();
		boxes[i].color = new osg::Vec4Array();
		boxes[i].center = new osg::Vec4Array();
		boxes[i].ids = new osg::Vec4Array();
	}

	for(unsigned int i = 0; i < vertices->size(); i++)
	{
		int box_id = box_centers->at(i).w();

		boxes[box_id].vertices->push_back(vertices->at(i));
		boxes[box_id].rotation->push_back(rotation->at(i));
		boxes[box_id].color->push_back(color->at(i));
		boxes[box_id].ids->push_back(ids->at(i));
		boxes[box_id].center->push_back(center->at(i));
		boxes[box_id].box_center = osg::Vec3(box_centers->at(i).x(), box_centers->at(i).y(), box_centers->at(i).z());
	}

	cloud.m_boxes.resize(num_boxes);
	for(int i = 0; i < num_boxes; i++)	cloud.m_boxes[i] = (boxes[i]);

	cloud.diffuselight_h = ambientlight_h;
	cloud.diffuselight_t = ambientlight_t;
	cloud.ambientlight_color = diffuselight;

	AddCloud(cloud);
}

void osgCloudyDay::ImportExport::GetData(int at, osg::ref_ptr<osg::Vec3Array> &vertices, osg::ref_ptr<osg::Vec4Array> &rotation, osg::ref_ptr<osg::Vec4Array> &color, osg::ref_ptr<osg::Vec4Array> &center, osg::ref_ptr<osg::Vec4Array> &ids, osg::ref_ptr<osg::Vec4Array> &boxcenter)
{
	if((unsigned int)at >= m_cloud.size()) return;

	Cloud c = m_cloud[at];
	vertices = new osg::Vec3Array();
	rotation = new osg::Vec4Array();
	color = new osg::Vec4Array();
	center = new osg::Vec4Array();
	ids = new osg::Vec4Array();
	boxcenter = new osg::Vec4Array();

	for(unsigned int i = 0; i < c.m_boxes.size(); i++)
	{
		for(unsigned int j = 0; j < c.m_boxes[i].vertices->size(); j++)
		{
			vertices->push_back(c.m_boxes[i].vertices->at(j));
			color->push_back(c.m_boxes[i].color->at(j));
			rotation->push_back(c.m_boxes[i].rotation->at(j));
			center->push_back(osg::Vec4(c.m_boxes[i].center->at(j)));
			ids->push_back(c.m_boxes[i].ids->at(j));
			boxcenter->push_back(osg::Vec4(c.m_boxes[i].box_center.x(), c.m_boxes[i].box_center.y(), c.m_boxes[i].box_center.z(), 1.0));
		}
	}
}