#include "ImportClouds.h"
#include <tinyxml2.h>

osgCloudyDay::ImportClouds::ImportClouds(void)
{

}

osgCloudyDay::ImportClouds::~ImportClouds(void)
{

}

void osgCloudyDay::ImportClouds::Perform()
{
	tinyxml2::XMLDocument doc;
    int r = doc.LoadFile( "foo.xml" );

	if(r == 0)
	{

		tinyxml2::XMLElement* xml_root = doc.FirstChildElement();
		tinyxml2::XMLElement* xml_cloud = xml_root->FirstChildElement();

		while(xml_cloud != 0)
		{			
			Cloud c;
			
			double x = 0.0, y = 0.0, z = 0.0;
			double cx = 0.0, cy = 0.0, cz = 0.0, cw = 0.0;
			tinyxml2::XMLElement* xml_position = xml_cloud->FirstChildElement("Position");
			xml_position->QueryDoubleAttribute("x", &x);
			xml_position->QueryDoubleAttribute("y", &y);
			xml_position->QueryDoubleAttribute("z", &z);
			c.cloud_center = osg::Vec3(x,y,z);

			c.ambientlight_color = new osg::Vec3Array();
			c.diffuselight_h = new osg::Vec3Array();
			c.diffuselight_t = new osg::Vec3Array();

			double r = 0.0, g = 0.0, b = 0.0;

			tinyxml2::XMLElement* xml_ambient = xml_cloud->FirstChildElement("Ambient");
			tinyxml2::XMLElement* xml_color = xml_ambient->FirstChildElement("Color");
			while(xml_color != 0)
			{
				xml_color->QueryDoubleAttribute("r", &r);
				xml_color->QueryDoubleAttribute("g", &g);
				xml_color->QueryDoubleAttribute("b", &b);
				c.ambientlight_color->push_back(osg::Vec3(r,g,b));
				xml_color = xml_color->NextSiblingElement("Color");
			}
			
			tinyxml2::XMLElement* xml_diffuse_height = xml_cloud->FirstChildElement("Diffuse_Height");
			xml_color = xml_diffuse_height->FirstChildElement("Color");
			while(xml_color != 0)
			{
				xml_color->QueryDoubleAttribute("r", &r);
				xml_color->QueryDoubleAttribute("g", &g);
				xml_color->QueryDoubleAttribute("b", &b);
				c.diffuselight_h->push_back(osg::Vec3(r,g,b));
				xml_color = xml_color->NextSiblingElement("Color");
			}
			
			tinyxml2::XMLElement* xml_diffuse_time = xml_cloud->FirstChildElement("Diffuse_Time");
			xml_color = xml_diffuse_time->FirstChildElement("Color");
			while(xml_color != 0)
			{
				xml_color->QueryDoubleAttribute("r", &r);
				xml_color->QueryDoubleAttribute("g", &g);
				xml_color->QueryDoubleAttribute("b", &b);
				c.diffuselight_t->push_back(osg::Vec3(r,g,b));
				xml_color = xml_color->NextSiblingElement("Color");
			}

			tinyxml2::XMLElement* xml_box = xml_cloud->FirstChildElement("Box");
	
			while(xml_box != 0)
			{
				Box* b = new Box();

				tinyxml2::XMLElement* xml_position = xml_box->FirstChildElement("Position");		
				xml_position->QueryDoubleAttribute("x", &x);
				xml_position->QueryDoubleAttribute("y", &y);
				xml_position->QueryDoubleAttribute("z", &z);
				b->box_center = osg::Vec3(x,y,z);

				b->vertices = new osg::Vec3Array();
				b->rotation = new osg::Vec4Array();
				b->center = new osg::Vec4Array();
				b->color = new osg::Vec4Array();
				b->ids = new osg::Vec4Array();
				tinyxml2::XMLElement* xml_particle = xml_box->FirstChildElement("Particle");
					
				int n = 0;
				while(xml_particle != 0)
				{
					int texId = 0, texId2 = 0;
					double rotation = 0.0, texId_weight = 0.0, density = 0.0;
					xml_particle->QueryIntAttribute("TextureID", &texId);
					xml_particle->QueryIntAttribute("TextureID2", &texId2);
					xml_particle->QueryDoubleAttribute("TextureID_Weight", &texId_weight);
					xml_particle->QueryDoubleAttribute("Rotation", &rotation);
					xml_particle->QueryDoubleAttribute("Density", &density);
						
					xml_position = xml_particle->FirstChildElement("Position");
					xml_position->QueryDoubleAttribute("x", &x);
					xml_position->QueryDoubleAttribute("y", &y);
					xml_position->QueryDoubleAttribute("z", &z);
					b->vertices->push_back(osg::Vec3(x, y, z));

					
					xml_color = xml_particle->FirstChildElement("Color");
					xml_color->QueryDoubleAttribute("x", &cx);
					xml_color->QueryDoubleAttribute("y", &cy);
					xml_color->QueryDoubleAttribute("z", &cz);
					xml_color->QueryDoubleAttribute("w", &cw);
					b->color->push_back(osg::Vec4(cx, cy, cz, cw));

					tinyxml2::XMLElement* xml_center = xml_particle->FirstChildElement("Center");
					if(xml_center != 0)
					{
						xml_center->QueryDoubleAttribute("x", &cx);
						xml_center->QueryDoubleAttribute("y", &cy);
						xml_center->QueryDoubleAttribute("z", &cz);
						xml_color->QueryDoubleAttribute("w", &cw);
					}
					b->center->push_back(osg::Vec4(cx, cy, cz, cw));

					tinyxml2::XMLElement* xml_size = xml_particle->FirstChildElement("Size");
					xml_size->QueryDoubleAttribute("x", &x);
					xml_size->QueryDoubleAttribute("y", &y);
					b->rotation->push_back(osg::Vec4(rotation, x, y, density));

					b->ids->push_back(osg::Vec4(texId, texId2, texId_weight, 0.0));

					n++;
					xml_particle = xml_particle->NextSiblingElement("Particle");		
				}
	
				c.m_boxes.push_back(*b);
				xml_box = xml_box->NextSiblingElement("Box");
			}

			this->m_cloud.push_back(c);
			xml_cloud = xml_cloud->NextSiblingElement("Cloud");
		}
	}
	else std::cout << "Loading not correct, ErrorCode: " << r << std::endl;
}
