#include "HUD.h"

//LUMIANCE EFFECT
osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_lum0_texture=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_lum1_texture=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_lum2_texture=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_lum3_texture=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_lum4_texture=0;
osg::FrameBufferObject* osgCloudyDay::HUD::fbo_Lum0=0;
osg::FrameBufferObject* osgCloudyDay::HUD::fbo_Lum1=0;
osg::FrameBufferObject* osgCloudyDay::HUD::fbo_Lum2=0;
osg::FrameBufferObject* osgCloudyDay::HUD::fbo_Lum3=0;
osg::FrameBufferObject* osgCloudyDay::HUD::fbo_Lum4=0;

osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_glare_texture=0;

//STAR AND GLARE EFFECT
osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_blurV1_texture=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_blurV2_texture=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_blurV3_texture=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_blurV4_texture=0;

osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_blurH1_texture=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_blurH2_texture=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_blurH3_texture=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_blurH4_texture=0;

osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_star1_texture=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_star2_texture=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_star3_texture=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::HUD::fbo_star4_texture=0;

osg::FrameBufferObject* osgCloudyDay::HUD::fbo_V1_blur=0;
osg::FrameBufferObject* osgCloudyDay::HUD::fbo_H1_blur=0;
osg::FrameBufferObject* osgCloudyDay::HUD::fbo_V2_blur=0;
osg::FrameBufferObject* osgCloudyDay::HUD::fbo_H2_blur=0;
osg::FrameBufferObject* osgCloudyDay::HUD::fbo_V3_blur=0;
osg::FrameBufferObject* osgCloudyDay::HUD::fbo_H3_blur=0;
osg::FrameBufferObject* osgCloudyDay::HUD::fbo_V4_blur=0;
osg::FrameBufferObject* osgCloudyDay::HUD::fbo_H4_blur=0;

osgCloudyDay::HUD::HUD(osg::ref_ptr<osg::Texture> debug_tex) : renderorder(3)
{
	m_debug_tex = debug_tex;
}


osgCloudyDay::HUD::HUD(void) : renderorder(3)
{
}


osgCloudyDay::HUD::~HUD(void)
{
}

void osgCloudyDay::HUD::Initialize()
{
	fbo_glare_texture = new osg::Texture2D();
	fbo_glare_texture->setBorderWidth(0);
	fbo_glare_texture->setTextureSize(osgCloudyDay::Scene::GetWidth(), osgCloudyDay::Scene::GetHeight());
	fbo_glare_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_glare_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_glare_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_glare_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_glare_texture->setInternalFormat(GL_RGBA32F/*GL_SRGB8_ALPHA8_EXT*/);
	fbo_glare_texture->setSourceFormat(GL_RGBA);
	fbo_glare_texture->setSourceType(GL_FLOAT);		
	//fbo_glare_texture->setUseHardwareMipMapGeneration(true);

	///////////////////

	fbo_blurV1_texture = new osg::Texture2D();
	fbo_blurV1_texture->setBorderWidth(0);
	fbo_blurV1_texture->setTextureSize(osgCloudyDay::Scene::GetWidth(), osgCloudyDay::Scene::GetHeight());
	fbo_blurV1_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_blurV1_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_blurV1_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_blurV1_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_blurV1_texture->setInternalFormat(GL_RGB8);
	fbo_blurV1_texture->setSourceFormat(GL_RGB);
	fbo_blurV1_texture->setSourceType(GL_FLOAT);

	fbo_blurH1_texture = new osg::Texture2D();
	fbo_blurH1_texture->setBorderWidth(0);
	fbo_blurH1_texture->setTextureSize(osgCloudyDay::Scene::GetWidth(), osgCloudyDay::Scene::GetHeight());
	fbo_blurH1_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_blurH1_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_blurH1_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_blurH1_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_blurH1_texture->setInternalFormat(GL_RGB8);
	fbo_blurH1_texture->setSourceFormat(GL_RGB);
	fbo_blurH1_texture->setSourceType(GL_FLOAT);

	fbo_star1_texture = new osg::Texture2D();
	fbo_star1_texture->setBorderWidth(0);
	fbo_star1_texture->setTextureSize(osgCloudyDay::Scene::GetWidth(), osgCloudyDay::Scene::GetHeight());
	fbo_star1_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_star1_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_star1_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_star1_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_star1_texture->setInternalFormat(GL_RGB8);
	fbo_star1_texture->setSourceFormat(GL_RGB);
	fbo_star1_texture->setSourceType(GL_FLOAT);


	fbo_blurV2_texture = new osg::Texture2D();	
	fbo_blurV2_texture->setBorderWidth(0);
	fbo_blurV2_texture->setTextureSize(osgCloudyDay::Scene::GetWidth()/2,osgCloudyDay::Scene::GetHeight()/2);
	fbo_blurV2_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_blurV2_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_blurV2_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_blurV2_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_blurV2_texture->setInternalFormat(GL_RGB8);
	fbo_blurV2_texture->setSourceFormat(GL_RGB);
	fbo_blurV2_texture->setSourceType(GL_FLOAT);

	fbo_blurH2_texture = new osg::Texture2D();
	fbo_blurH2_texture->setBorderWidth(0);
	fbo_blurH2_texture->setTextureSize(osgCloudyDay::Scene::GetWidth()/2,osgCloudyDay::Scene::GetHeight()/2);
	fbo_blurH2_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_blurH2_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_blurH2_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_blurH2_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_blurH2_texture->setInternalFormat(GL_RGB8);
	fbo_blurH2_texture->setSourceFormat(GL_RGB);
	fbo_blurH2_texture->setSourceType(GL_FLOAT);

	fbo_star2_texture = new osg::Texture2D();
	fbo_star2_texture->setBorderWidth(0);
	fbo_star2_texture->setTextureSize(osgCloudyDay::Scene::GetWidth()/2,osgCloudyDay::Scene::GetHeight()/2);
	fbo_star2_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_star2_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_star2_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_star2_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_star2_texture->setInternalFormat(GL_RGB8);
	fbo_star2_texture->setSourceFormat(GL_RGB);
	fbo_star2_texture->setSourceType(GL_FLOAT);

	
	fbo_blurV3_texture = new osg::Texture2D();
	fbo_blurV3_texture->setBorderWidth(0);
	fbo_blurV3_texture->setTextureSize(osgCloudyDay::Scene::GetWidth()/4,osgCloudyDay::Scene::GetHeight()/4);
	fbo_blurV3_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_blurV3_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_blurV3_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_blurV3_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_blurV3_texture->setInternalFormat(GL_RGB8);
	fbo_blurV3_texture->setSourceFormat(GL_RGB);
	fbo_blurV3_texture->setSourceType(GL_FLOAT);

	fbo_blurH3_texture = new osg::Texture2D();
	fbo_blurH3_texture->setBorderWidth(0);
	fbo_blurH3_texture->setTextureSize(osgCloudyDay::Scene::GetWidth()/4,osgCloudyDay::Scene::GetHeight()/4);
	fbo_blurH3_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_blurH3_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_blurH3_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_blurH3_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_blurH3_texture->setInternalFormat(GL_RGB8);
	fbo_blurH3_texture->setSourceFormat(GL_RGB);
	fbo_blurH3_texture->setSourceType(GL_FLOAT);

	fbo_star3_texture = new osg::Texture2D();
	fbo_star3_texture->setBorderWidth(0);
	fbo_star3_texture->setTextureSize(osgCloudyDay::Scene::GetWidth()/4,osgCloudyDay::Scene::GetHeight()/4);
	fbo_star3_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_star3_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_star3_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_star3_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_star3_texture->setInternalFormat(GL_RGB8);
	fbo_star3_texture->setSourceFormat(GL_RGB);
	fbo_star3_texture->setSourceType(GL_FLOAT);


	fbo_blurV4_texture = new osg::Texture2D();
	fbo_blurV4_texture->setBorderWidth(0);
	fbo_blurV4_texture->setTextureSize(osgCloudyDay::Scene::GetWidth()/8, osgCloudyDay::Scene::GetHeight()/8);
	fbo_blurV4_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_blurV4_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_blurV4_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_blurV4_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_blurV4_texture->setInternalFormat(GL_RGB8);
	fbo_blurV4_texture->setSourceFormat(GL_RGB);
	fbo_blurV4_texture->setSourceType(GL_FLOAT);

	fbo_blurH4_texture = new osg::Texture2D();
	fbo_blurH4_texture->setBorderWidth(0);
	fbo_blurH4_texture->setTextureSize(osgCloudyDay::Scene::GetWidth()/8, osgCloudyDay::Scene::GetHeight()/8);
	fbo_blurH4_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_blurH4_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_blurH4_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_blurH4_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_blurH4_texture->setInternalFormat(GL_RGB8);
	fbo_blurH4_texture->setSourceFormat(GL_RGB);
	fbo_blurH4_texture->setSourceType(GL_FLOAT);

	fbo_star4_texture = new osg::Texture2D();
	fbo_star4_texture->setBorderWidth(0);
	fbo_star4_texture->setTextureSize(osgCloudyDay::Scene::GetWidth()/8, osgCloudyDay::Scene::GetHeight()/8);
	fbo_star4_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_star4_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_star4_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_star4_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_star4_texture->setInternalFormat(GL_RGB8);
	fbo_star4_texture->setSourceFormat(GL_RGB);
	fbo_star4_texture->setSourceType(GL_FLOAT);

	fbo_V1_blur = new osg::FrameBufferObject();		
	fbo_H1_blur = new osg::FrameBufferObject();
	fbo_V2_blur = new osg::FrameBufferObject();		
	fbo_H2_blur = new osg::FrameBufferObject();
	fbo_V3_blur = new osg::FrameBufferObject();		
	fbo_H3_blur = new osg::FrameBufferObject();
	fbo_V4_blur = new osg::FrameBufferObject();		
	fbo_H4_blur = new osg::FrameBufferObject();

	fbo_V1_blur->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(fbo_blurV1_texture));	
	fbo_H1_blur->setAttachment(osg::Camera::COLOR_BUFFER0, osg::FrameBufferAttachment(fbo_blurH1_texture));
	fbo_H1_blur->setAttachment(osg::Camera::COLOR_BUFFER1, osg::FrameBufferAttachment(fbo_star1_texture));
	
	fbo_V2_blur->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(fbo_blurV2_texture));	
	fbo_H2_blur->setAttachment(osg::Camera::COLOR_BUFFER0, osg::FrameBufferAttachment(fbo_blurH2_texture));
	fbo_H2_blur->setAttachment(osg::Camera::COLOR_BUFFER1, osg::FrameBufferAttachment(fbo_star2_texture));
	
	fbo_V3_blur->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(fbo_blurV3_texture));	
	fbo_H3_blur->setAttachment(osg::Camera::COLOR_BUFFER0, osg::FrameBufferAttachment(fbo_blurH3_texture));
	fbo_H3_blur->setAttachment(osg::Camera::COLOR_BUFFER1, osg::FrameBufferAttachment(fbo_star3_texture));
	
	fbo_V4_blur->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(fbo_blurV4_texture));	
	fbo_H4_blur->setAttachment(osg::Camera::COLOR_BUFFER0, osg::FrameBufferAttachment(fbo_blurH4_texture));
	fbo_H4_blur->setAttachment(osg::Camera::COLOR_BUFFER1, osg::FrameBufferAttachment(fbo_star4_texture));

///////////////////////
	fbo_lum0_texture = new osg::Texture2D();
	fbo_lum0_texture->setBorderWidth(0);
	fbo_lum0_texture->setTextureSize(256,256);
	fbo_lum0_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_lum0_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_lum0_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_lum0_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_lum0_texture->setInternalFormat(GL_RGBA8);
	fbo_lum0_texture->setSourceFormat(GL_RGBA);
	fbo_lum0_texture->setSourceType(GL_FLOAT);

	fbo_lum1_texture = new osg::Texture2D();
	fbo_lum1_texture->setBorderWidth(0);
	fbo_lum1_texture->setTextureSize(64,64);
	fbo_lum1_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_lum1_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_lum1_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_lum1_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_lum1_texture->setInternalFormat(GL_RGBA8);
	fbo_lum1_texture->setSourceFormat(GL_RGBA);
	fbo_lum1_texture->setSourceType(GL_FLOAT);

	fbo_lum2_texture = new osg::Texture2D();
	fbo_lum2_texture->setBorderWidth(0);
	fbo_lum2_texture->setTextureSize(16,16);
	fbo_lum2_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_lum2_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_lum2_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_lum2_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_lum2_texture->setInternalFormat(GL_RGBA8);
	fbo_lum2_texture->setSourceFormat(GL_RGBA);
	fbo_lum2_texture->setSourceType(GL_FLOAT);

	fbo_lum3_texture = new osg::Texture2D();
	fbo_lum3_texture->setBorderWidth(0);
	fbo_lum3_texture->setTextureSize(4,4);
	fbo_lum3_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_lum3_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_lum3_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_lum3_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_lum3_texture->setInternalFormat(GL_RGBA8);
	fbo_lum3_texture->setSourceFormat(GL_RGBA);
	fbo_lum3_texture->setSourceType(GL_FLOAT);

	fbo_lum4_texture = new osg::Texture2D();
	fbo_lum4_texture->setBorderWidth(0);
	fbo_lum4_texture->setTextureSize(1,1);
	fbo_lum4_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_lum4_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_lum4_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_lum4_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_lum4_texture->setInternalFormat(GL_RGBA32F);
	fbo_lum4_texture->setSourceFormat(GL_RGBA);
	fbo_lum4_texture->setSourceType(GL_FLOAT);

	fbo_Lum0 = new osg::FrameBufferObject();			
	fbo_Lum1 = new osg::FrameBufferObject();		
	fbo_Lum2 = new osg::FrameBufferObject();		
	fbo_Lum3 = new osg::FrameBufferObject();		
	fbo_Lum4 = new osg::FrameBufferObject();		

	fbo_Lum0->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(fbo_lum0_texture));	
	fbo_Lum1->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(fbo_lum1_texture));	
	fbo_Lum2->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(fbo_lum2_texture));	
	fbo_Lum3->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(fbo_lum3_texture));	
	fbo_Lum4->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(fbo_lum4_texture));

}

osg::ref_ptr<osg::Camera> osgCloudyDay::HUD::GetCamera()
{
	return cam_hud;
}

void osgCloudyDay::HUD::CreateGeometry()
{	
	plane = (new osg::Geode());
	nodessP = plane->getOrCreateStateSet();	

	if(renderorder == 4)
	{	
		sh_blur_linear = new osg::Program();
		osg::ref_ptr<osg::Shader> shadowvertShaderV(osg::Shader::readShaderFile (osg::Shader::VERTEX,	"shaders/linear_blur_vert2.vert"));
		osg::ref_ptr<osg::Shader> shadowfragShaderV(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/linear_blur_vert2.frag"));		
		sh_blur_linear->addShader(shadowvertShaderV.get());
		sh_blur_linear->addShader(shadowfragShaderV.get());	
		sh_blur_linear->addBindFragDataLocation("out_color", 0);
		sh_blur_linear->addBindAttribLocation("vertex", 0);
		
		nodessP->setAttribute(sh_blur_linear.get());			
	}
	else if(renderorder == 5)
	{
		sh_blur_linear = new osg::Program();
		osg::ref_ptr<osg::Shader> shadowvertShaderH(osg::Shader::readShaderFile (osg::Shader::VERTEX,	"shaders/linear_blur_hori2.vert"));
		osg::ref_ptr<osg::Shader> shadowfragShaderH(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/linear_blur_hori2.frag"));		
		sh_blur_linear->addShader(shadowvertShaderH.get());
		sh_blur_linear->addShader(shadowfragShaderH.get());	
		sh_blur_linear->addBindFragDataLocation("out_color", 0);	
		sh_blur_linear->addBindFragDataLocation("out_color2", 1);	
		sh_blur_linear->addBindAttribLocation("vertex", 0);
		
		nodessP->setAttribute(sh_blur_linear.get());			
	}
	else
	{
		sh_lum = new osg::Program();
		osg::ref_ptr<osg::Shader> shadowvertShaderV(osg::Shader::readShaderFile (osg::Shader::VERTEX,	"shaders/avg_sum.vert"));
		osg::ref_ptr<osg::Shader> shadowfragShaderV(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/avg_sum.frag"));		
		sh_lum->addShader(shadowvertShaderV.get());
		sh_lum->addShader(shadowfragShaderV.get());	
		sh_lum->addBindFragDataLocation("out_color", 0);
		sh_lum->addBindAttribLocation("vertex", 0);

		nodessP->setAttribute(sh_lum.get());			
	}	
	
	if(renderorder==4 || renderorder==5 || renderorder == 6)	
	{
		SetupUniform(nodessP);	

		osg::ref_ptr<osg::Geometry> geom;		
		if(renderorder==4)
		{				
			geom = new BlurGeometry(sh_blur_linear, renderorder-4,
				fbo_glare_texture,
				uniform_blur_texsize, 
				fbo_V1_blur, fbo_H1_blur,
				fbo_V2_blur, fbo_H2_blur,
				fbo_V3_blur, fbo_H3_blur,
				fbo_V4_blur, fbo_H4_blur,
				fbo_blurV1_texture, fbo_blurH1_texture,
				fbo_blurV2_texture, fbo_blurH2_texture,
				fbo_blurV3_texture, fbo_blurH3_texture,
				fbo_blurV4_texture, fbo_blurH4_texture
			);						
		}
		else if(renderorder == 5)
		{			
			geom = new BlurGeometry(sh_blur_linear, renderorder-4,
				fbo_glare_texture,
				uniform_blur_texsize,
				fbo_V1_blur, fbo_H1_blur,
				fbo_V2_blur, fbo_H2_blur,
				fbo_V3_blur, fbo_H3_blur,
				fbo_V4_blur, fbo_H4_blur,
				fbo_blurV1_texture, fbo_blurH1_texture,
				fbo_blurV2_texture, fbo_blurH2_texture,
				fbo_blurV3_texture, fbo_blurH3_texture,
				fbo_blurV4_texture, fbo_blurH4_texture);						
		}
		else
		{			
			geom = new Luminance(sh_lum, Scene::GetSceneTexture(),
				fbo_Lum0,fbo_Lum1, fbo_Lum2, fbo_Lum3, fbo_Lum4,
				fbo_lum0_texture, fbo_lum1_texture, fbo_lum2_texture, fbo_lum3_texture, fbo_lum4_texture);						
		}

		osg::Vec3 width, depth, topleft;
		topleft = osg::Vec3(0.0, 0.0, 0.0 );
		width = osg::Vec3( 1.0, 0.0, 0.0 );
		depth = osg::Vec3( 0.0, 1.0, 0.0 );

		osg::ref_ptr<osg::Vec3Array> vertices = (new osg::Vec3Array());		
		vertices->push_back(topleft);
		vertices->push_back(topleft+depth);
		vertices->push_back(topleft+width+depth);
		vertices->push_back(topleft+width);	

		unsigned int* index = new unsigned int[4];
		index[0] = 0;	index[1] = 1;	index[2] = 2;		index[3] = 3;		

		geom->setVertexAttribArray(0, vertices.get());
		geom->setVertexAttribBinding(0, osg::Geometry::BIND_PER_VERTEX);				
		
		geom->addPrimitiveSet(new osg::DrawElementsUInt(osg::PrimitiveSet::QUADS, 4, &index[0]));
		geom->getPrimitiveSet(0)->getDrawElements()->setDataVariance(osg::Object::DYNAMIC);		
		
		geom->setUseVertexBufferObjects(true);
		geom->setSupportsDisplayList(false);		

		plane->addDrawable(geom.get());		
		//plane->addCullCallback(new ViewerCallbackBlur);

		plane->getDrawable(0)->asGeometry()->getPrimitiveSet(0)->dirty();
		geom->getVertexAttribArray(0)->dirty();
		geom->dirtyBound();
		plane->getDrawable(0)->dirtyBound();
		plane->dirtyBound();

		delete[] index;

		nodessP = plane->getOrCreateStateSet();	

		if(renderorder==4)		
		{
			
		}
		else if(renderorder==5)	
		{			
		}
		else					
		{
			Luminance* geomlum = dynamic_cast<Luminance*>(geom.get());			
			geomlum->uniform_avg_texsize = HUD::uniform_avg_texsize;
		}
	}
	else 
	{		
		//_________________________________
		//POST PROCESSING STEP
		plane->addDrawable(
			osg::createTexturedQuadGeometry(osg::Vec3(-0.5,-0.5, 0.0),
											osg::Vec3( 1.0, 0.0, 0.0),
											osg::Vec3( 0.0, 1.0, 0.0))
		);
		plane->getDrawable(0)->setSupportsDisplayList(false);

		plane->addCullCallback(new ViewerCallbackHUD);
		if(renderorder==7)	
			plane->getDrawable(0)->setDrawCallback(new FBODrawCallback(Scene::GetHUDTexture().get(), fbo_glare_texture.get()));					
		
		nodessP = plane->getOrCreateStateSet();	
		SetupUniform(nodessP);	
	}
		
	SetupTextures(nodessP);
	
	//osg::Depth* depth = new osg::Depth(osg::Depth::ALWAYS, 0.0, 1.0, false);
	//nodessP->setAttribute(depth);	

	//uview->setUpdateCallback(new ViewPostProcessingCullHandler);
	//uprojection->setUpdateCallback(new ProjectionPostProcessingCullHandler);

	cam_hud->addChild(plane);	
}

void osgCloudyDay::HUD::SetSceneTexture(osg::ref_ptr<osg::Texture2D> tex)
{
	m_scenetex = tex;
}

void osgCloudyDay::HUD::SetGodrayTexture(osg::ref_ptr<osg::Texture2D> tex)
{
	m_goodraytex = tex;
}

void osgCloudyDay::HUD::SetCloudTexture(osg::ref_ptr<osg::Texture2D> tex)
{
	m_cloudtex = tex;
}

void osgCloudyDay::HUD::SetupTextures(osg::ref_ptr<osg::StateSet> nodessP)
{
	//nodessP->setTextureAttributeAndModes(0, Scene::GetSceneTexture().get());	
	//nodessP->setTextureAttributeAndModes(1, Scene::GetGoodRayTexture().get());
	//nodessP->setTextureAttributeAndModes(2, osgCloudyDay::CloudScene::fbo_cloud_texture.get());
	
	nodessP->setTextureAttributeAndModes(0, m_scenetex.get());	
	nodessP->setTextureAttributeAndModes(1, m_goodraytex.get());
	nodessP->setTextureAttributeAndModes(2, m_cloudtex.get());
	nodessP->setTextureAttributeAndModes(3, m_debug_tex.get());

	//nodessP->setTextureAttributeAndModes(5, fbo_lightshaft1.get());
}

void osgCloudyDay::HUD::SetupUniform(osg::ref_ptr<osg::StateSet> nodessP)
{
	planeProg =(new osg::Program);
	osg::ref_ptr<osg::Shader> planevertexShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/hdr.vert"));
	osg::ref_ptr<osg::Shader> planefragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/hdr.frag"));
	
	//Binding the box shaders to its program
	planeProg->addShader(planevertexShader.get());
	planeProg->addShader(planefragShader.get());
	planeProg->addBindAttribLocation("vertex", 0);
	planeProg->addBindFragDataLocation("out_color", 0);
	planeProg->addBindFragDataLocation("out_color2", 1);

	nodessP->setAttribute(planeProg.get());
	nodessP->addUniform(new osg::Uniform("color_tex", 0));
	nodessP->addUniform(new osg::Uniform("ls_tex", 1));
	nodessP->addUniform(new osg::Uniform("color_cloud_tex", 2));	
	nodessP->addUniform(new osg::Uniform("debug_tex", 3));
	nodessP->addUniform(new osg::Uniform("ProjectionMatrix", osg::Matrixd()));
	nodessP->addUniform(new osg::Uniform("ModelViewMatrix", osg::Matrixd()));
	nodessP->addUniform(new osg::Uniform("ViewMatrix", osg::Matrixd()));
	nodessP->addUniform(new osg::Uniform("un_lightPos", Scene::m_skydome->GetLightPosition()));
	nodessP->addUniform(new osg::Uniform("weight", Scene::m_skydome->GetLightScatteringWeight()));
	nodessP->addUniform(new osg::Uniform("exposure", Scene::m_skydome->GetExposure()));
	nodessP->addUniform(new osg::Uniform("density", Scene::m_skydome->GetDensity()));
	nodessP->addUniform(new osg::Uniform("decay", Scene::m_skydome->GetDecay()));

	nodessP->addUniform(new osg::Uniform("un_width", Scene::GetWidth()));
	nodessP->addUniform(new osg::Uniform("un_height", Scene::GetHeight()));
}

void osgCloudyDay::HUD::CreateCamera()
{
	std::cout << "void HUD::CreateCamera()" << std::endl;
	osg::ref_ptr<osg::GraphicsContext::Traits> traits = new osg::GraphicsContext::Traits;
	traits->x = 20;
	traits->y = 20;
	traits->width = osgCloudyDay::Scene::GetWidth();
	traits->height = osgCloudyDay::Scene::GetHeight();
	traits->windowDecoration = true;
	traits->doubleBuffer = true;
	traits->sharedContext = 0;
	osg::ref_ptr<osg::GraphicsContext> gc = osg::GraphicsContext::createGraphicsContext(traits.get());

	cam_hud = new osg::Camera;
	cam_hud->setViewMatrix(osg::Matrixd().lookAt(osg::Vec3(2.0, 0.0, 0.0), osg::Vec3(0.f, 0.f ,0.f), osg::Vec3(0.f, 0.f, 1.f)));
	cam_hud->setProjectionMatrix(osg::Matrixd().ortho(-0.5f, 0.5f, -0.5f, 0.5f, 1.f, 100.f));
	cam_hud->setGraphicsContext(gc.get());
	cam_hud->setViewport(new osg::Viewport(0,0, traits->width, traits->height));

	GLenum buffer = traits->doubleBuffer ? GL_BACK : GL_FRONT;
	cam_hud->setDrawBuffer(buffer);
	cam_hud->setReadBuffer(buffer);
	cam_hud->setReferenceFrame(osg::Transform::ABSOLUTE_RF);
	cam_hud->setClearMask(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
	cam_hud->setRenderOrder(osg::Camera::POST_RENDER,renderorder+1);
	cam_hud->setAllowEventFocus(false);
	cam_hud->attach(osg::Camera::COLOR_BUFFER0, Scene::GetHUDTexture());	
	cam_hud->attach(osg::Camera::COLOR_BUFFER1, fbo_glare_texture);		
	cam_hud->getOrCreateStateSet()->setMode(GL_LIGHTING, osg::StateAttribute::OFF);
	cam_hud->setRenderTargetImplementation(osg::Camera::FRAME_BUFFER_OBJECT);
}