#include "Ground.h"
#include "CloudScene.h"

osgCloudyDay::Ground::Ground(void) : geode2(0)
{
}


osgCloudyDay::Ground::~Ground(void)
{
}

osg::Geode* osgCloudyDay::Ground::Create()
{
	// set up the Geometry.
	osg::ref_ptr<osg::Geode> terrain (new osg::Geode);
	osg::Geometry* geom = new osg::Geometry;

	const float Size = 	50000.0f;
	osg::Vec3 width, depth, topleft;
	topleft = osg::Vec3( -Size/2.0, -Size/2.0, -1000.0 );
	width = osg::Vec3( Size, 0.0, 0.0 );
	depth = osg::Vec3( 0.0, Size, 0.0 );

	osg::Vec3Array* coords = new osg::Vec3Array(4);
	(*coords)[0] = topleft;		
	(*coords)[1] = topleft+depth;
	(*coords)[2] = topleft+width+depth;
	(*coords)[3] = topleft+width;

	osg::Vec3Array* norms = new osg::Vec3Array(4);
	(*norms)[0] = osg::Vec3( 0.0, 0.0, 1.0 );
	(*norms)[1] = osg::Vec3( 0.0, 0.0, 1.0 );
	(*norms)[2] = osg::Vec3( 0.0, 0.0, 1.0 );
	(*norms)[3] = osg::Vec3( 0.0, 0.0, 1.0 );

	osg::Vec2Array* tcoords = new osg::Vec2Array(4);
	float n = 1.0f;  // no of times the texture is repeated
	(*tcoords)[0].set( 0.0f, 0.0f );	
	(*tcoords)[1].set( 0.0f, n );
	(*tcoords)[2].set( n, n );	
	(*tcoords)[3].set( n, 0.0f );

	geom->setVertexArray(coords);
	geom->setVertexAttribData( 1, osg::Geometry::ArrayData( tcoords, osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );
	geom->setVertexAttribData( 2, osg::Geometry::ArrayData( norms, osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );
	geom->setUseDisplayList(false);
	geom->addPrimitiveSet( new osg::DrawArrays( osg::PrimitiveSet::QUADS, 0 , coords->size() ) );
	terrain->addDrawable( geom );

	geode2 = new osg::Geode(*terrain);

	osg::StateSet* stateset = (geode2->getOrCreateStateSet());
 	stateset->setAttribute(osgCloudyDay::Scene::GetShadingProgram().get());	
	stateset->addUniform(new osg::Uniform("ProjectionMatrix", osgCloudyDay::Scene::GetProjectionMatrix_View()));
	stateset->addUniform(new osg::Uniform("ViewMatrix", osgCloudyDay::Scene::GetViewMatrix_View()));
	stateset->addUniform(new osg::Uniform("ModelMatrix", osg::Matrixd()));		
	stateset->addUniform(new osg::Uniform("light_mv_matrix", osgCloudyDay::Scene::GetProjectionMatrix_Light()));
	stateset->addUniform(new osg::Uniform("light_proj_matrix", osgCloudyDay::Scene::GetLightCamera()->getViewMatrix()));

	geode2->addCullCallback(new osgCloudyDay::ViewerLightCallback);	

	osg::StateSet* nodess8 = (terrain->getOrCreateStateSet());		
 	nodess8->setAttribute(osgCloudyDay::Scene::GetShadingProgram().get());	
	nodess8->addUniform(new osg::Uniform("ProjectionMatrix", osgCloudyDay::Scene::GetProjectionMatrix_View()));
	nodess8->addUniform(new osg::Uniform("ViewMatrix", osgCloudyDay::Scene::GetViewMatrix_View()));
	nodess8->addUniform(new osg::Uniform("ModelMatrix", osg::Matrixd()));	
	nodess8->addUniform(new osg::Uniform("tex0", 0));
	nodess8->addUniform(new osg::Uniform("light_proj_matrix", osgCloudyDay::Scene::GetProjectionMatrix_Light()));	
	nodess8->addUniform(new osg::Uniform("light_mv_matrix", osgCloudyDay::Scene::GetLightCamera()->getViewMatrix()));	
	nodess8->addUniform(new osg::Uniform("shadow_tex", 1));

	terrain->addCullCallback(new osgCloudyDay::ViewerLightCallback);
	//scene->addChild(terrain);

	nodess8->setTextureAttributeAndModes(0,osgCloudyDay::Scene::GetShadowDepthTexture(),osg::StateAttribute::ON);
	nodess8->setTextureAttributeAndModes(1,osgCloudyDay::CloudScene::fbo_light_texture,osg::StateAttribute::ON);

	return geode2;
}