#include "Grass.h"
#include "CloudScene.h"
#include <osg/PolygonMode>
#include <osgUtil/SmoothingVisitor>
#include <osgUtil/TangentSpaceGenerator>

osg::ref_ptr<osg::Program> osgCloudyDay::Grass::m_grassProg=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::Grass::tex_tree=0;
float* osgCloudyDay::Grass::heightmap_data=0;
osg::Vec4* osgCloudyDay::Grass::definition_data=0;
int osgCloudyDay::Grass::heightmap_width = 0;
int osgCloudyDay::Grass::heightmap_height = 0;

osgCloudyDay::Grass::Grass(void)
{ 
	
}


osgCloudyDay::Grass::~Grass(void)
{
}

void osgCloudyDay::Grass::SetDefinitionOfTerrain(osg::Texture* definition)
{
	std::cout << "SetHeightofTerrain - 1" << std::endl;
	std::cout << "GET HEIGHT: " << definition->getNumImages() << std::endl;
	unsigned char* data = (unsigned char*)definition->getImage(0)->getDataPointer();

	heightmap_width = definition->getTextureWidth();
	heightmap_height = definition->getTextureHeight();
	heightmap_width = 1024;
	heightmap_height = 1024;
	definition_data = new osg::Vec4[heightmap_width*heightmap_height];

	int multiplicator = 1;
	switch(definition->getImage(0)->getPixelFormat())
	{
	case GL_RGB:	
		std::cout << "RGB" << std::endl;
		multiplicator=3;
		break;
	case GL_RGBA:	
		std::cout << "RGBA" << std::endl;
		multiplicator=4;
		break;
	}

	for(int i = 0; i < 	heightmap_width * heightmap_height; i++)			
	{
		definition_data[i] = osg::Vec4(0.f, 0.f, 0.f, 1.f);
		definition_data[i].x() = (float)(data[i*multiplicator+0]);
		definition_data[i].y() = (float)(data[i*multiplicator+1]);
		definition_data[i].z() = (float)(data[i*multiplicator+2]);
		//definition_data[i].w() = (float)(data[i*multiplicator+3]);
	}
	
	std::cout << "SetHeightofTerrain - 5" << std::endl;
}

void osgCloudyDay::Grass::SetHeightofTerrain(osg::Texture* heightmap)
{
	std::cout << "SetHeightofTerrain - 1" << std::endl;
	std::cout << "GET HEIGHT: " << heightmap->getNumImages() << std::endl;
	unsigned char* data = (unsigned char*)heightmap->getImage(0)->getDataPointer();

	heightmap_width = heightmap->getTextureWidth();
	heightmap_height = heightmap->getTextureHeight();
	heightmap_width = 1024;
	heightmap_height = 1024;
	heightmap_data = new float[heightmap_width*heightmap_height];

	int multiplicator = 1;
	switch(heightmap->getImage(0)->getPixelFormat())
	{
	case GL_RGB:	
		std::cout << "RGB" << std::endl;
		multiplicator=3;
		break;
	case GL_RGBA:	
		std::cout << "RGBA" << std::endl;
		multiplicator=4;
		break;
	}

	for(int i = 0; i < 	heightmap_width * heightmap_height; i++)			
		heightmap_data[i] = (float)(data[i*multiplicator]);
	
	std::cout << "SetHeightofTerrain - 5" << std::endl;	
}

void osgCloudyDay::Grass::CreateTexture()
{
	osg::ref_ptr<osg::Image> img_ortho (osgDB::readImageFile("../data/textures/vegetation/grass.tga"));
	tex_tree = (new osg::Texture2D);
	tex_tree->setInternalFormat(GL_SRGB8_ALPHA8);
	tex_tree->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_tree->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);
	tex_tree->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP);
	tex_tree->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP);
	tex_tree->setImage(img_ortho.get());	
}

void osgCloudyDay::Grass::CreateShader()
{
	m_grassProg=(new osg::Program);
	osg::ref_ptr<osg::Shader> forestVertexShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/grass.vert"));
	osg::ref_ptr<osg::Shader> forestTessConShader(osg::Shader::readShaderFile (osg::Shader::TESSCONTROL, "shaders/grass.con"));
	osg::ref_ptr<osg::Shader> forestTessEvaShader(osg::Shader::readShaderFile (osg::Shader::TESSEVALUATION, "shaders/grass.eva"));
	osg::ref_ptr<osg::Shader> forestGeomShader(osg::Shader::readShaderFile (osg::Shader::GEOMETRY, "shaders/grass.geom"));
	osg::ref_ptr<osg::Shader> forestFragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/grass.frag"));
	
	//Binding the box shaders to its program
	m_grassProg->addShader(forestVertexShader.get());
	m_grassProg->addShader(forestTessConShader.get());
	m_grassProg->addShader(forestTessEvaShader.get());
	m_grassProg->addShader(forestGeomShader.get());
	m_grassProg->addShader(forestFragShader.get());
	m_grassProg->addBindFragDataLocation("out_color", 0);
	m_grassProg->addBindFragDataLocation("out_color2", 1);

	m_grassProg->setParameter(GL_PATCH_VERTICES, 3);
}

void osgCloudyDay::Grass::SetArrays()
{
	std::cout << "SETUP Arrays - start" << std::endl;
	m_vertices = new osg::Vec3Array();
	m_indices = new osg::UIntArray();

	osg::Vec2 size(1000.f*20.f, 1000.f*20.f);	

	unsigned int index = 0;
	osg::ref_ptr<osg::Vec3Array> vertices(new osg::Vec3Array());
	osg::ref_ptr<osg::UIntArray> indices(new osg::UIntArray());

	for(int i = 0; i < heightmap_height; i+=3)
	{
		for(int j = 0; j < heightmap_width; j+=3)
		{
			//std::cout << "definition_data[i*heightmap_width+j].y(): " << definition_data[i*heightmap_width+j].y() << std::endl;
			if(definition_data[i*heightmap_width+j].y() > 215.95f && (rand()%5) >= 2)			
			{
				vertices->push_back(osg::Vec3(((float)(j)/(float)(heightmap_width)+(((float)(rand()%1000)/1000.f)*0.01f-0.01f))  * size.x()-size.x()/2.f, 
											  ((float)(i)/(float)(heightmap_height)+(((float)(rand()%1000)/1000.f)*0.01f-0.01f)) * size.y()-size.y()/2.f, 
											  heightmap_data[i*heightmap_width+(j)] * 20.f -1000.f));
			
				indices->push_back(index);
				index++;
			}			
		}
		//std::cout << std::endl;
	}

	m_vertices->insert(	m_vertices->end(),	vertices->begin(), vertices->end()); 
	m_indices->insert(	m_indices->end(),	indices->begin(), indices->end()); 

	std::cout << "SETUP Arrays - end" << std::endl;
}

void osgCloudyDay::Grass::Initialize(osgCloudyDay::TerrainConfig* m_config)
{
	std::cout << std::endl << std::endl;
	std::cout << "Initialize - start" << std::endl;
	std::cout << "Diffuse TEX: " << m_config->GetPath2DiffuseTexture() << std::endl;
	std::cout << "HEIGHT TEX: " << m_config->GetPath2HeightTexture() << std::endl;
	std::cout << "Grass TEX: " << m_config->GetPathAt(2) << std::endl;
	std::cout << "Def TEX: " << m_config->GetPath2DefinationTexture() << std::endl;

	osg::ref_ptr<osg::Image> img_ortho (osgDB::readImageFile(m_config->GetPath2DiffuseTexture()));
	osg::ref_ptr<osg::Texture2D> tex_ortho = (new osg::Texture2D);
	tex_ortho->setImage(img_ortho.get());
	tex_ortho->setInternalFormat(GL_SRGB8);
	tex_ortho->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_ortho->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);
	tex_ortho->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP);
	tex_ortho->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP);
	tex_ortho->setMaxAnisotropy(16.f);

	osg::ref_ptr<osg::Image> img_height (osgDB::readImageFile(m_config->GetPath2HeightTexture()));
	osg::ref_ptr<osg::Texture2D> tex_height = (new osg::Texture2D);
	tex_height->setImage(img_height.get());
	tex_height->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_height->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);
	tex_height->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP);
	tex_height->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP);
	tex_height->setMaxAnisotropy(16.f);	

	osg::ref_ptr<osg::Image> img_grass (osgDB::readImageFile(m_config->GetPathAt(2)));
	osg::Texture2D* tex_grass = (new osg::Texture2D);
	tex_grass->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	tex_grass->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	tex_grass->setImage(img_grass.get());
	tex_grass->setInternalFormat(GL_SRGB8);
	tex_grass->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_grass->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);	

	osg::ref_ptr<osg::Image> img_def (osgDB::readImageFile(m_config->GetPath2DefinationTexture()));
	osg::ref_ptr<osg::Texture2D> tex_def = (new osg::Texture2D);
	tex_def->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	tex_def->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	tex_def->setImage(img_def.get());
	tex_def->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_def->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);
	tex_def->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP);
	tex_def->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP);
	tex_def->setMaxAnisotropy(16.f);

	osg::ref_ptr<osg::Image> img_bump6 (osgDB::readImageFile(m_config->GetNormalPathAt(0)));
	osg::Texture2D* bump6_tex = (new osg::Texture2D);
	bump6_tex->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	bump6_tex->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	bump6_tex->setImage(img_bump6.get());
	bump6_tex->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	bump6_tex->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);	
	bump6_tex->setMaxAnisotropy(16.f);

	osg::ref_ptr<osg::Image> img_bump4 (osgDB::readImageFile(m_config->GetNormalPathAt(1)));
	osg::Texture2D* bump4_tex = (new osg::Texture2D);
	bump4_tex->setWrap(osg::Texture::WRAP_S, osg::Texture::REPEAT);
	bump4_tex->setWrap(osg::Texture::WRAP_T, osg::Texture::REPEAT);
	bump4_tex->setImage(img_bump4.get());	
	bump4_tex->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	bump4_tex->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);	
	bump4_tex->setMaxAnisotropy(16.f);

	std::cout << "texture 11" << std::endl;
	osg::Node* terrain_obj = osgDB::readNodeFile(m_config->GetPath2File());		
	osg::ref_ptr<osg::Group> terrain_group = terrain_obj->asGroup();

	std::cout << "texture 12" << std::endl;
	/*osg::Group** terrain_group2 = new osg::Group*[6];
	for(int i = 0; i < 6; i++)
		terrain_group2[i] = new osg::Group();
		*/

	osg::ref_ptr<osg::PolygonMode> mode(new osg::PolygonMode());
	mode->setMode(  osg::PolygonMode::FRONT_AND_BACK, osg::PolygonMode::LINE );


	std::cout << "for(unsigned int i = 0; terrain_group != 0 && i < terrain_group->getNumChildren(); i++)" << std::endl;
	for(unsigned int i = 0; terrain_group != 0 && i < terrain_group->getNumChildren(); i++)
	{
		osg::ref_ptr<osg::Geode> geode = terrain_group->getChild(i)->asGeode();		
		if(geode)
		{
			// Compute smoothed normals
			osgUtil::SmoothingVisitor smoother;
			smoother.apply( *geode );

			for(unsigned int j = 0; j < geode->getNumDrawables(); j++)
			{
				osg::Geometry* geo = geode->getDrawable(j)->asGeometry();
							
				if(geo)
				{				
					osg::ref_ptr< osgUtil::TangentSpaceGenerator > tsg = new osgUtil::TangentSpaceGenerator;
					tsg->generate( geo, 0 );

					geo->setUseDisplayList(false);
					
					osg::Array* tcoords = geo->getTexCoordArray(0);
					//osg::Array* norms = geo->getNormalArray();
					geo->setVertexAttribData( 1, osg::Geometry::ArrayData( tcoords, osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );					
					geo->setVertexAttribData( 5, osg::Geometry::ArrayData( tsg->getNormalArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );
					geo->setVertexAttribData( 6, osg::Geometry::ArrayData( tsg->getTangentArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );
					geo->setVertexAttribData( 7, osg::Geometry::ArrayData( tsg->getBinormalArray(), osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );		
					
					//CONVERT FROM TRIANGLE_LIST TO TRIANGLE
					for(unsigned int k = 0; k < geo->getNumPrimitiveSets(); k++)
					{						
						//std::cout << "geo->getPrimitiveSet(k)->getMode(): " << geo->getPrimitiveSet(k)->getMode() << std::endl;
						if(geo->getPrimitiveSet(k)->getMode() == 5 || geo->getPrimitiveSet(k)->getType() == 4)
						{						
							//osg::PrimitiveSet::Type::
							if(geo->getPrimitiveSet(k)->getType() == 4)
							{
								GLushort* oldindices = (GLushort*)(geo->getPrimitiveSet(k)->getDataPointer());																
								GLushort* indices = new GLushort[(geo->getPrimitiveSet(k)->getNumIndices()-2)*3];
							
								for(unsigned int l = 2; l < geo->getPrimitiveSet(k)->getNumIndices(); l++)
								{
									indices[((l-2)*3)+0] = oldindices[l-2];
									indices[((l-2)*3)+1] = oldindices[l-1];
									indices[((l-2)*3)+2] = oldindices[l-0];																
								}

								geo->setPrimitiveSet(k, new osg::DrawElementsUShort( osg::PrimitiveSet::PATCHES, (geo->getPrimitiveSet(k)->getNumIndices()-2)*3, indices));								
							}
							else if(geo->getPrimitiveSet(k)->getType() == 1)
							{
								osg::DrawArrays* oldindices = static_cast<osg::DrawArrays*>(geo->getPrimitiveSet(k));																
								GLuint* indices = new GLuint[(geo->getPrimitiveSet(k)->getNumIndices()-2)*3];

								std::cout << geo->getPrimitiveSet(k)->getNumIndices() << " SIZE: "<< ((geo->getPrimitiveSet(k)->getNumIndices()-2)*3) << std::endl;
								for(unsigned int l = 2; l < geo->getPrimitiveSet(k)->getNumIndices(); l++)
								{
									indices[((l-2)*3)+0] = (l-2);
									indices[((l-2)*3)+1] = (l-1);
									indices[((l-2)*3)+2] = (l-0);					
								}
															
								geo->setPrimitiveSet(k, new osg::DrawElementsUInt(osg::PrimitiveSet::PATCHES, (geo->getPrimitiveSet(k)->getNumIndices()-2)*3, &indices[0]));
							}
							else
							{
								std::cout << "Ende" << std::endl;
							}
						}						
						else	geo->getPrimitiveSet(k)->setMode(osg::PrimitiveSet::PATCHES);						
						geo->getPrimitiveSet(k)->dirty();
						geo->dirtyBound();
					}			
				}
			}
			geode->getOrCreateStateSet()->setMode( GL_CULL_FACE, osg::StateAttribute::OFF ); 
			geode->addCullCallback(new osgCloudyDay::ViewerLightCallback);			
			
			osg::StateSet* heightmap_state = geode->getOrCreateStateSet();
			heightmap_state->addUniform(new osg::Uniform("ModelMatrix", osgCloudyDay::Scene::GetViewMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ProjectionMatrix", osgCloudyDay::Scene::GetProjectionMatrix_View()));
			heightmap_state->addUniform(new osg::Uniform("ViewMatrix", osgCloudyDay::Scene::GetViewMatrix_View()));			

			heightmap_state->addUniform(new osg::Uniform("v3LightPos", osgCloudyDay::Scene::m_skydome->GetLightPosition()));
			
			heightmap_state->addUniform(new osg::Uniform("color_tex", 0));			
			
			heightmap_state->addUniform(new osg::Uniform("light_proj_matrix", osgCloudyDay::Scene::GetProjectionMatrix_Light()));	
			heightmap_state->addUniform(new osg::Uniform("light_mv_matrix", osgCloudyDay::Scene::GetLightCamera()->getViewMatrix()));	

			heightmap_state->addUniform(new osg::Uniform("tex0", 0));
			heightmap_state->addUniform(new osg::Uniform("shadow_tex", 1));	
			heightmap_state->addUniform(new osg::Uniform("height_tex", 2));				
			
			heightmap_state->addUniform(new osg::Uniform("tex_grass", 5));
			heightmap_state->addUniform(new osg::Uniform("tex_def", 6));			

			heightmap_state->addUniform(new osg::Uniform("bump4_tex", 7));			
			heightmap_state->addUniform(new osg::Uniform("bump6_tex", 4));				
			heightmap_state->addUniform(new osg::Uniform("tex_tree", 3));							
			
			//heightmap_state->setAttribute(mode);

			heightmap_state->setTextureAttributeAndModes(0,tex_ortho,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(1,osgCloudyDay::CloudScene::fbo_light_texture,osg::StateAttribute::ON);

			heightmap_state->setTextureAttributeAndModes(2,tex_height,osg::StateAttribute::ON);			
			heightmap_state->setTextureAttributeAndModes(3,tex_tree,osg::StateAttribute::ON);							
			heightmap_state->setTextureAttributeAndModes(5,tex_grass,osg::StateAttribute::ON);
			heightmap_state->setTextureAttributeAndModes(6,tex_def,osg::StateAttribute::ON);			

			heightmap_state->setTextureAttributeAndModes(7,bump4_tex,osg::StateAttribute::ON);			
			heightmap_state->setTextureAttributeAndModes(4,bump6_tex,osg::StateAttribute::ON);											

			osgCloudyDay::Scene::m_skydome->SetupUniform(heightmap_state);
			
			heightmap_state->setAttribute(m_grassProg.get());					
		}
	}
	
	trans = new osg::MatrixTransform(osg::Matrixd(1000.f, 0.f, 0.f, 0.f, 
												  0.f, 1000.f, 0.f, 0.f, 
												  0.f, 0.f,1000.f, 0.f, 
												  0.f, 0.f,-1000.f, 1.f));
	osg::ref_ptr<osg::BlendFunc> blend = new osg::BlendFunc(osg::BlendFunc::SRC_COLOR, osg::BlendFunc::ONE_MINUS_SRC_COLOR);
	osg::ref_ptr<osg::Depth> depth = new osg::Depth(osg::Depth::LEQUAL, 0.0, 1.0, false);
	trans->getOrCreateStateSet()->setAttributeAndModes(blend);
	trans->getOrCreateStateSet()->setAttributeAndModes(depth);

	trans->addChild(terrain_obj);	

	std::cout << "Initialize - end" << std::endl;
}

osg::MatrixTransform* osgCloudyDay::Grass::GetGeode()
{
	return trans;
}

void osgCloudyDay::Grass::SetUniforms(osg::ref_ptr<osg::StateSet> nodess4)
{
	nodess4->setAttribute(m_grassProg.get());			
	
	nodess4->addUniform(new osg::Uniform("ProjectionMatrix", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("ViewMatrix", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("ModelMatrix", osg::Matrixd()));

	nodess4->addUniform(new osg::Uniform("light_mv_matrix", osg::Matrixd()));	
	nodess4->addUniform(new osg::Uniform("light_proj_matrix", osg::Matrixd()));	
	nodess4->addUniform(new osg::Uniform("inv_project_light", osg::Matrixd()));		
	
	nodess4->addUniform(new osg::Uniform("viewMatrixInv", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("viewMatrixInv_light", osg::Matrixd()));

	nodess4->addUniform(new osg::Uniform("color_tex", 0));
	nodess4->addUniform(new osg::Uniform("shadow_tex", 1));		

	osgCloudyDay::Scene::m_skydome->SetupUniform(nodess4);

	nodess4->setTextureAttributeAndModes(0,tex_tree,osg::StateAttribute::ON);
	nodess4->setTextureAttributeAndModes(1,osgCloudyDay::CloudScene::fbo_light_texture,osg::StateAttribute::ON);
}