#include "Forest.h"
#include "Scene.h"
#include "CloudScene.h"

osg::ref_ptr<osg::Program> osgCloudyDay::Forest::m_forestProg=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::Forest::tex_tree=0;
float* osgCloudyDay::Forest::heightmap_data=0;
osg::Vec4* osgCloudyDay::Forest::definition_data=0;
int osgCloudyDay::Forest::heightmap_width = 0;
int osgCloudyDay::Forest::heightmap_height = 0;

osgCloudyDay::Forest::Forest(void)
{ 
	
}


osgCloudyDay::Forest::~Forest(void)
{
}

void osgCloudyDay::Forest::SetDefinitionOfTerrain(osg::Texture* definition)
{
	std::cout << "SetHeightofTerrain - 1" << std::endl;
	std::cout << "GET HEIGHT: " << definition->getNumImages() << std::endl;
	unsigned char* data = (unsigned char*)definition->getImage(0)->getDataPointer();

	heightmap_width = definition->getTextureWidth();
	heightmap_height = definition->getTextureHeight();
	heightmap_width = 1024;
	heightmap_height = 1024;
	definition_data = new osg::Vec4[heightmap_width*heightmap_height];

	int multiplicator = 1;
	switch(definition->getImage(0)->getPixelFormat())
	{
	case GL_RGB:	
		std::cout << "RGB" << std::endl;
		multiplicator=3;
		break;
	case GL_RGBA:	
		std::cout << "RGBA" << std::endl;
		multiplicator=4;
		break;
	}

	for(int i = 0; i < 	heightmap_width * heightmap_height; i++)			
	{
		definition_data[i] = osg::Vec4(0.f, 0.f, 0.f, 1.f);
		definition_data[i].x() = (float)(data[i*multiplicator+0]);
		definition_data[i].y() = (float)(data[i*multiplicator+1]);
		definition_data[i].z() = (float)(data[i*multiplicator+2]);
		//definition_data[i].w() = (float)(data[i*multiplicator+3]);
	}
	
	std::cout << "SetHeightofTerrain - 5" << std::endl;
}

void osgCloudyDay::Forest::SetHeightofTerrain(osg::Texture* heightmap)
{
	std::cout << "SetHeightofTerrain - 1" << std::endl;
	std::cout << "GET HEIGHT: " << heightmap->getNumImages() << std::endl;
	unsigned char* data = (unsigned char*)heightmap->getImage(0)->getDataPointer();

	heightmap_width = heightmap->getTextureWidth();
	heightmap_height = heightmap->getTextureHeight();
	heightmap_width = 1024;
	heightmap_height = 1024;
	heightmap_data = new float[heightmap_width*heightmap_height];

	int multiplicator = 1;
	switch(heightmap->getImage(0)->getPixelFormat())
	{
	case GL_RGB:	
		std::cout << "RGB" << std::endl;
		multiplicator=3;
		break;
	case GL_RGBA:	
		std::cout << "RGBA" << std::endl;
		multiplicator=4;
		break;
	}

	for(int i = 0; i < 	heightmap_width * heightmap_height; i++)			
		heightmap_data[i] = (float)(data[i*multiplicator]);
	
	std::cout << "SetHeightofTerrain - 5" << std::endl;	
}

void osgCloudyDay::Forest::CreateTexture()
{
	osg::ref_ptr<osg::Image> img_ortho (osgDB::readImageFile("../data/textures/vegetation/basictree.tga"));
	tex_tree = (new osg::Texture2D);
	tex_tree->setInternalFormat(GL_SRGB8_ALPHA8);
	tex_tree->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	tex_tree->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);
	tex_tree->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP);
	tex_tree->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP);
	tex_tree->setImage(img_ortho.get());	
}

void osgCloudyDay::Forest::CreateShader()
{
	m_forestProg=(new osg::Program);
	osg::ref_ptr<osg::Shader> forestVertexShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/tree.vert"));
	osg::ref_ptr<osg::Shader> forestGeomShader(osg::Shader::readShaderFile (osg::Shader::GEOMETRY, "shaders/tree.geom"));
	osg::ref_ptr<osg::Shader> forestFragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/tree.frag"));
	
	//Binding the box shaders to its program
	m_forestProg->addShader(forestVertexShader.get());
	m_forestProg->addShader(forestGeomShader.get());
	m_forestProg->addShader(forestFragShader.get());
	m_forestProg->addBindFragDataLocation("out_color", 0);
	m_forestProg->addBindFragDataLocation("out_color2", 1);
}

void osgCloudyDay::Forest::SetArrays()
{
	std::cout << "SETUP Arrays - start" << std::endl;
	m_vertices = new osg::Vec3Array();
	m_indices = new osg::UIntArray();

	osg::Vec2 size(1000.f*20.f, 1000.f*20.f);	

	unsigned int index = 0;
	osg::ref_ptr<osg::Vec3Array> vertices(new osg::Vec3Array());
	osg::ref_ptr<osg::UIntArray> indices(new osg::UIntArray());

	for(int i = 0; i < heightmap_height; i+=3)
	{
		for(int j = 0; j < heightmap_width; j+=3)
		{
			//std::cout << "definition_data[i*heightmap_width+j].y(): " << definition_data[i*heightmap_width+j].y() << std::endl;
			if(definition_data[i*heightmap_width+j].y() > 215.95f && (rand()%5) >= 2)			
			{
				vertices->push_back(osg::Vec3(((float)(j)/(float)(heightmap_width)+(((float)(rand()%1000)/1000.f)*0.01f-0.01f))  * size.x()-size.x()/2.f, 
											  ((float)(i)/(float)(heightmap_height)+(((float)(rand()%1000)/1000.f)*0.01f-0.01f)) * size.y()-size.y()/2.f, 
											  heightmap_data[i*heightmap_width+(j)] * 20.f -1000.f));
			
				indices->push_back(index);
				index++;
			}			
		}
		//std::cout << std::endl;
	}

	m_vertices->insert(	m_vertices->end(),	vertices->begin(), vertices->end()); 
	m_indices->insert(	m_indices->end(),	indices->begin(), indices->end()); 

	std::cout << "SETUP Arrays - end" << std::endl;
}

void osgCloudyDay::Forest::Initialize()
{
	std::cout << std::endl << "Initialize - Forest - start" << std::endl;
	SetArrays();	
	
	geometry = new osg::Geometry();
	geometry->setVertexAttribArray(0, m_vertices.get());
	geometry->setVertexAttribBinding(0, osg::Geometry::BIND_PER_VERTEX);
	geometry->setUseDisplayList(false);
	geometry->setUseVertexBufferObjects(true);

	geometry->addPrimitiveSet(
		new osg::DrawElementsUInt(osg::PrimitiveSet::POINTS,
								m_indices->size(),
								&m_indices->at(0)));		
	geometry->getPrimitiveSet(geometry->getNumPrimitiveSets()-1)->getDrawElements()->setDataVariance(osg::Object::DYNAMIC);		


	osg::ref_ptr<osg::BlendFunc> blending = new osg::BlendFunc(osg::BlendFunc::SRC_ALPHA, osg::BlendFunc::ONE_MINUS_SRC_ALPHA);
	osg::ref_ptr<osg::Depth> depth = new osg::Depth(osg::Depth::LEQUAL, 0.0, 1.0, true);

	geode = (new osg::Geode());	
	geode->addDrawable(geometry.get());
	geode->setCullingActive(false); //wars ned		
	geode->getOrCreateStateSet()->setAttributeAndModes(new osg::CullFace(), osg::StateAttribute::OFF); 
	geode->addCullCallback(new ForestLightCallback());
	geode->getOrCreateStateSet()->setAttributeAndModes(blending, osg::StateAttribute::ON);
	geode->getOrCreateStateSet()->setAttributeAndModes(depth, osg::StateAttribute::ON);
	osg::ref_ptr<osg::StateSet> nodess4 = (geode->getOrCreateStateSet());			
	SetUniforms(nodess4);

	std::cout << "Initialize - end" << std::endl;
}

osg::Geode* osgCloudyDay::Forest::GetGeode()
{
	return geode;
}

void osgCloudyDay::Forest::SetUniforms(osg::ref_ptr<osg::StateSet> nodess4)
{
	nodess4->setAttribute(m_forestProg.get());			
	
	nodess4->addUniform(new osg::Uniform("ProjectionMatrix", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("ViewMatrix", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("ModelMatrix", osg::Matrixd()));

	nodess4->addUniform(new osg::Uniform("light_mv_matrix", osg::Matrixd()));	
	nodess4->addUniform(new osg::Uniform("light_proj_matrix", osg::Matrixd()));	
	nodess4->addUniform(new osg::Uniform("inv_project_light", osg::Matrixd()));		
	
	nodess4->addUniform(new osg::Uniform("viewMatrixInv", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("viewMatrixInv_light", osg::Matrixd()));

	nodess4->addUniform(new osg::Uniform("color_tex", 0));
	nodess4->addUniform(new osg::Uniform("shadow_tex", 1));		

	osgCloudyDay::Scene::m_skydome->SetupUniform(nodess4);

	nodess4->setTextureAttributeAndModes(0,tex_tree,osg::StateAttribute::ON);
	nodess4->setTextureAttributeAndModes(1,osgCloudyDay::CloudScene::fbo_light_texture,osg::StateAttribute::ON);
}