#include "Export.h"
#include <tinyxml2.h>

osgCloudyDay::Export::Export(void)
{
}

osgCloudyDay::Export::~Export(void)
{

}


void osgCloudyDay::Export::Perform()
{
	std::cout << "Export" << std::endl;

	tinyxml2::XMLDocument doc;
	tinyxml2::XMLElement* root = doc.NewElement("Sky");
	doc.InsertFirstChild(root);

	for(unsigned int c = 0; c < m_cloud.size(); c++)
	{
		Cloud* scloud = &m_cloud[c];

		tinyxml2::XMLElement* cloud = doc.NewElement("Cloud");
		root->InsertFirstChild(cloud);

		tinyxml2::XMLElement* center_position = doc.NewElement("Position");
		center_position->SetAttribute("x", 0.0);
		center_position->SetAttribute("y", 0.0);
		center_position->SetAttribute("z", 0.0);
		cloud->InsertEndChild(center_position);


		tinyxml2::XMLElement* diffuse = doc.NewElement("Diffuse_Height");
		for(unsigned int i = 0; i < scloud->diffuselight_h->size(); i++)
		{
			tinyxml2::XMLElement* color = doc.NewElement("Color");
			color->SetAttribute("r", scloud->diffuselight_h->at(i).x());
			color->SetAttribute("g", scloud->diffuselight_h->at(i).y());
			color->SetAttribute("b", scloud->diffuselight_h->at(i).z());
			diffuse->InsertEndChild(color);
		}
		cloud->InsertEndChild(diffuse);

		diffuse = doc.NewElement("Diffuse_Time");
		for(unsigned int i = 0; i < scloud->diffuselight_t->size(); i++)
		{
			tinyxml2::XMLElement* color = doc.NewElement("Color");
			color->SetAttribute("r", scloud->diffuselight_t->at(i).x());
			color->SetAttribute("g", scloud->diffuselight_t->at(i).y());
			color->SetAttribute("b", scloud->diffuselight_t->at(i).z());
			diffuse->InsertEndChild(color);
		}
		cloud->InsertEndChild(diffuse);

		tinyxml2::XMLElement* ambient = doc.NewElement("Ambient");
		for(unsigned int i = 0; i < scloud->ambientlight_color->size(); i++)
		{
			tinyxml2::XMLElement* color = doc.NewElement("Color");
			color->SetAttribute("r", scloud->ambientlight_color->at(i).x());
			color->SetAttribute("g", scloud->ambientlight_color->at(i).y());
			color->SetAttribute("b", scloud->ambientlight_color->at(i).z());
			ambient->InsertEndChild(color);
		}
		cloud->InsertEndChild(ambient);

		for(int i = 0; i < scloud->num_boxes; i++)
		{
			Box* sbox = &scloud->m_boxes[i];

			tinyxml2::XMLElement* box = doc.NewElement("Box");
			cloud->InsertFirstChild(box);

			tinyxml2::XMLElement* center_position = doc.NewElement("Position");
			center_position->SetAttribute("x", sbox->box_center.x());
			center_position->SetAttribute("y", sbox->box_center.y());
			center_position->SetAttribute("z", sbox->box_center.z());
			box->InsertEndChild(center_position);

			for(unsigned int j = 0; j < sbox->vertices->size(); j++)
			{
				tinyxml2::XMLElement* particles = doc.NewElement("Particle");
				particles->SetAttribute("TextureID", (int)sbox->ids->at(j).x());
				particles->SetAttribute("TextureID2", (int)sbox->ids->at(j).y());
				particles->SetAttribute("TextureID_Weight", sbox->ids->at(j).z());
				particles->SetAttribute("Rotation", sbox->rotation->at(j).x());
				particles->SetAttribute("Density", sbox->rotation->at(j).w());

				tinyxml2::XMLElement* position = doc.NewElement("Position");
				position->SetAttribute("x", sbox->vertices->at(j).x());
				position->SetAttribute("y", sbox->vertices->at(j).y());
				position->SetAttribute("z", sbox->vertices->at(j).z());
				particles->InsertEndChild(position);

				tinyxml2::XMLElement* color = doc.NewElement("Color");
				color->SetAttribute("x", sbox->color->at(j).x());
				color->SetAttribute("y", sbox->color->at(j).y());
				color->SetAttribute("z", sbox->color->at(j).z());
				color->SetAttribute("w", sbox->color->at(j).w());
				particles->InsertEndChild(color);

				tinyxml2::XMLElement* center = doc.NewElement("Center");
				center->SetAttribute("x", sbox->center->at(j).x());
				center->SetAttribute("y", sbox->center->at(j).y());
				center->SetAttribute("z", sbox->center->at(j).z());
				center->SetAttribute("w", sbox->center->at(j).w());
				particles->InsertEndChild(center);

				tinyxml2::XMLElement* size = doc.NewElement("Size");
				size->SetAttribute("x", sbox->rotation->at(j).y());
				size->SetAttribute("y", sbox->rotation->at(j).z());
				particles->InsertEndChild(size);

				box->InsertEndChild(particles);
			}
		}
	}
	doc.SaveFile("foo.xml");
	
	std::cout << "Export" << std::endl;
}