#include "DataCloud.h"
#include "CloudScene.h"

osgCloudyDay::DataCloud::DataCloud(osg::ref_ptr<osg::Vec3Array> vertices, osg::ref_ptr<osg::Vec4Array> rotation, osg::ref_ptr<osg::Vec4Array> color, osg::ref_ptr<osg::Vec4Array> center, osg::ref_ptr<osg::Vec4Array> ids, osg::ref_ptr<osg::Vec4Array> boxcenter) : CloudGenerator(osg::Vec4(1.f, 1.f, 1.f, 1.f))
{
	std::cout << "Konstruktur: DataCloud" << std::endl;	
	//m_cloud = new WangCloud(0);
	this->vertices = vertices;
	this->rotation = rotation;
	this->color = color;
	this->center = center;
	this->ids = ids;
	this->boxcenter = boxcenter;

	m_category = CloudScene::CT_Cumulus;
}


osgCloudyDay::DataCloud::~DataCloud(void)
{
}

bool osgCloudyDay::DataCloud::Update()
{
	return false;
}
void osgCloudyDay::DataCloud::Initialize()
{
	for(unsigned int i = 0; i < vertices->size(); i++)	m_cloud->GetVertices()->push_back(vertices->at(i));
	for(unsigned int i = 0; i < rotation->size(); i++)	m_cloud->GetRotation()->push_back(rotation->at(i));		
	for(unsigned int i = 0; i < color->size(); i++)		m_cloud->GetColor()->push_back(color->at(i));
	for(unsigned int i = 0; i < center->size(); i++)	m_cloud->GetCenter()->push_back(center->at(i));

	for(unsigned int i = 0; i < ids->size(); i++)		m_cloud->GetIds()->push_back(ids->at(i));	
	for(unsigned int i = 0; i < boxcenter->size(); i++)	m_cloud->GetBoxCenters()->push_back(boxcenter->at(i));	
}