#include "CumulusGenerator.h"
#include "CloudScene.h"

osgCloudyDay::CumulusGenerator::CumulusGenerator(osg::Vec4 layer) : CloudGenerator(layer)
{
	m_category = CloudScene::CT_Cumulus;
}


osgCloudyDay::CumulusGenerator::~CumulusGenerator(void)
{
}

bool osgCloudyDay::CumulusGenerator::Update()
{
	return false;
}

void osgCloudyDay::CumulusGenerator::Initialize()
{	
	m_iterFloatRand=0;
	osg::Vec3 jitter_sizes(200.f, 200.f, 200.f);
	
	osg::Vec3 randVer = m_middlepoint;

	osg::Vec3 sizes = osg::Vec3(5, 5, 5);

	int num_boxes = 0;	
	switch(/*CloudGenerator::numClouds % 2+*/1)
	{
	case CCT_HUMILIS:
	{
		int XM = 5;
		int YM = 5;
		int ZM = 2;

		for(int z = 0; z < 2; z++)
		{
			for(int y = -2; y < 2; y++)
			{
				for(int x = -2; x < 3; x++)
				{
					if((rand() % 3) <= 1)
					{
						osg::Vec3 posHelper = randVer + osg::Vec3( -60.0f, 0.f, 0.0f) + osg::Vec3(x*400.f, y*400.f, z*400.f);
						osg::Vec3 size = osg::Vec3(7.5f,7.5f*5.f,6.5f);

						AddCloudBox(num_boxes, posHelper, sizes, size, jitter_sizes, true, 500.f, osg::Vec4(50.f, 150.f, 50.f, 150.f), m_density);
						num_boxes++;
						AddBox(dBoxes_vertices, posHelper, size);
					}
				}
			}
		}		
		break;
	}
	case CCT_MEDIOCRIS:
	{
		osg::ref_ptr<osg::Vec3Array> box_triangles(new osg::Vec3Array());
		osg::Vec3 point = osg::Vec3();

		osg::Vec3 triangle[3];
		triangle[0] = osg::Vec3();
		triangle[1] = osg::Vec3();
		triangle[2] = osg::Vec3();

		for(int i = 0; i < 40; i++)
		{
			osg::Vec3 res;

			osg::Vec3* _ray = new osg::Vec3[2];
			_ray[0] = osg::Vec3(0.f, 0.f, 0.f);

			float signy = 0.f;
			float signx = 0.f;
			switch(rand()%4)
			{
			case 0: signx = 1.f;
					signy = 1.f;
				break;
			case 1: signx =-1.f;
					signy = 1.f;
				break;
			case 2: signx = 1.f;
					signy =-1.f;
				break;
			case 3: signx =-1.f;
					signy =-1.f;
				break;
			}
			_ray[1] = osg::Vec3(
				(frand())*5.f*(1.f-(float)(i)/40.f), 
				(frand())*5.f*(1.f-(float)(i)/40.f),
				frand()*((float)i/10.f));
			
			//Benachteilige diagonale Sprnge
			//if(abs(_ray[1].x()) > abs(_ray[1].y()) && abs(_ray[1].x()) > abs(_ray[1].z())) _ray[1].x() *= 4.0f;
			//if(abs(_ray[1].y()) > abs(_ray[1].x()) && abs(_ray[1].y()) > abs(_ray[1].z())) _ray[1].y() *= 4.0f;
			//if(abs(_ray[1].z()) > abs(_ray[1].y()) && abs(_ray[1].z()) > abs(_ray[1].x())) _ray[1].z() *= 2.0f;
			_ray[1].normalize();

			//std::cout << "ray: " << _ray[1].x() << " " << _ray[1].y() << " " << _ray[1].z() << std::endl;
			_ray[1] *= 10000.f;

			for(int j = 0; j < ((int)box_triangles->size()-2); j+=3)
			{
				triangle[0] = osg::Vec3(box_triangles->at(j+0).x(), box_triangles->at(j+0).y(), box_triangles->at(j+0).z());
				triangle[1] = osg::Vec3(box_triangles->at(j+1).x(), box_triangles->at(j+1).y(), box_triangles->at(j+1).z());
				triangle[2] = osg::Vec3(box_triangles->at(j+2).x(), box_triangles->at(j+2).y(), box_triangles->at(j+2).z());
				
				osg::Vec3 res2;
				int intersection_result = intersect_RayTriangle(_ray, triangle, res2);
				if(intersection_result == 1 && res2.length() > res.length())	res = res2;
			}
			
			//osg::Vec3 size = osg::Vec3(	/*(1.f-powf((float)(30-i)/30.f,2.f)) */ 100.f*(frand()*0.5f+0.5f),
			//							/*(1.f-powf((float)(30-i)/30.f,2.f)) */ 100.f*(frand()*0.5f+0.5f),
			//							/*(1.f-powf((float)(30-i)/30.f,2.f)) */ 100.f*(frand()*0.5f+0.5f));			
			osg::Vec3 size = osg::Vec3(	500.f * (float)(40-i)/40.f,
										500.f * (float)(40-i)/40.f,
										500.f * (float)(40-i)/40.f);			

			jitter_sizes.x() = size.x() / sizes.x(); 
			jitter_sizes.y() = size.y() / sizes.y(); 
			jitter_sizes.z() = size.z() / sizes.z(); 
			osg::Vec3 posHelper = randVer+res+size;
			
			/*if(i <= 20)	AddCloudBox(num_boxes, posHelper, sizes, size , jitter_sizes, true, 400.f, osg::Vec4(15.f, 30.f, 15.f, 30.f));
			else*/		
						
			//if(i <= 30) AddCloudBox(num_boxes, posHelper, sizes, size, jitter_sizes, true,  200.f, osg::Vec4(10.f, 20.f, 10.f, 20.f));
			//else		AddCloudBox(num_boxes, posHelper, sizes, size, jitter_sizes, false, 200.f, osg::Vec4(10.f, 20.f, 10.f, 20.f));
			if(i <= 30) AddCloudBox(num_boxes, posHelper, sizes, size, jitter_sizes, true,  400.f, osg::Vec4(10.f, 20.f, 10.f, 20.f), m_density);
			else		AddCloudBox(num_boxes, posHelper, sizes, size, jitter_sizes, false, 400.f, osg::Vec4(10.f, 20.f, 10.f, 20.f), m_density);

			num_boxes++;			

			AddBox(dBoxes_vertices, posHelper, size);

			posHelper -= randVer;			
			AddBox(box_triangles, posHelper, size);
		}
		break;
	}
	/*
		//Geht richtung Schfchen Wolken
		for(int i = 0; i < 10; i++)
		{
			int x = rand()% 10;
			int y = rand()% 10;
			int z = rand()% 2;

			osg::Vec3 posHelper = randVer + osg::Vec3( -60.0f*multiplikator, 0.f, 0.0f) + osg::Vec3(x*400.f, y*400.f, z*400.f);

			AddCloudBox(vertices, rotation, center, ids, box_centers, 0, posHelper, sizes, osg::Vec3(12.5f*multiplikator,12.5f*multiplikator*2.f,10.5f*multiplikator) , jitter_sizes, true, 500.f, osg::Vec4(100.f, 200.f, 100.f, 200.f));
		}
		*/

	case CCT_CONGESTUS:
	{
		osg::ref_ptr<osg::Vec3Array> box_triangles(new osg::Vec3Array());
		osg::Vec3 point = osg::Vec3();

		osg::Vec3 triangle[3];
		triangle[0] = osg::Vec3();
		triangle[1] = osg::Vec3();
		triangle[2] = osg::Vec3();

		for(int i = 0; i < 60; i++)
		{
			osg::Vec3 res;

			osg::Vec3* _ray = new osg::Vec3[2];
			_ray[0] = osg::Vec3(0.f, 0.f, 0.f);
			_ray[1] = osg::Vec3((frand()-0.5f)*2.f*std::max(1.f, (5.f-(float)i)), (frand()-0.5f)*2.f, frand()*std::max(1.f, (float)i/4.f));
			
			//Benachteilige diagonale Sprnge
			if(abs(_ray[1].x()) > abs(_ray[1].y()) && abs(_ray[1].x()) > abs(_ray[1].z())) _ray[1].x() *= 2.5f;			
			if(abs(_ray[1].z()) > abs(_ray[1].y()) && abs(_ray[1].z()) > abs(_ray[1].x())) _ray[1].z() *= 1.0f;
			_ray[1].normalize();

			_ray[1] *= 10000.f;

			for(int j = 0; j < ((int)box_triangles->size()-2); j+=3)
			{
				triangle[0] = osg::Vec3(box_triangles->at(j+0).x(), box_triangles->at(j+0).y(), box_triangles->at(j+0).z());
				triangle[1] = osg::Vec3(box_triangles->at(j+1).x(), box_triangles->at(j+1).y(), box_triangles->at(j+1).z());
				triangle[2] = osg::Vec3(box_triangles->at(j+2).x(), box_triangles->at(j+2).y(), box_triangles->at(j+2).z());
				
				osg::Vec3 res2;
				int intersection_result = intersect_RayTriangle(_ray, triangle, res2);
				if(intersection_result == 1 && res2.length() > res.length())	res = res2;
			}
						
			osg::Vec3 size = osg::Vec3(10.5f*std::max(1.f, frand()*2.5f),10.5f*std::max(1.f, frand()*2.5f),10.5f*std::max(1.f, frand()*3.5f));			

			osg::Vec3 posHelper;
			if(i > 0)	posHelper = randVer+res+(size/1.f);
			else		posHelper = randVer+res;
			 
			if(i <= 0)
			{
				size.x() *= 2.0;
				size.y() *= 2.0;
			}
			//AddCloudBox(num_boxes, posHelper, sizes, size , jitter_sizes, true, 750.f, osg::Vec4(100.f, 200.f, 100.f, 200.f));
			if(i <= 0)	AddCloudBox(num_boxes, posHelper, sizes, size , jitter_sizes, true, 200.f, osg::Vec4(10.f, 30.f, 10.f, 30.f), m_density);
			else		AddCloudBox(num_boxes, posHelper, sizes, size , jitter_sizes, false, 200.f, osg::Vec4(10.f, 30.f, 10.f, 30.f), m_density);

			num_boxes++;
			
			size*= 4.0f;
			AddBox(dBoxes_vertices, posHelper, size);

			posHelper -= randVer;
			
			AddBox(box_triangles, posHelper, size);
		}
		break;
	}
	}

	EliminateRedudantSprites();	
	DecideInsideOutside();

	dBoxes_indices.resize(dBoxes_vertices->size());
	for(unsigned int i = 0; i < dBoxes_vertices->size(); i++)
	{
		dBoxes_indices[i] = i;
	}
	dBoxes_geometry->setVertexArray (dBoxes_vertices.get());
	dBoxes_geometry->addPrimitiveSet(
		new osg::DrawElementsUShort(osg::PrimitiveSet::TRIANGLES, dBoxes_vertices->size(), &dBoxes_indices[0])
	);
	dBoxes_geometry->getPrimitiveSet(0)->getDrawElements()->setDataVariance(osg::Object::STATIC);
	dBoxes->addDrawable(dBoxes_geometry.get());
	dBoxes->getOrCreateStateSet()->setMode(GL_CULL_FACE, osg::StateAttribute::OFF );
	dBoxes->setCullingActive(false);

	ex->AddCloud(m_cloud->GetVertices(), m_cloud->GetRotation(), m_cloud->GetColor(), m_cloud->GetCenter(), m_cloud->GetIds(), m_cloud->GetBoxCenters(), num_boxes);
}