#include "CumolonimbusGenerator.h"
#include "CloudScene.h"

osgCloudyDay::CumolonimbusGenerator::CumolonimbusGenerator(osg::Vec4 density) : CloudGenerator(density)
{
	m_category = CloudScene::CT_Cumolonimbus;
}


osgCloudyDay::CumolonimbusGenerator::~CumolonimbusGenerator(void)
{
}

bool osgCloudyDay::CumolonimbusGenerator::Update()
{
	return false;
}

void osgCloudyDay::CumolonimbusGenerator::Initialize()
{	
	osg::Vec3 jitter_sizes(200.f, 200.f, 200.f);
	
	float multiplikator = 1.f;
	osg::Vec3 randVer = m_middlepoint;

	osg::Vec3 sizes = osg::Vec3(2, 2, 2);

	int num_boxes = 0;	
	
	osg::ref_ptr<osg::Vec3Array> box_triangles(new osg::Vec3Array());
	osg::Vec3 point = osg::Vec3();

	osg::Vec3 triangle[3];
	triangle[0] = osg::Vec3();
	triangle[1] = osg::Vec3();
	triangle[2] = osg::Vec3();

	for(int i = 60-1; i >= 0; i--)
	{
		osg::Vec3 res;

		osg::Vec3* _ray = new osg::Vec3[2];
		_ray[0] = osg::Vec3(0.f, 0.f, 0.f);
		_ray[1] = osg::Vec3((frand()-0.5f)*4.f*std::max(1.f, (5.f-(float)i)), (frand()-0.5f)*4.f, frand()*std::max(1.f, (float)i/4.f));
			
		//Benachteilige diagonale Sprnge
		if(abs(_ray[1].x()) > abs(_ray[1].y()) && abs(_ray[1].x()) > abs(_ray[1].z())) _ray[1].x() *= 2.5f;			
		if(abs(_ray[1].y()) > abs(_ray[1].x()) && abs(_ray[1].y()) > abs(_ray[1].z())) _ray[1].y() *= 2.5f;			
		if(abs(_ray[1].z()) > abs(_ray[1].y()) && abs(_ray[1].z()) > abs(_ray[1].x())) _ray[1].z() *= 1.0f;
		_ray[1].normalize();

		_ray[1] *= 10000.f;

		for(int j = 0; j < ((int)box_triangles->size()-2); j+=3)
		{
			triangle[0] = osg::Vec3(box_triangles->at(j+0).x(), box_triangles->at(j+0).y(), box_triangles->at(j+0).z());
			triangle[1] = osg::Vec3(box_triangles->at(j+1).x(), box_triangles->at(j+1).y(), box_triangles->at(j+1).z());
			triangle[2] = osg::Vec3(box_triangles->at(j+2).x(), box_triangles->at(j+2).y(), box_triangles->at(j+2).z());
				
			osg::Vec3 res2;
			int intersection_result = intersect_RayTriangle(_ray, triangle, res2);
			if(intersection_result == 1 && res2.length() > res.length())	res = res2;
		}
						
		osg::Vec3 size = osg::Vec3(12.5f*multiplikator*std::max(1.f, frand()*5.f),
									12.5f*multiplikator*std::max(1.f, frand()*5.f),
									12.5f*multiplikator*std::max(1.f, frand()*5.f));
		size*= 1.5f;
		//size.z() *= 2.f;

		osg::Vec3 posHelper;
		if(i > 0)	posHelper = randVer+res+(size/1.f);
		else		posHelper = randVer+res;
			 
		if(i <= 0)
		{
			size.x() *= 3.0;
			size.y() *= 3.0;
		}
		//AddCloudBox(num_boxes, posHelper, sizes, size , jitter_sizes, true, 750.f, osg::Vec4(100.f, 200.f, 100.f, 200.f));
		if(i <= 0)	AddCloudBox(num_boxes, posHelper, sizes, size , jitter_sizes, true, 250.f, osg::Vec4(10.f, 60.f, 10.f, 60.f), m_density);
		else		AddCloudBox(num_boxes, posHelper, sizes, size , jitter_sizes, false, 250.f, osg::Vec4(10.f, 60.f, 10.f, 60.f), m_density);

		num_boxes++;
			
		size*= 4.0f;
		AddBox(dBoxes_vertices, posHelper, size);

		posHelper -= randVer;
			
		AddBox(box_triangles, posHelper, size);	
	}

	EliminateRedudantSprites();

	dBoxes_indices.resize(dBoxes_vertices->size());
	for(unsigned int i = 0; i < dBoxes_vertices->size(); i++)
	{
		dBoxes_indices[i] = i;
	}
	dBoxes_geometry->setVertexArray (dBoxes_vertices.get());
	dBoxes_geometry->addPrimitiveSet(
		new osg::DrawElementsUShort(osg::PrimitiveSet::TRIANGLES, dBoxes_vertices->size(), &dBoxes_indices[0])
	);
	dBoxes_geometry->getPrimitiveSet(0)->getDrawElements()->setDataVariance(osg::Object::STATIC);
	dBoxes->addDrawable(dBoxes_geometry.get());
	dBoxes->getOrCreateStateSet()->setMode(GL_CULL_FACE, osg::StateAttribute::OFF );
	dBoxes->setCullingActive(false);

	ex->AddCloud(m_cloud->GetVertices(), m_cloud->GetRotation(), m_cloud->GetColor(), m_cloud->GetCenter(), m_cloud->GetIds(), m_cloud->GetBoxCenters(), num_boxes);
}