#include "Create2DCloud.h"
#include "PerlinNoiseCloud.h"
#include "CirrusStratus.h"
#include "AltStratus.h"
#include "CirrusCumulus.h"
#include "Cirrus.h"

osgCloudyDay::Create2DCloud::Create2DCloud(void) :  m_node_scene(0), m_node_light(0), m_reflection(0)
{
}


osgCloudyDay::Create2DCloud::~Create2DCloud(void)
{
}

void osgCloudyDay::Create2DCloud::Initialize(std::vector<osgCloudyDay::Cloud2DState> m_cloud2dstates)
{	
	m_reflection = new osg::Group*[6];
	for(int i = 0; i < 6; i++) m_reflection[i] = new osg::Group();

	m_node_scene = new osg::Group();
	for(unsigned int i = 0; i < m_cloud2dstates.size(); i++)
	{
		osgCloudyDay::Cloud2D* cloud2d; 
		switch(m_cloud2dstates[i].GetCategory())
		{
		case Cloud2DState::C2DT_Cirrus:
			cloud2d = new osgCloudyDay::Cirrus(m_cloud2dstates[i].getMiddlePoint(), m_cloud2dstates[i].getSize());	
			break;
		case Cloud2DState::C2DT_AltStratus:
			cloud2d = new osgCloudyDay::AltStratus(m_cloud2dstates[i].getMiddlePoint(), m_cloud2dstates[i].getSize());	
			break;
		case Cloud2DState::C2DT_CirrusCumulus:
			cloud2d = new osgCloudyDay::CirrusCumulus(m_cloud2dstates[i].getMiddlePoint(), m_cloud2dstates[i].getSize());	
			break;
		case Cloud2DState::C2DT_CirrusStratus:
			cloud2d = new osgCloudyDay::CirrusStratus(m_cloud2dstates[i].getMiddlePoint(), m_cloud2dstates[i].getSize());	
			break;
		case Cloud2DState::C2DT_Perlin:
			cloud2d = new osgCloudyDay::PerlinNoiseCloud();	
			break;
		}
		osg::Geode* geode = cloud2d->geode;
		geode->addCullCallback(new PerlinNoiseCallback);		
		m_geodes.push_back(geode);

		m_node_scene->addChild(geode);
		
		for(int i = 0; i < 6; i++)
		{
			osg::Geode* geode_cirrus2 = new osg::Geode(*geode, osg::CopyOp::DEEP_COPY_ALL); 	
			geode_cirrus2->addCullCallback(new PerlinNoiseCallback);
			m_reflection[i]->addChild(geode_cirrus2);	
		}
	}

#ifdef SHADOW_MAPPING	
	m_node_light = new osg::Group();
	for(unsigned int i = 0; i < m_cloud2dstates.size(); i++)
	{
		osgCloudyDay::Cloud2D* cloud2d; 
		switch(m_cloud2dstates[i].GetCategory())
		{
		case Cloud2DState::C2DT_Cirrus:
			cloud2d = new osgCloudyDay::Cirrus(m_cloud2dstates[i].getMiddlePoint(), m_cloud2dstates[i].getSize());	
			break;
		case Cloud2DState::C2DT_AltStratus:
			cloud2d = new osgCloudyDay::AltStratus(m_cloud2dstates[i].getMiddlePoint(), m_cloud2dstates[i].getSize());	
			break;
		case Cloud2DState::C2DT_CirrusCumulus:
			cloud2d = new osgCloudyDay::CirrusCumulus(m_cloud2dstates[i].getMiddlePoint(), m_cloud2dstates[i].getSize());	
			break;
		case Cloud2DState::C2DT_CirrusStratus:
			cloud2d = new osgCloudyDay::CirrusStratus(m_cloud2dstates[i].getMiddlePoint(), m_cloud2dstates[i].getSize());	
			break;
		case Cloud2DState::C2DT_Perlin:
			cloud2d = new osgCloudyDay::PerlinNoiseCloud();	
			break;
		}
		osg::Geode* geode = cloud2d->geode;
		geode->addCullCallback(new PerlinNoiseCallback);		
		m_light_geodes.push_back(geode);

		m_node_light->addChild(geode);
	}
#endif
}

osg::Node* osgCloudyDay::Create2DCloud::GetNode()
{
	return m_node_scene;
}

osg::Node* osgCloudyDay::Create2DCloud::GetNodeLight()
{
	return m_node_scene;
}

osg::Node* osgCloudyDay::Create2DCloud::GetReflectionCamera(int at)
{
	return m_reflection[at];
}