#include "ContrailUpdate.h"
//#include "CloudLayerUpdate.h"
#include "CloudScene.h"
#include "CumulusGenerator.h"
#include "StratusGenerator.h"
#include "NimbostratusGenerator.h"
#include "CumolonimbusGenerator.h"
#include "StratoCumulusGenerator.h"
#include <iostream>
#include <algorithm>


osgCloudyDay::ContrailUpdate::ContrailUpdate(void) : depth(0), iteration(0), layerid(0), bb_geo(0), cloud_added(false)
{
}


osgCloudyDay::ContrailUpdate::~ContrailUpdate(void)
{
}

void osgCloudyDay::ContrailUpdate::operator()(osg::Node* node, osg::NodeVisitor* nv)
{
	osgUtil::CullVisitor* cv = static_cast<osgUtil::CullVisitor*>(nv);	   
	osg::ref_ptr<osg::Geode> geode = static_cast<osg::Geode*> (node);

	if(geode && cv)
	{	
		osg::Vec3 eye, center, up;		
		osgCloudyDay::Scene::GetViewDepthCamera()->getViewMatrixAsLookAt(eye, center, up);

		osg::Vec3 center_light = center;

		osg::Matrixd modelMatrix = *cv->getModelViewMatrix() * osg::Matrixd::inverse(cv->getCurrentCamera()->getViewMatrix());
		osg::Matrixd project = osgCloudyDay::Scene::GetProjectionMatrix_View();	
		osg::Matrixd viewMatrix = osgCloudyDay::Scene::GetViewMatrix_View();
		osg::Matrixd modelViewMatrix = modelMatrix * viewMatrix;		

		osg::Matrixd m_halfAngleMatrix = m_halfAngleMatrix;
		osg::Matrixd m_halfAngleLightMatrix = m_halfAngleMatrix;		

		osg::StateSet* nodess4 = geode->getOrCreateStateSet();
		nodess4->getUniform("modelViewMatrix")->set(modelViewMatrix);
		nodess4->getUniform("modelViewMatrix_light")->set(osg::Matrixd());
		nodess4->getUniform("viewMatrix")->set(viewMatrix);
		nodess4->getUniform("viewMatrix_light")->set(osg::Matrixd());
		nodess4->getUniform("viewMatrixInv")->set(osg::Matrixd::inverse(viewMatrix));
		nodess4->getUniform("viewMatrixInv_light")->set(osg::Matrixd::inverse(osg::Matrixd()));
		nodess4->getUniform("project")->set(project);
		nodess4->getUniform("project_light")->set(osg::Matrixd());
		nodess4->getUniform("inv_project_light")->set(osg::Matrixd::inverse(osg::Matrixd()));

		/*
		osg::Vec3 viewVector = eye-center;
		float distV = viewVector.length();
		viewVector.normalize();

		osg::Vec3 lightVector = eye-center;
		float distL = lightVector.length();
		lightVector.normalize();

		for(unsigned int j = 0; j < geode->getNumDrawables();j++)
		{
			osg::ref_ptr<osg::Geometry> obj = static_cast<osg::Geometry*> (geode->getDrawable(j));
			osg::ref_ptr<osg::CloudGeometry> ppg = static_cast<osg::CloudGeometry*> (geode->getDrawable(j));
		
			
			bool slicingViewVectorTransformed= true;
			if(obj)
			{
				ppg->m_slicingViewVectorTransformed = slicingViewVectorTransformed;
				osg::Vec3 dir = viewVector;

				osg::Vec3Array* vecarray = static_cast<osg::Vec3Array*>(obj->getVertexAttribArray(0));
				depth = new float[obj->getVertexAttribArray(0)->getDataSize()];

				std::vector<unsigned int> index;
				index.resize(obj->getVertexAttribArray(0)->getDataSize());
				for(int i = 0; i < obj->getVertexAttribArray(0)->getDataSize(); i++)	index[i] = i;
						
				for(unsigned int i = 0; i < obj->getVertexAttribArray(0)->getDataSize(); i++)	
					depth[i] = (dir * vecarray->at(i));//.x(), vecarray->at(i).y(), vecarray->at(i).z())); //project into viewvec axis

				std::sort(index.begin(), index.end(), *this); //Das ist evt. falsch. Verliere CLouds
								
				unsigned int n = 0;
				for(unsigned int k = 0; k < obj->getNumPrimitiveSets()-1; k++)
				{
					switch ( obj->getPrimitiveSet(k)->getType() )
				 	{
						case osg::PrimitiveSet::DrawArraysPrimitiveType:
						{
							osg::DrawArrays* da = static_cast<osg::DrawArrays*>(obj->getPrimitiveSet(k));
							//for(unsigned int iter = 0; iter < index.size(); iter++)
							for(unsigned int iter = 0; iter < da->getNumIndices(); iter++)
							{	
								da->getDrawElements()->setElement(iter, index.at(n));
								n++;
							}
							break;
						}
						case osg::PrimitiveSet::DrawElementsUIntPrimitiveType:
						{
							osg::DrawElementsUInt* da = static_cast<osg::DrawElementsUInt *>(obj->getPrimitiveSet(k));
							//for(unsigned int iter = 0; iter < index.size(); iter++)							
							for(unsigned int iter = 0; iter < da->getNumIndices(); iter++)
							{	
								da->setElement(iter, index.at(n));
								n++;
							}
							break;
						}
						case osg::PrimitiveSet::DrawElementsUShortPrimitiveType:
						{
							osg::DrawElementsUShort* da = static_cast<osg::DrawElementsUShort  *>(obj->getPrimitiveSet(k));
							//for(unsigned int iter = 0; iter < index.size(); iter++)
							for(unsigned int iter = 0; iter < da->getNumIndices(); iter++)
							{	
								da->setElement(iter, index.at(n));
								n++;
							}
							break;
						}
						case osg::PrimitiveSet::DrawElementsUBytePrimitiveType:
						{
							osg::DrawElementsUByte* da = static_cast<osg::DrawElementsUByte *>(obj->getPrimitiveSet(k));
							//for(unsigned int iter = 0; iter < index.size(); iter++)
							for(unsigned int iter = 0; iter < da->getNumIndices(); iter++)
							{	
								da->setElement(iter, index.at(n));
								n++;
							}
							break;
						}
					}
					
					obj->getPrimitiveSet(k)->dirty();
				}
				
				obj->dirtyBound();
				delete[] depth;
				index.clear();
			}
		}*/
	}
    traverse(node, nv);
}