#include "Contrail.h"
#include <stdio.h>
#include <iostream>

osg::ref_ptr<osg::Texture2D> osgCloudyDay::Contrail::tex_clouds=0;
float osgCloudyDay::Contrail::timeOfDay = 0.75;
float osgCloudyDay::Contrail::fading = 0.0;
float osgCloudyDay::Contrail::dens = 1.0;
osgCloudyDay::Skydome* osgCloudyDay::Contrail::m_skydome = 0;
osgCloudyDay::Fog* osgCloudyDay::Contrail::m_fog = 0;

osg::Texture2D* osgCloudyDay::Contrail::m_tex_contrail=0;
osg::Program* osgCloudyDay::Contrail::m_shader=0;


osg::Vec3 osgCloudyDay::Contrail::sunLightColor = osg::Vec3(1.f, 1.f, 1.f);

osg::Vec3 osgCloudyDay::Contrail::ambientLight_h0 = osg::Vec3(0.f, 0.f, 0.f);
osg::Vec3 osgCloudyDay::Contrail::ambientLight_h1 = osg::Vec3(1.f, 1.f, 1.f);
osg::Vec3 osgCloudyDay::Contrail::ambientLight_t0 = osg::Vec3(0.f, 0.f, 0.f);
osg::Vec3 osgCloudyDay::Contrail::ambientLight_t1 = osg::Vec3(1.f, 1.f, 1.f);
osg::Matrix3 osgCloudyDay::Contrail::directionalColors = osg::Matrix3(0.4f, 0.4f, 0.4f, 0.8f, 0.8f, 0.8f, 0.9f, 0.9f, 0.9f);


float osgCloudyDay::Contrail::time = 0.f;


osgCloudyDay::Contrail::Contrail(void) : m_vertices(new osg::Vec3Array()), m_additional(new osg::Vec4Array()), contrail_obj(new osg::Geode()), m_geometry(new osg::Geometry())
{
}


osgCloudyDay::Contrail::~Contrail(void)
{
}

void osgCloudyDay::Contrail::CreateShader()
{
	m_shader = new osg::Program();	
	osg::Shader* vertex = osg::Shader::readShaderFile(osg::Shader::VERTEX, "shaders/contrail.vert");
	osg::Shader* geometry = osg::Shader::readShaderFile(osg::Shader::GEOMETRY, "shaders/contrail.geom");
	osg::Shader* fragment = osg::Shader::readShaderFile(osg::Shader::FRAGMENT, "shaders/contrail.frag");
	
	m_shader->addShader(vertex);
	m_shader->addShader(geometry);
	m_shader->addShader(fragment);

	m_shader->addBindFragDataLocation("out_color", 0);
	m_shader->addBindFragDataLocation("out_color2", 1);	
}

void osgCloudyDay::Contrail::Create(osg::Vec3 start, osg::Vec3 end)
{	
	std::cout << "create 1" << std::endl;
	osg::Vec3 stepDir = end-start;
	float length = stepDir.length();
	stepDir.normalize();

	float stepLength = 10.f;
	stepDir = stepDir*stepLength;

	osg::Vec3 s = start;
	for(float i = 0; i <= length; i+=stepLength)
	{
		m_vertices->push_back(s);			
		m_additional->push_back(osg::Vec4(10.f, 0.f, 0.f, 0.f));
		s = s + stepDir;
	}

	unsigned int* index = new unsigned int[m_vertices->size()];
	for(unsigned int i = 0; i < m_vertices->size(); i++)
		index[i] = i;
	
	m_geometry->setVertexArray(m_vertices.get());
	m_geometry->setVertexAttribArray(0, m_vertices.get());
	m_geometry->setVertexAttribBinding(0, osg::Geometry::BIND_PER_VERTEX);
	
	m_geometry->setVertexAttribArray(1, m_additional.get());
	m_geometry->setVertexAttribBinding(1, osg::Geometry::BIND_PER_VERTEX);

	m_geometry->addPrimitiveSet(
		new osg::DrawElementsUInt(osg::PrimitiveSet::POINTS,
			m_vertices->size(),
			&index[0])
			);		
	m_geometry->getPrimitiveSet(m_geometry->getNumPrimitiveSets()-1)->getDrawElements()->setDataVariance(osg::Object::DYNAMIC);			
	
	m_geometry->setUseDisplayList(false);
	m_geometry->setUseVertexBufferObjects(true);
		
	contrail_obj->addDrawable(m_geometry.get());
	contrail_obj->setCullingActive(false); //wars ned		
	
	osg::StateSet* nodess4 = contrail_obj->getOrCreateStateSet();	
	nodess4->setAttribute(m_shader);
	
	nodess4->addUniform(new osg::Uniform("project", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("project_light", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("inv_project_light", osg::Matrixd()));
		
	nodess4->addUniform(new osg::Uniform("modelViewMatrix", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("modelViewMatrix_light", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("viewMatrix", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("viewMatrix_light", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("viewMatrixInv", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("viewMatrixInv_light", osg::Matrixd()));

	nodess4->addUniform(new osg::Uniform("halfAngleDirVector", osg::Vec3()));
	nodess4->addUniform(new osg::Uniform("halfAngleRightVector", osg::Vec3()));
	nodess4->addUniform(new osg::Uniform("halfAngleUpVector", osg::Vec3()));	
	nodess4->addUniform(new osg::Uniform("viewHalfAngleMatrix", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("invViewHalfAngleMatrix", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("viewHalfAngleLightMatrix", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("invViewHalfAngleLightMatrix", osg::Matrixd()));

	nodess4->addUniform(new osg::Uniform("color_tex", 0));

	nodess4->addUniform(new osg::Uniform("un_light_pos", m_skydome->GetLightPosition()));
	nodess4->addUniform(new osg::Uniform("un_timeOfDay", timeOfDay));
	nodess4->addUniform(new osg::Uniform("un_fading", fading));
	nodess4->addUniform(new osg::Uniform("un_dens", dens));
	nodess4->addUniform(new osg::Uniform("un_skyLight_h0", ambientLight_h0));
	nodess4->addUniform(new osg::Uniform("un_skyLight_h1", ambientLight_h1));
	nodess4->addUniform(new osg::Uniform("un_skyLight_t0", ambientLight_t0));
	nodess4->addUniform(new osg::Uniform("un_skyLight_t1", ambientLight_t1));		
	nodess4->addUniform(new osg::Uniform("un_dir_colors", directionalColors));		
	
	m_skydome->SetupUniform(nodess4);	
	nodess4->addUniform(new osg::Uniform("un_sunLight", osg::Vec3(1.f, 1.f, 1.f)));

	
	nodess4->addUniform(new osg::Uniform("fogdensity", m_fog->GetFogDensity()));
	nodess4->addUniform(new osg::Uniform("fogheight", m_fog->GetFogHeight() ));
	nodess4->addUniform(new osg::Uniform("fogcolor", m_fog->GetFogColor()));

	nodess4->setTextureAttributeAndModes(0, Contrail::m_tex_contrail, osg::StateAttribute::ON);

}
