#include "CloudyDay.h"
osgCloudyDay::Scene* osgCloudyDay::CloudyDay::m_scene;

osgCloudyDay::LightShaft* osgCloudyDay::CloudyDay::m_lightshaft;

osg::ref_ptr<osg::Camera> osgCloudyDay::CloudyDay::GetLightshaftCamera()
{
	return m_lightshaft->GetCamera();
}

osgCloudyDay::CloudyDay::CloudyDay(osgCloudyDay::TerrainConfig* config, bool add_rain, bool add_forest, bool add_grass, bool bloom, bool star) : 
	m_terrainconfig(config), 
	scene (new osg::Group), 
	cube_scene(new osg::Group), 
	hud (new osg::Group), 
	num_reflections(0), 
	m_add_forest(add_forest), 
	m_add_grass(add_grass), 
	m_add_rain(add_rain),
	m_atmopshere(0),
	m_terrain(0),
	m_object(0),
	m_cloudcreator(0),
	m_precompute(0),
	m_blur(0),
	m_blur2(0),
	m_postprocess(0),
	m_luminance(0),
	m_bloom(bloom),
	m_star(star)
{
}
osgCloudyDay::CloudyDay::~CloudyDay(void)
{
	if(m_atmopshere != 0) delete m_atmopshere; m_atmopshere = 0;
	if(m_terrain != 0) delete m_terrain; m_terrain = 0;
	if(m_object != 0) delete m_object; m_object = 0;
	if(m_cloudcreator != 0) delete m_cloudcreator; m_cloudcreator = 0;
	if(m_precompute != 0) delete m_precompute; m_precompute = 0;
	if(m_add_grass) delete m_grass; m_grass = 0;
	if(m_add_forest) delete m_forrest; m_forrest = 0;
	if(m_add_rain) delete m_rain; m_rain = 0;
	if(m_postprocess != 0) delete m_postprocess; m_postprocess = 0;
	if(m_blur != 0) delete m_blur; m_blur = 0;
	if(m_blur2 != 0) delete m_blur2; m_blur2 = 0;
	if(m_luminance != 0) delete m_luminance; m_luminance = 0;
	
}

bool osgCloudyDay::CloudyDay::UseBloom()
{
	return m_bloom;
}
bool osgCloudyDay::CloudyDay::UseStar()
{
	return m_star;
}

void osgCloudyDay::CloudyDay::CreateTerrain()
{
	osgCloudyDay::SkydomeMie* skymie = dynamic_cast<osgCloudyDay::SkydomeMie*>(Scene::m_skydome);
	if(skymie != 0)
	{
		if(m_terrainconfig->UseTesselationShader())	m_terrain = new osgCloudyDay::TerrainGeometry(m_terrainconfig);		
		else										m_terrain = new osgCloudyDay::TerrainMIE(m_terrainconfig);
		
	}
	else
	{
		osgCloudyDay::TerrainHimmel* m_terrainhimmel = new osgCloudyDay::TerrainHimmel(m_terrainconfig, m_terrainconfig->UseTesselationShader());
		m_terrain = m_terrainhimmel;

		if(m_lightshaft)
		{
			m_terrainhimmel->SetLightshaft1(m_lightshaft->GetLightshaft1());
			m_terrainhimmel->SetLightshaft2(m_lightshaft->GetLightshaft2());
		}
	}

	m_terrain->SetFog(m_fog); 
	m_terrain->Initialize();
	
	if(m_add_forest)
	{
		Forest::SetHeightofTerrain(m_terrain->GetHeightTexture());
		Forest::SetDefinitionOfTerrain(m_terrain->GetDefinitionTexture());
	}
	if(m_add_grass)
	{
		Grass::SetHeightofTerrain(m_terrain->GetHeightTexture());
		Grass::SetDefinitionOfTerrain(m_terrain->GetDefinitionTexture());
	}

	scene->addChild(m_terrain->GetNode());	



	//camera_lightshaft->addChild(m_terrain->GetNode());

	for(int i = 0; i < 6; i++)
	{
		osg::Group* g = new osg::Group(*m_terrain->GetNode(), osg::CopyOp::DEEP_COPY_ALL);
		osg::MatrixTransform* trans2 = new osg::MatrixTransform( osg::Matrixd(1500.f, 0.f, 0.f, 0.f, 
														  0.f, 1500.f, 0.f, 0.f, 
														  0.f, 0.f,1000.f, 0.f, 
														  0.f, 0.f,-1000.f, 1.f));	

		trans2->addChild(g);
		for(int j = 0; j < num_reflections; j++)
			m_reflection[j]->GetCamera()[i]->addChild(trans2);		
	}

	lightView_scene->addChild(m_terrain->GetLightNode());
}
void osgCloudyDay::CloudyDay::CreateAtmosphere()
{
	osgCloudyDay::SkydomeMie* skymie = dynamic_cast<osgCloudyDay::SkydomeMie*>(Scene::m_skydome);
	if(skymie != 0)
	{
		std::cout << "CREATE Atmosphere Mie" << std::endl;
		m_atmopshere = new osgCloudyDay::AtmosphereMie();
	}
	else
	{
		std::cout << "CREATE Atmosphere Himmel" << std::endl;
		m_precompute = new osgCloudyDay::AtmospherePrecompute();
		m_precompute->compute();
	
		osgCloudyDay::AtmosphereHimmel* atmohimmel = new osgCloudyDay::AtmosphereHimmel();
		atmohimmel->m_inscatter = m_precompute->getInscatterTexture();
		atmohimmel->m_irradiance = m_precompute->getIrradianceTexture();
		atmohimmel->m_transmittance = m_precompute->getTransmittanceTexture();	

		if(m_lightshaft)
		{
			atmohimmel->fbo_lightshaft1 = m_lightshaft->GetLightshaft1();
			atmohimmel->fbo_lightshaft2 = m_lightshaft->GetLightshaft2();
		}
		m_atmopshere = atmohimmel;

		osgCloudyDay::SkydomeHimmel::m_inscatter = m_precompute->getInscatterTexture();
		osgCloudyDay::SkydomeHimmel::m_irradiance = m_precompute->getIrradianceTexture();
		osgCloudyDay::SkydomeHimmel::m_transmittance = m_precompute->getTransmittanceTexture();
	}		

	m_atmopshere->SetFog(m_fog); 
	m_atmopshere->Initialize();
	scene->addChild(m_atmopshere->GetNode());

	for(int j = 0; j < num_reflections; j++)
		m_reflection[j]->AddObject(m_atmopshere->GetNode());	

}
void osgCloudyDay::CloudyDay::CreateForest()
{
	Forest::CreateShader();
	Forest::CreateTexture();	
	
	m_forrest = new Forest();
	m_forrest->Initialize();
	scene->addChild(m_forrest->GetGeode());

}

void osgCloudyDay::CloudyDay::CreateNight()
{
	Night::CreateShader();
	Night::CreateTexture();	
	
	m_night = new Night();
	m_night->Initialize();
	scene->addChild(m_night->GetGeode());

}

void osgCloudyDay::CloudyDay::CreateGrass()
{
	Grass::CreateShader();
	Grass::CreateTexture();	
	
	m_grass = new Grass();
	m_grass->Initialize(m_terrainconfig);
	scene->addChild(m_grass->GetGeode());
}
void osgCloudyDay::CloudyDay::CreateRain(RainState* rainstate)
{
	osgCloudyDay::Rain::CreateShader();
	osgCloudyDay::Rain::CreateTexture();
	m_rain = new osgCloudyDay::Rain();
	m_rain->Initialize(rainstate);
	scene->addChild(m_rain->GetGeode());
}
void osgCloudyDay::CloudyDay::Create2DClouds(std::vector<osgCloudyDay::Cloud2DState> cloud2dstates)
{
	#if 0
//********************************************
	/*
	PerlinNoiseCloud* perlinNoiseCloud = new PerlinNoiseCloud();	
	osg::Geode* geode = perlinNoiseCloud->geode;
	geode->addUpdateCallback(new PerlinNoiseCallback);	
	scene->addChild(geode);

#ifdef SHADOW_MAPPING	
	{
		PerlinNoiseCloud* perlinNoiseCloud = new PerlinNoiseCloud();	
		osg::Geode* geode = perlinNoiseCloud->geode;
		geode->addUpdateCallback(new PerlinNoiseCallback);
		lightView_scene->addChild(geode);
	}
#endif	

//********************************************
	/*/
	Cirrus* cirrusCloud = new Cirrus(osg::Vec3(0.f, 0.f, 5000.0f), osg::Vec2(10000.0f, 10000.0f));	
	osg::Geode* geode_cirrus = cirrusCloud->geode;
	geode_cirrus->addUpdateCallback(new PerlinNoiseCallback);	
	scene->addChild(geode_cirrus);	

	//27.1.
	for(int i = 0; i < 6; i++)
	{
		osg::Geode* geode_cirrus2 = new osg::Geode(*geode_cirrus, osg::CopyOp::DEEP_COPY_ALL); 	
		geode_cirrus2->addUpdateCallback(new PerlinNoiseCallback);
		m_reflection[0]->GetCamera()[i]->addChild(geode_cirrus2);	
	}

#ifdef SHADOW_MAPPING
	{		
		Cirrus* cirrusCloud = new Cirrus(osg::Vec3(0.f, 0.f, 5000.0f), osg::Vec2(10000.0f, 10000.0f));	
		osg::Geode* geode_cirrus = cirrusCloud->geode;
		geode_cirrus->addUpdateCallback(new PerlinNoiseCallback);	
		lightView_scene->addChild(geode_cirrus);
	}
#endif	
	//*/
//********************************************
#else
	osgCloudyDay::Create2DCloud* m_create2dclouds = new osgCloudyDay::Create2DCloud();
	m_create2dclouds->Initialize(cloud2dstates);
	scene->addChild(m_create2dclouds->GetNode());	

	/*
#ifdef SHADOW_MAPPING
	lightView_scene->addChild(m_create2dclouds->GetNodeLight());
#endif
	/*std::cerr << "---4---" << std::endl;
	for(int j = 0; j < num_reflections; j++)
		for(int i = 0; i < 6; i++)				
			m_reflection[j]->GetCamera()[i]->addChild(m_create2dclouds->GetReflectionCamera(i));	
	*/
#endif

}
void osgCloudyDay::CloudyDay::CreatePostProcessing(std::vector<std::string> luds, int hdr_mapping, bool use_avglum)
{
	m_blur = new osgCloudyDay::Blur(4);	
	m_blur->CreateCamera();

	m_blur2 = new osgCloudyDay::Blur(5);		
	m_blur2->CreateCamera();

	m_luminance = new osgCloudyDay::LuminanceCalculation();
	m_luminance->CreateCamera();

	m_postprocess = new osgCloudyDay::PostProcess(hdr_mapping, use_avglum, m_bloom, m_star);
	for(unsigned int i = 0; i < luds.size(); i++)
		m_postprocess->AddLUD(luds[i]/*"color-gradient/yellowLUT.bmp"*/);
	m_postprocess->CreateCamera();
}
void osgCloudyDay::CloudyDay::CreateClouds(osgCloudyDay::CloudState*& clouds)
{
	m_cloudcreator = new osgCloudyDay::CloudCreator(scene);
	m_cloudcreator->Initialize(clouds, m_fog);
		
	m_cloudcreator->CreateDummyObjectForShader(scene);
	{
		osg::Group* debug_boxes = m_cloudcreator->GetDebugBoxes();	
		osg::ref_ptr<osg::StateSet> nodessP = debug_boxes->getOrCreateStateSet();

		osg::ref_ptr<osg::Program> planeProg =(new osg::Program);
		osg::ref_ptr<osg::Shader> planevertexShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/debug_shad.vert"));
		osg::ref_ptr<osg::Shader> planefragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/debug_shad.frag"));
			
		//Binding the box shaders to its program
		planeProg->addShader(planevertexShader.get());
		planeProg->addShader(planefragShader.get());
		planeProg->addBindAttribLocation("vertex", 0);
		planeProg->addBindFragDataLocation("out_color", 0);
		nodessP->setAttribute(planeProg.get());

		nodessP->addUniform(new osg::Uniform("ProjectionMatrix", Scene::GetProjectionMatrix_View()));
		nodessP->addUniform(new osg::Uniform("ModelViewMatrix", Scene::GetViewMatrix_View()));
		nodessP->addUniform(new osg::Uniform("ViewMatrix", Scene::GetViewMatrix_View()));	
		debug_boxes->addUpdateCallback(new ViewerLightCallback());
		//scene->addChild(debug_boxes);
	}			

	/*//camera_plane_cubemap[5]->addChild(cube_scene);
	for(int i = 0; i < 6; i++)
	{
		osg::Group* g = new osg::Group(*cube_scene, osg::CopyOp::DEEP_COPY_ALL);
		//g->addCullCallback(new ViewerLightCallbackTest);

		for(int j = 0; j < g->getNumChildren(); j++)
		{
			g->getChild(j)->addUpdateCallback(new ViewerLightCallbackTest);
		}
		camera_plane_cubemap[i]->addChild(g);
	}*/	

	//std::cout << "LIGHTSHAFT" << std::endl;
}
void osgCloudyDay::CloudyDay::Initialize(int width, int size, osgCloudyDay::CloudState*& clouds, std::vector<osgCloudyDay::Cloud2DState> cloud2dstates, std::vector<int> ids_model, std::vector<std::string> reflection_models, std::vector<std::string> reflection_tex, osgCloudyDay::Fog* fog, std::vector<std::string> luds, RainState* rainstate)
{	
	my_scene = new Scene(width,size);		
	//m_scene->CreateViewDepthCamera();
	//m_scene->CreateLightCamera();	
	m_scene->CreateViewCamera();	
	osgCloudyDay::CloudScene::Initialize();
	osgCloudyDay::CloudScene::CreateCloudCamera();	
		
	lightView_scene = new osg::Group();
	m_reflection = new ReflectionCamera*[reflection_models.size()];
	for(unsigned int i = 0; i < reflection_models.size(); i++)
	{
		m_reflection[i] = new ReflectionCamera();
		m_reflection[i]->Initialize();	
	}
	num_reflections = reflection_models.size();

	m_lightshaft = new osgCloudyDay::LightShaft();
	m_lightshaft->Initialize();

	m_hud = new osgCloudyDay::HUD(/*m_lightshaft->GetLightshaft1()*/);
	m_hud->SetSceneTexture(osgCloudyDay::Scene::GetSceneTexture());
	m_hud->SetGodrayTexture(osgCloudyDay::Scene::GetGoodRayTexture());
	m_hud->SetCloudTexture(osgCloudyDay::CloudScene::fbo_cloud_texture);

	osgCloudyDay::HUD::Initialize();
	m_hud->CreateCamera();	
		
	CreatePostProcessing(luds, osgCloudyDay::PostProcess::HDRM_ReinhardModified, true);	

	m_fog = fog;	
	CreateAtmosphere();
	CreateTerrain();

	if(m_add_forest) CreateForest();
	if(m_add_grass)	 CreateGrass();
	
	m_ground = new Ground();
	lightView_scene->addChild(m_ground->Create());
	
	m_object = new ObjectModel*[reflection_models.size()];

	for(unsigned int i = 0; i < reflection_models.size(); i++)
	{
		m_object[i] = new ObjectModel();
		m_object[i]->Initialize(ids_model[i], reflection_models[i], reflection_tex[i], m_reflection[i]->fbo_plane_cube);
		scene->addChild(m_object[i]->ViewNode());
		lightView_scene->addChild(m_object[i]->LightNode());	
	}

	Create2DClouds(cloud2dstates);

	if(m_add_rain)	CreateRain(rainstate);

	CreateNight();

	/*Contrail::m_skydome = Scene::m_skydome;	
	Contrail::m_fog = m_fog; 

	Contrail* m_contrail = new Contrail();
	Contrail::m_tex_contrail = CloudScene::tex_clouds;
	Contrail::CreateShader();	
	m_contrail->Create(osg::Vec3(0, 0, 10.f), osg::Vec3(0, 1000, 10000.f));	
	
	osg::Geode* contrail = m_contrail->contrail_obj;
	ContrailUpdate* contrail_update = new ContrailUpdate();
	contrail->setCullCallback(contrail_update);
	scene->addChild(contrail);	
	*/

	m_hud->CreateGeometry();
	m_blur->CreateGeometry();	
	m_blur2->CreateGeometry();
	m_postprocess->CreateGeometry();
	m_luminance->CreateGeometry();

#ifdef SHADOW_MAPPING
	osg::CullFace* cull = new osg::CullFace();
	cull->setMode(osg::CullFace::FRONT);
	lightView_scene->getOrCreateStateSet()->setAttributeAndModes(cull, osg::StateAttribute::ON);
	Scene::GetLightCamera()->addChild(lightView_scene);	
#endif	

	scene2 = new osg::Group();
//	Scene::GetViewDepthCamera()->addChild(scene2);	

	osg::CullFace* cull2 = new osg::CullFace();
	cull2->setMode(osg::CullFace::BACK);
	scene->getOrCreateStateSet()->setAttributeAndModes(cull2, osg::StateAttribute::ON);	

	{		
		debug_geode2 = new osg::Geode;	

		// set up the Geometry.
		osg::ref_ptr<osg::Geometry> geom = new osgCloudyDay::DebugGeometry;

		osg::Vec3 size(40000.f, 40000.f, 10000.f);
		osg::Vec3 width, depth, topleft, height;
		topleft = osg::Vec3( -size.x()/2.0, -size.y()/2.0, -1000.0f );
		width = osg::Vec3( size.x(), 0.0, 0.0 );
		depth = osg::Vec3( 0.0, size.y(), 0.0 );
		height = osg::Vec3( 0.0, 0.f, size.z() );

		osg::ref_ptr<osg::Vec3Array> coords = new osg::Vec3Array(20);		
		unsigned int* indices = new unsigned int[20];	

		coords->at(0) = (topleft);		
		coords->at(1) = (topleft+depth);
		coords->at(2) = (topleft+width+depth);
		coords->at(3) = (topleft+width);

		coords->at(4) = (topleft);		
		coords->at(5) = (topleft+depth);
		coords->at(6) = (topleft+depth+height);
		coords->at(7) = (topleft+height);

		coords->at(8) = (topleft+depth);		
		coords->at(9) = (topleft+width+depth);
		coords->at(10) = (topleft+width+depth+height);
		coords->at(11) = (topleft+depth+height);

		coords->at(12) = (topleft+width+depth);		
		coords->at(13) = (topleft+width);
		coords->at(14) = (topleft+width+height);
		coords->at(15) = (topleft+width+depth+height);

		coords->at(16) = (topleft+width);		
		coords->at(17) = (topleft);
		coords->at(18) = (topleft+height);
		coords->at(19) = (topleft+width+height);


		for(int i = 0; i < 20; i++)
			indices[i] = i;

		geom->setVertexArray(coords.get());
		geom->setVertexAttribArray(0, coords.get());
		geom->setVertexAttribBinding(0, osg::Geometry::BIND_PER_VERTEX);						
		
		geom->addPrimitiveSet(new osg::DrawElementsUInt(osg::PrimitiveSet::QUADS, 20, &indices[0]));
		geom->getPrimitiveSet(0)->getDrawElements()->setDataVariance(osg::Object::DYNAMIC);		
		
		geom->setUseVertexBufferObjects(true);
		geom->setSupportsDisplayList(false);		
	
		debug_geode2->addDrawable( geom );				

		debug_geode2->getOrCreateStateSet()->setAttribute(Scene::GetShadingProgram().get());			
		debug_geode2->getOrCreateStateSet()->addUniform(new osg::Uniform("ProjectionMatrix", osg::Matrixd()));
		debug_geode2->getOrCreateStateSet()->addUniform(new osg::Uniform("light_proj_matrix", osg::Matrixd()));

		debug_geode2->getOrCreateStateSet()->addUniform(new osg::Uniform("ModelMatrix", osg::Matrixd()));
		debug_geode2->getOrCreateStateSet()->addUniform(new osg::Uniform("ViewMatrix", osg::Matrixd()));				
		debug_geode2->getOrCreateStateSet()->addUniform(new osg::Uniform("light_mv_matrix", osg::Matrixd()));
	
		debug_geode2->addCullCallback(new ViewerLightCallback());
		
		debug_geode2->getDrawable(0)->asGeometry()->getPrimitiveSet(0)->dirty();
		geom->getVertexAttribArray(0)->dirty();
		geom->dirtyBound();
		debug_geode2->getDrawable(0)->dirtyBound();
		debug_geode2->dirtyBound();

		debug_geode2->getOrCreateStateSet()->setAttributeAndModes(cull2, osg::StateAttribute::OFF);	
		lightView_scene->addChild(debug_geode2);
	}

	
	blurShadow = new osgCloudyDay::BlurShadow();
	blurShadow->Initialize();	

//	scene3 = new osg::Group(*scene, osg::CopyOp::DEEP_COPY_ALL);
//	scene3->addCullCallback(new ViewerLightTerrainCallback());

	scene->getOrCreateStateSet()->setAttributeAndModes( new osg::Depth( osg::Depth::LEQUAL, 0.0, 1.0) );
	//scene3->getOrCreateStateSet()->setAttributeAndModes( new osg::Depth( osg::Depth::LEQUAL, 0.0, 1.0) );

	Scene::GetViewCamera2()->addChild(scene);	

	CreateClouds(clouds);	

	
	m_lightshaft2 = new LightShaft2();
	m_lightshaft2->Initialize();
	scene->addChild(m_lightshaft2->GetGeode());
	
	Scene::GetViewCamera()->addChild(scene);		
	Scene::GetViewCamera()->setPostDrawCallback(new PostDrawCallBack(m_cloudcreator));
}

osg::ref_ptr<osg::Camera> osgCloudyDay::CloudyDay::GetBlurShadowMapCamera()
{
	return blurShadow->GetCamera();
}
osg::ref_ptr<osg::Camera> osgCloudyDay::CloudyDay::GetLuminanceCalculation()
{	
	return m_luminance->GetCamera();
}
osg::ref_ptr<osg::Camera> osgCloudyDay::CloudyDay::GetBlur2Process()
{	
	return m_blur2->GetCamera();
}
osg::ref_ptr<osg::Camera> osgCloudyDay::CloudyDay::GetBlurProcess()
{	
	return m_blur->GetCamera();
}
osg::ref_ptr<osg::Camera> osgCloudyDay::CloudyDay::GetPostProcess()
{	
	return m_postprocess->GetCamera();
}

osg::ref_ptr<osg::Camera> osgCloudyDay::CloudyDay::GetHUD()
{
	return m_hud->GetCamera();
}

osg::ref_ptr<osg::Node> osgCloudyDay::CloudyDay::GetObjectModel(int i)
{
	return m_object[i]->ViewNode();
}

/*
osg::ref_ptr<osg::Node> CloudyDay::GetAtmosphere()
{
	return m_atmopshere->;
}

osg::ref_ptr<osg::Node> CloudyDay::GetTerrain()
{
	return m_terrain;
}*/

osg::ref_ptr<osg::Camera> osgCloudyDay::CloudyDay::GetLightCamera()
{
	return Scene::GetLightCamera();
}

osg::ref_ptr<osg::Camera> osgCloudyDay::CloudyDay::GetLightCloudCamera()
{
	return osgCloudyDay::CloudScene::GetCloudCamera();
}

osg::ref_ptr<osg::Camera> osgCloudyDay::CloudyDay::GetViewCamera()
{
	return Scene::GetViewCamera();
}

osg::ref_ptr<osg::Camera> osgCloudyDay::CloudyDay::GetViewCamera2()
{
	return Scene::GetViewCamera2();
}

osg::ref_ptr<osg::Camera> osgCloudyDay::CloudyDay::GetViewDepthCamera()
{
	return Scene::GetViewDepthCamera();
}

osg::ref_ptr<osg::Node> osgCloudyDay::CloudyDay::GetScene()
{
	return scene2;
}

int osgCloudyDay::CloudyDay::GetNumberOfReflectionObjects()
{
	return num_reflections;
}

osg::Camera**& osgCloudyDay::CloudyDay::GetReflectionCamerasAt(int i)
{
	return m_reflection[i]->GetCamera(); //return m_reflectioncameras[i]->GetCamera();
}

void osgCloudyDay::CloudyDay::UpdateLightForClouds()
{
	if(m_cloudcreator->GetCloudScene() != 0)
	{
		m_cloudcreator->GetCloudScene()->UpdateUniform(osgCloudyDay::CloudScene::WCU_LightPos);
		m_cloudcreator->GetCloudScene()->UpdateUniform(osgCloudyDay::CloudScene::WCU_SunLightColor);		
	}
}