#include "CloudVoxel.h"
#include "CloudScene.h"
#include "VoxelizeMesh.h"

osgCloudyDay::CloudVoxel::CloudVoxel(std::string path, osg::Vec3 middlepos, int sx, int sy, int sz, int type, osg::Vec4 density) : CloudGenerator(density), slicex(sx), slicey(sy) ,slicez(sz), m_path(path), m_middlepos(middlepos)
{
	m_category = type;
}


osgCloudyDay::CloudVoxel::~CloudVoxel(void)
{

}

bool osgCloudyDay::CloudVoxel::Update()
{
	return false;
}

void osgCloudyDay::CloudVoxel::Initialize()
{
	//std::cout << "CloudVoxel - Initialize()" << std::endl;
	VoxelizeMesh* voxel_loader = new VoxelizeMesh(m_path, slicex,slicey,slicez);
	voxel_loader->Perform();
	
	osg::Vec3 randVer = m_middlepoint;
	osg::Vec3 sizes = osg::Vec3(1, 1, 1);

	int num_boxes = 0;	
	
	float sx = (voxel_loader->m_boundingbox.xMax()- voxel_loader->m_boundingbox.xMin());
	float sy = (voxel_loader->m_boundingbox.yMax()- voxel_loader->m_boundingbox.yMin());
	float sz = (voxel_loader->m_boundingbox.zMax()- voxel_loader->m_boundingbox.zMin());
	//std::cout << "S: " << sx << " " << sy << " " << sz << std::endl;

	osg::Vec3 size = osg::Vec3( sx/(float)(slicex),
								sy/(float)(slicey),
								sz/(float)(slicez));				
	for(int z = 0; z < slicex; z++)
	{
		for(int y = 0; y < slicey; y++)
		{
			for(int x = 0; x < slicex; x++)
			{				
				if(voxel_loader->GetData(x,y,z).x() > 0.5f)
				{
					osg::Vec3 posHelper = m_middlepos + osg::Vec3((float)(x)*size.x()*100.f,
																  (float)(y)*size.y()*100.f,
																  (float)(z)*size.z()*100.f);							
					osg::Vec3 jitter_sizes(size.x()/sizes.x(), size.y()/sizes.y(), size.z()/sizes.z());	
		
					////std::cout << "POS: " << posHelper.x() << " " << posHelper.y() << " " << posHelper.z() << std::endl;		

					AddCloudBox(num_boxes, posHelper, sizes, size*100.f, jitter_sizes, true, 100.f, osg::Vec4(10.f, 20.f, 10.f, 20.f), m_density);
					num_boxes++;
					AddBox(dBoxes_vertices, posHelper, size);
				}
			}
		}
	}

	//EliminateRedudantSprites();	
	DecideInsideOutside();

	dBoxes_indices.resize(dBoxes_vertices->size());
	for(unsigned int i = 0; i < dBoxes_vertices->size(); i++)
	{
		dBoxes_indices[i] = i;
	}
	dBoxes_geometry->setVertexArray (dBoxes_vertices.get());
	dBoxes_geometry->addPrimitiveSet(
		new osg::DrawElementsUShort(osg::PrimitiveSet::TRIANGLES, dBoxes_vertices->size(), &dBoxes_indices[0])
	);
	dBoxes_geometry->getPrimitiveSet(0)->getDrawElements()->setDataVariance(osg::Object::STATIC);
	dBoxes->addDrawable(dBoxes_geometry.get());
	dBoxes->getOrCreateStateSet()->setMode(GL_CULL_FACE, osg::StateAttribute::OFF );
	dBoxes->setCullingActive(false);

	ex->AddCloud(m_cloud->GetVertices(), m_cloud->GetRotation(), m_cloud->GetColor(), m_cloud->GetCenter(), m_cloud->GetIds(), m_cloud->GetBoxCenters(), num_boxes);

}