#include "CloudState.h"


osgCloudyDay::CloudState::CloudState(void) : num_of_clouds(0)
{
	m_middlepoint = std::map<int, osg::Vec3>();
	m_size = std::map<int, osg::Vec3>();
	m_type = std::map<int, int>();
	m_path = std::map<int, std::string>();
	m_type_generation = std::map<int, int>();
	m_color = std::map<int, osg::Vec4f>();
}


osgCloudyDay::CloudState::~CloudState(void)
{
	m_middlepoint.clear();
	m_size.clear();
	m_type.clear();
	m_path.clear();
	m_type_generation.clear();
	m_color.clear();
}

void osgCloudyDay::CloudState::AddCloud(int type, osg::Vec3 middlepoint, osg::Vec3 size, osg::Vec4 color)
{	
	m_middlepoint.insert(std::pair<int, osg::Vec3>(num_of_clouds, middlepoint));
	m_size.insert(std::pair<int, osg::Vec3>(num_of_clouds, size));
	m_type.insert(std::pair<int, int>(num_of_clouds, type));
	m_type_generation.insert(std::pair<int,int>(num_of_clouds, CStG_Standard));
	m_path.insert(std::pair<int,std::string>(num_of_clouds, ""));
	m_color.insert(std::pair<int, osg::Vec4>(num_of_clouds, color));
	num_of_clouds++;
}

void osgCloudyDay::CloudState::AddCloud(int type, std::string path, osg::Vec3 middlepoint, osg::Vec3 size, int gentype, osg::Vec4 color)
{	
	m_middlepoint.insert(std::pair<int, osg::Vec3>(num_of_clouds, middlepoint));
	m_size.insert(std::pair<int, osg::Vec3>(num_of_clouds, size));
	m_type.insert(std::pair<int, int>(num_of_clouds, type));
	m_type_generation.insert(std::pair<int,int>(num_of_clouds, gentype));
	m_path.insert(std::pair<int,std::string>(num_of_clouds, path));
	m_color.insert(std::pair<int, osg::Vec4>(num_of_clouds, color));

	num_of_clouds++;
}

int osgCloudyDay::CloudState::GetCloudGenerationType(int at)
{
	return m_type_generation[at];
}

int osgCloudyDay::CloudState::GetCloudType(int at)
{
	return m_type[at];
}

std::string osgCloudyDay::CloudState::GetPath(int at)
{
	return m_path[at];
}

osg::Vec3 osgCloudyDay::CloudState::getMiddlePoint(int at)
{
	return m_middlepoint[at];
}

void osgCloudyDay::CloudState::setMiddlePoint(int at, osg::Vec3 middlepoint)
{
	m_middlepoint[at] = middlepoint;
}

osg::Vec3 osgCloudyDay::CloudState::getSize(int at)
{
	return m_size[at];
}

void osgCloudyDay::CloudState::setSize(int at, osg::Vec3 size)
{
	m_size[at] = size;
}

int osgCloudyDay::CloudState::GetNumberOfClouds()
{
	return num_of_clouds;
}

osg::Vec4 osgCloudyDay::CloudState::getColor(int at)
{
	return m_color[at];
}
void osgCloudyDay::CloudState::setColor(int at, osg::Vec4 size)
{
	m_color[at] = size;
}