#include "CSGObject.h"
#include "CloudScene.h"

osg::ref_ptr<osg::Program> osgCloudyDay::CloudScene::cloudShadowMapProg=0;
osg::ref_ptr<osg::Program> osgCloudyDay::CloudScene::cloudProg=0;
osg::ref_ptr<osg::Program> osgCloudyDay::CloudScene::cloudShadowProg=0;
osg::ref_ptr<osg::Program> osgCloudyDay::CloudScene::cloudBlurVertProg=0;
osg::ref_ptr<osg::Program> osgCloudyDay::CloudScene::cloudBlurHoriProg=0;
osg::ref_ptr<osg::Program> osgCloudyDay::CloudScene::cloudBlurLinearVertProg=0;
osg::ref_ptr<osg::Program> osgCloudyDay::CloudScene::cloudBlurLinearHoriProg=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::CloudScene::tex_clouds=0;
float osgCloudyDay::CloudScene::timeOfDay = 0.75;
float osgCloudyDay::CloudScene::fading = 0.0;
float osgCloudyDay::CloudScene::dens = 1.0;

osgCloudyDay::CloudLayerState* osgCloudyDay::CloudScene::m_CloudLayerState  = new osgCloudyDay::CloudLayerState();

osg::Vec3 osgCloudyDay::CloudScene::sunLightColor = osg::Vec3(1.f, 1.f, 1.f);

osg::Vec3 osgCloudyDay::CloudScene::ambientLight_h0 = osg::Vec3(0.f, 0.f, 0.f);
osg::Vec3 osgCloudyDay::CloudScene::ambientLight_h1 = osg::Vec3(1.f, 1.f, 1.f);
osg::Vec3 osgCloudyDay::CloudScene::ambientLight_t0 = osg::Vec3(0.f, 0.f, 0.f);
osg::Vec3 osgCloudyDay::CloudScene::ambientLight_t1 = osg::Vec3(1.f, 1.f, 1.f);
osg::Matrix3 osgCloudyDay::CloudScene::directionalColors = osg::Matrix3(0.4, 0.4, 0.4, 0.8, 0.8, 0.8, 0.9, 0.9, 0.9);

float osgCloudyDay::CloudScene::time = 0.f;

bool osgCloudyDay::CloudScene::m_backtofront=true;
bool osgCloudyDay::CloudScene::m_backtofront_old=true;

osg::ref_ptr<osg::Camera> osgCloudyDay::CloudScene::m_lightCloudCamera=0;	
osg::FrameBufferObject* osgCloudyDay::CloudScene::fbo_cloud_viewer=0;
osg::FrameBufferObject* osgCloudyDay::CloudScene::fbo_shadow=0;
osg::FrameBufferObject* osgCloudyDay::CloudScene::fbo_vert_blur=0;
osg::FrameBufferObject* osgCloudyDay::CloudScene::fbo_hori_blur=0;
osg::FrameBufferObject* osgCloudyDay::CloudScene::fbo_hori_blur2=0;
osg::FrameBufferObject* osgCloudyDay::CloudScene::fbo_vert_linear_blur=0;
osg::FrameBufferObject* osgCloudyDay::CloudScene::fbo_hori_linear_blur=0;


osg::ref_ptr<osg::Texture2D> osgCloudyDay::CloudScene::fbo_light_texture=0;
osg::ref_ptr<osg::Texture2D> osgCloudyDay::CloudScene::fbo_cloud_texture=0;


osgCloudyDay::CloudScene::CloudScene() : setup_attribute(false), numClouds(0), cloud_layer_update(0), m_fog(0)
{
	m_startLayerIndex = (new osg::IntArray());	

	m_vertices = (new osg::Vec3Array());
	m_bb_min = (new osg::Vec3Array());
	m_bb_max = (new osg::Vec3Array());
	m_rotation = (new osg::Vec4Array());
	m_center = (new osg::Vec4Array());
	m_ids = (new osg::Vec4Array());
	m_color = (new osg::Vec4Array());
	m_box_centers = (new osg::Vec4Array());	
	m_start_indices = (new osg::IntArray());	
	m_numPrimitiveArrays = (new osg::IntArray());

	m_cloudcenter = (new osg::Vec3Array());

	m_ambientlight_h = (new osg::Vec3Array());
	m_ambientlight_t = (new osg::Vec3Array());
	m_diffuselight = (new osg::Vec3Array());

	quadBillBoard = new osg::Geode();

	m_uniforms.insert(std::pair<int, std::string>(WCU_LightPos, "un_light_pos"));
	m_uniforms.insert(std::pair<int, std::string>(WCU_TimeOfDay, "un_timeOfDay"));
	m_uniforms.insert(std::pair<int, std::string>(WCU_Fading, "un_fading"));
	m_uniforms.insert(std::pair<int, std::string>(WCU_Density, "un_dens"));	
	m_uniforms.insert(std::pair<int, std::string>(WCU_AmbientLight_H0, "un_skyLight_h0"));	
	m_uniforms.insert(std::pair<int, std::string>(WCU_AmbientLight_H1, "un_skyLight_h1"));	
	m_uniforms.insert(std::pair<int, std::string>(WCU_AmbientLight_T0, "un_skyLight_t0"));	
	m_uniforms.insert(std::pair<int, std::string>(WCU_AmbientLight_T1, "un_skyLight_t1"));	
	m_uniforms.insert(std::pair<int, std::string>(WCU_DirectionalColor, "un_dir_colors"));	
	m_uniforms.insert(std::pair<int, std::string>(WCU_SunLightColor, "un_sunLight"));	
	
	geode = (new osg::Geode());

#ifdef SHADOW_MAPPING
	geometry = (new osgCloudyDay::CloudGeometry(	CloudScene::tex_clouds, 
										fbo_light_texture,
										Scene::GetShadowDepthTexture(),
										Scene::GetBlurTexture(),
										fbo_shadow,	
										fbo_vert_linear_blur,
										fbo_hori_linear_blur,
										fbo_hori_blur,
										fbo_vert_blur,
										fbo_cloud_viewer,
										fbo_hori_blur2,
										CloudScene::cloudProg,
										CloudScene::cloudShadowProg,
										CloudScene::cloudBlurVertProg,
										CloudScene::cloudBlurHoriProg,
										CloudScene::cloudBlurLinearVertProg,
										CloudScene::cloudBlurLinearHoriProg,
										CloudScene::cloudShadowMapProg
									));
#else
	geometry = osg::ref_ptr<osg::Geometry>(new osg::Geometry());
#endif	
}


void osgCloudyDay::CloudScene::Initialize()
{
	fbo_light_texture = new osg::Texture2D();
	fbo_light_texture->setBorderWidth(0);
	fbo_light_texture->setTextureSize(1024,1024);
	fbo_light_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_light_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_light_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_light_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);	
	fbo_light_texture->setSourceFormat(GL_RGBA);
	fbo_light_texture->setInternalFormat(GL_RGBA32F);
	fbo_light_texture->setSourceType(GL_FLOAT);
	//fbo_light_texture->setMaxAnisotropy(8.f);
	//RenderInformation::shadow_texture = fbo_light_texture;

	fbo_cloud_texture = new osg::Texture2D();
	fbo_cloud_texture->setBorderWidth(0);
	fbo_cloud_texture->setTextureSize(osgCloudyDay::Scene::GetWidth(),osgCloudyDay::Scene::GetHeight());
	fbo_cloud_texture->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR);
	fbo_cloud_texture->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	fbo_cloud_texture->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	fbo_cloud_texture->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	fbo_cloud_texture->setInternalFormat(GL_RGBA32F);
	fbo_cloud_texture->setSourceFormat(GL_RGBA);
	fbo_cloud_texture->setSourceType(GL_FLOAT);			
	//fbo_cloud_texture->setUseHardwareMipMapGeneration(true);

	fbo_cloud_viewer = new osg::FrameBufferObject();
	fbo_cloud_viewer->setAttachment(osg::Camera::DEPTH_BUFFER, osg::FrameBufferAttachment(Scene::GetSceneDepthTexture()));
	fbo_cloud_viewer->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(fbo_cloud_texture));
		
	fbo_shadow = new osg::FrameBufferObject();
#ifdef SHADOW_MAPPING
	//fbo_shadow->setAttachment(osg::Camera::DEPTH_BUFFER, osg::FrameBufferAttachment(Scene::fbo_light_depth));
	fbo_shadow->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(fbo_light_texture));
#endif

	fbo_vert_blur = new osg::FrameBufferObject();
	fbo_hori_blur = new osg::FrameBufferObject();
	fbo_hori_blur2 = new osg::FrameBufferObject();
#ifdef SHADOW_MAPPING
	fbo_vert_blur->setAttachment(osg::Camera::DEPTH_BUFFER, osg::FrameBufferAttachment(Scene::GetShadowDepthTexture()));
	fbo_vert_blur->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(Scene::GetBlurTexture()));

	fbo_hori_blur->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(Scene::GetBlurTexture()));
	fbo_hori_blur2->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(fbo_light_texture));
#endif

	fbo_vert_linear_blur = new osg::FrameBufferObject();
	fbo_hori_linear_blur = new osg::FrameBufferObject();	
#ifdef SHADOW_MAPPING	
	fbo_vert_linear_blur->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(Scene::GetBlurTexture()));
	fbo_hori_linear_blur->setAttachment(osg::Camera::COLOR_BUFFER, osg::FrameBufferAttachment(fbo_light_texture));
#endif	
}


void osgCloudyDay::CloudScene::SetFog(osgCloudyDay::Fog* fog)
{
	m_fog = fog;
}

osgCloudyDay::CloudScene::~CloudScene(void)
{
	std::cout << "Destructor: CLOUD SCene" << std::endl;
}

void osgCloudyDay::CloudScene::AddLayer(int layerID, int type)
{
	m_layerToCloudLayerID.push_back(layerID);
	m_layerToCloudType.push_back(type);
	m_startLayerIndex->push_back(m_vertices->size());

	geometry->AddLayer(type);
}

int osgCloudyDay::CloudScene::GetType(int layer)
{
	return m_layerToCloudType.at(layer);
}

int osgCloudyDay::CloudScene::GetNumberOfLayers()
{
	return m_layerToCloudType.size();
}

float osgCloudyDay::CloudScene::frand()
{
    return rand() / (float) RAND_MAX;
}

osg::Vec2 osgCloudyDay::CloudScene::GetGaussianDistributedRandomNumber(osg::Vec2 m, float v)
{
	//float PI = 3.147f;

	//BoxMuller method
	//http://en.wikipedia.org/wiki/Box%E2%80%93Muller_transform
	float U = frand();
	float V = frand();
	float X  = sqrt(-2.f*log(U)) * cos(2.f*PI*V);
	float Y  = sqrt(-2.f*log(U)) * sin(2.f*PI*V);
	
	return osg::Vec2( X*v+m.x(), Y*v+m.x());
}

osg::Vec3 osgCloudyDay::CloudScene::CalculatePosition(int id)
{
	osg::Vec3 m_middlepoint = CloudScene::m_CloudLayerState->getMiddlePoint(id);
	osg::Vec3 m_size = CloudScene::m_CloudLayerState->getSize(id);
	int numClots = CloudScene::m_CloudLayerState->getClot(id);
	float variance = CloudScene::m_CloudLayerState->getVariance(id);

	osg::Vec3 jitter_sizes(200.f, 200.f, 200.f);
	osg::Vec3 jitter = osg::Vec3((frand()-0.5f)*jitter_sizes.x(), (frand()-0.5f)*jitter_sizes.y(), (frand()-0.5f)*jitter_sizes.z());

	int iteration_helper = m_numOfClouds.x();
	float iteration_helperf = m_numOfClouds.y();
	
	unsigned int cloudnum = numClouds%(numClots);
	int nc = std::floor(sqrt((float)numClots)+0.4999f);

	float hx = (float)(cloudnum)/(float)(numClots);
	float hy = (float)(cloudnum%nc)/(float)(nc);

	osg::Vec3 p = osg::Vec3(m_size.x() * hx, 
							m_size.y() * hy, 
							m_size.z() )
				 -osg::Vec3(m_size.x()/2.f, m_size.y()/2.f, m_size.z()/2.f); 

	osg::Vec2 var = GetGaussianDistributedRandomNumber(osg::Vec2(0.f, 0.f), variance*sqrt(powf(m_size.x(), 2.f) + powf(m_size.y(), 2.f) ) );

	osg::Vec3 randVer = m_middlepoint+p+osg::Vec3(var.x(), var.y(), 0.f);
	
	numClouds++;
	return randVer;
}

unsigned int osgCloudyDay::CloudScene::GetNumberOfParticles()
{
	//std::cout << "Num Indices: " << m_num_indices << std::endl;
	return m_num_indices;	//-4, da ich 4 Vertices noch hinzugeben muss fr das Quad frs Blurren
}

int osgCloudyDay::CloudScene::GetNumberOfClouds()
{
	return m_start_indices->size()-1;	//-4, da ich 4 Vertices noch hinzugeben muss fr das Quad frs Blurren
}

osg::ref_ptr<osg::Geometry> osgCloudyDay::CloudScene::InsertCloud(WangCloud* cloud, int layerID)
{	

	GetStates()->setNumClouds(layerID, GetStates()->getNumClouds(layerID)+1);

	unsigned int id = 0;
	for(unsigned int i = 0; i < m_layerToCloudLayerID.size(); i++)	
		if(layerID == m_layerToCloudLayerID[i])
			id = i;
		
	cloud->GetBoundingBox();
		
	osg::ref_ptr<osg::Vec3Array> vertices =		cloud->GetVertices();
	osg::ref_ptr<osg::Vec4Array> rotations =	cloud->GetRotation();
	osg::ref_ptr<osg::Vec4Array> centers =		cloud->GetCenter();
	osg::ref_ptr<osg::Vec4Array> ids =			cloud->GetIds();
	osg::ref_ptr<osg::Vec4Array> box_centers =	cloud->GetBoxCenters();
	osg::ref_ptr<osg::Vec4Array> color		=	cloud->GetColor();
		
	unsigned int count = vertices->size();
	unsigned int start_index = m_startLayerIndex->at(id);

	unsigned int first_index = 0;
	for(unsigned int i = 0; i < m_start_indices->size(); i++)			
	{
		if(m_start_indices->at(i) == start_index)
			first_index = i;	
		if(m_start_indices->at(i) >= (int)(start_index))
			m_start_indices->at(i) += count;			
	}
	
	m_start_indices->insert(m_start_indices->begin()+first_index, start_index);	
	m_numPrimitiveArrays->insert(m_numPrimitiveArrays->begin()+first_index, 0);
	
	for(unsigned int j = id+1; j < m_startLayerIndex->size(); j++)		
		m_startLayerIndex->at(j) += vertices->size();	

	osg::Vec3 m = osg::Vec3();
	for(unsigned int i = 0; i < count; i++)
	{
		m += vertices->at(i);
		m_bb_min->insert(		m_bb_min->begin()+start_index,		cloud->BoundingBoxMin());
		m_bb_max->insert(		m_bb_max->begin()+start_index,		cloud->BoundingBoxMax());		
	}	

	m_vertices->insert(		m_vertices->begin()+start_index,	vertices->begin(), vertices->end()); 
	m_rotation->insert(		m_rotation->begin()+start_index,	rotations->begin(), rotations->end()); 
	m_center->insert(		m_center->begin()+start_index,		centers->begin(), centers->end());
	m_ids->insert(			m_ids->begin()+start_index,			ids->begin(), ids->end());
	m_box_centers->insert(	m_box_centers->begin()+start_index,	box_centers->begin(), box_centers->end());		
	m_color->insert(		m_color->begin()+start_index,		color->begin(), color->end());		

	m_cloudcenter->insert(m_cloudcenter->begin()+first_index, m/(float)(count));	

	for(int i = 0; i < cloudstartindex.size(); i++)
	{
		if(start_index <= cloudstartindex[i])
		{
			//cloudstartindex[i] += vertices->size();	
			//cloudendindex[i] += vertices->size();
		}
	}
	
	m_clouds.push_back(cloud);	
	cloudstartindex.push_back(start_index);
	cloudendindex.push_back(start_index + vertices->size());	
	m_cloudcenter->push_back(m/(float)(count));	

	std::cerr << "###start: " << start_index << " SIZE: " << vertices->size() << std::endl;

#ifdef CREATE_BOUNDINGBOX	
	//return 0;
	return CreateBBForCloud(first_index);
#else
	return 0;
#endif
}

void osgCloudyDay::CloudScene::AddCloud(WangCloud* cloud, int layerID)
{			
	GetStates()->setNumClouds(layerID, GetStates()->getNumClouds(layerID)+1);
	cloud->GetBoundingBox();

	osg::ref_ptr<osg::Vec3Array> ambientlight_h = new osg::Vec3Array();
	ambientlight_h->push_back(osg::Vec3(0.2, 0.2, 0.2));
	ambientlight_h->push_back(osg::Vec3(0.8, 0.8, 0.8));

	osg::ref_ptr<osg::Vec3Array> ambientlight_t = new osg::Vec3Array();
	ambientlight_t->push_back(osg::Vec3(0.1, 0.1, 0.1));
	ambientlight_t->push_back(osg::Vec3(0.8, 0.8, 0.8));

	osg::ref_ptr<osg::Vec3Array> diffuselight = new osg::Vec3Array();
	diffuselight->push_back(osg::Vec3(0.1, 0.1, 0.1));
	diffuselight->push_back(osg::Vec3(0.5, 0.5, 0.5));
	diffuselight->push_back(osg::Vec3(1.0, 1.0, 1.0));

	m_ambientlight_h = ambientlight_h;
	m_ambientlight_t = ambientlight_t;
	m_diffuselight = diffuselight;
		
	osg::ref_ptr<osg::Vec3Array> vertices =		cloud->GetVertices();
	osg::ref_ptr<osg::Vec4Array> rotations =	cloud->GetRotation();
	osg::ref_ptr<osg::Vec4Array> centers =		cloud->GetCenter();
	osg::ref_ptr<osg::Vec4Array> ids =			cloud->GetIds();
	osg::ref_ptr<osg::Vec4Array> box_centers =	cloud->GetBoxCenters();
	osg::ref_ptr<osg::Vec4Array> color		 =	cloud->GetColor();	

	//std::cout << "ADD: " << m_vertices->size() << std::endl;
	m_start_indices->push_back(m_vertices->size());	
	m_numPrimitiveArrays->push_back(0);

	osg::Vec3 m = osg::Vec3();
	unsigned int start_index = m_vertices->size();
	unsigned int count = vertices->size();
	for(unsigned int i = 0; i < count; i++)
	{
		m += vertices->at(i);
		m_bb_min->insert(		m_bb_min->begin()+start_index,		cloud->BoundingBoxMin());
		m_bb_max->insert(		m_bb_max->begin()+start_index,		cloud->BoundingBoxMax());		
	}	

	m_vertices->insert(		m_vertices->begin()+start_index,	vertices->begin(), vertices->end()); 
	m_rotation->insert(		m_rotation->begin()+start_index,	rotations->begin(), rotations->end()); 
	m_center->insert(		m_center->begin()+start_index,		centers->begin(), centers->end());
	m_ids->insert(			m_ids->begin()+start_index,			ids->begin(), ids->end());
	m_box_centers->insert(	m_box_centers->begin()+start_index,	box_centers->begin(), box_centers->end());	
	m_color->insert(		m_color->begin()+start_index,		color->begin(),			color->end());	

	m_clouds.push_back(cloud);	
	
	for(int i = 0; i < cloudstartindex.size(); i++)
	{
		if(start_index <= cloudstartindex[i])
		{
			cloudstartindex[i] += vertices->size();	
			cloudendindex[i] += vertices->size();
		}
	}
	std::cerr << "!!!start: " << start_index << " SIZE: " << vertices->size() << std::endl;
	cloudstartindex.push_back(start_index);
	cloudendindex.push_back(start_index + vertices->size());	
	m_cloudcenter->push_back(m/(float)(count));	


}

void osgCloudyDay::CloudScene::UpdateCloud(WangCloud* cloud, int at)
{
	int start1 = m_start_indices->at(at);
	int end1 = 0;
	if((at+1) < (int)(m_start_indices->size()))	end1 = m_start_indices->at(at+1);
	else										end1 = m_vertices->size();


	for(int i = 0; i < cloudstartindex.size(); i++)
	{
		if(start1 <= cloudstartindex[i] && cloudendindex[i] <= end1)		
		{
			cloudstartindex.erase(cloudstartindex.begin()+i);
			cloudendindex.erase(cloudendindex.begin()+i);			
		}
	}

	int oldsize = m_vertices->size();
	m_vertices->erase(		m_vertices->begin()+start1,		m_vertices->begin()+end1	); 
	m_rotation->erase(		m_rotation->begin()+start1,		m_rotation->begin()+end1	); 
	m_center->erase(		m_center->begin()+start1,		m_center->begin()+end1		);
	m_ids->erase(			m_ids->begin()+start1,			m_ids->begin()+end1			);
	m_box_centers->erase(	m_box_centers->begin()+start1,	m_box_centers->begin()+end1	);	
	m_color->erase(			m_color->begin()+start1,		m_color->begin()+end1	);	

	oldsize = oldsize - m_vertices->size();

	//delete m_clouds[at]; //Ich glaube, dass darf icht nicht tun
	m_clouds[at] = cloud;

	GetStates()->setNumClouds(at, GetStates()->getNumClouds(at)+1);
	cloud->GetBoundingBox();
		
	osg::ref_ptr<osg::Vec3Array> vertices =		cloud->GetVertices();
	osg::ref_ptr<osg::Vec4Array> rotations =	cloud->GetRotation();
	osg::ref_ptr<osg::Vec4Array> centers =		cloud->GetCenter();
	osg::ref_ptr<osg::Vec4Array> ids =			cloud->GetIds();
	osg::ref_ptr<osg::Vec4Array> box_centers =	cloud->GetBoxCenters();
	osg::ref_ptr<osg::Vec4Array> color =		cloud->GetColor();
			
	for(unsigned int i = at+1; i < m_start_indices->size(); i++)
		m_start_indices->at(i) += vertices->size()-(end1-start1);	

	m_numPrimitiveArrays->at(at) = 0;

	osg::Vec3 m = osg::Vec3();
	unsigned int start_index = m_vertices->size();
	unsigned int count = vertices->size();
	for(unsigned int i = 0; i < count; i++)
	{
		m += vertices->at(i);
		//m_bb_min->at(at) = (		m_bb_min->begin()+start_index,		cloud->BoundingBoxMin());
		//m_bb_max->at(at) = (		m_bb_max->begin()+start_index,		cloud->BoundingBoxMax());		
	}

	m_vertices->insert(		m_vertices->begin()+start_index,	vertices->begin(),		vertices->end()); 
	m_rotation->insert(		m_rotation->begin()+start_index,	rotations->begin(),		rotations->end()); 
	m_center->insert(		m_center->begin()+start_index,		centers->begin(),		centers->end());
	m_ids->insert(			m_ids->begin()+start_index,			ids->begin(),			ids->end());
	m_box_centers->insert(	m_box_centers->begin()+start_index,	box_centers->begin(),	box_centers->end());	
	m_color->insert(		m_color->begin()+start_index,		color->begin(),			color->end());	

	for(int i = 0; i < cloudstartindex.size(); i++)
	{
		if(start_index <= cloudstartindex[i])		
			cloudstartindex[i] += vertices->size()-oldsize;
		if(start_index < cloudendindex[i])		
			cloudendindex[i] += vertices->size()-oldsize;		
	}

	m_cloudcenter->at(at) = (m/(float)(count));	
}

void osgCloudyDay::CloudScene::Create()
{	
	m_start_indices->push_back(m_vertices->size());			
	Setup();
}

void osgCloudyDay::CloudScene::RemoveScreenBillBoard()
{
#ifdef SHADOW_MAPPING
	geometry->removePrimitiveSet(geometry->getNumPrimitiveSets()-1, 1);

	//m_start_indices->erase(m_start_indices->begin()+m_start_indices->size()-1);

	for(int i = 0; i < 4; i++)
	{
		m_vertices->erase(m_vertices->begin()+m_vertices->size()-1);
		m_bb_min->erase(m_bb_min->begin()+m_bb_min->size()-1);
		m_bb_max->erase(m_bb_max->begin()+m_bb_max->size()-1);
		m_rotation->erase(m_rotation->begin()+m_rotation->size()-1);
		m_center->erase(m_center->begin()+m_center->size()-1);
		m_color->erase(m_color->begin()+m_color->size()-1);
		m_ids->erase(m_ids->begin()+m_ids->size()-1);
	}
#endif
}
void osgCloudyDay::CloudScene::InsertScreenBillBoard()
{
	//m_start_indices->push_back(m_vertices->size());

	////////////////////////////////////////////////			
	osg::Vec3 width, depth, topleft;
	topleft = osg::Vec3(0.0, 0.0, 0.0 );
	width = osg::Vec3( 1.0, 0.0, 0.0 );
	depth = osg::Vec3( 0.0, 1.0, 0.0 );

	m_vertices->push_back(topleft);
	m_vertices->push_back(topleft+depth);
	m_vertices->push_back(topleft+width+depth);
	m_vertices->push_back(topleft+width);
	
	for(int i = 0; i < 4; i++)
	{
		m_bb_min->push_back(osg::Vec3(0.0f, 0.0f, 0.0));
		m_bb_max->push_back(osg::Vec3(0.0f, 0.0f, 0.0));
		m_rotation->push_back( osg::Vec4(0.0f, 0.0f, 0.0, 0.0 ));
		m_center->push_back( osg::Vec4(0.0f, 0.0f, 0.0, 0.0 ));
		m_ids->push_back( osg::Vec4(0.0f, 0.0f, 0.0, 0.0 ));	
		m_color->push_back( osg::Vec4(0.0f, 0.0f, 0.0, 0.0 ));	
	}

	m_num_indices = m_vertices->size()-4;	
////////////////////////////////////////////////
}

unsigned int osgCloudyDay::CloudScene::GetLayer(int index)
{
	unsigned int layer = 0;
	bool setted = false;

	for(int l = 0; l < (int)(m_startLayerIndex->size())-1; l++)
	{					
		if(m_startLayerIndex->at(l)   <= index &&  m_startLayerIndex->at(l+1) >= index)
		{
			layer = m_layerToCloudLayerID.at(l);					
			setted = true;
		}
	}
	
	if(!setted && (int)(m_startLayerIndex->size()) > 0)			
		layer = m_layerToCloudLayerID.at((int)(m_startLayerIndex->size())-1);
	else return 0;

	
	return	layer;
}
void osgCloudyDay::CloudScene::AddDrawElementsPoint(std::vector<unsigned int> index, unsigned int start, unsigned int count, int k)
{
	geometry->addPrimitiveSet(
				new osg::DrawElementsUInt(osg::PrimitiveSet::POINTS,
					count,
				&index[0]+start));
	geometry->getPrimitiveSet(geometry->getNumPrimitiveSets()-1)->getDrawElements()->setDataVariance(osg::Object::DYNAMIC);
	m_numPrimitiveArrays->at(k)++;
}

void osgCloudyDay::CloudScene::Setup()
{	
	if(m_vertices->size() == 0) return;

#ifdef SHADOW_MAPPING
	InsertScreenBillBoard();
#endif	

	std::vector<unsigned int> index;		
	for(unsigned int i = 0; i < m_vertices->size(); i++)	
		index.push_back(i);

	unsigned int helper = 0;
	unsigned int num_draws = 100;	//min = 1

	geometry->removePrimitiveSet(0, geometry->getNumPrimitiveSets());	
	geometry->DeletePrimitives();	
	
	//for(unsigned int k = 0; k < m_numPrimitiveArrays->size()/* && (k+1) < m_start_indices->size()*/; k++)
	{				
		unsigned int num_indices = index.size()-4;//m_start_indices->at(k+1) - m_start_indices->at(k);	
		unsigned int num_points_per_draw = (unsigned int)((float)(num_indices)/(float)(num_draws));	

		int rest = num_indices% num_draws;		

		if(num_points_per_draw > 0)
		{		
			int helperiterator=0;
			int helper2 = 0;

			for(unsigned int n = 0; n < (num_draws); n++)
			{	
				int num_points_per_draw_CPY = num_points_per_draw;
				if(helperiterator < rest )
					num_points_per_draw_CPY++;
				
				unsigned int layer = GetLayer(0+(n*num_points_per_draw_CPY));//GetLayer(m_start_indices->at(k)+(n*num_points_per_draw_CPY));				
				geometry->AddPrimitive(layer);

				AddDrawElementsPoint(index, (0+(n*num_points_per_draw)), num_points_per_draw_CPY, 0);//AddDrawElementsPoint(index, (m_start_indices->at(k)+(n*num_points_per_draw)), num_points_per_draw_CPY, k);
				helper2 += num_points_per_draw_CPY;
				helper+=num_points_per_draw_CPY;
				helperiterator++;
			}
			
			if(num_indices-helper2 > 0)
			{
				unsigned int layer = GetLayer(0+helper2); //GetLayer(m_start_indices->at(k)+helper2);
				geometry->AddPrimitive(layer);

				AddDrawElementsPoint(index, 0+helper2, num_indices-helper2, 0);				//AddDrawElementsPoint(index, m_start_indices->at(k)+helper2, num_indices-helper2, k);				
				helper+=(num_indices-helper2);			
			}
		}
		else
		{
			unsigned int layer = GetLayer(m_start_indices->at(0)); //GetLayer(m_start_indices->at(k));
			geometry->AddPrimitive(layer);

			AddDrawElementsPoint(index, 0, num_indices, 0);						//AddDrawElementsPoint(index, m_start_indices->at(k), num_indices, k);						
			helper+=(num_indices);
		}	

		/*
		unsigned int num_indices = m_start_indices->at(k+1) - m_start_indices->at(k);	
		unsigned int num_points_per_draw = (unsigned int)((float)(num_indices)/(float)(num_draws));		

		if(num_points_per_draw > 0)
		{		
			int helper2 = 0;
			for(unsigned int n = 0; n < (num_draws); n++)
			{	
				unsigned int layer = GetLayer(m_start_indices->at(k)+(n*num_points_per_draw));
				geometry->AddPrimitive(layer);

				AddDrawElementsPoint(index, (m_start_indices->at(k)+(n*num_points_per_draw)), num_points_per_draw, k);
				helper2 += num_points_per_draw;
				helper+=num_points_per_draw;
			}
				
			if(num_indices-helper2 > 0)
			{
				unsigned int layer = GetLayer(m_start_indices->at(k)+helper2);
				geometry->AddPrimitive(layer);

				AddDrawElementsPoint(index, m_start_indices->at(k)+helper2, num_indices-helper2, k);				
				helper+=(num_indices-helper2);
			}
		}
		else
		{
			unsigned int layer = GetLayer(m_start_indices->at(k));
			geometry->AddPrimitive(layer);

			AddDrawElementsPoint(index, m_start_indices->at(k), num_indices, k);						
			helper+=(num_indices);
		}		*/
	}	

////////////////////////////////////////////////	
#ifdef SHADOW_MAPPING
	geometry->addPrimitiveSet(
		new osg::DrawElementsUInt(osg::PrimitiveSet::QUADS,
				4,
				&index[0]+m_num_indices)
			);		
	geometry->getPrimitiveSet(geometry->getNumPrimitiveSets()-1)->getDrawElements()->setDataVariance(osg::Object::DYNAMIC);		
#endif

////////////////////////////////////////////////
	if(!setup_attribute)
	{	
		geometry->setVertexAttribArray(0, m_vertices.get());
		geometry->setVertexAttribArray(1, m_rotation.get());
		geometry->setVertexAttribArray(2, m_center.get());
		geometry->setVertexAttribArray(3, m_ids.get());
		geometry->setVertexAttribArray(4, m_bb_min.get());
		geometry->setVertexAttribArray(5, m_bb_max.get());
		geometry->setVertexAttribArray(6, m_color.get());

		geometry->setVertexAttribBinding(0, osg::Geometry::BIND_PER_VERTEX);
		geometry->setVertexAttribBinding(1, osg::Geometry::BIND_PER_VERTEX);
		geometry->setVertexAttribBinding(2, osg::Geometry::BIND_PER_VERTEX);
		geometry->setVertexAttribBinding(3, osg::Geometry::BIND_PER_VERTEX);
		geometry->setVertexAttribBinding(4, osg::Geometry::BIND_PER_VERTEX);
		geometry->setVertexAttribBinding(5, osg::Geometry::BIND_PER_VERTEX);
		geometry->setVertexAttribBinding(6, osg::Geometry::BIND_PER_VERTEX);

		geometry->setUseDisplayList(false);
		geometry->setUseVertexBufferObjects(true);
		
		quadBillBoard->addDrawable(geometry.get());
		nodess4 = (quadBillBoard->getOrCreateStateSet());

		quadBillBoard->setCullingActive(false); //wars ned		
		
		cloud_layer_update = new CloudLayerUpdate();
		quadBillBoard->addCullCallback(cloud_layer_update);
		quadBillBoard->setUserData(this);		
		
		CloudScene::ambientLight_h0 = m_ambientlight_h->at(0);
		CloudScene::ambientLight_h1 = m_ambientlight_h->at(1);
		CloudScene::ambientLight_t0 = m_ambientlight_t->at(0);
		CloudScene::ambientLight_t1 = m_ambientlight_t->at(1);		
		CloudScene::directionalColors = osg::Matrix3(m_diffuselight->at(0).x(), m_diffuselight->at(0).y(), m_diffuselight->at(0).z(), 
														 m_diffuselight->at(1).x(), m_diffuselight->at(1).y(), m_diffuselight->at(1).z(),
														 m_diffuselight->at(2).x(), m_diffuselight->at(2).y(), m_diffuselight->at(2).z());
	
		
		quadBillBoard->getDrawable(0)->setDataVariance(osg::Object::DYNAMIC);		
		SetupAttributes(nodess4);
	}
	else
	{				
		quadBillBoard->getDrawable(0)->asGeometry()->setVertexAttribArray(0, m_vertices.get());
		quadBillBoard->getDrawable(0)->asGeometry()->setVertexAttribArray(1, m_rotation.get());
		quadBillBoard->getDrawable(0)->asGeometry()->setVertexAttribArray(2, m_center.get());
		quadBillBoard->getDrawable(0)->asGeometry()->setVertexAttribArray(3, m_ids.get());
		quadBillBoard->getDrawable(0)->asGeometry()->setVertexAttribArray(4, m_bb_min.get());
		quadBillBoard->getDrawable(0)->asGeometry()->setVertexAttribArray(5, m_bb_max.get());	
		quadBillBoard->getDrawable(0)->asGeometry()->setVertexAttribArray(6, m_color.get());	

		quadBillBoard->getDrawable(0)->asGeometry()->setVertexAttribBinding(0, osg::Geometry::BIND_PER_VERTEX);
		quadBillBoard->getDrawable(0)->asGeometry()->setVertexAttribBinding(1, osg::Geometry::BIND_PER_VERTEX);
		quadBillBoard->getDrawable(0)->asGeometry()->setVertexAttribBinding(2, osg::Geometry::BIND_PER_VERTEX);
		quadBillBoard->getDrawable(0)->asGeometry()->setVertexAttribBinding(3, osg::Geometry::BIND_PER_VERTEX);
		quadBillBoard->getDrawable(0)->asGeometry()->setVertexAttribBinding(4, osg::Geometry::BIND_PER_VERTEX);
		quadBillBoard->getDrawable(0)->asGeometry()->setVertexAttribBinding(5, osg::Geometry::BIND_PER_VERTEX);
		quadBillBoard->getDrawable(0)->asGeometry()->setVertexAttribBinding(6, osg::Geometry::BIND_PER_VERTEX);

		for(unsigned int  i = 0; i < quadBillBoard->getDrawable(0)->asGeometry()->getNumVertexAttribArrays(); i++)
			quadBillBoard->getDrawable(0)->asGeometry()->getVertexAttribArray(i)->dirty();
		for(unsigned int  i = 0; i < quadBillBoard->getDrawable(0)->asGeometry()->getNumPrimitiveSets(); i++)
			quadBillBoard->getDrawable(0)->asGeometry()->getPrimitiveSet(i)->dirty();

		quadBillBoard->getDrawable(0)->asGeometry()->dirtyBound();
		quadBillBoard->getDrawable(0)->dirtyBound();		
	}
	setup_attribute = true;
	
#ifdef SHADOW_MAPPING
	geometry->m_numPrimitiveArrays = m_numPrimitiveArrays;
#endif
}

void osgCloudyDay::CloudScene::SetupAttributes(osg::ref_ptr<osg::StateSet> nodess4)
{
	nodess4->setAttribute(cloudProg.get());			


	projectuniform = new osg::Uniform("project", osg::Matrixd());
	projectuniform->setUpdateCallback(new project_light());
	nodess4->addUniform(projectuniform);

	modelViewMatrixuniform = new osg::Uniform("modelViewMatrix", osg::Matrixd());
	modelViewMatrixuniform->setUpdateCallback(new modelViewMatrix_light());
	nodess4->addUniform(modelViewMatrixuniform);

	viewMatrixuniform = new osg::Uniform("viewMatrix", osg::Matrixd());
	viewMatrixuniform->setUpdateCallback(new viewMatrix_light());
	nodess4->addUniform(viewMatrixuniform);

	viewMatrixInvuniform = new osg::Uniform("viewMatrixInv", osg::Matrixd());
	viewMatrixInvuniform->setUpdateCallback(new viewMatrixInv_light());
	nodess4->addUniform(viewMatrixInvuniform);



	project_lightuniform = new osg::Uniform("project_light", osg::Matrixd());
	project_lightuniform->setUpdateCallback(new project_light());
	nodess4->addUniform(project_lightuniform);

	modelViewMatrix_lightuniform = new osg::Uniform("modelViewMatrix_light", osg::Matrixd());
	modelViewMatrix_lightuniform->setUpdateCallback(new modelViewMatrix_light());
	nodess4->addUniform(modelViewMatrix_lightuniform);

	viewMatrix_lightuniform = new osg::Uniform("viewMatrix_light", osg::Matrixd());
	viewMatrix_lightuniform->setUpdateCallback(new viewMatrix_light());
	nodess4->addUniform(viewMatrix_lightuniform);

	viewMatrixInv_lightuniform = new osg::Uniform("viewMatrixInv_light", osg::Matrixd());
	viewMatrixInv_lightuniform->setUpdateCallback(new viewMatrixInv_light());
	nodess4->addUniform(viewMatrixInv_lightuniform);

	//nodess4->addUniform(new osg::Uniform("project", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("inv_project_light", osg::Matrixd()));

	/*nodess4->addUniform(new osg::Uniform("halfAngleDirVector", osg::Vec3()));
	nodess4->addUniform(new osg::Uniform("halfAngleRightVector", osg::Vec3()));
	nodess4->addUniform(new osg::Uniform("halfAngleUpVector", osg::Vec3()));	
	nodess4->addUniform(new osg::Uniform("viewHalfAngleMatrix", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("invViewHalfAngleMatrix", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("viewHalfAngleLightMatrix", osg::Matrixd()));
	nodess4->addUniform(new osg::Uniform("invViewHalfAngleLightMatrix", osg::Matrixd()));
	*/
	nodess4->addUniform(new osg::Uniform("color_tex", 0));
	nodess4->addUniform(new osg::Uniform("shadow_tex", 1));

	nodess4->addUniform(new osg::Uniform("un_light_pos", Scene::m_skydome->GetLightPosition()));
	nodess4->addUniform(new osg::Uniform("un_timeOfDay", timeOfDay));
	nodess4->addUniform(new osg::Uniform("un_fading", fading));
	nodess4->addUniform(new osg::Uniform("un_dens", dens));
	nodess4->addUniform(new osg::Uniform("un_skyLight_h0", ambientLight_h0));
	nodess4->addUniform(new osg::Uniform("un_skyLight_h1", ambientLight_h1));
	nodess4->addUniform(new osg::Uniform("un_skyLight_t0", ambientLight_t0));
	nodess4->addUniform(new osg::Uniform("un_skyLight_t1", ambientLight_t1));		
	nodess4->addUniform(new osg::Uniform("un_dir_colors", directionalColors));	

	if(m_fog)	nodess4->addUniform(new osg::Uniform("fogdensity",  m_fog->GetFogDensity() ));	
	else		nodess4->addUniform(new osg::Uniform("fogdensity",  0.f));	



	if(osgCloudyDay::SkydomeHimmel::m_irradiance	!= 0)	
	{
		nodess4->addUniform(new osg::Uniform("inscatterSampler",		3 ));	
		nodess4->setTextureAttributeAndModes(3, osgCloudyDay::SkydomeHimmel::m_irradiance ,osg::StateAttribute::ON);	
	}
	if(osgCloudyDay::SkydomeHimmel::m_inscatter		!= 0)
	{
		nodess4->addUniform(new osg::Uniform("skyIrradianceSampler",	4 ));		
		nodess4->setTextureAttributeAndModes(4, osgCloudyDay::SkydomeHimmel::m_inscatter ,osg::StateAttribute::ON);	
	}
	if(osgCloudyDay::SkydomeHimmel::m_transmittance != 0)	
	{
		nodess4->addUniform(new osg::Uniform("transmittanceSampler",	5 ));	
		nodess4->setTextureAttributeAndModes(5, osgCloudyDay::SkydomeHimmel::m_transmittance ,osg::StateAttribute::ON);	
	}
	if(osgCloudyDay::SkydomeHimmel::m_glare	!= 0)			
	{
		nodess4->addUniform(new osg::Uniform("glareSampler",	6 ));	
		nodess4->setTextureAttributeAndModes(6, osgCloudyDay::SkydomeHimmel::m_glare ,osg::StateAttribute::ON);	
	}
	
	
	nodess4->addUniform(new osg::Uniform("backtofront", (int)(CloudScene::m_backtofront))); 
	
	Scene::m_skydome->SetupUniform(nodess4);

	/*
	nodess4->setMode(GL_BLEND, osg::StateAttribute::ON);
	nodess4->setAttributeAndModes(new osg::BlendFunc);
	nodess4->setRenderingHint(osg::StateSet::TRANSPARENT_BIN); 
	nodess4->setRenderBinDetails(100, "BackToFront");*/

	nodess4->setTextureAttributeAndModes(0, tex_clouds,osg::StateAttribute::ON);
	nodess4->setTextureAttributeAndModes(1, CloudScene::fbo_light_texture ,osg::StateAttribute::ON);	


	geometry->projectuniform = projectuniform;
	geometry->modelViewMatrixuniform = modelViewMatrixuniform;
	geometry->viewMatrixuniform = viewMatrixuniform;
	geometry->viewMatrixInvuniform = viewMatrixInvuniform;

	geometry->project_lightuniform = project_lightuniform;
	geometry->modelViewMatrix_lightuniform = modelViewMatrix_lightuniform;
	geometry->viewMatrix_lightuniform = viewMatrix_lightuniform;
	geometry->viewMatrixInv_lightuniform = viewMatrixInv_lightuniform;
}
void osgCloudyDay::CloudScene::UpdateUniform(int type)
{
	switch(type)
	{
	case WCU_LightPos : 
		nodess4->getUniform(m_uniforms[type])->set(Scene::m_skydome->GetLightPosition());
		break;
	case WCU_TimeOfDay : 
			nodess4->getUniform(m_uniforms[type])->set(timeOfDay);
		break;
	case WCU_Fading : 
			nodess4->getUniform(m_uniforms[type])->set(fading);
		break;
	case WCU_Density : 
			nodess4->getUniform(m_uniforms[type])->set(dens);
		break;
	case WCU_AmbientLight_H0 : 
			nodess4->getUniform(m_uniforms[type])->set(ambientLight_h0);
		break;
	case WCU_AmbientLight_H1 : 
			nodess4->getUniform(m_uniforms[type])->set(ambientLight_h1);
		break;
	case WCU_AmbientLight_T0 : 
			nodess4->getUniform(m_uniforms[type])->set(ambientLight_t0);
		break;
	case WCU_AmbientLight_T1 : 
			nodess4->getUniform(m_uniforms[type])->set(ambientLight_t1);
		break;
	case WCU_DirectionalColor : 
			nodess4->getUniform(m_uniforms[type])->set(directionalColors);
		break;
	case WCU_SunLightColor : 
			nodess4->getUniform(m_uniforms[type])->set(sunLightColor);
		break;
	default:
		break;
	}	
}
void osgCloudyDay::CloudScene::LoadingTexture()
{
	osg::ref_ptr<osg::Image> img_clouds (osgDB::readImageFile("../data/textures/cloud3d/clouds.bmp"));

	//Bind the image to a 2D texture object
	tex_clouds = (new osg::Texture2D);
	tex_clouds->setImage(img_clouds.get());
	tex_clouds->setFilter(osg::Texture::MIN_FILTER, osg::Texture::NEAREST_MIPMAP_NEAREST);
	tex_clouds->setFilter(osg::Texture::MAG_FILTER, osg::Texture::NEAREST_MIPMAP_NEAREST);
	//tex_clouds->setInternalFormat(GL_RED);
}
void osgCloudyDay::CloudScene::LoadingShader()
{
	cloudShadowMapProg=(new osg::Program);
	osg::ref_ptr<osg::Shader> cloudShadowMapVertexShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/shadowCloud.vert"));	
	osg::ref_ptr<osg::Shader> cloudShadowMapFragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/shadowCloud.frag"));
	
	//Binding the box shaders to its program
	cloudShadowMapProg->addShader(cloudShadowMapVertexShader.get());
	cloudShadowMapProg->addShader(cloudShadowMapFragShader.get());
	cloudShadowMapProg->addBindFragDataLocation("out_color", 0);


	cloudProg =(new osg::Program);
#ifdef SHADOW_MAPPING
	osgCloudyDay::SkydomeMie* skymie = dynamic_cast<osgCloudyDay::SkydomeMie*>(Scene::m_skydome);
	if(skymie != 0)
	{
		osg::ref_ptr<osg::Shader> cloudvertexShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/cloud_mie.vert"));
		osg::ref_ptr<osg::Shader> cloudgeometryShader(osg::Shader::readShaderFile (osg::Shader::GEOMETRY, "shaders/cloud_mie.geom"));
		osg::ref_ptr<osg::Shader> cloudfragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/cloud_mie.frag"));
		cloudProg->addShader(cloudvertexShader.get());
		cloudProg->addShader(cloudgeometryShader.get());
		cloudProg->addShader(cloudfragShader.get());
	}
	else
	{
		osg::ref_ptr<osg::Shader> cloudvertexShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/cloud.vert"));
		osg::ref_ptr<osg::Shader> cloudgeometryShader(osg::Shader::readShaderFile (osg::Shader::GEOMETRY, "shaders/cloud.geom"));
		osg::ref_ptr<osg::Shader> cloudfragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/cloud.frag"));
		cloudProg->addShader(cloudvertexShader.get());
		cloudProg->addShader(cloudgeometryShader.get());
		cloudProg->addShader(cloudfragShader.get());
	}
#else
	osg::ref_ptr<osg::Shader> cloudvertexShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/cloud_WO_SHAD.vert"));
	osg::ref_ptr<osg::Shader> cloudgeometryShader(osg::Shader::readShaderFile (osg::Shader::GEOMETRY, "shaders/cloud_WO_SHAD.geom"));
	osg::ref_ptr<osg::Shader> cloudfragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/cloud_WO_SHAD.frag"));	
#endif
	
	//Binding the box shaders to its program
	

	cloudProg->addBindFragDataLocation("out_color", 0);
	cloudProg->addBindFragDataLocation("out_color2", 1);	

#ifdef SHADOW_MAPPING
	cloudShadowProg =(new osg::Program);
	osg::ref_ptr<osg::Shader> cloudShadowVertexShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/cloudLight.vert"));
	osg::ref_ptr<osg::Shader> cloudShadowGeometryShader(osg::Shader::readShaderFile (osg::Shader::GEOMETRY, "shaders/cloudLight.geom"));
	osg::ref_ptr<osg::Shader> cloudShadowFragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/cloudLight.frag"));
	
	//Binding the box shaders to its program
	cloudShadowProg->addShader(cloudShadowVertexShader.get());
	cloudShadowProg->addShader(cloudShadowGeometryShader.get());
	cloudShadowProg->addShader(cloudShadowFragShader.get());

	cloudShadowProg->addBindFragDataLocation("out_color", 0);
	//cloudShadowProg->addBindFragDataLocation("out_color2", 1);
#endif

#ifdef SHADOW_MAPPING
	//Definition of Bluring Shade
	cloudBlurHoriProg =(new osg::Program);
	osg::ref_ptr<osg::Shader> cloudBlurHoriVertexShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/blur_hori.vert"));	
	osg::ref_ptr<osg::Shader> cloudBlurHoriFragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/blur_hori.frag"));
	
	//Binding the box shaders to its program
	cloudBlurHoriProg->addShader(cloudBlurHoriVertexShader.get());
	cloudBlurHoriProg->addShader(cloudBlurHoriFragShader.get());

	cloudBlurHoriProg->addBindFragDataLocation("out_color", 0);
	
	cloudBlurVertProg =(new osg::Program);
	osg::ref_ptr<osg::Shader> cloudBlurVertVertexShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/blur_vert.vert"));	
	osg::ref_ptr<osg::Shader> cloudBlurVertFragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/blur_vert.frag"));
	
	//Binding the box shaders to its program
	cloudBlurVertProg->addShader(cloudBlurVertVertexShader.get());
	cloudBlurVertProg->addShader(cloudBlurVertFragShader.get());

	cloudBlurVertProg->addBindFragDataLocation("out_color", 0);


	cloudBlurLinearHoriProg =(new osg::Program);
	osg::ref_ptr<osg::Shader> cloudBlurLinearHoriVertexShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/linear_blur_hori.vert"));	
	osg::ref_ptr<osg::Shader> cloudBlurLinearHoriFragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/linear_blur_hori.frag"));
	
	//Binding the box shaders to its program
	cloudBlurLinearHoriProg->addShader(cloudBlurLinearHoriVertexShader.get());
	cloudBlurLinearHoriProg->addShader(cloudBlurLinearHoriFragShader.get());

	cloudBlurLinearHoriProg->addBindFragDataLocation("out_color", 0);
	
	cloudBlurLinearVertProg =(new osg::Program);
	osg::ref_ptr<osg::Shader> cloudBlurLinearVertVertexShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/linear_blur_vert.vert"));	
	osg::ref_ptr<osg::Shader> cloudBlurLinearVertFragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/linear_blur_vert.frag"));
	
	//Binding the box shaders to its program
	cloudBlurLinearVertProg->addShader(cloudBlurLinearVertVertexShader.get());
	cloudBlurLinearVertProg->addShader(cloudBlurLinearVertFragShader.get());

	cloudBlurLinearVertProg->addBindFragDataLocation("out_color", 0);	
#endif
}
void osgCloudyDay::CloudScene::SetStates(CloudLayerState* state)
{
	m_CloudLayerState = (state);
}
osgCloudyDay::CloudLayerState* osgCloudyDay::CloudScene::GetStates()
{
	return m_CloudLayerState;
}
void osgCloudyDay::CloudScene::DeleteStates()
{
	delete m_CloudLayerState;
}
osg::Geometry* osgCloudyDay::CloudScene::createSphere(osg::Vec3 middlePoint, float radius, int vpr)
{
	float fvpr = (float)(vpr);

	osg::Geometry* geom = new osg::Geometry();

#if 0
	osg::Vec3Array* coords = new osg::Vec3Array((vpr-1)*vpr+2);		
	osg::UIntArray* indices = new osg::UIntArray(vpr*(vpr-2)*3*2+vpr*2*3);

	osg::Vec2 offset = osg::Vec2(0.f, 0.f);		
	osg::Vec2 scale = osg::Vec2(1.f*PI, 2.f*PI);
	float r = radius;
	float tex_scale = 1.f;
		
	unsigned int iter = 0;
	unsigned int citer = 0;
	
	coords->at(0) = middlePoint + osg::Vec3( 0.f, r, 0.f);					
	citer++;			

	for(int s = 1; s < 2; s++)
	{				
		float sf = (float)(s)/(fvpr);
		for(int t = 1; t <= vpr; t++)
		{			
			float tf = (float)(t)/(fvpr);					

			coords->at(citer) = middlePoint + osg::Vec3(	r*sinf(sf*scale.x()+offset.x())*cosf(tf*scale.y()+offset.y()), 
															r*cosf(sf*scale.x()+offset.x()),
															r*sinf(sf*scale.x()+offset.x())*sinf(tf*scale.y()+offset.y()) 
														);		

			citer++;
																					
			
			indices->at(iter) = ((t%vpr)+(vpr*(s-1))+1);	iter++;
			indices->at(iter) = (citer-1);					iter++;			
			indices->at(iter) = 0;							iter++;
		}
	}


	for(int s = 2; s < vpr; s++)
	{				
		float sf = (float)(s)/(fvpr);
		for(int t = 1; t <= vpr; t++)
		{			
			float tf = (float)(t)/(fvpr);				
				
			coords->at(citer) = middlePoint + osg::Vec3(	r*sinf(sf*scale.x()+offset.x())*cosf(tf*scale.y()+offset.y()), 
															r*cosf(sf*scale.x()+offset.x()),
															r*sinf(sf*scale.x()+offset.x())*sinf(tf*scale.y()+offset.y()) 
														);	
			citer++;											
			indices->at(iter) = ((t%vpr)+(vpr*(s-1))+1);			iter++;						
			indices->at(iter) = citer-1;							iter++;
			indices->at(iter) = citer-1-vpr;						iter++;
																		
			indices->at(iter) = ((t%vpr)+(vpr*(s-1))+1)-vpr;		iter++;
			indices->at(iter) = ((t%vpr)+(vpr*(s-1))+1);			iter++;
			indices->at(iter) = citer-1-vpr;						iter++;
			
			if(s == (vpr-1))
			{																																																		
				indices->at(iter) = ((t%vpr)+1+(vpr*(s-1)));	iter++;
				indices->at(iter) = (vpr-1)*vpr+1;				iter++;
				indices->at(iter) = (citer-1);					iter++;
			}
		}
	}
			
	coords->at((vpr-1)*vpr+1) = middlePoint + osg::Vec3( 0.f, -r, 0.f	);	
	citer++;			
#else	
	osg::UIntArray* indices = new osg::UIntArray(6*2*3);


	unsigned int iter=36;			
	unsigned int citer=8;			

		float size = radius;
		osg::Vec3Array* coords = new osg::Vec3Array(8);		
		coords->at(0) = (middlePoint+(osg::Vec3(+1.0, +1.0, +1.0)*size));	citer++;		
		coords->at(1) = (middlePoint+(osg::Vec3(-1.0, +1.0, +1.0)*size));	citer++;		
		coords->at(2) = (middlePoint+(osg::Vec3(-1.0, -1.0, +1.0)*size));	citer++;		
		coords->at(3) = (middlePoint+(osg::Vec3(+1.0, -1.0, +1.0)*size));	citer++;		
		coords->at(4) = (middlePoint+(osg::Vec3(+1.0, +1.0, -1.0)*size));	citer++;		
		coords->at(5) = (middlePoint+(osg::Vec3(-1.0, +1.0, -1.0)*size));	citer++;		
		coords->at(6) = (middlePoint+(osg::Vec3(-1.0, -1.0, -1.0)*size));	citer++;		
		coords->at(7) = (middlePoint+(osg::Vec3(+1.0, -1.0, -1.0)*size));	citer++;		
		
		
		indices->at(0) = 0; indices->at(1) = 1; indices->at(2) = 2;
		indices->at(3) = 0; indices->at(4) = 2; indices->at(5) = 3;
		indices->at(6) = 7; indices->at(7) = 6; indices->at(8) = 5;
		indices->at(9) = 7; indices->at(10) = 5; indices->at(11) = 4;
		indices->at(12) = 0; indices->at(13) = 4; indices->at(14) = 5;
		indices->at(15) = 0; indices->at(16) = 5; indices->at(17) = 1;
		indices->at(18) = 1; indices->at(19) = 5; indices->at(20) = 6;
		indices->at(21) = 1; indices->at(22) = 6; indices->at(23) = 2;
		indices->at(24) = 2; indices->at(25) = 6; indices->at(26) = 7;
		indices->at(27) = 2; indices->at(28) = 7; indices->at(29) = 3;
		indices->at(30) = 3; indices->at(31) = 7; indices->at(32) = 4;								 
		indices->at(33) = 3; indices->at(34) = 4; indices->at(35) = 0;



#endif
	geom->setVertexArray(coords);	
	geom->addPrimitiveSet( new osg::DrawElementsUInt( osg::PrimitiveSet::TRIANGLES, iter, &indices->at(0)));
	geom->setUseDisplayList(false);

	return geom;
}
osg::ref_ptr<osg::Geometry> osgCloudyDay::CloudScene::CreateBBForCloud(int cloudID)
{
	unsigned int cloud_start = m_start_indices->at(cloudID);

	int num_vertices = 8;

	osg::ref_ptr<osg::Geometry> bb = createSphere(m_vertices->at(cloud_start), 1.2f*sqrt(powf(m_rotation->at(cloud_start).y(), 2.f) + powf(m_rotation->at(cloud_start).z(), 2.f)), num_vertices);	
	
	std::vector<osg::ref_ptr<osg::Geometry>> m2;
	for(int i = cloud_start+1; i < m_start_indices->at(cloudID+1)-1; i++)
	{						
		osg::ref_ptr<osg::Geometry> new_sphere = osg::ref_ptr<osg::Geometry>(createSphere(m_vertices->at(i)*1.f, 
			sqrt(powf(m_rotation->at(i).y(), 2.f) + powf(m_rotation->at(i).z(), 2.f)), num_vertices));				
		m2.push_back(new_sphere);
	}
		
	CSGObject* csg = new CSGObject();
	bb = csg->Perform(bb, m2, CSGObject::CSG_UNION);
	m2.clear();
	
	bb->setUseDisplayList(false);
	return bb;
}

osg::ref_ptr<osg::Camera> osgCloudyDay::CloudScene::GetCloudCamera()
{
	return m_lightCloudCamera;
}

void osgCloudyDay::CloudScene::CreateCloudCamera()
{
	osg::Vec3 binm = osg::Vec3(0.f, 1.f, 0.f);
	osg::Vec3 dir = osg::Vec3(-100.0f,0,5000.0f);
	binm.normalize();
	osg::Vec3 h = binm^dir;
	h.normalize();

	osg::Matrixd light_view = osg::Matrixd::lookAt(osg::Vec3(-100.0f,0,5000.0f), osg::Vec3(0.0f, 0.0f, 0.f), h);
	osg::Matrixd light_projection = osg::Matrixd::ortho(-10000.f, 10000.f, -10000.f, 10000.f, 1.f, 20000.0f);	
	//osg::Matrix light_view = osg::Matrixd().lookAt(osg::Vec3(2.0, 0.0, 50000.0), osg::Vec3(0.f, 0.f ,0.f), osg::Vec3(0.f, 0.f, 1.f));
	//osg::Matrix light_projection = osg::Matrixd().perspective(10.0, 1.f, 8000.0, 100000.0);	
	
	osg::ref_ptr<osg::GraphicsContext::Traits> traits2 = new osg::GraphicsContext::Traits;
	traits2->x = 50;
	traits2->y = 50;
	traits2->width = osgCloudyDay::Scene::GetWidth();
	traits2->height = osgCloudyDay::Scene::GetHeight();
	traits2->windowDecoration = true;
	traits2->doubleBuffer = true;
	traits2->sharedContext = 0;

	m_lightCloudCamera = new osg::Camera;
#ifdef SHADOW_MAPPING
	m_lightCloudCamera->setViewMatrix(light_view);
	m_lightCloudCamera->setProjectionMatrix(light_projection);
	m_lightCloudCamera->setGraphicsContext(osg::GraphicsContext::createGraphicsContext(traits2.get()));
	m_lightCloudCamera->setViewport(new osg::Viewport(0,0, traits2->width, traits2->height));
	GLenum buffer = traits2->doubleBuffer ? GL_BACK : GL_FRONT;
#else
	m_lightCloudCamera->setViewMatrix(view);
	m_lightCloudCamera->setProjectionMatrix(projection);
	m_lightCloudCamera->setGraphicsContext(osg::GraphicsContext::createGraphicsContext(traits.get()));
	m_lightCloudCamera->setViewport(new osg::Viewport(0,0, traits->width, traits->height));
	buffer = traits->doubleBuffer ? GL_BACK : GL_FRONT;
	m_lightCloudCamera->attach(osg::Camera::DEPTH_BUFFER, fbo_scene_depth);
	m_lightCloudCamera->setClearMask(GL_COLOR_BUFFER_BIT);
#endif		
	m_lightCloudCamera->setDrawBuffer(buffer);
	m_lightCloudCamera->setReadBuffer(buffer);
	m_lightCloudCamera->setClearColor(osg::Vec4(0.0, 0.0, 0.0, 0.0));
	m_lightCloudCamera->setClearDepth(1.0);
	m_lightCloudCamera->setAllowEventFocus(false);
	m_lightCloudCamera->setReferenceFrame(osg::Transform::ABSOLUTE_RF);
	m_lightCloudCamera->setClearMask(GL_ACCUM_BUFFER_BIT);
	//m_lightCloudCamera->setClearMask(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	m_lightCloudCamera->setRenderOrder(osg::Camera::POST_RENDER,3);
	m_lightCloudCamera->setComputeNearFarMode( osgUtil::CullVisitor::DO_NOT_COMPUTE_NEAR_FAR );
	m_lightCloudCamera->attach(osg::Camera::COLOR_BUFFER0, fbo_cloud_texture);			
	//m_lightCloudCamera->attach(osg::Camera::COLOR_BUFFER0, Scene::fbo_goodrays);			
	m_lightCloudCamera->setRenderTargetImplementation(osg::Camera::FRAME_BUFFER_OBJECT);
	m_lightCloudCamera->setImplicitBufferAttachmentMask(osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT, osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT);
	m_lightCloudCamera->setCullingActive(false);
	m_lightCloudCamera->getOrCreateStateSet()->setMode(GL_LIGHTING, osg::StateAttribute::OFF);
	m_lightCloudCamera->setClearMask(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
}