#include "CloudLayerUpdate.h"
#include "CloudScene.h"
#include "CumulusGenerator.h"
#include "StratusGenerator.h"
#include "CelluarAutomataGenerator.h"
#include "NimbostratusGenerator.h"
#include "CumolonimbusGenerator.h"
#include "StratoCumulusGenerator.h"
#include "AltCumulusGenerator.h"
#include "AltStratusGenerator.h"
#include <iostream>
#include <algorithm>

osgCloudyDay::CloudLayerUpdate::CloudLayerUpdate(void) : iteration(0), layerid(0)
{
}


osgCloudyDay::CloudLayerUpdate::~CloudLayerUpdate(void)
{
}

bool osgCloudyDay::CloudLayerUpdate::CloudAdded()
{
	return cloud_added;
}

void osgCloudyDay::CloudLayerUpdate::UpdateShader(osg::ref_ptr<osg::Geode> geode)
{
	#ifdef SHADOW_MAPPING
	//Hack for Shader
	switch(iteration)
	{
	case 1:	geode->getOrCreateStateSet()->setAttribute(CloudScene::cloudProg);
			iteration = 1;
		break;
	case 0:	geode->getOrCreateStateSet()->setAttribute(CloudScene::cloudShadowProg);	
			iteration = 2;
		break;
	case 2:	geode->getOrCreateStateSet()->setAttribute(CloudScene::cloudShadowMapProg);	
			iteration = 1;
		break;
//	case 3:	geode->getOrCreateStateSet()->setAttribute(CloudScene::cloudBlurVertProg);	
//			iteration = 4;
		break;
	case 3:	geode->getOrCreateStateSet()->setAttribute(CloudScene::cloudBlurHoriProg);				
			iteration = 4;
			break;
	case 4:	geode->getOrCreateStateSet()->setAttribute(CloudScene::cloudBlurLinearVertProg);				
			iteration = 5;
			break;
	case 5:	geode->getOrCreateStateSet()->setAttribute(CloudScene::cloudBlurLinearHoriProg);				
			iteration = 0;
		break;
	}
#else
	geode->getOrCreateStateSet()->setAttribute(CloudScene::cloudProg);
#endif
}

void UpdateLayer(osgCloudyDay::CloudScene* m_cloud)
{	
	m_cloud->RemoveScreenBillBoard();

	for(unsigned int i = 0; i < m_cloud->m_clouds.size(); i++)
	{		
		/*if(m_cloud->m_clouds[i]->GetCloudGenerator() != 0)
		{
			osgCloudyDay::CelluarAutomataGenerator* wc = dynamic_cast<osgCloudyDay::CelluarAutomataGenerator*>(m_cloud->m_clouds[i]->GetCloudGenerator());
			if(wc != 0)				
			{
				wc->Update();					
				m_cloud->UpdateCloud(wc->m_cloud, i);
			}
		}*/

		osgCloudyDay::CloudGenerator* wc = m_cloud->m_clouds[i]->GetCloudGenerator();
		if(wc->Update())	m_cloud->UpdateCloud(wc->m_cloud, i);
	}	
		
	m_cloud->Setup();	
}




osgCloudyDay::Plane::Plane( osg::Vec3 &v1,  osg::Vec3 &v2,  osg::Vec3 &v3) {

	set3Points(v1,v2,v3);
}


osgCloudyDay::Plane::Plane() {}
osgCloudyDay::Plane::~Plane() {}


void osgCloudyDay::Plane::set3Points( osg::Vec3 &v1,  osg::Vec3 &v2,  osg::Vec3 &v3) 
{
	osg::Vec3 aux1, aux2;
	aux1 = v1 - v2;
	aux2 = v3 - v2;
	normal = aux2 ^ aux1;

	normal.normalize();
	point = v2;
	d = -(normal * point);
}

void osgCloudyDay::Plane::setNormalAndPoint(osg::Vec3 &normal, osg::Vec3 &point) {

	this->normal = normal;
	this->normal.normalize();
	d = -(this->normal * point);
}

void osgCloudyDay::Plane::setCoefficients(float a, float b, float c, float d) {

	// set the normal vector
	normal.set(a,b,c);
	
	//compute the lenght of the vector
	float l = normal.length();
	
	// normalize the vector
	normal.set(a/l,b/l,c/l);
	
	// and divide d by th length as well
	this->d = d/l;
}


float osgCloudyDay::Plane::distance(osg::Vec3 &p) {

	return (d + (normal * p));
}



void osgCloudyDay::CloudLayerUpdate::setCamInternals(float angle, float ratio, float nearD, float farD) 
{
	this->ratio = ratio;
	this->angle = angle;
	this->nearD = nearD;
	this->farD = farD;

	tang = (float)tan(angle* PI/180.f * 0.5) ;
	nh = nearD * tang;
	nw = nh * ratio; 
	fh = farD  * tang;
	fw = fh * ratio;
}


void osgCloudyDay::CloudLayerUpdate::SetCamDef(osg::Vec3 &p, osg::Vec3 &l, osg::Vec3 &u) 
{
	osg::Vec3 dir,nc,fc,X,Y,Z;

	Z = p - l;
	Z.normalize();

	X = u ^ Z;
	X.normalize();

	Y = Z ^ X;

	nc = p - Z * nearD;
	fc = p - Z * farD;

	ntl = nc + Y * nh - X * nw;
	ntr = nc + Y * nh + X * nw;
	nbl = nc - Y * nh - X * nw;
	nbr = nc - Y * nh + X * nw;

	ftl = fc + Y * fh - X * fw;
	ftr = fc + Y * fh + X * fw;
	fbl = fc - Y * fh - X * fw;
	fbr = fc - Y * fh + X * fw;

	pl[0].set3Points(ntr,ntl,ftl);
	pl[1].set3Points(nbl,nbr,fbr);
	pl[2].set3Points(ntl,nbl,fbl);
	pl[3].set3Points(nbr,ntr,fbr);
	pl[4].set3Points(ntl,ntr,nbr);
	pl[5].set3Points(ftr,ftl,fbl);
}

int osgCloudyDay::CloudLayerUpdate::SphereInFrustum(osg::Vec3f p, float raio) 
{

	int result = 1;									//INSIDE
	float distance;

	for(int i=0; i < 6; i++) 
	{
		distance = pl[i].distance(p);

		if (distance < -raio)		return 3;		//OUTSIDE
		else if (distance < raio)	result =  2;	//INTERSECT
	}

	return result;
}


osgCloudyDay::AABox::AABox( osg::Vec3 &corner,  float x, float y, float z) {

	setBox(corner,x,y,z);
}

osgCloudyDay::AABox::AABox(void) 
{
	corner.x() = 0; corner.y() = 0; corner.z() = 0;

	x = 1.0f;
	y = 1.0f;
	z = 1.0f;	
}

osgCloudyDay::AABox::~AABox() {}

void osgCloudyDay::AABox::setBox( osg::Vec3 &corner,  float x, float y, float z) 
{
	this->corner = osg::Vec3(corner);

	if (x < 0.0) {
		x = -x;
		this->corner.x() -= x;
	}
	if (y < 0.0) {
		y = -y;
		this->corner.y() -= y;
	}
	if (z < 0.0) {
		z = -z;
		this->corner.z() -= z;
	}
	this->x = x;
	this->y = y;
	this->z = z;
}

osg::Vec3 osgCloudyDay::AABox::getVertexP(osg::Vec3 &normal) {

	osg::Vec3 res = corner;

	if (normal.x() > 0)
		res.x() += x;
	if (normal.y() > 0)
		res.y() += y;
	if (normal.z() > 0)
		res.z() += z;

	return(res);
}



osg::Vec3 osgCloudyDay::AABox::getVertexN(osg::Vec3 &normal) 
{
	osg::Vec3 res = corner;
	if (normal.x() < 0)
		res.x() += x;
	if (normal.y() < 0)
		res.y() += y;
	if (normal.z() < 0)
		res.z() += z;
	return(res);
}

int osgCloudyDay::CloudLayerUpdate::BoxInFrustum(osgCloudyDay::AABox &b) 
{
	int result = 1;									//INSIDE
	for(int i=0; i < 6; i++) 
	{
		if (pl[i].distance(b.getVertexP(pl[i].normal)) < 0)
			return 3;								//OUTSIDE
		else if (pl[i].distance(b.getVertexN(pl[i].normal)) < 0)
			result =  2;							//INTERSECT
	}
	return(result);
}


void osgCloudyDay::CloudLayerUpdate::operator()(osg::Node* node, osg::NodeVisitor* nv)
{		
	//std::cerr << "UPDATE OPERATOR" << std::endl;
	if(Scene::GetViewCamera() != 0)	Scene::GetViewCamera()->setViewMatrix(Scene::GetViewDepthCamera()->getViewMatrix());
	if(Scene::GetViewCamera() != 0)	Scene::GetViewCamera()->setProjectionMatrix(Scene::GetViewDepthCamera()->getProjectionMatrix());

	osgUtil::CullVisitor* cv = static_cast<osgUtil::CullVisitor*>(nv);	   
	osg::ref_ptr<osg::Geode> geode = static_cast<osg::Geode*> (node);
	CloudScene* m_cloud = static_cast<CloudScene*>(node->getUserData());
	
	if(!(geode && cv && m_cloud)) return;
	unsigned int active_layer = CloudScene::GetStates()->GetLayers().size()+1;
	
	UpdateShader(geode);
	
#ifdef SHADOW_MAPPING		
	std::vector<unsigned int> layers = CloudScene::GetStates()->GetLayers();
	if(layers.size() > layerid)
	{
		active_layer = layers.at(layerid);
		//Create Clouds
		if( CloudScene::GetStates()->getMeasureOvercast(active_layer) > CloudScene::GetStates()->getOvercast(active_layer))
		{
			if(layers.size() > 0 && layerid < layers.size()-1)
			{
				layerid++;
				active_layer = layers.at(layerid);	
				
				m_cloud->geometry->Active(true);
			}
			else	m_cloud->geometry->Active(false);
		}
		else m_cloud->geometry->Active(true);
			
		m_cloud->geometry->SetActiveLayer(active_layer);				
		unsigned int type = m_cloud->GetType(active_layer);				
		if( CloudScene::GetStates()->getMeasureOvercast(active_layer) <= CloudScene::GetStates()->getOvercast(active_layer))
		{							
#ifdef SHADOW_MAPPING
			m_cloud->RemoveScreenBillBoard();
#endif				
			for(int i = 0; i < 1; i++)
			{
				CloudGenerator* gen;
										
				switch(type)
				{
				case CloudScene::CT_Cumulus:									
					gen = new CumulusGenerator(CloudScene::GetStates()->getColor(active_layer));
					//gen = new CelluarAutomataGenerator(32*2,32*2,32*2);
					break;
				case CloudScene::CT_Stratus:
					gen = new StratusGenerator(CloudScene::GetStates()->getColor(active_layer));
					break;
				case CloudScene::CT_AltStratus:
					gen = new AltStratusGenerator(CloudScene::GetStates()->getColor(active_layer));
					break;
				case CloudScene::CT_StratoCumulusGenerator:
					gen = new StratoCumulusGenerator(CloudScene::GetStates()->getColor(active_layer));
					break;
				case CloudScene::CT_AltCumulusGenerator:
					gen = new AltCumulusGenerator(CloudScene::GetStates()->getColor(active_layer));
					break;
				case CloudScene::CT_Nimbostratus:
					gen = new NimbostratusGenerator(CloudScene::GetStates()->getColor(active_layer));
					break;
				case CloudScene::CT_Cumolonimbus:
					gen = new CumolonimbusGenerator(CloudScene::GetStates()->getColor(active_layer));
					break;
				}	
			
				WangCloud* c = gen->Create(m_cloud->CalculatePosition(active_layer));		
				c->SetCloudGenerator(gen);
				//bb_geo = m_cloud->InsertCloud(c, layerid);								
				cloud_added = true;				
			}				
		
			m_cloud->Create();						

			m_cloud->geode->dirtyBound();
			m_cloud->geometry->dirtyBound();
			m_cloud->quadBillBoard->dirtyBound();					
		}		


		UpdateLayer(m_cloud);	
	}
#endif				

#ifdef SHADOW_MAPPING	
	try
	{		
		osg::Vec3 eye, center, up;
		osg::Vec3 eye_light, center_light, up_light;			
	
		Scene::GetViewMatrix_View().getLookAt(eye, center, up);
		Scene::GetLightCamera()->getViewMatrixAsLookAt(eye_light, center_light, up_light);			

		osg::Matrixd modelMatrix = osg::Matrix::identity(); //*cv->getModelViewMatrix() * osg::Matrixd::inverse(cv->getCurrentCamera()->getViewMatrix());
		osg::Matrixd project = Scene::GetProjectionMatrix_View();		
		osg::Matrixd viewMatrix = Scene::GetViewMatrix_View();	
		osg::Matrixd modelViewMatrix = viewMatrix;		
	
		osg::Matrixd project_light;		
		project_light = Scene::GetProjectionMatrix_Light();
		osg::Matrixd viewMatrix_light = Scene::GetLightCamera()->getViewMatrix();		
		osg::Matrixd modelViewMatrix_light = viewMatrix_light;		
			
		if(active_layer < (CloudScene::GetStates()->GetLayers().size()) && CloudScene::GetStates()->getMeasureOvercast(active_layer) <= CloudScene::GetStates()->getOvercast(active_layer))
		{		
			osg::Vec3 middlePoint = m_cloud->GetStates()->getMiddlePoint(active_layer);
			osg::Vec3 size = m_cloud->GetStates()->getSize(active_layer);
		
			osg::Matrixd mvm_light = osg::Matrixd();
			osg::Vec3 m = osg::Vec3(middlePoint.x(),middlePoint.y(), middlePoint.z());
			osg::Vec3 c =  osg::Vec3(m.x(), m.y(), 0.f); 
			
			mvm_light = osg::Matrixd::lookAt(m, c, osg::Vec3(1.f, 0.f, 0.f));			
			project_light = osg::Matrixd::ortho(-size.x(), size.x(),
												-size.y(), size.y(),
												-size.z(), size.z());				
		
			modelViewMatrix_light = modelMatrix * mvm_light;
			viewMatrix_light = mvm_light;			
		}

		m_cloud->nodess4->getUniform("modelViewMatrix")->set(modelViewMatrix);
		m_cloud->nodess4->getUniform("modelViewMatrix_light")->set(modelViewMatrix_light);
		m_cloud->nodess4->getUniform("viewMatrix")->set(viewMatrix);
		m_cloud->nodess4->getUniform("viewMatrix_light")->set(viewMatrix_light);

		m_cloud->nodess4->getUniform("viewMatrixInv")->set(osg::Matrixd::inverse(viewMatrix));
		m_cloud->nodess4->getUniform("viewMatrixInv_light")->set(osg::Matrixd::inverse(viewMatrix_light));
		m_cloud->nodess4->getUniform("project")->set(project);
		m_cloud->nodess4->getUniform("project_light")->set(project_light);
		m_cloud->nodess4->getUniform("inv_project_light")->set(osg::Matrixd::inverse(project_light));

		osg::Matrixd m_halfAngleMatrix = osg::Matrixd();
		osg::Matrixd m_halfAngleLightMatrix = osg::Matrixd();
	
		osg::Vec3 viewVector = eye-center;
		float distV = viewVector.normalize();

		osg::Vec3 lightVector = eye_light-center_light;
		float distL = lightVector.normalize();		
	
		osg::Vec3 halfAngleVec;
		
		if((viewVector * lightVector) > 0.f)
		{
			halfAngleVec = viewVector+lightVector;
			halfAngleVec.normalize();			
			CloudScene::m_backtofront = false;		
		}
		else
		{
			halfAngleVec = -viewVector+lightVector;
			halfAngleVec.normalize();			
			CloudScene::m_backtofront = true;					
		}

		//if(iteration==0)					
		if(CloudScene::m_backtofront_old != CloudScene::m_backtofront)		geode->getOrCreateStateSet()->setAttribute(CloudScene::cloudProg);			
		CloudScene::m_backtofront_old = CloudScene::m_backtofront;	
			
		m_cloud->nodess4->getUniform("backtofront")->set(CloudScene::m_backtofront);
		//m_cloud->nodess4->getUniform("backtofrontold")->set((int)(Scene::m_backtofront_old)); 

		osg::Vec3 halfAngleUp = osg::Vec3(0.f, 1.f, 0.f);
		osg::Vec3 rightVec = halfAngleVec ^ halfAngleUp;		
		rightVec.normalize();

		osg::Vec3 halfAngleCenterPos = center;//(center+center_light)/2.0;
		osg::Vec3 halfAnglePos = halfAngleVec*distV;
		m_halfAngleMatrix = osg::Matrixd::lookAt(halfAnglePos+center, center, halfAngleUp);

		halfAnglePos = halfAngleVec*distL;
		m_halfAngleLightMatrix = osg::Matrixd::lookAt(halfAnglePos+center_light, center_light, halfAngleUp);
		
		osg::Vec3 dir = (halfAngleVec);

	#else
			osg::Vec3 eye, center, up;		

			osg::Vec3 center_light = center;

			osg::Matrixd modelMatrix = *cv->getModelViewMatrix() * osg::Matrixd::inverse(cv->getCurrentCamera()->getViewMatrix());
			osg::Matrixd project = Scene::GetProjectionMatrix_View();	
			osg::Matrixd viewMatrix = Scene::GetViewMatrix_View();
			osg::Matrixd modelViewMatrix = modelMatrix * viewMatrix;		

			osg::Matrixd m_halfAngleMatrix = m_halfAngleMatrix;
			osg::Matrixd m_halfAngleLightMatrix = m_halfAngleMatrix;		

			m_cloud->nodess4->getUniform("modelViewMatrix")->set(modelViewMatrix);
			m_cloud->nodess4->getUniform("modelViewMatrix_light")->set(osg::Matrixd());
			m_cloud->nodess4->getUniform("viewMatrix")->set(viewMatrix);
			m_cloud->nodess4->getUniform("viewMatrix_light")->set(osg::Matrixd());
			m_cloud->nodess4->getUniform("viewMatrixInv")->set(osg::Matrixd::inverse(viewMatrix));
			m_cloud->nodess4->getUniform("viewMatrixInv_light")->set(osg::Matrixd::inverse(osg::Matrixd()));
			m_cloud->nodess4->getUniform("project")->set(project);
			m_cloud->nodess4->getUniform("project_light")->set(osg::Matrixd());
			m_cloud->nodess4->getUniform("inv_project_light")->set(osg::Matrixd::inverse(osg::Matrixd()));

			osg::Vec3 viewVector = eye-center;
			float distV = viewVector.length();
			viewVector.normalize();

			osg::Vec3 lightVector = eye-center;
			float distL = lightVector.length();
			lightVector.normalize();
	#endif			

		for(unsigned int j = 0; j < geode->getNumDrawables();j++)
		{
			osg::ref_ptr<osg::Geometry> obj = static_cast<osg::Geometry*> (geode->getDrawable(j));
			osg::ref_ptr<osgCloudyDay::CloudGeometry> ppg = static_cast<osgCloudyDay::CloudGeometry*> (geode->getDrawable(j));
		
	#ifdef SHADOW_MAPPING
			if(obj && ppg)
	#else
			if(obj)
	#endif	
			{
				ppg->m_slicingViewVectorTransformed = CloudScene::m_backtofront;
	#ifdef SHADOW_MAPPING
				
	#else
						osg::Vec3 dir = viewVector;
	#endif			

	#ifdef SHADOW_MAPPING 
	#if 0
					std::vector<unsigned int> index2;
					index2.resize(m_cloud->GetNumberOfClouds());			
					for(int i = 0; i < m_cloud->GetNumberOfClouds(); i++)	index2[i] = i;

					depth = new float[m_cloud->GetNumberOfClouds()];
					for(int i = 0; i < m_cloud->GetNumberOfClouds(); i++)
						depth[i] = (dir * m_cloud->m_cloudcenter->at(i));


					std::sort(index2.begin(), index2.end(), *this); //Das ist evt. falsch. Verliere CLouds
					if(ppg->m_CloudsIterArrays == 0) 
					{
						ppg->m_CloudsIterArrays = (new osg::IntArray());
						ppg->m_CloudsIterArrays->resize(m_cloud->GetNumberOfClouds());
					}
				

					for(int i = 0; i < m_cloud->GetNumberOfClouds(); i++)	ppg->m_CloudsIterArrays->at(i) = index2[i];
					delete[] depth;
	#endif
	#endif			

	#ifdef SHADOW_MAPPING
				osg::Vec4Array* rotationarray = static_cast<osg::Vec4Array*>(obj->getVertexAttribArray(1));			
				osg::Vec3Array* vecarray = static_cast<osg::Vec3Array*>(obj->getVertexAttribArray(0));			
				depth = new float[vecarray->getNumElements()-4];				

				std::vector<unsigned int> index;
				//index.resize(vecarray->getNumElements()-4);
				//for(unsigned int i = 0; i < index.size()-4; i++)	
				//for(unsigned int i = 0; i < vecarray->getNumElements()-4; i++)	
				//	index[i] = i;
				
				//--------------------------
				//---- FRUSTRUM CULLING ----
				//--------------------------

				double angle, ratio, nearP, farP;
				osg::Vec3 p, c, u;

				Scene::GetViewCamera()->getProjectionMatrix().getPerspective(angle, ratio, nearP, farP);
				setCamInternals((float)(angle), (float)(ratio), (float)(nearP), (float)(farP));				
				Scene::GetViewCamera()->getViewMatrix().getLookAt(p, c, u);
				SetCamDef(p,c,u);
				
				int* helperarray = new int[vecarray->getNumElements()-4];
				for(size_t i = 0; i < vecarray->getNumElements()-4; i++)
					helperarray[i] = -1;

				index.clear();
				int num_deleted=0;
				int numInside = 0;
				
				for(unsigned int i = 0; i < m_cloud->m_clouds.size(); i++)
				{		
					WangCloud* c = m_cloud->m_clouds.at(i);
					osg::Vec3 corner2 = c->BoundingBoxMin();
					osg::Vec3 size2 = c->BoundingBoxMax()-c->BoundingBoxMin();					
					AABox aabb2(corner2, size2.x(), size2.y(), size2.z());
					
					for(size_t j = 0; j < c->GetNumberOfBoundingBoxes()  && BoxInFrustum(aabb2) <= 2; j++)
					{
						osg::Vec3 origin = c->GetBoundingBoxOriginAt(j);
						osg::Vec3 size = c->GetBoundingBoxSizeAt(j);
						osg::Vec3 corner = origin-(size);
						AABox aabb(corner, size.x()*2.f, size.y()*2.f, size.z()*2.f);
						
						int start = m_cloud->cloudstartindex[i];

						if((vecarray->getNumElements()-4) < (c->GetBoundingBoxEndIndex(j)+start))
						{
							std::cerr << "start: " << start << " " << c->GetBoundingBoxStartIndex(j) << " " << c->GetBoundingBoxEndIndex(j) << std::endl;
							std::cerr << "k+start: " << (c->GetBoundingBoxStartIndex(j)+start) << " (k+end): " << (c->GetBoundingBoxEndIndex(j)+start) << " size: " << (vecarray->getNumElements()-4) << std::endl;					
							continue;
						}

						if(BoxInFrustum(aabb) <= 2)
						{
							for(size_t k = c->GetBoundingBoxStartIndex(j); k < c->GetBoundingBoxEndIndex(j); k++)
								if(SphereInFrustum(vecarray->at(k+start), std::max(rotationarray->at(k+start).y(), rotationarray->at(k+start).z())) <= 2)
									helperarray[k+start] = k+start;							
						}
					}
				}
				/*/for(size_t i = 0; i < (vecarray->getNumElements()-4); i++)
				{
					//http://www.lighthouse3d.com/tutorials/view-frustum-culling/
					if(SphereInFrustum(vecarray->at(i), std::max(rotationarray->at(i).y(), rotationarray->at(i).z())) <= 2)
					{
						//NOT CULLING
						numInside++;
						helperarray[i] = i;
					}					
				}//*/
				
				Scene::GetLightCamera()->getProjectionMatrix().getPerspective(angle, ratio, nearP, farP);
				setCamInternals((float)(angle), (float)(ratio), (float)(nearP), (float)(farP));				
				Scene::GetLightCamera()->getViewMatrix().getLookAt(p, c, u);
				SetCamDef(p,c,u);

				numInside = 0;

				/*
				for(int i = (int)(index.size())-1; i >= 0; i--)	
				{
					//http://www.lighthouse3d.com/tutorials/view-frustum-culling/
					if(SphereInFrustum(vecarray->at(i), std::max(rotationarray->at(i).y(), rotationarray->at(i).z())) <= 2)
					{
						//NOT CULLING
						numInside++;
						helperarray[i] = i;
					}					
				}
				/*/
				for(unsigned int i = 0; i < m_cloud->m_clouds.size(); i++)
				{	
					WangCloud* c = m_cloud->m_clouds.at(i);

					osg::Vec3 corner2 = c->BoundingBoxMin();
					osg::Vec3 size2 = c->BoundingBoxMax()-c->BoundingBoxMin();					
					AABox aabb2(corner2, size2.x(), size2.y(), size2.z());
					
					for(size_t j = 0; j < c->GetNumberOfBoundingBoxes()  && BoxInFrustum(aabb2) <= 2; j++)
					{
						osg::Vec3 origin = c->GetBoundingBoxOriginAt(j);
						osg::Vec3 size = c->GetBoundingBoxSizeAt(j);
						osg::Vec3 corner = origin-(size);
						AABox aabb(corner, size.x()*2.f, size.y()*2.f, size.z()*2.f);

						int start = m_cloud->cloudstartindex[i];												
						if((vecarray->getNumElements()-4) < (c->GetBoundingBoxEndIndex(j)+start))
						{
							std::cerr << "start: " << start << " " << c->GetBoundingBoxStartIndex(j) << " " << c->GetBoundingBoxEndIndex(j) << std::endl;
							std::cerr << "k+start: " << (c->GetBoundingBoxStartIndex(j)+start) << " (k+end): " << (c->GetBoundingBoxEndIndex(j)+start) << " size: " << (vecarray->getNumElements()-4) << std::endl;					
							continue;
						}
						
						if(BoxInFrustum(aabb) <= 2)
						{
							for(size_t k = c->GetBoundingBoxStartIndex(j); k < c->GetBoundingBoxEndIndex(j); k++)
								if(SphereInFrustum(vecarray->at(k+start), std::max(rotationarray->at(k+start).y(), rotationarray->at(k+start).z())) <= 2)
									helperarray[k+start] = k+start;							
						}
					}
				}//*/

				for(size_t i = 0; i < vecarray->getNumElements()-4; i++)
					if(helperarray[i] > -1)
						index.push_back(i);
				
				////////////
				// TODO
				// REDUCE THE SIZE OF THE NUMBER OF PARTICLES TO DRAW
				////////////				
								
				depth = new float[vecarray->getNumElements()-4];				
				for(unsigned int i = 0; i < vecarray->getNumElements()-4; i++)						
					depth[i] = -(dir * vecarray->at(i));			

				std::sort(index.begin(), index.begin()+index.size(), *this);
				
				//std::cerr << "INDEX SIZE: " << index.size() << std::endl;
				
				int start = 0;					
				unsigned int helper = 0;
				unsigned int num_draws = 100;	//min = 1
				unsigned int num_indices = index.size();//m_start_indices->at(k+1) - m_start_indices->at(k);	
				unsigned int num_points_per_draw = (unsigned int)((float)(num_indices)/(float)(num_draws));	
					
				int rest = num_indices% num_draws;		

				if(num_points_per_draw > 0)
				{		
					int helperiterator=0;
					int helper2 = 0;						
					for(unsigned int n = 0; n < (num_draws); n++)
					{	
						int num_points_per_draw_CPY = num_points_per_draw;
						if(helperiterator < rest )
							num_points_per_draw_CPY++;
				
						obj->setPrimitiveSet(helperiterator, new osg::DrawElementsUInt(osg::PrimitiveSet::POINTS,	num_points_per_draw_CPY,	&index[0]+(n*num_points_per_draw+start))); 

						helper2 += num_points_per_draw_CPY;
						helper+=num_points_per_draw_CPY;
						helperiterator++;
					}					
				}	
				else
				{						
					obj->setPrimitiveSet(0, new osg::DrawElementsUInt(osg::PrimitiveSet::POINTS,	num_indices,	&index[0])); 																			
				}			

				delete[] depth;

				//--------------------------
				//--------------------------
				/*
				delete[] depth;
				depth = new float[vecarray->getNumElements()-4];
				for(unsigned int i = 0; i < vecarray->getNumElements()-4; i++)		
				{
					//depth[i] = (eye_light * vecarray->at(i));
					//depth[i] = m_halfAngleLightMatrix.postMult(vecarray->at(i)).length();
					depth[i] = -(dir * vecarray->at(index[i]));//.x(), vecarray->at(i).y(), vecarray->at(i).z())); //project into viewvec axis					
				}
				
				*/

				/*
				osg::ref_ptr<osg::IntArray> prim = ppg::m_numPrimitiveArrays;
				int startindex = 0;
				for(int i = 0; i < prim->size(); i++)
				{
					std::sort(index.begin()+startindex, index.begin()+startindex+prim->at(i), *this); //Das ist evt. falsch. Verliere CLouds
					startindex += prim->at(i);
				}
				/*/
			
				//std::sort(index.begin(), index.begin()+index.size(), *this);
				//*/
	#else
					osg::Vec3Array* vecarray = static_cast<osg::Vec3Array*>(obj->getVertexAttribArray(0));
					depth = new float[m_cloud->GetNumberOfParticles()];

					std::vector<unsigned int> index;
					index.resize(m_cloud->GetNumberOfParticles());
					for(int i = 0; i < m_cloud->GetNumberOfParticles(); i++)	index[i] = i;
						
					for(unsigned int i = 0; i < m_cloud->GetNumberOfParticles(); i++)	
						depth[i] = (dir * vecarray->at(i));//.x(), vecarray->at(i).y(), vecarray->at(i).z())); //project into viewvec axis

					std::sort(index.begin(), index.end(), *this); //Das ist evt. falsch. Verliere CLouds
	#endif			
							
				/*unsigned int n = 0;
				for(unsigned int k = 0; k < obj->getNumPrimitiveSets()-1; k++)
				{					
					switch ( obj->getPrimitiveSet(k)->getType() )
			 		{
						case osg::PrimitiveSet::DrawArraysPrimitiveType:
						{
							osg::DrawArrays* da = static_cast<osg::DrawArrays*>(obj->getPrimitiveSet(k));
							//for(unsigned int iter = 0; iter < index.size(); iter++)	
							for(unsigned int iter = 0; iter < da->getNumIndices(); iter++)
							{							
								da->getDrawElements()->setElement(iter, index.at(n));
								n++;
							}
							
							break;
						}
						case osg::PrimitiveSet::DrawElementsUIntPrimitiveType:
						{
							osg::DrawElementsUInt* da = static_cast<osg::DrawElementsUInt *>(obj->getPrimitiveSet(k));
							//for(unsigned int iter = 0; iter < index.size(); iter++)		
							for(unsigned int iter = 0; iter < da->getNumIndices(); iter++)
							{	
								da->setElement(iter, index.at(n));								
								n++;
							}
							break;
						}
						case osg::PrimitiveSet::DrawElementsUShortPrimitiveType:
						{
							osg::DrawElementsUShort* da = static_cast<osg::DrawElementsUShort  *>(obj->getPrimitiveSet(k));
							//for(unsigned int iter = 0; iter < index.size(); iter++)								
							for(unsigned int iter = 0; iter < da->getNumIndices(); iter++)
							{	
								da->setElement(iter, index.at(n));
								n++;
							}
							break;
						}
						case osg::PrimitiveSet::DrawElementsUBytePrimitiveType:
						{
							osg::DrawElementsUByte* da = static_cast<osg::DrawElementsUByte *>(obj->getPrimitiveSet(k));
							//for(unsigned int iter = 0; iter < index.size(); iter++)	
							for(unsigned int iter = 0; iter < da->getNumIndices(); iter++)
							{	
								da->setElement(iter, index.at(n));								
								n++;
							}						
							break;
						}					
					}
					obj->getPrimitiveSet(k)->dirty();
				}
				
				obj->dirtyBound();
				delete[] depth;
				index.clear();*/
			}
		}			
	}
	catch(...)
	{
		std::cerr << "ERROR at 3d cloud drawing" << std::endl;
	}

	traverse(node, nv);    
}