#include "CloudLayerState.h"


osgCloudyDay::CloudLayerState::CloudLayerState(void)
{	
	m_keys = std::vector<unsigned int>();
	m_type = std::map<unsigned int, int>();

	m_overcast = std::map<unsigned int, float>();
	m_overcast_measure = std::map<unsigned int, float>();
	m_height = std::map<unsigned int, float>();
	m_numClouds = std::map<unsigned int, unsigned int>();

	m_middlepoint = std::map<unsigned int, osg::Vec3>();
	m_size = std::map<unsigned int, osg::Vec3>();

	m_clot = std::map<unsigned int, unsigned int>();
	m_var = std::map<unsigned int, float>();

	m_color = std::map<unsigned int, osg::Vec4>();
}


osgCloudyDay::CloudLayerState::~CloudLayerState(void)
{
	m_keys.clear();
	m_type.clear();
	m_overcast.clear();
	m_overcast_measure.clear();
	m_height.clear();
	m_numClouds.clear();
	m_middlepoint.clear();
	m_size.clear();
	m_clot.clear();
	m_color.clear();
	m_var.clear();
}

void osgCloudyDay::CloudLayerState::AddLayer(unsigned int layer, unsigned int type)
{
	m_keys.push_back(layer);

	m_type.insert(std::pair<unsigned int, unsigned int>(layer, type)); 
	m_numClouds.insert(std::pair<unsigned int, unsigned int>(layer, 0));

	m_overcast.insert(std::pair<unsigned int, float>(layer, 0.f));
	m_overcast_measure.insert(std::pair<unsigned int, float>(layer, 0.f));
	m_height.insert(std::pair<unsigned int, float>(layer, 0.f));
	m_var.insert(std::pair<unsigned int, float>(layer, 0.f));
		
	m_middlepoint.insert(std::pair<unsigned int, osg::Vec3>(layer, osg::Vec3f()));
	m_size.insert(std::pair<unsigned int, osg::Vec3>(layer, osg::Vec3f()));

	m_color.insert(std::pair<unsigned int, osg::Vec4>(layer, osg::Vec4f()));

	m_clot.insert(std::pair<unsigned int, unsigned int>(layer, 0));		
}

std::vector<unsigned int> osgCloudyDay::CloudLayerState::GetLayers()
{
	return m_keys;
}

void osgCloudyDay::CloudLayerState::SetType(unsigned int layer, unsigned int type)
{
	m_type[layer] = type;
}

int osgCloudyDay::CloudLayerState::GetType(unsigned int layer)
{
	return m_type[layer];
}

osg::Vec4f osgCloudyDay::CloudLayerState::getColor(unsigned int cloud_type)
{
	return m_color[cloud_type];
}

void osgCloudyDay::CloudLayerState::setColor(unsigned int cloud_type, osg::Vec4f v)
{
	m_color[cloud_type] = v;
}

float osgCloudyDay::CloudLayerState::getVariance(unsigned int cloud_type)
{
	return m_var[cloud_type];
}

void osgCloudyDay::CloudLayerState::setVariance(unsigned int cloud_type, float v)
{
	m_var[cloud_type] = v;
}

int osgCloudyDay::CloudLayerState::getClot(unsigned int cloud_type)
{
	return m_clot[cloud_type];
}

void osgCloudyDay::CloudLayerState::setClot(unsigned int cloud_type, unsigned int clot)
{
	m_clot[cloud_type] = clot;
}

float osgCloudyDay::CloudLayerState::getMeasureOvercast(unsigned int cloud_type)
{
	return m_overcast_measure.at(cloud_type);
}

void osgCloudyDay::CloudLayerState::setMeasureOvercast(unsigned int cloud_type, float overcast)
{
	m_overcast_measure[cloud_type] = overcast;
	//m_overcast_measure.insert(std::pair<int, float>(cloud_type, overcast));	
}

float osgCloudyDay::CloudLayerState::getOvercast(unsigned int cloud_type)
{
	return m_overcast[cloud_type];
}

void osgCloudyDay::CloudLayerState::setOvercast(unsigned int cloud_type, float overcast)
{
	//m_overcast.insert(std::pair<int, float>(cloud_type, overcast));	
	m_overcast[cloud_type] = overcast;	

	//m_overcast.insert(std::pair<int, float>(cloud_type, 1.f));	
	//setNumClouds(cloud_type, osg::Vec2(15.f*overcast, 15.f*overcast));
}

unsigned int osgCloudyDay::CloudLayerState::GetEstimationOfNumberOfCloudsOfLayer(unsigned int cloud_type)
{
	return std::max(m_clot[cloud_type] , (unsigned int)(( (float)(m_clot[cloud_type]) * (10.f*m_overcast[cloud_type]))+0.5f));
}

float osgCloudyDay::CloudLayerState::getHeight(unsigned int cloud_type)
{
	return m_height[cloud_type];
}

void osgCloudyDay::CloudLayerState::setHeight(unsigned int cloud_type, float height)
{
	m_height[cloud_type] = height;	
}

osg::Vec3 osgCloudyDay::CloudLayerState::getMiddlePoint(unsigned int cloud_type)
{
	return m_middlepoint[cloud_type];
}

void osgCloudyDay::CloudLayerState::setMiddlePoint(unsigned int cloud_type, osg::Vec3 middlepoint)
{
	m_middlepoint[cloud_type] = middlepoint;
}

osg::Vec3 osgCloudyDay::CloudLayerState::getSize(unsigned int cloud_type)
{
	return m_size[cloud_type];
}

void osgCloudyDay::CloudLayerState::setSize(unsigned int cloud_type, osg::Vec3 size)
{
	m_size[cloud_type] = size;
}


unsigned int osgCloudyDay::CloudLayerState::getNumClouds(unsigned int cloud_type)
{
	return m_numClouds[cloud_type];
}

void osgCloudyDay::CloudLayerState::setNumClouds(unsigned int cloud_type, unsigned int size)
{
	m_numClouds[cloud_type] = size;
}