﻿#include "CloudGeometry.h"
#include "CloudScene.h"
#include <osg/ClearNode>
#include <osgViewer/Viewer>

#include <osg/GL>
#include <osgUtil/RenderStage>
#include <gl/GL.h>
#include <gl/GLU.h>
#include <osg/PolygonOffset>
#include <osg/BlendFunc>
#include <osg/BlendEquation>
#include <osg/Depth>
#include <osg/GL2Extensions>

bool osgCloudyDay::CloudGeometry::blur = false;

osgCloudyDay::CloudGeometry::CloudGeometry(	osg::ref_ptr<osg::Texture2D> _tex_clouds,
									osg::ref_ptr<osg::Texture2D> _fbo_light_texture,
									osg::ref_ptr<osg::Texture2D> _fbo_light_depth,
									osg::ref_ptr<osg::Texture2D> _fbo_blur_texture,									
									osg::ref_ptr<osg::FrameBufferObject> _fbo_shadow,
									osg::ref_ptr<osg::FrameBufferObject> _fbo_vert_linear_blur,
									osg::ref_ptr<osg::FrameBufferObject> _fbo_hori_linear_blur,
									osg::ref_ptr<osg::FrameBufferObject> _fbo_hori_blur,
									osg::ref_ptr<osg::FrameBufferObject> _fbo_vert_blur,
									osg::ref_ptr<osg::FrameBufferObject> _fbo_cloud_viewer,
									osg::ref_ptr<osg::FrameBufferObject> _fbo_hori_blur2,
									osg::ref_ptr<osg::Program> viewer,
									osg::ref_ptr<osg::Program> light,
									osg::ref_ptr<osg::Program> blur_vert,
									osg::ref_ptr<osg::Program> blur_hori,
									osg::ref_ptr<osg::Program> blur_linear_vert,
									osg::ref_ptr<osg::Program> blur_linear_hori,
									osg::ref_ptr<osg::Program> shadow_map) : m_slicingViewVectorTransformed(true)
{
	tex_clouds = _tex_clouds;
	fbo_shadow = _fbo_shadow;
	fbo_light_texture = _fbo_light_texture;
	fbo_light_depth = _fbo_light_depth;
	fbo_blur_texture = _fbo_blur_texture;

	fbo_cloud_viewer = _fbo_cloud_viewer;
	fbo_vert_blur = _fbo_vert_blur;
	fbo_vert_linear_blur = _fbo_vert_linear_blur;
	fbo_hori_linear_blur = _fbo_hori_linear_blur;
	fbo_hori_blur = _fbo_hori_blur;
	fbo_hori_blur2 = _fbo_hori_blur2;

	sh_viewer = viewer;
	sh_light = light;
	sh_blur_vert = blur_vert;
	sh_blur_hori = blur_hori;
	sh_shadow_map = shadow_map;	

	sh_blur_linear_vert=blur_linear_vert;
	sh_blur_linear_hori=blur_linear_hori;

	m_primitive2Layer = osg::ref_ptr<osg::UIntArray>(new osg::UIntArray());
	m_active_layer = 0;
	processing = false;
}

osgCloudyDay::CloudGeometry::~CloudGeometry(void)
{
}

void osgCloudyDay::CloudGeometry::SetActiveLayer(int layer)
{
	m_active_layer = layer;
}

void osgCloudyDay::CloudGeometry::AddLayer(int type)
{
	m_layers.push_back(type);
}

void osgCloudyDay::CloudGeometry::AddPrimitive(int type)
{
	m_primitive2Layer->push_back(type);
}

void osgCloudyDay::CloudGeometry::DeletePrimitives()
{
	m_primitive2Layer->erase(m_primitive2Layer->begin(), m_primitive2Layer->end());
}

void osgCloudyDay::CloudGeometry::Active(bool type)
{
	processing = type; 	
}

void osgCloudyDay::CloudGeometry::drawImplementation(osg::RenderInfo& renderInfo) const
{
    if (_internalOptimizedGeometry.valid())
    {
        _internalOptimizedGeometry->drawImplementation(renderInfo);
        return;
    }

    osg::State& state = *renderInfo.getState();

    bool checkForGLErrors = state.getCheckForGLErrors()==osg::State::ONCE_PER_ATTRIBUTE;
    if (checkForGLErrors) state.checkGLErrors("start of Geometry::drawImplementation()");
    
    bool useFastPath = areFastPathsUsed();
    // useFastPath = false;

    bool usingVertexBufferObjects = _useVertexBufferObjects && state.isVertexBufferObjectSupported();
    bool handleVertexAttributes = !_vertexAttribList.empty();

    osg::ArrayDispatchers& arrayDispatchers = state.getArrayDispatchers();

    arrayDispatchers.reset();
    arrayDispatchers.setUseVertexAttribAlias(useFastPath && state.getUseVertexAttributeAliasing());
    arrayDispatchers.setUseGLBeginEndAdapter(!useFastPath);

    arrayDispatchers.activateNormalArray(_normalData.binding, _normalData.array.get(), _normalData.indices.get());
    arrayDispatchers.activateColorArray(_colorData.binding, _colorData.array.get(), _colorData.indices.get());
    arrayDispatchers.activateSecondaryColorArray(_secondaryColorData.binding, _secondaryColorData.array.get(), _secondaryColorData.indices.get());
    arrayDispatchers.activateFogCoordArray(_fogCoordData.binding, _fogCoordData.array.get(), _fogCoordData.indices.get());

    if (handleVertexAttributes)
    {
        for(unsigned int unit=0;unit<_vertexAttribList.size();++unit)
        {
            arrayDispatchers.activateVertexAttribArray(_vertexAttribList[unit].binding, unit, _vertexAttribList[unit].array.get(), _vertexAttribList[unit].indices.get());
        }
    }

    // dispatch any attributes that are bound overall
    arrayDispatchers.dispatch(BIND_OVERALL,0);

    state.lazyDisablingOfVertexAttributes();

    if (useFastPath)
    {
        // set up arrays
        if( _vertexData.array.valid() )
            state.setVertexPointer(_vertexData.array.get());

        if (_normalData.binding==BIND_PER_VERTEX && _normalData.array.valid())
            state.setNormalPointer(_normalData.array.get());

        if (_colorData.binding==BIND_PER_VERTEX && _colorData.array.valid())
            state.setColorPointer(_colorData.array.get());

        if (_secondaryColorData.binding==BIND_PER_VERTEX && _secondaryColorData.array.valid())
            state.setSecondaryColorPointer(_secondaryColorData.array.get());

        if (_fogCoordData.binding==BIND_PER_VERTEX && _fogCoordData.array.valid())
            state.setFogCoordPointer(_fogCoordData.array.get());

        for(unsigned int unit=0;unit<_texCoordList.size();++unit)
        {
            const osg::Array* array = _texCoordList[unit].array.get();
            if (array) state.setTexCoordPointer(unit,array);
        }

        if( handleVertexAttributes )
        {
            for(unsigned int index = 0; index < _vertexAttribList.size(); ++index )
            {
                const osg::Array* array = _vertexAttribList[index].array.get();
                const AttributeBinding ab = _vertexAttribList[index].binding;
                if( ab == BIND_PER_VERTEX && array )
                {
                    state.setVertexAttribPointer( index, array, _vertexAttribList[index].normalize );
                }
            }
        }
    }
    else
    {
        for(unsigned int unit=0;unit<_texCoordList.size();++unit)
        {
            arrayDispatchers.activateTexCoordArray(BIND_PER_VERTEX, unit, _texCoordList[unit].array.get(), _texCoordList[unit].indices.get());
        }

        arrayDispatchers.activateVertexArray(BIND_PER_VERTEX, _vertexData.array.get(), _vertexData.indices.get());
    }

    state.applyDisablingOfVertexAttributes();

    bool bindPerPrimitiveSetActive = arrayDispatchers.active(BIND_PER_PRIMITIVE_SET);
    bool bindPerPrimitiveActive = arrayDispatchers.active(BIND_PER_PRIMITIVE);

    unsigned int primitiveNum = 0;

    if (checkForGLErrors) state.checkGLErrors("Geometry::drawImplementation() after vertex arrays setup.");

	
	osg::BlendFunc* bf_front_to_back = new osg::BlendFunc(GL_ONE_MINUS_DST_ALPHA, GL_ONE); // back-to-front
	osg::BlendFunc* bf_back_to_front = new osg::BlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA); // back-to-front
		
	
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //
    // draw the primitives themselves.
    //
	osg::PrimitiveSet* last_primitiveset = _primitives[_primitives.size()-1].get();		

	osg::Depth* depth2 = new osg::Depth(osg::Depth::LEQUAL, 0.0, 1.0, false);	//MIT DEPTH => FEHLER	
	osg::Depth* depth3 = new osg::Depth(osg::Depth::ALWAYS, 0.0, 1.0, true);	//MIT DEPTH => FEHLER	
	osg::Depth* depth4 = new osg::Depth(osg::Depth::ALWAYS, 0.0, 1.0, false);	//MIT DEPTH => FEHLER	
			
	if(processing)
	{		
		if(fbo_shadow == 0) std::cerr << "fbo_shadow: IS NULL " << std::endl;
		fbo_shadow->apply(state, osg::FrameBufferObject::DRAW_FRAMEBUFFER);
		glClear( GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
							
		glViewport(0,0,1024, 1024);
		for(unsigned int primitiveSetNum=0; primitiveSetNum!= _primitives.size()-1 ; ++primitiveSetNum)
		{		
			// dispatch any attributes that are bound per primitive
			if (bindPerPrimitiveSetActive) 
			{
				arrayDispatchers.dispatch(BIND_PER_PRIMITIVE_SET, primitiveSetNum);
			}

			//std::cout << " << m_primitive2Layer->at(primitiveSetNum) << " << m_primitive2Layer->at(primitiveSetNum) << std::endl;
			if(m_primitive2Layer->at(primitiveSetNum) == m_active_layer)
			{								
				const osg::PrimitiveSet* primitiveset = _primitives[primitiveSetNum].get();	
									
				//LIGHT VIEW
				osg::Depth* depth2 = new osg::Depth(osg::Depth::ALWAYS, 0.0, 1.0, true);	//MIT DEPTH => FEHLER	
				depth2->apply(state);				
				glDepthMask(GL_FALSE);
				glDisable(GL_DEPTH_TEST);

				glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA); //bf_back_to_front->apply(state);
				
				state.applyTextureMode(1, GL_TEXTURE_2D, false);
				state.applyTextureAttribute(0, tex_clouds);
						
				fbo_shadow->apply(state, osg::FrameBufferObject::DRAW_FRAMEBUFFER);
				sh_light->apply(state);		
				glEnable(GL_BLEND);
				glDepthMask(GL_FALSE);
				glDisable(GL_DEPTH_TEST);
				primitiveset->draw(state, usingVertexBufferObjects);        		
				glDisable(GL_BLEND);							
				glDepthMask(GL_TRUE);
				glEnable(GL_DEPTH_TEST);
			}
		}
		
		//////////////////////////////////				
		//CALCULATING DENSITY		
		fbo_shadow->apply(*(renderInfo.getState()), osg::FrameBufferObject::READ_FRAMEBUFFER); 		
		state.applyTextureMode(0, GL_TEXTURE_2D, true);
		state.applyTextureAttribute(0, fbo_light_texture);
		
		if(fbo_light_texture->getTextureObject( renderInfo.getContextID()) == 0)
		{
			fbo_light_texture->getTextureObject( renderInfo.getContextID() )->bind(); 			
			osg::FBOExtensions* fbo_ext = osg::FBOExtensions::instance(renderInfo.getContextID(),true);

			fbo_light_texture->setUseHardwareMipMapGeneration(true);
			fbo_light_texture->getTextureObject(renderInfo.getContextID())->bind();
			fbo_ext->__glewGenerateMipmap(fbo_light_texture->getTextureTarget());	

			GLint width = 1024;
			GLint height = 1024;
			glGetTexLevelParameteriv(GL_TEXTURE_2D, 0, GL_TEXTURE_WIDTH, &width);
			glGetTexLevelParameteriv(GL_TEXTURE_2D, 0, GL_TEXTURE_HEIGHT, &height);			
		
			osg::Image* image = new osg::Image();	
			image->readPixels(0, 0, width, height, GL_RGBA, GL_FLOAT); 
			GLfloat * p = (GLfloat*)image->getDataPointer();
		
			//float* p = new float[width*height*4];		
			//glGetTexImage(GL_TEXTURE_2D, 1, GL_RGBA, GL_FLOAT, p);	
			
			float pixel_add=0;
			for(int i = 0; i < width*height; i++)
				if(p[3+i*4]  > 0.f)	pixel_add++;//=p[3+i*4];						
			delete [] p;

			float dichte = pixel_add/(float)(width*height);	

			std::cerr << "*DICHTE: " << dichte << std::endl;		

	/*


		width = 1024/1;
		height = 1024/1;
		glGetTexLevelParameteriv(GL_TEXTURE_2D, 0, GL_TEXTURE_WIDTH, &width);
		glGetTexLevelParameteriv(GL_TEXTURE_2D, 0, GL_TEXTURE_HEIGHT, &height);			
		
		//image = new osg::Image();	
		//image->readPixels(0, 0, width, height, GL_RGBA, GL_FLOAT); 
		//p = (GLfloat*)image->getDataPointer();
		float* p2 = new float[width*height*4];		
		glGetTexImage(GL_TEXTURE_2D, 0, GL_RGBA, GL_FLOAT, p);	
					
		pixel_add=0;
		for(int i = 0; i < width*height; i++)
			if((float)(p2[3+i*4])  > 0.f)	pixel_add++;//=p[3+i*4];	
		
		delete [] p2;
		//glDisable(GL_TEXTURE_2D);
		dichte = pixel_add/(float)(width*height);	
		std::cout << "*DICHTE: " << dichte << std::endl;			



		width = 1024/4;
		height = 1024/4;
		glGetTexLevelParameteriv(GL_TEXTURE_2D, 2, GL_TEXTURE_WIDTH, &width);
		glGetTexLevelParameteriv(GL_TEXTURE_2D, 2, GL_TEXTURE_HEIGHT, &height);			
		std::cerr << "WIDTH: " << width << " " << height << std::endl;
					
		//image = new osg::Image();	
		//image->readPixels(0, 0, width, height, GL_RGBA, GL_FLOAT); 
		//p = (GLfloat*)image->getDataPointer();
		p2 = new float[width*height*4];
		glGetTexImage(GL_TEXTURE_2D, 2, GL_RGBA, GL_FLOAT, p2);		
			
		pixel_add=0;
		for(int i = 0; i < width*height; i++)
			if(p2[3+i*4]  > 0.f)	pixel_add++;//=p[3+i*4];		

		std::cout << "p[3+i*4]: " << p2[0]  << " " << p2[1] << " " << p2[2] << " " << p2[3] << std::endl;
		std::cout << "p[3+i*4]: " << (float)(p2[0])  << " " << (float)(p2[1]) << " " << (float)(p2[2]) << " " << (float)(p2[3]) << std::endl;

		delete [] p2;
		//glDisable(GL_TEXTURE_2D);
		dichte = pixel_add/(float)(width*height);	
		
		std::cout << "*DICHTE: " << dichte << std::endl;


		width = 1024/4;
		height = 1024/4;
		glGetTexLevelParameteriv(GL_TEXTURE_2D, 5, GL_TEXTURE_WIDTH, &width);
		glGetTexLevelParameteriv(GL_TEXTURE_2D, 5, GL_TEXTURE_HEIGHT, &height);			
		std::cerr << "WIDTH: " << width << " " << height << std::endl;
					
		//image = new osg::Image();	
		//image->readPixels(0, 0, width, height, GL_RGBA, GL_FLOAT); 
		//p = (GLfloat*)image->getDataPointer();
		p2 = new float[width*height*4];
		glGetTexImage(GL_TEXTURE_2D, 5, GL_RGBA, GL_FLOAT, p2);		
			
		pixel_add=0;
		for(int i = 0; i < width*height; i++)
			if(p2[3+i*4]  > 0.f)	pixel_add++;//=p[3+i*4];		

		std::cout << "p[3+i*4]: " << p2[0]  << " " << p2[1] << " " << p2[2] << " " << p2[3] << std::endl;
		std::cout << "p[3+i*4]: " << (float)(p2[0])  << " " << (float)(p2[1]) << " " << (float)(p2[2]) << " " << (float)(p2[3]) << std::endl;

		delete [] p2;
		//glDisable(GL_TEXTURE_2D);
		dichte = pixel_add/(float)(width*height);	
		
		std::cout << "*DICHTE: " << dichte << std::endl;



		width = 1024/4;
		height = 1024/4;
		glGetTexLevelParameteriv(GL_TEXTURE_2D, 8, GL_TEXTURE_WIDTH, &width);
		glGetTexLevelParameteriv(GL_TEXTURE_2D, 8, GL_TEXTURE_HEIGHT, &height);			
		std::cerr << "WIDTH: " << width << " " << height << std::endl;
					
		//image = new osg::Image();	
		//image->readPixels(0, 0, width, height, GL_RGBA, GL_FLOAT); 
		//p = (GLfloat*)image->getDataPointer();
		p2 = new float[width*height*4];
		glGetTexImage(GL_TEXTURE_2D, 8, GL_RGBA, GL_FLOAT, p2);		
			
		pixel_add=0;
		for(int i = 0; i < width*height; i++)
			if(p2[3+i*4]  > 0.f)	pixel_add++;//=p[3+i*4];		

		std::cout << "p[3+i*4]: " << p2[0]  << " " << p2[1] << " " << p2[2] << " " << p2[3] << std::endl;
		std::cout << "p[3+i*4]: " << (float)(p2[0])  << " " << (float)(p2[1]) << " " << (float)(p2[2]) << " " << (float)(p2[3]) << std::endl;

		delete [] p2;
		//glDisable(GL_TEXTURE_2D);
		dichte = pixel_add/(float)(width*height);	
		

		width = 1024/1;
		height = 1024/1;
		glGetTexLevelParameteriv(GL_TEXTURE_2D, 10, GL_TEXTURE_WIDTH, &width);
		glGetTexLevelParameteriv(GL_TEXTURE_2D, 10, GL_TEXTURE_HEIGHT, &height);			
					
		//image = new osg::Image();	
		//image->readPixels(0, 0, width, height, GL_RGBA, GL_FLOAT); 
		//p = (GLfloat*)image->getDataPointer();
		p2 = new float[width*height*4];
		glGetTexImage(GL_TEXTURE_2D, 10, GL_RGBA, GL_FLOAT, p2);		
			
		pixel_add=0;
		for(int i = 0; i < width*height; i++)
			if(p2[3+i*4]  > 0.f)	pixel_add++;//=p[3+i*4];		
		
		delete [] p2;		
		dichte = pixel_add/(float)(width*height);		
*/		
		//dichte = 1.f;		//ACHTUNG
		
		
			glDisable(GL_TEXTURE_2D);

			CloudScene::GetStates()->setMeasureOvercast(m_active_layer, dichte);		
			//////////////////////////////////								
		}
		else CloudScene::GetStates()->setMeasureOvercast(m_active_layer, 1.f);		
	
		fbo_shadow->apply(state, osg::FrameBufferObject::DRAW_FRAMEBUFFER);
		glClear( GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);	
	}
	else
	{
		osg::GL2Extensions* extension = osg::GL2Extensions::Get(0,true);

		fbo_shadow->apply(state, osg::FrameBufferObject::READ_DRAW_FRAMEBUFFER);		
		glViewport(0,0,1024, 1024);		
		
		glClearColor(0.f, 0.f, 0.f, 0.f);		
		glClear( GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
	
		fbo_hori_blur->apply(state, osg::FrameBufferObject::READ_DRAW_FRAMEBUFFER);																		
		glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);					

		fbo_vert_blur->apply(state, osg::FrameBufferObject::READ_DRAW_FRAMEBUFFER);																		
		glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);					

		fbo_cloud_viewer->apply(state, osg::FrameBufferObject::READ_DRAW_FRAMEBUFFER);
		glViewport(0,0,osgCloudyDay::Scene::GetWidth(), osgCloudyDay::Scene::GetHeight());
		glClearColor(0.f, 0.f, 0.f, 0.f);
		glClearDepth(1.0f);
		glClear( GL_COLOR_BUFFER_BIT);

		bool first=true;
		for(unsigned int primitiveSetNum=0; primitiveSetNum!= _primitives.size()-1; ++primitiveSetNum)
		{
			if (bindPerPrimitiveSetActive) 			
				arrayDispatchers.dispatch(BIND_PER_PRIMITIVE_SET, primitiveSetNum);
			
			const osg::PrimitiveSet* primitiveset = _primitives[primitiveSetNum].get();									
					
			if(!CloudScene::m_backtofront)		glBlendFunc(GL_ONE_MINUS_DST_ALPHA, GL_ONE); //bf_front_to_back->apply(state);	//FRONT TO BACK											
			else								glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA); //bf_back_to_front->apply(state);	//BACK TO FRONT						
															
			glEnable(GL_DEPTH_TEST);		
			glDepthFunc(GL_LEQUAL);
			glDepthMask(GL_FALSE);

			state.applyTextureMode(0, GL_TEXTURE_2D, true);
			state.applyTextureAttribute(0, tex_clouds);

			if(first)
			{
				state.applyTextureMode(1, GL_TEXTURE_2D, true);
				state.applyTextureAttribute(1, fbo_blur_texture);
			}
			fbo_cloud_viewer->apply(state, osg::FrameBufferObject::DRAW_FRAMEBUFFER);			
					
			sh_viewer->apply(state);		
			if(first)
			{
				projectuniform->apply(extension, state.getUniformLocation("project"));
				modelViewMatrixuniform->apply(extension, state.getUniformLocation("modelViewMatrix"));
				viewMatrixuniform->apply(extension, state.getUniformLocation("viewMatrix"));
				viewMatrixInvuniform->apply(extension, state.getUniformLocation("viewMatrixInv"));
			}
					
			glEnable(GL_BLEND);
			glViewport(0,0,osgCloudyDay::Scene::GetWidth(), osgCloudyDay::Scene::GetHeight());
					
			//depth2->apply(state);									
			primitiveset->draw(state, usingVertexBufferObjects);        	
								
			//LIGHT VIEW																			
			if(CloudScene::m_backtofront) glBlendFunc(GL_ONE_MINUS_DST_ALPHA, GL_ONE); //bf_front_to_back->apply(state);			//FRONT TO BACK
					
			//depth3->apply(state);
			glDepthFunc(GL_ALWAYS);
			glDepthMask(GL_TRUE);
							
			fbo_vert_blur->apply(state, osg::FrameBufferObject::DRAW_FRAMEBUFFER);																												
			sh_light->apply(state);							 
										
			if(first)
			{
				project_lightuniform->apply(extension, state.getUniformLocation("project_light"));
				modelViewMatrix_lightuniform->apply(extension, state.getUniformLocation("modelViewMatrix_light"));
				viewMatrix_lightuniform->apply(extension, state.getUniformLocation("viewMatrix_light"));
				viewMatrixInv_lightuniform->apply(extension, state.getUniformLocation("viewMatrixInv_light"));
			}

			glViewport(0,0,1024, 1024);
			primitiveset->draw(state, usingVertexBufferObjects);        		
					
			glDisable(GL_BLEND);				
			first=false;
	
			if(blur)
			{			
				state.applyTextureAttribute(0, fbo_blur_texture);
				sh_blur_linear_vert->apply(state);
				fbo_shadow->apply(state, osg::FrameBufferObject::DRAW_FRAMEBUFFER);								
				last_primitiveset->draw(state, usingVertexBufferObjects); 													

				state.applyTextureAttribute(0, fbo_light_texture);				
				sh_blur_linear_hori->apply(state);
				fbo_hori_blur->apply(state, osg::FrameBufferObject::DRAW_FRAMEBUFFER);								
				last_primitiveset->draw(state, usingVertexBufferObjects); 													
			}			
	
		}
	}	
	
	//std::cout << "end: "<<_primitives.size() << std::endl;
	if(!processing)
	{
		glEnable(GL_BLEND);
		glBlendFunc(GL_ONE, GL_ZERO);
		/////////////

		glViewport(0,0,1024,1024);				
						
		state.applyTextureMode(0, GL_TEXTURE_2D, true);				
		state.applyTextureAttribute(0, fbo_blur_texture);
		state.applyTextureMode(1, GL_TEXTURE_2D, true);
		state.applyTextureAttribute(1, fbo_light_depth);
		fbo_light_depth->apply(state);
		
		sh_shadow_map->apply(state);											

		fbo_hori_blur2->apply(state, osg::FrameBufferObject::DRAW_FRAMEBUFFER);											

		//depth3->apply(state);
		glDepthFunc(GL_ALWAYS);
		glDepthMask(GL_TRUE);

		last_primitiveset->draw(state, usingVertexBufferObjects); 					
		glDisable(GL_BLEND);
		/////////////
		
		state.applyTextureMode(1, GL_TEXTURE_2D, false);		
		state.applyTextureMode(0, GL_TEXTURE_2D, true);	
		state.applyTextureAttribute(0, fbo_light_texture);														
		osg::FBOExtensions::instance(0,true)->__glewGenerateMipmap(GL_TEXTURE_2D);
		glDepthFunc(GL_LEQUAL);
		glBlendFunc(GL_ONE, GL_ONE_MINUS_SRC_ALPHA); //bf_back_to_front->apply(state);
		

		//if(!blur)
		{			
			glDisable(GL_BLEND);

			state.applyTextureMode(1, GL_TEXTURE_2D, false);
			state.applyTextureAttribute(0, fbo_light_texture);
			sh_blur_linear_vert->apply(state);
			fbo_vert_linear_blur->apply(state, osg::FrameBufferObject::DRAW_FRAMEBUFFER);								
			glClear(GL_COLOR_BUFFER_BIT);					
			last_primitiveset->draw(state, usingVertexBufferObjects);

			state.applyTextureMode(1, GL_TEXTURE_2D, false);
			state.applyTextureAttribute(0, fbo_blur_texture);
			sh_blur_linear_hori->apply(state);
			fbo_hori_linear_blur->apply(state, osg::FrameBufferObject::DRAW_FRAMEBUFFER);				
			glClear(GL_COLOR_BUFFER_BIT);					
			last_primitiveset->draw(state, usingVertexBufferObjects); 																
		}
	}
	//state.applyTextureAttribute(0, fbo_light_texture);	

    // unbind the VBO's if any are used.
    state.unbindVertexBufferObject();
    state.unbindElementBufferObject();
	
    if (checkForGLErrors) state.checkGLErrors("end of Geometry::drawImplementation().");
}