#include "CloudGenerator.h"
#include "CloudScene.h"

osgCloudyDay::Export* osgCloudyDay::CloudGenerator::ex = new Export();
int osgCloudyDay::CloudGenerator::numClouds = 0;
float* osgCloudyDay::CloudGenerator::m_frands=0;
int osgCloudyDay::CloudGenerator::m_iterFloatRand = 0;

void osgCloudyDay::CloudGenerator::GenerateRandomNumber() 
{
	if(m_frands != 0) return;
	m_frands = new float[100*100*1000];
	for(int i = 0; i < (100*1000*100); i++)
		m_frands[i] = frand();	
}

float osgCloudyDay::CloudGenerator::GetRandomFloat()
{
	m_iterFloatRand++;
	if(m_iterFloatRand >= (100*1000*100)) m_iterFloatRand=1;
	return m_frands[m_iterFloatRand-1];
}

osgCloudyDay::CloudGenerator::CloudGenerator(osg::Vec4 layer) : m_density(layer)
{
	GenerateRandomNumber();
	dBoxes = (new osg::Geode());
	dBoxes_geometry  = (new osg::Geometry());
	dBoxes_vertices = new osg::Vec3Array();	

	//std::cout << "ENDE VON CLOUD GENERATOR CONSTRUCTOR" << std::endl;
}

osgCloudyDay::CloudGenerator::~CloudGenerator(void)
{	
	delete m_cloud;
	delete[] m_frands;

	//dBoxes_vertices->erase(dBoxes_vertices->begin(), dBoxes_vertices->end());
	//dBoxes_indices.erase(dBoxes_indices.begin(), dBoxes_indices.end());	
}

osgCloudyDay::WangCloud* osgCloudyDay::CloudGenerator::Create()
{
	return Create(osg::Vec3());
}


osgCloudyDay::WangCloud* osgCloudyDay::CloudGenerator::Create(osg::Vec3 middlepoint)
{
	m_middlepoint = middlepoint;
	m_cloud = new WangCloud(m_category);

	Initialize();
	m_cloud->Setup();		
	CloudGenerator::numClouds++;
	return m_cloud;
}

void osgCloudyDay::CloudGenerator::AddCloudBox(int box_iter, osg::Vec3 origin, osg::Vec3 sizes, osg::Vec3 cloud_size, osg::Vec3 jitter_sizes, bool buttom, float size_xy, osg::Vec4 min_max_scale, osg::Vec4 density)
{
	int startindex = m_cloud->GetVertices()->size();

	osg::Vec3 minpos;
	osg::Vec3 maxpos;

	//Mehrere Boxen machen, dann krieg ich die Shape
	//for(int y = 0; y < sizes.y(); y++)
	for(int z = 0; z < sizes.z(); z++)
	{
		for(int y = 0; y < sizes.y(); y++)
		{
			for(int x = 0; x < sizes.x(); x++)
			{
				osg::Vec3 p = osg::Vec3(x,y,z)-(sizes/2.0);				
				p.x() /= sizes.x()/2.f;
				p.y() /= sizes.y()/2.f;
				p.z() /= sizes.z()/2.f;
				//p = [-1,1]^3

				p.set( p.x() * cloud_size.x(), p.y() * cloud_size.y(), p.z() * cloud_size.z());

				osg::Vec3 jitter = osg::Vec3(	(GetRandomFloat()-0.5f)/0.5f*jitter_sizes.x(), 
												(GetRandomFloat()-0.5f)/0.5f*jitter_sizes.y(), 
												(GetRandomFloat()-0.5f)/0.5f*jitter_sizes.z());				

				osg::Vec3 pos = (origin+p+jitter);								
				

				//float s = frand()*150.f+0.f;
				float s = (GetRandomFloat()*0.4f+0.6f)*size_xy;
				float sx = s+(GetRandomFloat()*min_max_scale.x()+min_max_scale.y());
				float sy = s+(GetRandomFloat()*min_max_scale.z()+min_max_scale.w());
				float rot = GetRandomFloat()*2.f*PI;
				float cloudtype = floor(GetRandomFloat()*15.f);
								
				switch(m_category)
				{
				case CloudScene::CT_AltCumulusGenerator:
				{
					cloudtype = rand() % 6+4;														

					break;
				}
				case CloudScene::CT_Stratus:			
				case CloudScene::CT_AltStratus:
				case CloudScene::CT_Nimbostratus:				
				{									
					int r = 1;//rand() % 20;
					if((r >= 0 && r < 4) || (r >= 6 && r < 8) || (r >= 12))	cloudtype = 1+12;//(rand()%3)+12;	
					else													cloudtype = r;

					if(1/*rand()*/ % 4 == 1)					
						r = 1;//rand() % 20;									

					break;
				}				
				case CloudScene::CT_Cumolonimbus:
				case CloudScene::CT_Cumulus:
				case CloudScene::CT_StratoCumulusGenerator:				

					//if((x <= 2 || y <= 2 || x >= int(sizes.x()-3) || y >= int(sizes.x()-3)) && (rand() % 2) == 0)	cloudtype = 10;
					if(z <= 0 /* && (rand() % 5) != 0*/ && buttom)
					{
						int r = 1;//rand() % 10;

						if((r >= 4 && r <= 5) || r >= 8)	cloudtype = 15;
						else cloudtype = r;

						if(false && cloudtype == 15)
						{
							sx *= 3.0;
							sy *= 3.0;
							rot = (GetRandomFloat()-0.5f)*7.5f/180.f*PI;
						}
					}
					if(z >= (sizes.z()-1) && !buttom)
					{
						cloudtype = 1;//rand() % 8;
						//rot = (frand()-0.5f)*5.f/180.f*PI;
					}
					break;
				}
				
				osg::Vec4 geometry_infos = osg::Vec4(rot, sx, sy, density.w());				
				int cloudtype2 = ((int)cloudtype+8)%16;				

				m_cloud->GetVertices()->push_back(pos);
				m_cloud->GetRotation()->push_back(geometry_infos);
				m_cloud->GetIds()->push_back(osg::Vec4(cloudtype, cloudtype2, 0.5, 0.0));
				m_cloud->GetCenter()->push_back(osg::Vec4(origin.x(), origin.y(), origin.z(), 1.0));
				m_cloud->GetBoxCenters()->push_back(osg::Vec4(0.f, 0.f, 0.f, box_iter));				
				m_cloud->GetColor()->push_back(osg::Vec4(density.x(), density.y(), density.z(), 1.f));				

				minpos.x() = std::min(pos.x(), minpos.x());
				minpos.y() = std::min(pos.y(), minpos.y());
				minpos.z() = std::min(pos.z(), minpos.z());

				maxpos.x() = std::max(pos.x(), maxpos.x());
				maxpos.y() = std::max(pos.y(), maxpos.y());
				maxpos.z() = std::max(pos.z(), maxpos.z());
			}
		}
	}

	osg::Vec3 origin2 = (maxpos+minpos)/2.f;
	osg::Vec3 size2 = maxpos-origin2;
	m_cloud->AddBoundingBox(origin2, size2, startindex, (m_cloud->GetVertices()->size() - startindex));
	//std::cerr << "startindex: " << startindex << " " << (m_cloud->GetVertices()->size() - startindex) << std::endl;
}

void osgCloudyDay::CloudGenerator::AddCloudBox(CloudCreateVolume* volume, int box_iter, osg::Vec3 origin, osg::Vec3 sizes, osg::Vec3 cloud_size, osg::Vec3 jitter_sizes, bool buttom, osg::Vec4 density)
{
	//Mehrere Boxen machen, dann krieg ich die Shape
	//for(int y = 0; y < sizes.y(); y++)
	for(int z = 0; z < sizes.z(); z++)
	{
		for(int y = 0; y < sizes.y(); y++)
		{
			for(int x = 0; x < sizes.x(); x++)
			{
				osg::Vec3 p = (osg::Vec3((float)(x)/sizes.x(),(float)(y)/sizes.y(),(float)(z)/sizes.z())) - osg::Vec3(0.5f,0.5f,0.5f);
				p *= 2.f;
				p.set( p.x() * cloud_size.x(), p.y() * cloud_size.y(), p.z() * cloud_size.z());

				osg::Vec3 jitter = osg::Vec3(frand()*jitter_sizes.x(), frand()*jitter_sizes.y(), frand()*jitter_sizes.z());
				jitter = jitter - (jitter_sizes/2.0);

				osg::Vec3 pos = (origin+p+jitter);

				if(volume->PointInside(pos))
				{
					//std::cout << "ADD BOX" << std::endl;
					AddCloudBox(box_iter, origin, sizes, cloud_size, jitter_sizes, false, 100.f, osg::Vec4(5, 10, 5, 10), density);
					box_iter++;
				}
			}
		}
	}
}

void osgCloudyDay::CloudGenerator::EliminateRedudantSprites()
{
	int n = m_cloud->GetNumberOfBoundingBoxes()-1;
	for(int i = m_cloud->GetVertices()->size()-1; i >= 0; i--)
	{
		if(i < m_cloud->GetBoundingBoxStartIndex(n))	n--;

		for(int j = m_cloud->GetVertices()->size()-1; j >= 0; j--)
		{					
			switch(m_category)
			{
				case CloudScene::CT_Stratus:				
					//vorher 2
				if(i != j && (m_cloud->GetVertices()->at(i)-m_cloud->GetVertices()->at(j)).length() < (m_cloud->GetRotation()->at(i).z() / (2.0)))
				{				
					m_cloud->GetVertices()->erase(m_cloud->GetVertices()->begin()+i);
					m_cloud->GetRotation()->erase(m_cloud->GetRotation()->begin()+i);
					m_cloud->GetCenter()->erase(m_cloud->GetCenter()->begin()+i);
					m_cloud->GetIds()->erase(m_cloud->GetIds()->begin()+i);
					m_cloud->GetBoxCenters()->erase(m_cloud->GetBoxCenters()->begin()+i);
					m_cloud->GetColor()->erase(m_cloud->GetColor()->begin()+i);

					for(int m = 0; m < m_cloud->GetNumberOfBoundingBoxes(); m++)	
					{
						if(m_cloud->GetBoundingBoxEndIndex(m) > i)
							m_cloud->SetBoundingBoxEnd(m, m_cloud->GetBoundingBoxEndIndex(m)-1);					
						if(m_cloud->GetBoundingBoxStartIndex(m) > i)						
							m_cloud->SetBoundingBoxStart(m, m_cloud->GetBoundingBoxStartIndex(m)-1);																		
					}

					j = -1;
				}
				break;

				case CloudScene::CT_AltStratus:				
				if(i != j && (m_cloud->GetVertices()->at(i)-m_cloud->GetVertices()->at(j)).length() < (m_cloud->GetRotation()->at(i).z() / (2.0)))
				{				
					m_cloud->GetVertices()->erase(m_cloud->GetVertices()->begin()+i);
					m_cloud->GetRotation()->erase(m_cloud->GetRotation()->begin()+i);
					m_cloud->GetCenter()->erase(m_cloud->GetCenter()->begin()+i);
					m_cloud->GetIds()->erase(m_cloud->GetIds()->begin()+i);
					m_cloud->GetBoxCenters()->erase(m_cloud->GetBoxCenters()->begin()+i);
					m_cloud->GetColor()->erase(m_cloud->GetColor()->begin()+i);					

					for(int m = 0; m < m_cloud->GetNumberOfBoundingBoxes(); m++)	
					{
						if(m_cloud->GetBoundingBoxEndIndex(m) > i)
							m_cloud->SetBoundingBoxEnd(m, m_cloud->GetBoundingBoxEndIndex(m)-1);					
						if(m_cloud->GetBoundingBoxStartIndex(m) > i)
							m_cloud->SetBoundingBoxStart(m, m_cloud->GetBoundingBoxStartIndex(m)-1);					
					}

					j = -1;
				}
				break;

				case CloudScene::CT_Nimbostratus:				
				//vorher 2
				if(i != j && (m_cloud->GetVertices()->at(i)-m_cloud->GetVertices()->at(j)).length() < (m_cloud->GetRotation()->at(i).z() / (2.0)))
				{				
					m_cloud->GetVertices()->erase(m_cloud->GetVertices()->begin()+i);
					m_cloud->GetRotation()->erase(m_cloud->GetRotation()->begin()+i);
					m_cloud->GetCenter()->erase(m_cloud->GetCenter()->begin()+i);
					m_cloud->GetIds()->erase(m_cloud->GetIds()->begin()+i);
					m_cloud->GetBoxCenters()->erase(m_cloud->GetBoxCenters()->begin()+i);
					m_cloud->GetColor()->erase(m_cloud->GetColor()->begin()+i);					

					for(int m = 0; m < m_cloud->GetNumberOfBoundingBoxes(); m++)	
					{
						if(m_cloud->GetBoundingBoxEndIndex(m) > i)
							m_cloud->SetBoundingBoxEnd(m, m_cloud->GetBoundingBoxEndIndex(m)-1);					
						if(m_cloud->GetBoundingBoxStartIndex(m) > i)
							m_cloud->SetBoundingBoxStart(m, m_cloud->GetBoundingBoxStartIndex(m)-1);					
					}
					j = -1;
				}
				break;
				case CloudScene::CT_Cumulus:	
				case CloudScene::CT_Cumolonimbus:
					//vorher 7
					//nun Cumulus
				if(i != j && (m_cloud->GetVertices()->at(i)-m_cloud->GetVertices()->at(j)).length() < (m_cloud->GetRotation()->at(i).z() / (2.50)))
				{				
					m_cloud->GetVertices()->erase(m_cloud->GetVertices()->begin()+i);
					m_cloud->GetRotation()->erase(m_cloud->GetRotation()->begin()+i);
					m_cloud->GetCenter()->erase(m_cloud->GetCenter()->begin()+i);
					m_cloud->GetIds()->erase(m_cloud->GetIds()->begin()+i);
					m_cloud->GetBoxCenters()->erase(m_cloud->GetBoxCenters()->begin()+i);
					m_cloud->GetColor()->erase(m_cloud->GetColor()->begin()+i);

					for(int m = 0; m < m_cloud->GetNumberOfBoundingBoxes(); m++)	
					{
						if(m_cloud->GetBoundingBoxEndIndex(m) > i)
							m_cloud->SetBoundingBoxEnd(m, m_cloud->GetBoundingBoxEndIndex(m)-1);					
						if(m_cloud->GetBoundingBoxStartIndex(m) > i)
							m_cloud->SetBoundingBoxStart(m, m_cloud->GetBoundingBoxStartIndex(m)-1);					
					}
					j = -1;
				}
				break;
				case CloudScene::CT_StratoCumulusGenerator:
				if(i != j && (m_cloud->GetVertices()->at(i)-m_cloud->GetVertices()->at(j)).length() < (m_cloud->GetRotation()->at(i).z() / (3.0)))
				{				
					m_cloud->GetVertices()->erase(m_cloud->GetVertices()->begin()+i);
					m_cloud->GetRotation()->erase(m_cloud->GetRotation()->begin()+i);
					m_cloud->GetCenter()->erase(m_cloud->GetCenter()->begin()+i);
					m_cloud->GetIds()->erase(m_cloud->GetIds()->begin()+i);
					m_cloud->GetBoxCenters()->erase(m_cloud->GetBoxCenters()->begin()+i);
					m_cloud->GetColor()->erase(m_cloud->GetColor()->begin()+i);

					for(int m = 0; m < m_cloud->GetNumberOfBoundingBoxes(); m++)	
					{
						if(m_cloud->GetBoundingBoxEndIndex(m) > i)
							m_cloud->SetBoundingBoxEnd(m, m_cloud->GetBoundingBoxEndIndex(m)-1);					
						if(m_cloud->GetBoundingBoxStartIndex(m) > i)
							m_cloud->SetBoundingBoxStart(m, m_cloud->GetBoundingBoxStartIndex(m)-1);					
					}
					j = -1;
				}
				break;
				case CloudScene::CT_AltCumulusGenerator:
				if(i != j && (m_cloud->GetVertices()->at(i)-m_cloud->GetVertices()->at(j)).length() < (m_cloud->GetRotation()->at(i).z() / (10.0)))
				{				
					m_cloud->GetVertices()->erase(m_cloud->GetVertices()->begin()+i);
					m_cloud->GetRotation()->erase(m_cloud->GetRotation()->begin()+i);
					m_cloud->GetCenter()->erase(m_cloud->GetCenter()->begin()+i);
					m_cloud->GetIds()->erase(m_cloud->GetIds()->begin()+i);
					m_cloud->GetBoxCenters()->erase(m_cloud->GetBoxCenters()->begin()+i);
					m_cloud->GetColor()->erase(m_cloud->GetColor()->begin()+i);
					
					for(int m = 0; m < m_cloud->GetNumberOfBoundingBoxes(); m++)	
					{
						if(m_cloud->GetBoundingBoxEndIndex(m) > i)
							m_cloud->SetBoundingBoxEnd(m, m_cloud->GetBoundingBoxEndIndex(m)-1);					
						if(m_cloud->GetBoundingBoxStartIndex(m) > i)
							m_cloud->SetBoundingBoxStart(m, m_cloud->GetBoundingBoxStartIndex(m)-1);					
					}
					j = -1;
				}
				break;
			}					
		}
	}

	for(int m = m_cloud->GetNumberOfBoundingBoxes()-1; m >= 0; m--)	
	{
		if(m_cloud->GetBoundingBoxEndIndex(m) == m_cloud->GetBoundingBoxStartIndex(m))
		{
			std::cerr << "+++++" << std::endl;
			m_cloud->EraseBoundingBoxAtIndex(m);
		}
	}
}

void osgCloudyDay::CloudGenerator::DecideInsideOutside()
{	

	for(int i = m_cloud->GetVertices()->size()-1; i >= 0; i--)
	{
		osg::Vec3 center = osg::Vec3(m_cloud->GetBoxCenters()->at(i).x(), m_cloud->GetBoxCenters()->at(i).y(), m_cloud->GetBoxCenters()->at(i).z());
		bool outside = true;
		osg::Vec3 position = m_cloud->GetVertices()->at(i);

		osg::Vec3 posToCenter = center-position;

		for(int j = m_cloud->GetVertices()->size()-1; j >= 0 && !outside; j--)
		{
			osg::Vec3 position2 = m_cloud->GetVertices()->at(j);
			osg::Vec3 posToPos2 = position2-position;
			
			if(posToCenter * posToPos2 < 0.0)
			{
				outside = false;
			}
		}

		if(outside)
		{
			m_cloud->GetIds()->at(i).w() = 1.0;
		}
		else
		{
			m_cloud->GetIds()->at(i).w() = 0.0;
		}
	}
}

void osgCloudyDay::CloudGenerator::DoExport()
{
	//std::cout << "______________" << std::endl;
	//std::cout << "EXPORT CLOUDS" << std::endl;
	
	ex->Perform();	
	
	/*
	std::cout << "______________" << std::endl;
	std::cout << "IMPORT CLOUDS" << std::endl;
	ImportExport* im = new ImportClouds();
	im->Perform();
	std::cout << "______________" << std::endl;

	osg::ref_ptr<osg::Vec3Array> vertices2;
	osg::ref_ptr<osg::Vec4Array> rotation2;
	osg::ref_ptr<osg::Vec4Array> center2; 
	osg::ref_ptr<osg::Vec4Array> ids2;
	im->GetData(0, vertices2, rotation2, center2, ids2);*/
}

void osgCloudyDay::CloudGenerator::AddBox(osg::ref_ptr<osg::Vec3Array> boxt, osg::Vec3 posHelper, osg::Vec3 size)
{
	boxt->push_back(posHelper+osg::Vec3( size.x(), size.y(),-size.z()));
	boxt->push_back(posHelper+osg::Vec3(-size.x(), size.y(),-size.z()));
	boxt->push_back(posHelper+osg::Vec3(-size.x(), size.y(), size.z()));
	boxt->push_back(posHelper+osg::Vec3( size.x(), size.y(),-size.z()));
	boxt->push_back(posHelper+osg::Vec3(-size.x(), size.y(), size.z()));
	boxt->push_back(posHelper+osg::Vec3( size.x(), size.y(), size.z()));

	boxt->push_back(posHelper+osg::Vec3( size.x(),-size.y(), size.z()));
	boxt->push_back(posHelper+osg::Vec3(-size.x(),-size.y(), size.z()));
	boxt->push_back(posHelper+osg::Vec3(-size.x(),-size.y(),-size.z()));
	boxt->push_back(posHelper+osg::Vec3( size.x(),-size.y(), size.z()));
	boxt->push_back(posHelper+osg::Vec3(-size.x(),-size.y(),-size.z()));
	boxt->push_back(posHelper+osg::Vec3( size.x(),-size.y(),-size.z()));

	boxt->push_back(posHelper+osg::Vec3( size.x(), size.y(), size.z()));
	boxt->push_back(posHelper+osg::Vec3(-size.x(), size.y(), size.z()));
	boxt->push_back(posHelper+osg::Vec3(-size.x(),-size.y(), size.z()));
	boxt->push_back(posHelper+osg::Vec3( size.x(), size.y(), size.z()));
	boxt->push_back(posHelper+osg::Vec3(-size.x(),-size.y(), size.z()));
	boxt->push_back(posHelper+osg::Vec3( size.x(),-size.y(), size.z()));

	boxt->push_back(posHelper+osg::Vec3( size.x(),-size.y(),-size.z()));
	boxt->push_back(posHelper+osg::Vec3(-size.x(),-size.y(),-size.z()));
	boxt->push_back(posHelper+osg::Vec3(-size.x(), size.y(),-size.z()));
	boxt->push_back(posHelper+osg::Vec3( size.x(),-size.y(),-size.z()));
	boxt->push_back(posHelper+osg::Vec3(-size.x(), size.y(),-size.z()));
	boxt->push_back(posHelper+osg::Vec3( size.x(), size.y(),-size.z()));

	boxt->push_back(posHelper+osg::Vec3(-size.x(), size.y(), size.z()));
	boxt->push_back(posHelper+osg::Vec3(-size.x(), size.y(),-size.z()));
	boxt->push_back(posHelper+osg::Vec3(-size.x(),-size.y(),-size.z()));
	boxt->push_back(posHelper+osg::Vec3(-size.x(), size.y(), size.z()));
	boxt->push_back(posHelper+osg::Vec3(-size.x(),-size.y(),-size.z()));
	boxt->push_back(posHelper+osg::Vec3(-size.x(),-size.y(), size.z()));

	boxt->push_back(posHelper+osg::Vec3( size.x(), size.y(),-size.z()));
	boxt->push_back(posHelper+osg::Vec3( size.x(), size.y(), size.z()));
	boxt->push_back(posHelper+osg::Vec3( size.x(),-size.y(), size.z()));
	boxt->push_back(posHelper+osg::Vec3( size.x(), size.y(),-size.z()));
	boxt->push_back(posHelper+osg::Vec3( size.x(),-size.y(), size.z()));
	boxt->push_back(posHelper+osg::Vec3( size.x(),-size.y(),-size.z()));
}