#include "CloudCreatorWang.h"
#include "CloudScene.h"


osgCloudyDay::CloudCreatorWang::CloudCreatorWang(std::string path, osg::Vec3 middlepos, int type, osg::Vec4 layer) : CloudGenerator(layer), m_path(path), m_middlepos(middlepos)
{
	m_category = type;
}


osgCloudyDay::CloudCreatorWang::~CloudCreatorWang(void)
{
}


bool osgCloudyDay::CloudCreatorWang::Update()
{
	return false;
}

void osgCloudyDay::CloudCreatorWang::Initialize()
{
	osg::ref_ptr<osg::Node> quad = osgDB::readNodeFile(m_path);
	
	TraverseMesh bbox ;
	quad->accept( bbox  );
	std::vector<osg::BoundingBox> boundingboxes = bbox.getBoundBox();

	//std::cout <<"CloudCreatorWang" << std::endl;
	osg::Vec3 sizes = osg::Vec3(3, 3, 3);
	int num_boxes = 0;	
	
	//std::cout << "BOUNDINGBOX size: " << boundingboxes.size() << std::endl;
	for(std::vector<osg::BoundingBox>::iterator it = boundingboxes.begin(); it != boundingboxes.end(); it++)
	{
		osg::Vec3 posHelper = m_middlepos + osg::Vec3(it->xMin()*200.f,it->yMin()*200.f, it->zMin()*200.f);		
		osg::Vec3 size = osg::Vec3(it->xMax()-it->xMin(),it->yMax()-it->yMin(), it->zMax()-it->zMin());
		size *= 200.f;
		osg::Vec3 jitter_sizes(size.x()/sizes.x(), size.y()/sizes.y(), size.z()/sizes.z());	
		
		//std::cout << "POS: " << posHelper.x() << " " << posHelper.y() << " " << posHelper.z() << std::endl;		

		switch(m_category)
		{
		case CloudScene::CT_AltCumulusGenerator:
		case CloudScene::CT_Cumolonimbus:
		case CloudScene::CT_Cumulus:
		case CloudScene::CT_StratoCumulusGenerator:
			AddCloudBox(num_boxes, posHelper, sizes, size, jitter_sizes, true, 250.f, osg::Vec4(50.f, 150.f, 50.f, 150.f), m_density);
		default:
			AddCloudBox(num_boxes, posHelper, sizes, size, jitter_sizes, true, 500.f, osg::Vec4(50.f, 150.f, 50.f, 150.f), m_density);
		}
		num_boxes++;
		AddBox(dBoxes_vertices, posHelper, size);
	}

	EliminateRedudantSprites();	
	DecideInsideOutside();

	dBoxes_indices.resize(dBoxes_vertices->size());
	for(unsigned int i = 0; i < dBoxes_vertices->size(); i++)
	{
		dBoxes_indices[i] = i;
	}
	dBoxes_geometry->setVertexArray (dBoxes_vertices.get());
	dBoxes_geometry->addPrimitiveSet(
		new osg::DrawElementsUShort(osg::PrimitiveSet::TRIANGLES, dBoxes_vertices->size(), &dBoxes_indices[0])
	);
	dBoxes_geometry->getPrimitiveSet(0)->getDrawElements()->setDataVariance(osg::Object::STATIC);
	dBoxes->addDrawable(dBoxes_geometry.get());
	dBoxes->getOrCreateStateSet()->setMode(GL_CULL_FACE, osg::StateAttribute::OFF );
	dBoxes->setCullingActive(false);

	ex->AddCloud(m_cloud->GetVertices(), m_cloud->GetRotation(), m_cloud->GetColor(), m_cloud->GetCenter(), m_cloud->GetIds(), m_cloud->GetBoxCenters(), num_boxes);
}