#include "CloudCreator.h"
#include "ObjCloud.h"
#include "DataCloud.h"

osgCloudyDay::CloudCreator::CloudCreator(osg::ref_ptr<osg::Group>& _scene) : scene(_scene), cloud (new osg::Group), m_cloudscene(0), debugProg(new osg::Program)
{
}


osgCloudyDay::CloudCreator::~CloudCreator(void)
{
	delete m_cloudscene;
}

osgCloudyDay::CloudScene*& osgCloudyDay::CloudCreator::GetCloudScene()
{
	return m_cloudscene;
}

void osgCloudyDay::CloudCreator::Initialize(CloudState* clouds, Fog* fog)
{
	//CloudCreateVolume* m_createVol;
	//scene->addChild(m_createVol->LoadingVolume(""));			
	
	osg::ref_ptr<osg::Shader> debugvertShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/debug_shad.vert"));
	osg::ref_ptr<osg::Shader> debugfragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/debug_shad.frag"));
	debugProg->addShader(debugvertShader.get());
	debugProg->addShader(debugfragShader.get());	
	debugProg->addBindFragDataLocation("out_color", 0);
	debugProg->addBindFragDataLocation("out_color2", 1);
	
	CloudScene::LoadingShader();
	CloudScene::LoadingTexture();		
	
	m_cloudscene = new CloudScene();	
	m_cloudscene->SetFog(fog);
		
	unsigned int num_layers = 0;

	nodes_debug = new osg::Group();
	
	
	std::vector<unsigned int> layers = CloudScene::GetStates()->GetLayers();
	for(unsigned int j = 0; j < layers.size(); j++)
	{		
		unsigned int layerID = layers.at(j);		
		unsigned int type = CloudScene::GetStates()->GetType(layerID);
		m_cloudscene->AddLayer(layerID, type);

		for(unsigned int i = 0; i < CloudScene::GetStates()->GetEstimationOfNumberOfCloudsOfLayer(layerID); i++)
		{			
			CloudGenerator* m_cloud = 0;
			switch(type)
			{
			case CloudScene::CT_Cumulus:
				m_cloud = new CumulusGenerator(CloudScene::GetStates()->getColor(layerID));	
				//m_cloud = new CelluarAutomataGenerator(16,16,16);	
				break;
			case CloudScene::CT_Stratus:
				m_cloud = new StratusGenerator(CloudScene::GetStates()->getColor(layerID));
				//m_cloud = new CelluarAutomataGenerator(32,32,32);	
				break;
			case CloudScene::CT_StratoCumulusGenerator:
				m_cloud = new StratoCumulusGenerator(CloudScene::GetStates()->getColor(layerID));
				break;
			case CloudScene::CT_Nimbostratus:
				m_cloud = new NimbostratusGenerator(CloudScene::GetStates()->getColor(layerID));
				break;
			case CloudScene::CT_Cumolonimbus:
				m_cloud = new CumolonimbusGenerator(CloudScene::GetStates()->getColor(layerID));
				break;
			case CloudScene::CT_AltCumulusGenerator:
				m_cloud = new AltCumulusGenerator(CloudScene::GetStates()->getColor(layerID));
				break;
			case CloudScene::CT_AltStratus:
				m_cloud = new AltStratusGenerator(CloudScene::GetStates()->getColor(layerID));
				break;
			}			
						
			//nodes_debug->addChild(m_cloud->dBoxes);
			WangCloud* c = m_cloud->Create(m_cloudscene->CalculatePosition(layerID));
			m_cloudscene->AddCloud(c, layerID);
			c->SetCloudGenerator(m_cloud);
			//delete m_cloud;
		}		
		num_layers++;
	}

	for(int j = 0; j < clouds->GetNumberOfClouds(); j++)
	{	
		unsigned int layerID = num_layers;
		if(std::find(layers.begin(), layers.end(), layerID) == layers.end())
		{			
			m_cloudscene->AddLayer(layerID, clouds->GetCloudType(j));
			layers.push_back(layerID);
		}

		CloudGenerator* m_cloud;
		switch(clouds->GetCloudType(j))
		{
		case CloudScene::CT_Cumulus:
			switch(clouds->GetCloudGenerationType(j))
			{
			case CloudState::CStG_Standard:
				m_cloud = new CumulusGenerator(clouds->getColor(j));
				break;
			case CloudState::CStG_Simulation:
				m_cloud = new CelluarAutomataGenerator(64*2,64*2,20, CloudScene::CT_Cumulus, clouds->getColor(j));		
				break;
			case CloudState::CStG_Voxel:
				m_cloud = new CloudVoxel(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), 32,32,32, CloudScene::CT_Cumulus, clouds->getColor(j));
				break;
			case CloudState::CStG_Wang:
				m_cloud = new CloudCreatorWang(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), CloudScene::CT_Cumulus, clouds->getColor(j));
				break;
			case CloudState::CStG_Objs:
				m_cloud = new ObjCloud(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), CloudScene::CT_Cumulus, clouds->getColor(j));
				break;			
			}
			break;
		case CloudScene::CT_Stratus:
			switch(clouds->GetCloudGenerationType(j))
			{
			case CloudState::CStG_Standard:
				m_cloud = new StratusGenerator(clouds->getColor(j));
				break;
			case CloudState::CStG_Simulation:
				m_cloud = new CelluarAutomataGenerator(64*2,64*2,20, CloudScene::CT_Stratus, clouds->getColor(j));		
				break;
			case CloudState::CStG_Voxel:
				m_cloud = new CloudVoxel(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), 32,32,32, CloudScene::CT_Stratus, clouds->getColor(j));
				break;
			case CloudState::CStG_Wang:
				m_cloud = new CloudCreatorWang(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), CloudScene::CT_Stratus, clouds->getColor(j));
				break;
			case CloudState::CStG_Objs:
				m_cloud = new ObjCloud(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), CloudScene::CT_Stratus, clouds->getColor(j));
				break;
			}
			break;
		case CloudScene::CT_AltStratus:
			switch(clouds->GetCloudGenerationType(j))
			{
			case CloudState::CStG_Standard:
				m_cloud = new AltStratusGenerator(clouds->getColor(j));
				break;
			case CloudState::CStG_Simulation:
				m_cloud = new CelluarAutomataGenerator(64*2,64*2,20, CloudScene::CT_AltStratus, clouds->getColor(j));		
				break;
			case CloudState::CStG_Voxel:
				m_cloud = new CloudVoxel(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), 32,32,32, CloudScene::CT_AltStratus, clouds->getColor(j));
				break;
			case CloudState::CStG_Wang:
				m_cloud = new CloudCreatorWang(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), CloudScene::CT_AltStratus, clouds->getColor(j));
				break;
			case CloudState::CStG_Objs:
				m_cloud = new ObjCloud(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), CloudScene::CT_AltStratus, clouds->getColor(j));
				break;
			}
			break;
		case CloudScene::CT_StratoCumulusGenerator:			
			switch(clouds->GetCloudGenerationType(j))
			{
			case CloudState::CStG_Standard:
				m_cloud = new StratoCumulusGenerator(clouds->getColor(j));
				break;
			case CloudState::CStG_Simulation:
				m_cloud = new CelluarAutomataGenerator(64*2,64*2,20, CloudScene::CT_StratoCumulusGenerator, clouds->getColor(j));		
				break;
			case CloudState::CStG_Voxel:
				m_cloud = new CloudVoxel(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), 32,32,32, CloudScene::CT_StratoCumulusGenerator, clouds->getColor(j));
				break;
			case CloudState::CStG_Wang:
				m_cloud = new CloudCreatorWang(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), CloudScene::CT_StratoCumulusGenerator, clouds->getColor(j));
				break;
			case CloudState::CStG_Objs:
				m_cloud = new ObjCloud(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), CloudScene::CT_StratoCumulusGenerator, clouds->getColor(j));
				break;
			}
			break;
		case CloudScene::CT_Nimbostratus:			
			switch(clouds->GetCloudGenerationType(j))
			{
			case CloudState::CStG_Standard:
				m_cloud = new NimbostratusGenerator(clouds->getColor(j));
				break;
			case CloudState::CStG_Simulation:
				m_cloud = new CelluarAutomataGenerator(64*2,64*2,20, CloudScene::CT_Nimbostratus, clouds->getColor(j));		
				break;
			case CloudState::CStG_Voxel:
				m_cloud = new CloudVoxel(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), 32,32,32, CloudScene::CT_Nimbostratus, clouds->getColor(j));
				break;
			case CloudState::CStG_Wang:
				m_cloud = new CloudCreatorWang(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), CloudScene::CT_Nimbostratus, clouds->getColor(j));
				break;
			case CloudState::CStG_Objs:
				m_cloud = new ObjCloud(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), CloudScene::CT_Nimbostratus, clouds->getColor(j));
				break;
			}
			break;
		case CloudScene::CT_Cumolonimbus:
			switch(clouds->GetCloudGenerationType(j))
			{
			case CloudState::CStG_Standard:
				m_cloud = new CumolonimbusGenerator(clouds->getColor(j));
				break;
			case CloudState::CStG_Simulation:
				m_cloud = new CelluarAutomataGenerator(64*2,64*2,20, CloudScene::CT_Cumolonimbus, clouds->getColor(j));		
				break;
			case CloudState::CStG_Voxel:
				m_cloud = new CloudVoxel(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), 32,32,32, CloudScene::CT_Cumolonimbus, clouds->getColor(j));
				break;
			case CloudState::CStG_Wang:
				m_cloud = new CloudCreatorWang(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), CloudScene::CT_Cumolonimbus, clouds->getColor(j));
				break;
			case CloudState::CStG_Objs:
				m_cloud = new ObjCloud(clouds->GetPath(j), osg::Vec3(0.f, 0.f, 1000.f), CloudScene::CT_Cumolonimbus, clouds->getColor(j));
				break;
			}
			break;
		case CloudScene::CT_AltCumulusGenerator:
			m_cloud = new AltCumulusGenerator(clouds->getColor(j));
			break;
		}	

		if(clouds->GetCloudGenerationType(j) == CloudState::CStG_XML)
		{
			ImportExport* im = new ImportClouds();
			im->Perform();
			
			osg::ref_ptr<osg::Vec3Array> vertices=0;
			osg::ref_ptr<osg::Vec4Array> rotation=0;
			osg::ref_ptr<osg::Vec4Array> color=0;
			osg::ref_ptr<osg::Vec4Array> center=0; 
			osg::ref_ptr<osg::Vec4Array> ids=0;
			osg::ref_ptr<osg::Vec4Array> boxcenter=0;
			im->GetData(0, vertices, rotation, color, center, ids, boxcenter);	

			m_cloud = new DataCloud(vertices, rotation, color, center, ids, boxcenter);				
		}
					
		//nodes_debug->addChild(m_cloud->dBoxes);

		//WangCloud* c = m_cloud->Create(clouds->getMiddlePoint(j));
		WangCloud* c = m_cloud->Create();	
		c->SetCloudGenerator(m_cloud);
		m_cloudscene->AddCloud(c, layerID);	
		//delete m_cloud;				
	}

	//scene->addChild(nodes_debug);

	m_cloudscene->Create();	
	osg::Geode* n = m_cloudscene->quadBillBoard.get();		
	cloud->addChild(n);	
	
	
#ifdef SHADOW_MAPPING
	osg::Depth* depth2 = new osg::Depth(osg::Depth::ALWAYS, 0.0, 1.0, false);
	cloud->getOrCreateStateSet()->setAttribute(depth2);
#else	
	osg::BlendFunc* bf = new
	osg::BlendFunc(osg::BlendFunc::ONE, osg::BlendFunc::ONE_MINUS_SRC_ALPHA );
	cloud->getOrCreateStateSet()->setAttributeAndModes(bf);
    cloud->getOrCreateStateSet()->setRenderingHint(osg::StateSet::TRANSPARENT_BIN);
	osg::Depth* depth2 = new osg::Depth(osg::Depth::LEQUAL, 0.0, 1.0, false);
	cloud->getOrCreateStateSet()->setAttribute(depth2);
#endif

#ifdef CREATE_BOUNDINGBOX
	//std::cout << "Bounding Box start" << std::endl;
	//CREATE BOUNDING BOX
	for(int j = 0; j < layers.size(); j++)
	{		
		unsigned int layerID = layers.at(j);	
		
		for(int i = 0; i < CloudScene::GetStates()->getNumClouds(layerID); i++)
		{
			osg::Geode* bb = new osg::Geode();
			bb->addDrawable(m_cloudscene->CreateBBForCloud(i));

			osg::StateSet* bb_state = (bb->getOrCreateStateSet());

			/*
			//Attaching the shader program to the node
		 	bb_state->setAttribute(debugProg.get());

		    osg::PolygonMode * polygonMode = new osg::PolygonMode;     
		    polygonMode->setMode( osg::PolygonMode::FRONT_AND_BACK, osg::PolygonMode::LINE );
     
			bb_state->setAttributeAndModes( polygonMode,	osg::StateAttribute::OVERRIDE | osg::StateAttribute::ON );
	
			bb_state->addUniform(new osg::Uniform("ProjectionMatrix", Scene::GetProjectionMatrix_View()));
			bb_state->addUniform(new osg::Uniform("ModelViewMatrix", Scene::GetViewMatrix_View()));
			bb_state->addUniform(new osg::Uniform("ViewMatrix", Scene::GetViewMatrix_View()));
			bb_state->addUniform(new osg::Uniform("light_proj_matrix", Scene::GetProjectionMatrix_Light()));
			bb_state->addUniform(new osg::Uniform("light_mv_matrix", Scene::GetViewMatrix_Light()));
			bb->addCullCallback(new ViewerLightCallback);
			*/

			osg::PolygonMode * polygonMode = new osg::PolygonMode;     
			polygonMode->setMode( osg::PolygonMode::FRONT_AND_BACK, osg::PolygonMode::LINE );    
			bb_state->setAttributeAndModes( polygonMode,	osg::StateAttribute::OVERRIDE | osg::StateAttribute::ON );
	
			scene->addChild(bb); //damit bindet man die BB ein
		}
	}
	//std::cout << "Bounding Box end" << std::endl;
#endif

	osg::CullFace* cullcloud = new osg::CullFace();
	cullcloud->setMode(osg::CullFace::BACK);
	cloud->getOrCreateStateSet()->setAttributeAndModes(cullcloud, osg::StateAttribute::OFF);
	
	CloudScene::GetCloudCamera()->addChild(cloud);	
	//CloudGenerator::DoExport();
}

osg::Group* osgCloudyDay::CloudCreator::GetDebugBoxes()
{
	return nodes_debug;
}

void osgCloudyDay::CloudCreator::UpdateAddClouds()
{	
	if(m_cloudscene != 0  && m_cloudscene->cloud_layer_update != 0 && m_cloudscene->cloud_layer_update->CloudAdded() )
	{
#ifdef CREATE_BOUNDINGBOX
		osg::Geode* bb = new osg::Geode();
		bb->addDrawable(m_cloudscene->cloud_layer_update->bb_geo);
			
		osg::StateSet* bb_state = (bb->getOrCreateStateSet());

		//Attaching the shader program to the node
	 	bb_state->setAttribute(debugProg.get());
		
		osg::PolygonMode * polygonMode = new osg::PolygonMode;     
		polygonMode->setMode( osg::PolygonMode::FRONT_AND_BACK, osg::PolygonMode::LINE );    
		bb_state->setAttributeAndModes( polygonMode,	osg::StateAttribute::OVERRIDE | osg::StateAttribute::ON );
	
		/*bb_state->addUniform(new osg::Uniform("ProjectionMatrix", Scene::GetProjectionMatrix_View()));
		bb_state->addUniform(new osg::Uniform("ModelViewMatrix", osg::Matrixd()));
		bb_state->addUniform(new osg::Uniform("ViewMatrix", Scene::GetViewMatrix_View()));
		*/		
		//bb->addCullCallback(new ViewerLightCallback);
		scene->addChild(bb);

		m_cloudscene->cloud_layer_update->cloud_added = false;

#endif
	}
}

void osgCloudyDay::CloudCreator::CreateDummyObjectForShader(osg::ref_ptr<osg::Group> root)
{	
	osg::ref_ptr<osg::Geode> debug_geode = new osg::Geode;	

	// set up the Geometry.
	osg::ref_ptr<osg::Geometry> geom = new osgCloudyDay::DebugGeometry;

	osg::Vec3 size(1000000.f, 1000000.f, -100.f);
	osg::Vec3 width, depth, topleft;
	topleft = osg::Vec3( -size.x()/2.0, -size.y()/2.0, 400.0 );
	width = osg::Vec3( size.x(), 0.0, 0.0 );
	depth = osg::Vec3( 0.0, size.y(), 0.0 );

	osg::ref_ptr<osg::Vec3Array> coords = new osg::Vec3Array(4);		
	osg::ref_ptr<osg::Vec4Array> coords2 = new osg::Vec4Array(4);		
	osg::ref_ptr<osg::Vec4Array> coords3 = new osg::Vec4Array(4);		
	osg::ref_ptr<osg::Vec4Array> coords4 = new osg::Vec4Array(4);		
	osg::ref_ptr<osg::Vec4Array> coords5 = new osg::Vec4Array(4);		
	unsigned int* indices = new unsigned int[1];	

	coords->at(0) = (topleft);		
	coords->at(1) = (topleft+depth);
	coords->at(2) = (topleft+width+depth);
	coords->at(3) = (topleft+width);
	indices[0] = 0; 

	geom->setVertexArray(coords.get());
	geom->setVertexAttribArray(0, coords.get());
	geom->setVertexAttribBinding(0, osg::Geometry::BIND_PER_VERTEX);						
	
	geom->addPrimitiveSet(new osg::DrawElementsUInt(osg::PrimitiveSet::POINTS, 1, &indices[0]));
	geom->getPrimitiveSet(0)->getDrawElements()->setDataVariance(osg::Object::DYNAMIC);		
		
	geom->setUseVertexBufferObjects(true);
	geom->setSupportsDisplayList(false);		
	
	debug_geode->addDrawable( geom );				

	debug_geode->getOrCreateStateSet()->setAttribute(osgCloudyDay::CloudScene::cloudShadowProg);			
	debug_geode->getOrCreateStateSet()->addUniform(new osg::Uniform("project", osg::Matrixd()));
	debug_geode->getOrCreateStateSet()->addUniform(new osg::Uniform("project_light", osg::Matrixd()));
	debug_geode->getOrCreateStateSet()->addUniform(new osg::Uniform("inv_project_light", osg::Matrixd()));
	debug_geode->getOrCreateStateSet()->addUniform(new osg::Uniform("modelViewMatrix", osg::Matrixd()));
	debug_geode->getOrCreateStateSet()->addUniform(new osg::Uniform("modelViewMatrix_light", osg::Matrixd()));
	debug_geode->getOrCreateStateSet()->addUniform(new osg::Uniform("viewMatrix", osg::Matrixd()));
	debug_geode->getOrCreateStateSet()->addUniform(new osg::Uniform("viewMatrix_light", osg::Matrixd()));
	debug_geode->getOrCreateStateSet()->addUniform(new osg::Uniform("viewMatrixInv", osg::Matrixd()));
	debug_geode->getOrCreateStateSet()->addUniform(new osg::Uniform("viewMatrixInv_light", osg::Matrixd()));
	debug_geode->getOrCreateStateSet()->addUniform(new osg::Uniform("color_tex", 0));
	debug_geode->getOrCreateStateSet()->addUniform(new osg::Uniform("shadow_tex", 1));
	debug_geode->getOrCreateStateSet()->addUniform(new osg::Uniform("depth_tex", 2));
	debug_geode->getOrCreateStateSet()->setTextureAttribute( 0, osgCloudyDay::CloudScene::tex_clouds );
	debug_geode->getOrCreateStateSet()->setTextureAttribute( 1, osgCloudyDay::Scene::GetBlurTexture() );
	debug_geode->getOrCreateStateSet()->setTextureAttribute( 2, osgCloudyDay::Scene::GetShadowDepthTexture() );

	debug_geode->addCullCallback(new osgCloudyDay::CullDebugGeometryCallback);
		
	debug_geode->getDrawable(0)->asGeometry()->getPrimitiveSet(0)->dirty();
	geom->getVertexAttribArray(0)->dirty();
	geom->dirtyBound();
	debug_geode->getDrawable(0)->dirtyBound();
	debug_geode->dirtyBound();
	root->addChild(debug_geode);
}