#include "CloudCreateVolume.h"
#include <osg/Array>


osgCloudyDay::CloudCreateVolume::CloudCreateVolume(void)
{
}


osgCloudyDay::CloudCreateVolume::~CloudCreateVolume(void)
{
}

osg::Node* osgCloudyDay::CloudCreateVolume::LoadingVolume(std::string path)
{
	//std::cout << "...Loading Volume" << std::endl;
	//object = osgDB::readNodeFile("../data/models/star.obj");
	object = osgDB::readNodeFile(path/*"../data/models/standford_bunny.obj"*/);
	//std::cout << "...Loading Volume done" << std::endl;

	osg::Group* group = object->asGroup();
	if(!group) return 0;

	osg::Vec3 triangle[3];
	triangle[0] = osg::Vec3();
	triangle[1] = osg::Vec3();
	triangle[2] = osg::Vec3();

	for(unsigned int i = 0; i < group->getNumChildren(); i++)
	{
		osg::Node* g = group->getChild(i);

		osg::Geode* geode = g->asGeode();
		if(!geode) return 0;

		for(unsigned int j = 0; j < geode->getNumDrawables(); j++)
		{
			osg::Vec3 aabb_min = osg::Vec3( 999999.f, 999999.f, 999999.f);
			osg::Vec3 aabb_max = osg::Vec3(-999999.f,-999999.f,-999999.f);

			osg::Geometry* geo = geode->getDrawable(j)->asGeometry();

			if(geo)
			{
				osg::Vec3Array* vecarray = dynamic_cast<osg::Vec3Array*>(geo->getVertexArray());

				for(unsigned int k = 0; k < vecarray->size(); k++)
				{
					osg::Vec3 point = osg::Matrixd().scale(osg::Vec3(20.f, 20.f, 20.f)) * osg::Vec3(vecarray->at(k).x(), vecarray->at(k).y(), vecarray->at(k).z());

					if(aabb_min.x() > point.x()) aabb_min.x() = point.x();
					if(aabb_min.y() > point.y()) aabb_min.y() = point.y();
					if(aabb_min.z() > point.z()) aabb_min.z() = point.z();
					if(aabb_max.x() < point.x()) aabb_max.x() = point.x();
					if(aabb_max.y() < point.y()) aabb_max.y() = point.y();
					if(aabb_max.z() < point.z()) aabb_max.z() = point.z();
				}
			}
			m_aabb_boundbox.push_back(std::pair<osg::Vec3, osg::Vec3>(aabb_min, aabb_max));
		}
	}

	//std::cout << "...BoundingBoxes calculated" << std::endl;
	return object;
}

//Transformation in WorldCoordinates?!
bool osgCloudyDay::CloudCreateVolume::PointInside(osg::Vec3 point)
{
	osg::Vec3** ray = new osg::Vec3*[6];
	for(int i = 0; i < 6; i++) ray[i] = new osg::Vec3[2];

	ray[0][0] = point+osg::Vec3(0, 0, 0);
	ray[0][1] = point+osg::Vec3(0, 0, 100);
	ray[1][0] = point+osg::Vec3(0, 0, 0);
	ray[1][1] = point+osg::Vec3(0, 0,-100);
	ray[2][0] = point+osg::Vec3(0, 0, 0);
	ray[2][1] = point+osg::Vec3(0, 100, 0);
	ray[3][0] = point+osg::Vec3(0, 0, 0);
	ray[3][1] = point+osg::Vec3(0, -100, 0);
	ray[4][0] = point+osg::Vec3(0, 0, 0);
	ray[4][1] = point+osg::Vec3(100, 0, 0);
	ray[5][0] = point+osg::Vec3(0, 0, 0);
	ray[5][1] = point+osg::Vec3(-100, 0, 0);

	osg::Vec3 triangle[3];
	triangle[0] = osg::Vec3();
	triangle[1] = osg::Vec3();
	triangle[2] = osg::Vec3();

	osg::Group* group = object->asGroup();
	if(!group) return 0;

	int num_intersection[6];
	for(int i = 0; i < 6; i++) num_intersection[i] = 0;

	for(unsigned int i = 0; i < group->getNumChildren(); i++)
	{
		osg::Node* g = group->getChild(i);

		osg::Geode* geode = g->asGeode();
		if(!geode) return 0;

		for(unsigned int j = 0; j < geode->getNumDrawables(); j++)
		{
			osg::Geometry* geo = geode->getDrawable(j)->asGeometry();

			if(geo)
			{
				osg::Vec3Array* vecarray = dynamic_cast<osg::Vec3Array*>(geo->getVertexArray());

				for(unsigned int k = 0; k < geo->getNumPrimitiveSets(); k++)
				{
					osg::PrimitiveSet* primitveset = geo->getPrimitiveSet(k);
				
					//primitveset->getDrawElements()->getNumIndices()-3
					for(unsigned int l = 0; l < primitveset->getDrawElements()->getNumIndices()-2; )
					{
						if(primitveset->getMode() ==  GL_TRIANGLES || primitveset->getMode() == GL_TRIANGLE_STRIP)
						{
							osg::Vec3 p1 = vecarray->at(primitveset->getDrawElements()->getElement(l+0));
							osg::Vec3 p2 = vecarray->at(primitveset->getDrawElements()->getElement(l+1));
							osg::Vec3 p3 = vecarray->at(primitveset->getDrawElements()->getElement(l+2));

							triangle[0] = osg::Matrixd().scale(osg::Vec3(20.f, 20.f, 20.f)) * osg::Vec3(p1.x(), p1.y(), p1.z());
							triangle[1] = osg::Matrixd().scale(osg::Vec3(20.f, 20.f, 20.f)) * osg::Vec3(p2.x(), p2.y(), p2.z());
							triangle[2] = osg::Matrixd().scale(osg::Vec3(20.f, 20.f, 20.f)) * osg::Vec3(p3.x(), p3.y(), p3.z());
							
							for(int n = 0; n < 6; n++)
							{
								int intersection_result = intersect_RayTriangle(ray[n], triangle, point);
								if(intersection_result > 0)	num_intersection[n]++;
							}

							if(primitveset->getMode() ==  GL_TRIANGLES)	l+=3;
							if(primitveset->getMode() == GL_TRIANGLE_STRIP) l++;
						}
					}
				}
			}
		}
	}
	
	
	bool outside = false;
	for(int i = 0; i < 6; i++)
	{
		if(num_intersection[i] % 2 == 0) outside = true;
	}
	
	return !outside;
}