#include "CirrusStratus.h"


osgCloudyDay::CirrusStratus::CirrusStratus(osg::Vec3 position, osg::Vec2 size)
{
	Initialize(position, size);
}


osgCloudyDay::CirrusStratus::~CirrusStratus(void)
{
}

void osgCloudyDay::CirrusStratus::Initialize(osg::Vec3 position, osg::Vec2 size)
{
	SetGeometry(position, size);
	
	osg::Image* perlinImg  = osgDB::readImageFile( "../data/textures/cloud2d/cirrus3.bmp");
	osg::Image* perlinNormalImg  = osgDB::readImageFile( "../data/textures/cloud2d/cirrus3_n.bmp");
	
	Create(geode, perlinImg, perlinNormalImg);
}

void osgCloudyDay::CirrusStratus::SetupGeometry(osg::Vec3 position, osg::Vec2 size, osg::Vec3Array* coords, osg::Vec2Array* tcoords, osg::UIntArray* indices)
{	
	osg::Vec2 offset = osg::Vec2(-0.5f, -0.5f);			
	float tex_scale = 1.f;

	float a = 0.75f;
	float b = 0.75f;
	float c = 1.0f;
		
	for(int t = 0; t < 100; t++)
	{				
		float tf = (float)(t)/100.f;

		for(int s = 0; s < 100; s++)
		{			
			float sf = (float)(s)/100.f;				
			
			float x = sf + offset.x();
			float y = tf + offset.y();	
			float z = (((powf(y, 2.f)/pow(b, 2.f)) - (powf(x, 2.f)/pow(a, 2.f)))*c);
					
			x *= size.x();
			y *= size.y();
			z *= size.x()/100.f;

			coords->at(t*100+s) = osg::Vec3(x, y, z) + position;
			tcoords->at(t*100+s) = (osg::Vec2(sf*tex_scale, tf*tex_scale));

			if(t > 0 && s > 0)
			{
				indices->at( (6*(t-1)*99)+((s-1)*6)+0) = ((s-1)+((t-1)*100));
				indices->at( (6*(t-1)*99)+((s-1)*6)+1) = ((s-1)+(t*100));
				indices->at( (6*(t-1)*99)+((s-1)*6)+2) = (s+(t*100));

				indices->at( (6*(t-1)*99)+((s-1)*6)+3) = ((s-1)+((t-1)*100));
				indices->at( (6*(t-1)*99)+((s-1)*6)+4) = (s+(t*100));
				indices->at( (6*(t-1)*99)+((s-1)*6)+5) = (s+((t-1)*100));												
			}
		}
	}
}