#include "Cirrus.h"


osgCloudyDay::Cirrus::Cirrus(osg::Vec3 position, osg::Vec2 size)
{
	Initialize(position, size);
}


osgCloudyDay::Cirrus::~Cirrus(void)
{
}

void osgCloudyDay::Cirrus::Initialize(osg::Vec3 position, osg::Vec2 size)
{
	SetGeometry(position, size);
	
	osg::Image* perlinImg  = osgDB::readImageFile( "../data/textures/cloud2d/cirrus.bmp" );
	osg::Image* perlinNormalImg  = osgDB::readImageFile( "../data/textures/cloud2d/cirrus_n.bmp" );
	
	Create(geode, perlinImg, perlinNormalImg);
}

void osgCloudyDay::Cirrus::SetupGeometry(osg::Vec3 position, osg::Vec2 size, osg::Vec3Array* coords, osg::Vec2Array* tcoords, osg::UIntArray* indices)
{	
	osg::Vec2 offset = osg::Vec2(-0.5f, -0.5f);			
	float tex_scale = 2.f;

	float a = 0.75f;
	float b = 0.75f;
	float c = 1.0f;
		
	int n = 0;
	for(int t = 0; t < 100; t++)
	{				
		float tf = (float)(t)/100.f;

		for(int s = 0; s < 100; s++)
		{			
			float sf = (float)(s)/100.f;				
			
			float x = sf + offset.x();
			float y = tf + offset.y();	
			float z = (((powf(y, 2.f)/pow(b, 2.f)) - (powf(x, 2.f)/pow(a, 2.f)))*c);
					
			x *= size.x();
			y *= size.y();
			z *= size.x()/100.f;

			coords->at(t*100+s) = osg::Vec3(x, y, z) + position;
			tcoords->at(t*100+s) = (osg::Vec2(sf*tex_scale, tf*tex_scale));

			if(t > 0 && s > 0)
			{
				indices->at( n+0) = ((s-1)+((t-1)*100));
				indices->at( n+1) = ((s-1)+(t*100));
				indices->at( n+2) = (s+(t*100));

				indices->at( n+3) = ((s-1)+((t-1)*100));
				indices->at( n+4) = (s+(t*100));
				indices->at( n+5) = (s+((t-1)*100));								
				n+=6;
			}
		}
	}
}