#include "CSGObject.h"

tex_t operator*(double s, const tex_t &t) {
  return tex_t(t.u * s, t.v * s);
}

tex_t &operator+=(tex_t &t1, const tex_t &t2) {
  t1.u += t2.u;
  t1.v += t2.v;
  return t1;
}



osgCloudyDay::CSGObject::CSGObject(void)
{
}


osgCloudyDay::CSGObject::~CSGObject(void)
{
}

carve::mesh::MeshSet<3>* osgCloudyDay::CSGObject::SetGeometry(osg::Geometry *mesh)
{
	if(mesh == 0) return 0;
	
	std::vector<carve::mesh::MeshSet<3>::vertex_t> v;	

	osg::Vec3Array* vertexarray; 
	
	if(mesh->getVertexArray() != 0)
	{
		vertexarray = static_cast<osg::Vec3Array*>(mesh->getVertexArray());
		for(unsigned int i = 0; i < vertexarray->getNumElements(); i++)
		{
			v.push_back(carve::mesh::MeshSet<3>::vertex_t(carve::geom::VECTOR(vertexarray->at(i).x(), vertexarray->at(i).y(), vertexarray->at(i).z())));		
			//std::cout << " - " << vertexarray->at(i).x() << " " << vertexarray->at(i).y() << " " <<  vertexarray->at(i).z() << std::endl;
		}
	}
	
	std::vector<carve::mesh::MeshSet<3>::face_t *> faces;
	for(unsigned int i = 0; i < mesh->getNumPrimitiveSets(); i++)
	{
		bool upgedated = false;

		if(!upgedated)
		{
			upgedated = true;
			osg::DrawElementsUInt* face = static_cast<osg::DrawElementsUInt*>(mesh->getPrimitiveSet(i));
		
			for(unsigned int j = 2; face != 0&& j < face->size(); j+=3)
			{
				//faces.push_back(new carve::mesh::MeshSet<3>::face_t(&v.at(face->at(j-3)), &v.at(face->at(j-2)), &v.at(face->at(j-1)), &v.at(face->at(j)) ));
				faces.push_back(new carve::mesh::MeshSet<3>::face_t(&v.at(face->at(j-2)), &v.at(face->at(j-1)), &v.at(face->at(j)) ));
			}
		}	
		
		/*if(!upgedated)
		{
			upgedated = true;
			osg::DrawArrays* face = static_cast<osg::DrawArrays*>(mesh->getPrimitiveSet(i));					
			for(int j = 2; face != 0&& j < face->getCount(); j+=3)
			{	
				//faces.push_back(new carve::mesh::MeshSet<3>::face_t(&v.at(j-3), &v.at(j-2), &v.at(j-1), &v.at(j) ));				
				faces.push_back(new carve::mesh::MeshSet<3>::face_t(&v.at(j-2), &v.at(j-1), &v.at(j) ));				
			}
		}*/
	}
	return new carve::mesh::MeshSet<3>(faces);
}

osg::ref_ptr<osg::Geometry> osgCloudyDay::CSGObject::GetGeometry(carve::mesh::MeshSet<3> *mesh)
{	  	
	//if(mesh->isClosed()) std::cout << "MESH GESCHLOSSEN" << std::endl;

	osg::Vec3Array* vertices = new osg::Vec3Array(mesh->vertex_storage.size());

	//std::cout << "mesh->vertex_storage.size() :" << mesh->vertex_storage.size() << std::endl;
	for(unsigned int vertID = 0; vertID < mesh->vertex_storage.size(); vertID++)
	{
		vertices->at(vertID)  = osg::Vec3(	mesh->vertex_storage.at(vertID).v.x, 
										mesh->vertex_storage.at(vertID).v.y,
										mesh->vertex_storage.at(vertID).v.z);

//		std::cout << "V: " << mesh->vertex_storage.at(vertID).v.x  << " " << 
//										mesh->vertex_storage.at(vertID).v.y << " " << 
//										mesh->vertex_storage.at(vertID).v.z << std::endl;
	}

	//std::cout << "for loop" << std::endl;
	std::vector<unsigned int> m_ids;
	std::vector<unsigned int> indices;		
	for (carve::mesh::MeshSet<3>::face_iter i = mesh->faceBegin(); i != mesh->faceEnd(); ++i)
	{
		carve::mesh::MeshSet<3>::face_t *f = *i;  
	
		std::vector<carve::mesh::MeshSet<3>::vertex_t *> verts;
		f->getVertices(verts);		

		int count = 0;
		for (carve::mesh::MeshSet<3>::face_t::edge_iter_t e = f->begin(); e != f->end(); ++e) 
		{
			/*std::cout << "IDX: " << e.idx() << std::endl;
			std::cout << "POS: " << e.pos << std::endl;
			std::cout << "V: " << verts.at(e.idx())->v.v[0] << " " << verts.at(e.idx())->v.v[1] << " " << verts.at(e.idx())->v.v[2] << std::endl;
			std::cout << "VERTS: " << verts.at(e.idx())->v.x << " " << verts.at(e.idx())->v.y << " " << verts.at(e.idx())->v.z << std::endl;
			*/
						
			int id1 = -1;
			//std::cout << "----------" << std::endl;
			for(unsigned int it = 0; it < mesh->vertex_storage.size(); it++)
			{
				float x1 = abs(mesh->vertex_storage.at(it).v.x - verts.at(e.idx())->v.x);
				float y1 = abs(mesh->vertex_storage.at(it).v.y - verts.at(e.idx())->v.y);
				float z1 = abs(mesh->vertex_storage.at(it).v.z - verts.at(e.idx())->v.z);
				float xyz1 = x1+y1+z1;

				if(	xyz1 <= 0.001 ) id1 = it;
			}
			//std::cout << "ID: " << id1 << std::endl;
			//std::cout << "----------" << std::endl;

			//indices.push_back(id1);
			m_ids.push_back(id1);
			count++;
		}	

		for(int m = 0; m < count-2; m++)	//M = 0 wird gelscht
		{
			indices.push_back(m_ids.at(m));			//AKUTELLES
			indices.push_back(m_ids.at(m+1));		//EINES DAVOR
			indices.push_back(m_ids.at(count-1));	//EINES DAHINTER
		}
		m_ids.clear();

		//std::cout << "---" << std::endl;
		//std::cout << "COUNT: " << count << std::endl;			

	}
	//std::cout << "CREATE GEOM" << std::endl;

	osg::Geometry* geom = new osg::Geometry;		
	geom->addPrimitiveSet(
		new osg::DrawElementsUInt(osg::PrimitiveSet::TRIANGLES,
			(indices.size()),
			&indices[0])
	);
	geom->setVertexArray(vertices);

	//std::cout << "RETURN CSG Object" << std::endl;

	return osg::ref_ptr<osg::Geometry>(geom);
}

carve::mesh::MeshSet<3> *osgCloudyDay::CSGObject::texturedCube(
    carve::interpolate::FaceVertexAttr<tex_t> &fv_tex,
    carve::interpolate::FaceAttr<GLuint> &f_tex_num,
    const carve::math::Matrix &transform) 
{
	std::vector<carve::mesh::MeshSet<3>::vertex_t> v;
	v.push_back(carve::mesh::MeshSet<3>::vertex_t(transform * carve::geom::VECTOR(+1.0, +1.0, +1.0)));
	v.push_back(carve::mesh::MeshSet<3>::vertex_t(transform * carve::geom::VECTOR(-1.0, +1.0, +1.0)));
	v.push_back(carve::mesh::MeshSet<3>::vertex_t(transform * carve::geom::VECTOR(-1.0, -1.0, +1.0)));
	v.push_back(carve::mesh::MeshSet<3>::vertex_t(transform * carve::geom::VECTOR(+1.0, -1.0, +1.0)));
	v.push_back(carve::mesh::MeshSet<3>::vertex_t(transform * carve::geom::VECTOR(+1.0, +1.0, -1.0)));
	v.push_back(carve::mesh::MeshSet<3>::vertex_t(transform * carve::geom::VECTOR(-1.0, +1.0, -1.0)));
	v.push_back(carve::mesh::MeshSet<3>::vertex_t(transform * carve::geom::VECTOR(-1.0, -1.0, -1.0)));
	v.push_back(carve::mesh::MeshSet<3>::vertex_t(transform * carve::geom::VECTOR(+1.0, -1.0, -1.0)));

	std::vector<carve::mesh::MeshSet<3>::face_t *> faces;
	faces.reserve(6);
	faces.push_back(new carve::mesh::MeshSet<3>::face_t(&v[0], &v[1], &v[2], &v[3]));
	faces.push_back(new carve::mesh::MeshSet<3>::face_t(&v[7], &v[6], &v[5], &v[4]));
	faces.push_back(new carve::mesh::MeshSet<3>::face_t(&v[0], &v[4], &v[5], &v[1]));
	faces.push_back(new carve::mesh::MeshSet<3>::face_t(&v[1], &v[5], &v[6], &v[2]));
	faces.push_back(new carve::mesh::MeshSet<3>::face_t(&v[2], &v[6], &v[7], &v[3]));
	faces.push_back(new carve::mesh::MeshSet<3>::face_t(&v[3], &v[7], &v[4], &v[0]));
	
	/*
	for (size_t i = 0; i < 6; ++i) 
	{
		fv_tex.setAttribute(faces[i], 0, tex_t(0.0f, 1.0f));
		fv_tex.setAttribute(faces[i], 1, tex_t(1.0f, 1.0f));
		fv_tex.setAttribute(faces[i], 2, tex_t(1.0f, 0.0f));
		fv_tex.setAttribute(faces[i], 3, tex_t(0.0f, 0.0f));
		f_tex_num.setAttribute(faces[i], 0);
	}*/

	carve::mesh::MeshSet<3> *poly = new carve::mesh::MeshSet<3>(faces);

	return poly;
}
osg::ref_ptr<osg::Geometry> osgCloudyDay::CSGObject::Perform(osg::ref_ptr<osg::Geometry> m1, std::vector<osg::ref_ptr<osg::Geometry>> m2, unsigned int operation)
{
	//carve::mesh::MeshSet<3>* _m = SetGeometry(m1);
	//return GetGeometry(_m);

	carve::mesh::MeshSet<3>* _m1 = SetGeometry(m1);
	

	carve::mesh::MeshSet<3>* res;
	unsigned int m2size = m2.size();
	for(unsigned int i = 0; i < m2size; i++)
	{
		carve::mesh::MeshSet<3>* _m2 = SetGeometry(m2.at(i));						
		carve::csg::CSG* csg = new carve::csg::CSG();

		switch(operation)
		{
		case CSG_UNION:
			res = csg->compute(_m1, _m2, carve::csg::CSG::UNION);//, NULL, carve::csg::CSG::CLASSIFY_NORMAL);		
			break;
		case CSG_INTERSECT:		
			res = csg->compute(_m1, _m2, carve::csg::CSG::INTERSECTION, NULL, carve::csg::CSG::CLASSIFY_EDGE);
			break;
		case CSG_MERGE:
			{					
				carve::mesh::MeshSet<3>* r1 = csg->compute(_m1, _m2, carve::csg::CSG::SYMMETRIC_DIFFERENCE, NULL, carve::csg::CSG::CLASSIFY_EDGE);
				carve::mesh::MeshSet<3>* r2 = csg->compute(_m1, _m2, carve::csg::CSG::INTERSECTION, NULL, carve::csg::CSG::CLASSIFY_EDGE);				
				if(r2->vertex_storage.size() > 0)	res = csg->compute(r1, r2, carve::csg::CSG::UNION, NULL, carve::csg::CSG::CLASSIFY_EDGE);				
				else	res = r1;				

				delete r2;
				delete r1;
				
			}
			break;
		case CSG_A_MINUS_B:
			res = csg->compute(_m1, _m2, carve::csg::CSG::A_MINUS_B, NULL, carve::csg::CSG::CLASSIFY_EDGE);
			break;
		case CSG_B_MINUS_A:
			res = csg->compute(_m1, _m2, carve::csg::CSG::B_MINUS_A, NULL, carve::csg::CSG::CLASSIFY_EDGE);
			break;
		}

		delete csg;
		delete _m2;		
		delete _m1;		
		
		if(res->vertex_storage.size() > 0) 	
		{
			_m1 = res;//->clone();
		}
	}

	//std::cout << "ENDE" << std::endl;
	return GetGeometry(_m1);
}

osg::ref_ptr<osg::Geometry> osgCloudyDay::CSGObject::Perform(osg::Geometry* m1, osg::Geometry* m2, unsigned int operation)
{
	carve::mesh::MeshSet<3>* _m = SetGeometry(m2);
	return GetGeometry(_m);
	
	carve::mesh::MeshSet<3>* _m1 = SetGeometry(m1);
	carve::mesh::MeshSet<3>* _m2 = SetGeometry(m2);
	
	carve::csg::CSG csg;
	//fv_tex.installHooks(csg);
	//f_tex_num.installHooks(csg);

#if 1
	carve::mesh::MeshSet<3>* res;
	switch(operation)
	{
	case CSG_UNION:
		res = csg.compute(_m1, _m2, carve::csg::CSG::UNION, NULL, carve::csg::CSG::CLASSIFY_EDGE);		
		break;
	case CSG_INTERSECT:		
		res = csg.compute(_m1, _m2, carve::csg::CSG::INTERSECTION, NULL, carve::csg::CSG::CLASSIFY_EDGE);
		break;
	case CSG_MERGE:
		{
			carve::mesh::MeshSet<3>* r1 = csg.compute(_m1, _m2, carve::csg::CSG::SYMMETRIC_DIFFERENCE, NULL, carve::csg::CSG::CLASSIFY_EDGE);
			carve::mesh::MeshSet<3>* r2 = csg.compute(_m1, _m2, carve::csg::CSG::INTERSECTION, NULL, carve::csg::CSG::CLASSIFY_EDGE);
			res = csg.compute(r1, r2, carve::csg::CSG::UNION, NULL, carve::csg::CSG::CLASSIFY_EDGE);
		}
		break;
	case CSG_A_MINUS_B:
		res = csg.compute(_m1, _m2, carve::csg::CSG::A_MINUS_B, NULL, carve::csg::CSG::CLASSIFY_EDGE);
		break;
	case CSG_B_MINUS_A:
		res = csg.compute(_m1, _m2, carve::csg::CSG::B_MINUS_A, NULL, carve::csg::CSG::CLASSIFY_EDGE);
		break;
	}

	return GetGeometry(res);
#else
	return 0;
#endif
}

osg::Geometry* osgCloudyDay::CSGObject::TestScene()
{
	carve::interpolate::FaceVertexAttr<tex_t> fv_tex;
	carve::interpolate::FaceAttr<GLuint> f_tex_num;
	carve::mesh::MeshSet<3> *base = NULL;

	bool b = true;
	for (int x = -10; x <= +10; x += 5) {
		for (int y = -10; y <= +10; y += 5) {
			for (int z = -10; z <= +10; z += 5) {
				double rot = x * .17 + y * .06 + z * .09;
				carve::mesh::MeshSet<3> *r = texturedCube(fv_tex, f_tex_num, carve::math::Matrix::TRANS(x/2.5, y/2.5, z/2.5) *	carve::math::Matrix::ROT(rot, 1,2,3));
			
				if (base) 
				{
					carve::mesh::MeshSet<3> *temp = base;
					carve::csg::CSG csg;
					fv_tex.installHooks(csg);
					f_tex_num.installHooks(csg);
	
				    base = csg.compute(temp, r, carve::csg::CSG::UNION);
					delete temp;
					delete r;
				} 
				else 
				{
					base = r;
				}
			}
		}
	}

	carve::mesh::MeshSet<3> *r1 = texturedCube(fv_tex, f_tex_num, 
												carve::math::Matrix::TRANS(0,0,4) *
												carve::math::Matrix::SCALE(4,4,4));

	carve::mesh::MeshSet<3> *r2 = texturedCube(fv_tex, f_tex_num, 
						                        carve::math::Matrix::TRANS(0,0,5) *
											    carve::math::Matrix::SCALE(2, 2, 2));

	carve::csg::CSG csg;
	fv_tex.installHooks(csg);
	f_tex_num.installHooks(csg);

	carve::mesh::MeshSet<3> *r3 = csg.compute(base, r1, carve::csg::CSG::INTERSECTION, NULL, carve::csg::CSG::CLASSIFY_EDGE);
	carve::mesh::MeshSet<3> *r4 = csg.compute(r3, r2, carve::csg::CSG::UNION, NULL, carve::csg::CSG::CLASSIFY_EDGE);
	carve::mesh::MeshSet<3> *r5 = csg.compute(r3, r2, carve::csg::CSG::INTERSECTION, NULL, carve::csg::CSG::CLASSIFY_EDGE);
	carve::mesh::MeshSet<3> *r6 = csg.compute(r4, r5, carve::csg::CSG::A_MINUS_B, NULL, carve::csg::CSG::CLASSIFY_EDGE);
	//std::cout << "NUMBER OF VERTICES: " << (r3->vertex_storage.size()+r2->vertex_storage.size()) << std::endl;
	//std::cout << "NUMBER OF VERTICES: " << r4->vertex_storage.size() << std::endl;
	//std::cout << "NUMBER OF VERTICES: " << r6->vertex_storage.size() << std::endl;

	return GetGeometry(r6);
}

