#include "BlurShadow.h"

osgCloudyDay::BlurShadow::BlurShadow() : sh_blur_linear_vert1(0), sh_blur_linear_hori1(0), uniform_blur_texsize1(0), uniform_blur_texsize2(0), cam_hud(0), nodessP(0), planeProg(0)	
{
}


osgCloudyDay::BlurShadow::~BlurShadow(void)
{
}

void osgCloudyDay::BlurShadow::Initialize()
{
	CreateCamera();
	CreateGeometry(0);
	CreateGeometry(1);
}

osg::ref_ptr<osg::Camera> osgCloudyDay::BlurShadow::GetCamera()
{
	return cam_hud;
}

void osgCloudyDay::BlurShadow::CreateGeometry(int rendering)
{	
	osg::ref_ptr<osg::Geode> plane;
	plane = (new osg::Geode());
		
	osg::ref_ptr<osgCloudyDay::BlurShadowGeometry> geom;

	if(rendering==0)
	{			
		sh_blur_linear_vert1 = new osg::Program();
		osg::ref_ptr<osg::Shader> shadowvertShaderV(osg::Shader::readShaderFile (osg::Shader::VERTEX,	"shaders/linear_blur_vert3.vert"));
		osg::ref_ptr<osg::Shader> shadowfragShaderV(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/linear_blur_vert3.frag"));		
		sh_blur_linear_vert1->addShader(shadowvertShaderV.get());
		sh_blur_linear_vert1->addShader(shadowfragShaderV.get());	
		sh_blur_linear_vert1->addBindFragDataLocation("out_color", 0);
		sh_blur_linear_vert1->addBindAttribLocation("vertex", 0);

		nodessP = plane->getOrCreateStateSet();	
		uniform_blur_texsize1 = new osg::Uniform("texsize", (float)(osgCloudyDay::Scene::GetWidth()));
		uniform_blur_texsize1->setUpdateCallback(new UniformBlurShadowTexsize());
		nodessP->addUniform(uniform_blur_texsize1);

		geom = new osgCloudyDay::BlurShadowGeometry(sh_blur_linear_vert1, uniform_blur_texsize1, rendering);						
	}
	else
	{
		sh_blur_linear_hori1 = new osg::Program();
		osg::ref_ptr<osg::Shader> shadowvertShaderH(osg::Shader::readShaderFile (osg::Shader::VERTEX,	"shaders/linear_blur_hori3.vert"));
		osg::ref_ptr<osg::Shader> shadowfragShaderH(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/linear_blur_hori3.frag"));		
		sh_blur_linear_hori1->addShader(shadowvertShaderH.get());
		sh_blur_linear_hori1->addShader(shadowfragShaderH.get());	
		sh_blur_linear_hori1->addBindFragDataLocation("out_color", 0);	
		sh_blur_linear_hori1->addBindAttribLocation("vertex", 0);

		nodessP = plane->getOrCreateStateSet();	

		uniform_blur_texsize2 = new osg::Uniform("texsize", (float)(osgCloudyDay::Scene::GetWidth()));
		uniform_blur_texsize2->setUpdateCallback(new UniformBlurShadowTexsize());
		nodessP->addUniform(uniform_blur_texsize2);

		geom = new osgCloudyDay::BlurShadowGeometry(sh_blur_linear_hori1, uniform_blur_texsize2, rendering);						
	}
		
	osg::Vec3 width, depth, topleft;
	topleft = osg::Vec3(0.0, 0.0, 0.0 );
	width = osg::Vec3( 1.0, 0.0, 0.0 );
	depth = osg::Vec3( 0.0, 1.0, 0.0 );

	osg::ref_ptr<osg::Vec3Array> vertices = (new osg::Vec3Array());		
	vertices->push_back(topleft);
	vertices->push_back(topleft+depth);
	vertices->push_back(topleft+width+depth);
	vertices->push_back(topleft+width);	

	unsigned int* index = new unsigned int[4];
	index[0] = 0;	index[1] = 1;	index[2] = 2;		index[3] = 3;		

	geom->setVertexAttribArray(0, vertices.get());
	geom->setVertexAttribBinding(0, osg::Geometry::BIND_PER_VERTEX);				
		
	geom->addPrimitiveSet(new osg::DrawElementsUInt(osg::PrimitiveSet::QUADS, 4, &index[0]));
	geom->getPrimitiveSet(0)->getDrawElements()->setDataVariance(osg::Object::DYNAMIC);		
		
	geom->setUseVertexBufferObjects(true);
	geom->setSupportsDisplayList(false);		

	plane->addDrawable(geom.get());		
	plane->addCullCallback(new BlurCullCallback);

	plane->getDrawable(0)->asGeometry()->getPrimitiveSet(0)->dirty();
	geom->getVertexAttribArray(0)->dirty();
	geom->dirtyBound();
	plane->getDrawable(0)->dirtyBound();
	plane->dirtyBound();

	delete[] index;

	nodessP = plane->getOrCreateStateSet();	

	if(rendering==0)	
	{
		nodessP->setTextureAttributeAndModes(0, Scene::GetShadowTexture().get());		
		nodessP->setAttribute(sh_blur_linear_vert1.get());
	}
	else
	{
		nodessP->setTextureAttributeAndModes(0, Scene::GetBlurTexture().get());		
		nodessP->setAttribute(sh_blur_linear_hori1.get());
	}
	
	cam_hud->addChild(plane);	
}

void osgCloudyDay::BlurShadow::CreateCamera()
{
	std::cout << "void BlurShadow::CreateCamera()" << std::endl;
	osg::ref_ptr<osg::GraphicsContext::Traits> traits = new osg::GraphicsContext::Traits;
	traits->x = 20;
	traits->y = 20;
	traits->width = 800;
	traits->height = 600;
	traits->windowDecoration = true;
	traits->doubleBuffer = true;
	traits->sharedContext = 0;
	osg::ref_ptr<osg::GraphicsContext> gc = osg::GraphicsContext::createGraphicsContext(traits.get());

	cam_hud = new osg::Camera;
	cam_hud->setViewMatrix(osg::Matrixd().lookAt(osg::Vec3(2.0, 0.0, 0.0), osg::Vec3(0.f, 0.f ,0.f), osg::Vec3(0.f, 0.f, 1.f)));
	cam_hud->setProjectionMatrix(osg::Matrixd().ortho(-0.5f, 0.5f, -0.5f, 0.5f, 1.f, 100.f));
	cam_hud->setGraphicsContext(gc.get());
	cam_hud->setViewport(new osg::Viewport(0,0, traits->width, traits->height));

	GLenum buffer = traits->doubleBuffer ? GL_BACK : GL_FRONT;
	cam_hud->setDrawBuffer(buffer);
	cam_hud->setReadBuffer(buffer);
	cam_hud->setReferenceFrame(osg::Transform::ABSOLUTE_RF);
	cam_hud->setClearMask(GL_COLOR_BUFFER_BIT);
	cam_hud->setRenderOrder(osg::Camera::POST_RENDER,2);
	cam_hud->setAllowEventFocus(false);
	cam_hud->attach(osg::Camera::COLOR_BUFFER0, Scene::GetBlurTexture());
	cam_hud->getOrCreateStateSet()->setMode(GL_LIGHTING, osg::StateAttribute::OFF);
	cam_hud->setRenderTargetImplementation(osg::Camera::FRAME_BUFFER_OBJECT);
}