#include "Blur.h"


osgCloudyDay::Blur::Blur(int _renderorder)
{	
	renderorder = _renderorder;
}


osgCloudyDay::Blur::~Blur(void)
{
}


void osgCloudyDay::Blur::SetupTextures(osg::ref_ptr<osg::StateSet> nodessP)
{
	nodessP->setTextureAttributeAndModes(0, fbo_glare_texture.get());		
	nodessP->setTextureAttributeAndModes(1, fbo_glare_texture.get());	
}

void osgCloudyDay::Blur::SetupUniform(osg::ref_ptr<osg::StateSet> nodessP)
{	
	nodessP->setAttribute(sh_blur_linear.get());
	nodessP->addUniform(new osg::Uniform("color_tex", 0));
	nodessP->addUniform(new osg::Uniform("color_tex2", 1));
	nodessP->setTextureAttributeAndModes(0, fbo_glare_texture.get());		
	nodessP->setTextureAttributeAndModes(1, fbo_glare_texture.get());		

	uniform_blur_texsize = new osg::Uniform("texsize", (float)(osgCloudyDay::Scene::GetWidth()));
	uniform_blur_texsize->setUpdateCallback(new UniformBlurTexsize());
	nodessP->addUniform(uniform_blur_texsize);
}

void osgCloudyDay::Blur::CreateCamera()
{
	osg::ref_ptr<osg::GraphicsContext::Traits> traits = new osg::GraphicsContext::Traits;
	traits->x = 20;
	traits->y = 20;
	traits->width = osgCloudyDay::Scene::GetWidth();
	traits->height = osgCloudyDay::Scene::GetHeight();
	traits->windowDecoration = true;
	traits->doubleBuffer = true;
	traits->sharedContext = 0;
	osg::ref_ptr<osg::GraphicsContext> gc = osg::GraphicsContext::createGraphicsContext(traits.get());

	cam_hud = new osg::Camera;
	cam_hud->setViewMatrix(osg::Matrixd().lookAt(osg::Vec3(2.0, 0.0, 0.0), osg::Vec3(0.f, 0.f ,0.f), osg::Vec3(0.f, 0.f, 1.f)));
	cam_hud->setProjectionMatrix(osg::Matrixd().ortho(-0.5f, 0.5f, -0.5f, 0.5f, 1.f, 100.f));
	cam_hud->setGraphicsContext(gc.get());
	cam_hud->setViewport(new osg::Viewport(0,0, traits->width, traits->height));

	GLenum buffer = traits->doubleBuffer ? GL_BACK : GL_FRONT;
	cam_hud->setDrawBuffer(buffer);
	cam_hud->setReadBuffer(buffer);
	cam_hud->setReferenceFrame(osg::Transform::ABSOLUTE_RF);
	cam_hud->setClearMask(GL_COLOR_BUFFER_BIT);
	cam_hud->setRenderOrder(osg::Camera::POST_RENDER,renderorder+1);
	cam_hud->setAllowEventFocus(false);
	if(renderorder == 5)
	{
		cam_hud->attach(osg::Camera::COLOR_BUFFER0, HUD::fbo_blurH1_texture);	
		cam_hud->attach(osg::Camera::COLOR_BUFFER1, HUD::fbo_blurH1_texture);	
	}
	//cam_hud->attach(osg::Camera::COLOR_BUFFER0, Scene::fbo_blurH1_texture);	
	cam_hud->getOrCreateStateSet()->setMode(GL_LIGHTING, osg::StateAttribute::OFF);
	cam_hud->setRenderTargetImplementation(osg::Camera::FRAME_BUFFER_OBJECT);
	cam_hud->setImplicitBufferAttachmentMask(osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT, osg::Camera::IMPLICIT_COLOR_BUFFER_ATTACHMENT);
	cam_hud->setCullingActive(false);
}