#include "AtmosphereMie.h"


osgCloudyDay::AtmosphereMie::AtmosphereMie(void) : Atmosphere()
{
	m_fog = 0;
}


osgCloudyDay::AtmosphereMie::~AtmosphereMie(void)
{
}

void osgCloudyDay::AtmosphereMie::Initialize()
{
	//The Atmosphere
	athmosphere = new osg::Geode;
	osg::ref_ptr<osg::PolygonMode> sphere (new osg::PolygonMode);
	athmosphere->addDrawable(new osg::ShapeDrawable(new osg::Sphere(osg::Vec3(0,0,0), 20000.f)));
	nodessSkydome = (athmosphere->getOrCreateStateSet());
	//nodessSkydome->setRenderingHint(osg::StateSet::OPAQUE_BIN); 
	//Forcing the wireframe mode on this particular node (the Cube)
	nodessSkydome->setAttribute(sphere.get());
	//poly->setMode(osg::PolygonMode::FRONT_AND_BACK,osg::PolygonMode::LINE);
	//Its shader defn

	osg::ref_ptr<osg::Program> mieProg (new osg::Program);
	 osg::ref_ptr<osg::Shader> mievertShader(
      osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/mie.vert"));

	 osg::ref_ptr<osg::Shader> miefragShader(
      osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/mie.frag"));
	
	//Binding the box shaders to its program
	mieProg->addShader(mievertShader.get());
	mieProg->addShader(miefragShader.get());
	mieProg->addBindAttribLocation("vertex", 0);
	mieProg->addBindFragDataLocation("out_color", 0);
	mieProg->addBindFragDataLocation("out_color2", 1);

	//Attaching the shader program to the node
 	nodessSkydome->setAttribute(mieProg.get());
	
	athmosphere->addCullCallback(new AthmosphereCallback);
	//scene->addChild(athmosphere);
	//nodess7->setAttribute(fbo);

	nodessSkydome->addUniform(new osg::Uniform("ModelMatrix", Scene::GetViewMatrix_View()));
	nodessSkydome->addUniform(new osg::Uniform("ProjectionMatrix", Scene::GetProjectionMatrix_View()));
	nodessSkydome->addUniform(new osg::Uniform("ViewMatrix", Scene::GetViewMatrix_View()));						
	
	nodessSkydome->addUniform(new osg::Uniform("light_proj_matrix", Scene::GetProjectionMatrix_Light()));	
	nodessSkydome->addUniform(new osg::Uniform("light_mv_matrix", Scene::GetLightCamera()->getViewMatrix()));	

	nodessSkydome->addUniform(new osg::Uniform("v3LightPos", Scene::m_skydome->GetLightPosition()));

	Scene::m_skydome->SetupUniform(nodessSkydome);

	if(m_fog)
	{
		nodessSkydome->addUniform(new osg::Uniform("fogdensity", m_fog->GetFogDensity()));
		nodessSkydome->addUniform(new osg::Uniform("fogheight", m_fog->GetFogHeight()));
		//nodessSkydome->addUniform(new osg::Uniform("fogcolor", m_fog->GetFogColor()));
	}
	else
	{
		nodessSkydome->addUniform(new osg::Uniform("fogdensity", 0.f));
		nodessSkydome->addUniform(new osg::Uniform("fogheight", 0.f));
	}
	
	osg::CullFace* cull3 = new osg::CullFace();
	cull3->setMode(osg::CullFace::FRONT);
	nodessSkydome->setAttributeAndModes(cull3, osg::StateAttribute::ON);

	//
}