#include "AtmosphereHimmel.h"
#include <osg/Depth>

osgCloudyDay::AtmosphereHimmel::AtmosphereHimmel(void) : Atmosphere(), fbo_lightshaft1(0), fbo_lightshaft2(0), m_transmittance(0), m_irradiance(0), m_inscatter(0)
{
	m_fog = 0;
}


osgCloudyDay::AtmosphereHimmel::~AtmosphereHimmel(void)
{
}

void osgCloudyDay::AtmosphereHimmel::Initialize()
{
	//The Atmosphere
	athmosphere = (new osg::Geode);

	osg::ref_ptr<osg::Image> img_glare (osgDB::readImageFile("../data/textures/atmosphere/sunglare.bmp"));
	osg::Texture2D* glare_tex = (new osg::Texture2D);
	glare_tex->setWrap(osg::Texture::WRAP_S, osg::Texture::CLAMP_TO_EDGE);
	glare_tex->setWrap(osg::Texture::WRAP_T, osg::Texture::CLAMP_TO_EDGE);
	//glare_tex->setSourceFormat(GL_RGB);
	//glare_tex->setInternalFormat(GL_RGB8);
	glare_tex->setFilter(osg::Texture::MAG_FILTER, osg::Texture::LINEAR);
	glare_tex->setFilter(osg::Texture::MIN_FILTER, osg::Texture::LINEAR_MIPMAP_LINEAR);
	glare_tex->setImage(img_glare.get());

	
	osg::Geometry* geom = new osg::Geometry;

	const float Size = 	1.0f;

	osg::Vec3 width, depth, topleft;
	topleft = osg::Vec3( -Size, -Size, 0.f );
	width = osg::Vec3( Size*2.0, 0.0f, 0.0f );
	depth = osg::Vec3( 0.0f,  Size*2.0, 0.f );

	osg::Vec3Array* coords = new osg::Vec3Array(4);
	(*coords)[0] = topleft;		
	(*coords)[1] = topleft+depth;
	(*coords)[2] = topleft+width+depth;
	(*coords)[3] = topleft+width;
		
	geom->setVertexArray(coords);
	geom->setVertexAttribData( 0, osg::Geometry::ArrayData( coords, osg::Geometry::BIND_PER_VERTEX, GL_FALSE ) );
	geom->setUseDisplayList(false);
	geom->addPrimitiveSet( new osg::DrawArrays( osg::PrimitiveSet::QUADS, 0 , coords->size() ) );
	athmosphere->addDrawable( geom );
	
	athmosphere->setCullingActive(false); 
	nodessSkydome = (athmosphere->getOrCreateStateSet());	

	osg::ref_ptr<osg::Program> athmosphereProg (new osg::Program);
	osg::ref_ptr<osg::Shader> atmoshperevertShader(osg::Shader::readShaderFile (osg::Shader::VERTEX, "shaders/atmosphere.vert"));
	osg::ref_ptr<osg::Shader> atmoshperefragShader(osg::Shader::readShaderFile (osg::Shader::FRAGMENT, "shaders/atmosphere.frag"));
	
	//Binding the box shaders to its program
	athmosphereProg->addShader(atmoshperevertShader.get());
	athmosphereProg->addShader(atmoshperefragShader.get());
	athmosphereProg->addBindAttribLocation("vertex", 0);
	athmosphereProg->addBindFragDataLocation("out_color", 0);
	athmosphereProg->addBindFragDataLocation("out_color2", 1);

	//Attaching the shader program to the node
 	nodessSkydome->setAttribute(athmosphereProg.get());
	
	athmosphere->addCullCallback(new AthmosphereCallback);	
	
	//nodess7->setAttribute(fbo);
	nodessSkydome->addUniform(new osg::Uniform("ModelMatrix", Scene::GetViewMatrix_View()));
	nodessSkydome->addUniform(new osg::Uniform("ProjectionMatrix", Scene::GetProjectionMatrix_View()));
	nodessSkydome->addUniform(new osg::Uniform("ViewMatrix", Scene::GetViewMatrix_View()));						
	
	nodessSkydome->addUniform(new osg::Uniform("light_proj_matrix", Scene::GetProjectionMatrix_Light()));	
	nodessSkydome->addUniform(new osg::Uniform("light_mv_matrix", Scene::GetLightCamera()->getViewMatrix()));	

	nodessSkydome->addUniform(new osg::Uniform("transmittanceSampler", 9));			
	nodessSkydome->addUniform(new osg::Uniform("skyIrradianceSampler", 10));			
	nodessSkydome->addUniform(new osg::Uniform("inscatterSampler", 11));							
	nodessSkydome->addUniform(new osg::Uniform("glareSampler", 8));	
	nodessSkydome->addUniform(new osg::Uniform("deltaAdd_tex", 13));							
	nodessSkydome->addUniform(new osg::Uniform("deltaMult_tex", 14));									

	if(m_fog)
	{
		nodessSkydome->addUniform(new osg::Uniform("fogdensity", m_fog->GetFogDensity()));
		nodessSkydome->addUniform(new osg::Uniform("fogheight", m_fog->GetFogHeight()));
	}
	else
	{
		nodessSkydome->addUniform(new osg::Uniform("fogdensity", 0.f));
		nodessSkydome->addUniform(new osg::Uniform("fogheight", 0.f));
	}

    nodessSkydome->setAttributeAndModes(new osg::Depth(osg::Depth::ALWAYS, 1.0, 1.0), osg::StateAttribute::ON);
	
	nodessSkydome->setTextureAttributeAndModes(8,glare_tex);	
	nodessSkydome->setTextureAttributeAndModes(9,m_transmittance);		
	nodessSkydome->setTextureAttributeAndModes(10,m_irradiance);		
	nodessSkydome->setTextureAttributeAndModes(11,m_inscatter);			

	if(fbo_lightshaft1) nodessSkydome->setTextureAttributeAndModes(13,fbo_lightshaft1);		
	if(fbo_lightshaft2) nodessSkydome->setTextureAttributeAndModes(14,fbo_lightshaft2);		

	nodessSkydome->setAttributeAndModes(new osg::CullFace(), osg::StateAttribute::OFF);	

	
}