#include "AltCumulusGenerator.h"
#include "CloudScene.h"

osgCloudyDay::AltCumulusGenerator::AltCumulusGenerator(osg::Vec4 layer) : CloudGenerator(layer)
{
	m_category = CloudScene::CT_AltCumulusGenerator;
}


osgCloudyDay::AltCumulusGenerator::~AltCumulusGenerator(void)
{
}

bool osgCloudyDay::AltCumulusGenerator::Update()
{
	return false;
}

void osgCloudyDay::AltCumulusGenerator::Initialize()
{	
	osg::Vec3 randVer = m_middlepoint;	
	osg::Vec3 sizes = osg::Vec3(3, 3, 2);
	
	//std::cout << "Create Humilis" << std::endl;
	int XM = 4;
	int YM = 4;
	int ZM = 2;
	int num_boxes=0;

	for(int z = 0; z < 1; z++)
	{
		for(int y = -1; y < 2; y++)
		{
			for(int x = -1; x < 2; x++)
			{
				//if((y != 0 && y != (YM-1) && x < 2 && x > (XM-3)) || (rand() % (z+1)) <= 1)
				if((rand() % 12) <= (5-z))
				{
					osg::Vec3 posHelper = randVer + osg::Vec3(x*300.f, y*300.f, z*300.f);

					osg::Vec3 size = osg::Vec3();
					size.x() = 270.0f+(std::max(frand(),0.5f)*80.f);
					size.y() = 270.0f+(std::max(frand(),0.5f)*80.f);
					size.z() = 240.0f+(std::max(frand(),0.5f)*80.f);

					AddCloudBox(num_boxes, posHelper, sizes, size, size, z == 0, 400.f, osg::Vec4(10.f, 20.f, 10.f, 20.f), m_density);
					num_boxes++;
					AddBox(dBoxes_vertices, posHelper, size);
				}
			}
		}
	}
	//std::cout << "Humilis created: " << num_boxes << std::endl;
	
	EliminateRedudantSprites();	
	
	dBoxes_indices.resize(dBoxes_vertices->size());
	for(unsigned int i = 0; i < dBoxes_vertices->size(); i++)
	{
		dBoxes_indices[i] = i;
	}
	dBoxes_geometry->setVertexArray (dBoxes_vertices.get());
	dBoxes_geometry->addPrimitiveSet(
		new osg::DrawElementsUShort(osg::PrimitiveSet::TRIANGLES, dBoxes_vertices->size(), &dBoxes_indices[0])
	);
	dBoxes_geometry->getPrimitiveSet(0)->getDrawElements()->setDataVariance(osg::Object::STATIC);
	dBoxes->addDrawable(dBoxes_geometry.get());
	dBoxes->getOrCreateStateSet()->setMode(GL_CULL_FACE, osg::StateAttribute::OFF );
	dBoxes->setCullingActive(false);
	//dBoxes->getOrCreateStateSet()->setMode(GL_FRONT_AND_BACK, osg::PolygonMode::LINE );

	ex->AddCloud(m_cloud->GetVertices(), m_cloud->GetRotation(), m_cloud->GetColor(), m_cloud->GetCenter(), m_cloud->GetIds(), m_cloud->GetBoxCenters(), num_boxes);

}