#version 330 core
#extension GL_EXT_geometry_shader4 : enable
layout (points) in;
layout (triangle_strip, max_vertices = 4) out;

uniform mat4 ProjectionMatrix;
uniform mat4 ViewMatrix;
uniform mat4 ModelMatrix;

in vec4 ex_vd_velocity[];
in vec4 ex_vd_information[];

out vec2 ex_texCoord;
out vec4 ex_information;
out vec4 ex_velocity;
out vec3 ex_eyeVector;

out vec3 p;

void main()                                                   
{
	//float cbeta = cos(ex_vd_center[0].w);	float sbeta = sin(ex_vd_center[0].w);
	float cbeta = cos(0.0);	float sbeta = sin(0.0);
	mat2 rot = mat2(1.0, 0.0, 0.0, 1.0); //mat2(cbeta, -sbeta, sbeta, cbeta);
		
	vec3 pos = (ViewMatrix*gl_PositionIn[0]).xyz; // eye space

	// rotation
	vec2 s = vec2(0.032, 1.0);	
	//float x1 = ex_vd_size[0].x*s.x; float y1 = ex_vd_size[0].y*s.y; vec2 t1 = rot*vec2(-x1,-y1); vec2 t2 = rot*vec2(-x1, y1); vec2 t3 = rot*vec2( x1,-y1); vec2 t4 = rot*vec2( x1, y1);
	float x1 = 20.0*s.x; float y1 = 20.0*s.y; vec2 t1 = rot*vec2(-x1,-y1); vec2 t2 = rot*vec2(-x1, y1); vec2 t3 = rot*vec2( x1,-y1); vec2 t4 = rot*vec2( x1, y1);
		
	/*
	vec4 v1 = vec4(pos.x+t1.x, pos.y+t1.y, pos.z, 1.0);
	vec4 v2 = vec4(pos.x+t2.x, pos.y+t2.y, pos.z, 1.0);
	vec4 v3 = vec4(pos.x+t3.x, pos.y+t3.y, pos.z, 1.0);
	vec4 v4 = vec4(pos.x+t4.x, pos.y+t4.y, pos.z, 1.0);
	/*/
	vec4 v1 = vec4(pos.x-x1, pos.y-y1, pos.z, 1.0);
	vec4 v2 = vec4(pos.x-x1, pos.y+y1, pos.z, 1.0);
	vec4 v3 = vec4(pos.x+x1, pos.y-y1, pos.z, 1.0);
	vec4 v4 = vec4(pos.x+x1, pos.y+y1, pos.z, 1.0);
	
	mat4 transformation = ProjectionMatrix*ViewMatrix;
	mat4 viewMatrixInv = inverse(ViewMatrix);
		
	vec3 eyePos = (viewMatrixInv * vec4(0.0,0.0,0.0,1.0)).xyz;
		
	vec4 pw = viewMatrixInv*v1;
	ex_texCoord = vec2(0.0, 0.0);	
	ex_information = ex_vd_information[0];	
	ex_velocity = ex_vd_velocity[0];	
	ex_eyeVector = normalize(pos.xyz-eyePos);
	gl_Position = transformation * pw;
	EmitVertex();
	
	pw = viewMatrixInv*v2;
	ex_texCoord = vec2(0.0, 1.0);		
	ex_information = ex_vd_information[0];	
	ex_velocity = ex_vd_velocity[0];	
	ex_eyeVector = normalize(pos.xyz-eyePos);
	gl_Position = transformation * pw;
	EmitVertex();
	
	pw = viewMatrixInv*v3;
	ex_texCoord = vec2(1.0, 0.0);      
	ex_information = ex_vd_information[0];	
	ex_velocity = ex_vd_velocity[0];	
	ex_eyeVector = normalize(pos.xyz-eyePos);
	gl_Position = transformation * pw;
	EmitVertex();
	
	pw = viewMatrixInv*v4;
	ex_texCoord = vec2(1.0, 1.0);	
	ex_information = ex_vd_information[0];	
	ex_velocity = ex_vd_velocity[0];	
	ex_eyeVector = normalize(pos.xyz-eyePos);
	gl_Position =  transformation * pw;
	EmitVertex();
}  