#version 330 compatibility 

uniform mat4 light_proj_matrix;
uniform mat4 light_mv_matrix;
uniform mat4 ProjectionMatrix;
uniform mat4 ViewMatrix;
uniform mat4 ModelMatrix;

layout(location=0) in vec4 vertex;
layout(location=1) in vec4 tex;
layout(location=5) in vec4 normal;
layout (location = 6) in vec4 in_tangent;
layout (location = 7) in vec4 in_binormal;
out vec3 p;
out vec3 n;
out vec2 uv;
out vec4 fragC;
out vec4 viewPos;

out vec4 ex_shadowCoord;
out float ex_lightdistance;
out float ex_lightdistance2;

out vec3 lightVec;
out vec3 eyeVec;

uniform mat4 osg_ViewMatrix;

void main() 
{	
	mat4 tmpModelMatrix = inverse(osg_ViewMatrix) * gl_ModelViewMatrix;
    vec4 position = tmpModelMatrix * vertex;			
	gl_Position = ProjectionMatrix * osg_ViewMatrix * position;
		
	mat4 invModelMatrix = inverse(tmpModelMatrix);	
	vec3 lightPosition = (inverse(light_mv_matrix*invModelMatrix) * vec4(0.0,0.0,0.0,1.0)).xyz;	
	float ex_lightdistance = length(lightPosition - position.xyz);
	
	vec3 cameraPos = (inverse(osg_ViewMatrix) * vec4(0.0,0.0,0.0,1.0)).xyz;		
	
	mat3 tbnMatrix = mat3(in_tangent.x, in_binormal.x, normal.x,
	                      in_tangent.y, in_binormal.y, normal.y,
	                      in_tangent.z, in_binormal.z, normal.z);
	
	
	eyeVec = tbnMatrix*(invModelMatrix * vec4(cameraPos.xyz - position.xyz,1.0)).xyz;
	lightVec = tbnMatrix*(invModelMatrix * vec4(normalize(lightPosition.xyz-position.xyz),1.0)).xyz;
	
	
	p = position.xyz;	
	p.z = max(p.z,0.0);
	//p.z*=0.1;
	n = (transpose(invModelMatrix)*vec4(normal.xyz, 0.0)).xyz;    	
	uv = tex.xy;
	
	fragC = osg_ViewMatrix * position;
	
	viewPos = inverse(osg_ViewMatrix) * vec4(0.0,0.0,0.0,1.0);
		
	ex_lightdistance = length(lightPosition - position.xyz);	
	ex_shadowCoord = light_proj_matrix * light_mv_matrix * position;
	ex_lightdistance2 = (light_mv_matrix * position).y;
}
