#version 330 core
uniform sampler2D color_tex;
uniform sampler2D glare_tex;
uniform sampler3D lud_tex;
	
uniform mat4 ModelViewMatrix;
uniform mat4 ViewMatrix;
uniform mat4 ProjectionMatrix;

out vec4 out_color;

float A = 0.15;
float B = 0.50;
float C = 0.10;
float D = 0.20;
float E = 0.02;
float F = 0.30;
float W = 11.2;

vec3 Uncharted2Tonemap(vec3 x)
{
	return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}

//from NVIDIA SDK
float vignette(vec2 pos, float inner, float outer)
{
	float r = length(pos);
	r = 1.0 - smoothstep(inner, outer, r);
	return r;
}


void main()
{   			
	vec2 texCoord = gl_FragCoord.st / vec2(800.0, 600.0);	
	vec4 helper = texture(color_tex, texCoord);	
	
	vec4 avg4 = textureLod(color_tex, texCoord, 10.0);
	float avg = exp(avg4.w);
	float act =  (helper.r*0.2126 + helper.g*0.7152 + helper.b*0.0722);
	float l_scaled = act/avg*0.50;//*max(0.1, 1.5- 1.5/(avg*0.1+1.0));
	
	helper *= (l_scaled*(1.0+l_scaled/pow(2.5,2.0)))/(l_scaled+1.0);
	//helper *=  l_scaled / (l_scaled+1.0);
	
	//http://filmicgames.com/archives/75
	//float ExposureBias = 2.0f;
	//vec3 curr = Uncharted2Tonemap(ExposureBias*helper.xyz*1.0); 
	//vec3 curr = Uncharted2Tonemap(ExposureBias*vec3(l_scaled)*1.0); 	//Unchareted auf Idee von obrigen angewendet 
	//vec3 whiteScale = vec3(1.0)/Uncharted2Tonemap(vec3(W, W, W));
	//helper.xyz *= curr.x*whiteScale.x;
	//helper.xyz *= 2.5;
		
	vec4 glare = textureLod(glare_tex, texCoord,1.0)*0.2 + textureLod(glare_tex, texCoord,2.0) * 0.15 + textureLod(glare_tex, texCoord,3.0)*0.1  + textureLod(glare_tex, texCoord,4.0)*0.05;	
	helper += glare * glare.w*0.5;		
	
	//helper.xyz *= vignette(texCoord*2-1, 0.7, 1.5);	
	helper.xyz = clamp(helper.xyz,vec3(0.0), vec3(1.0));	
	helper.xyz = pow(helper.xyz,vec3(1.0/2.2));	//LUT darf nicht gamma sein.
	
	vec3 h = helper.xyz;		
	h.x = h.x*(1.0-1.0/(2.0*32.0) - (1.0/(2.0*32.0)))+ (1.0/(2.0*32.0));
	h.y = h.y*(1.0-1.0/(2.0*32.0) - (1.0/(2.0*32.0)))+ (1.0/(2.0*32.0));
	h.z = h.z*(1.0-1.0/(2.0*32.0) - (1.0/(2.0*32.0)))+ (1.0/(2.0*32.0));				
	vec4 tmp = texture(lud_tex, h.rgb);		
		
	helper.rgb = tmp.rgb;
	
	out_color.xyz = helper.xyz;
	out_color.w = 1.0;
	
	//if( texCoord.x < 0.24)		out_color.xyz = glare.xyz;
}

