#version 330 compatibility
uniform mat4 ModelMatrix;
uniform mat4 ViewMatrix;
uniform mat4 osg_ViewMatrix;
uniform mat4 ProjectionMatrix;
uniform mat4 NormalMatrix;
uniform mat4 LightMatrix;

layout (location = 0) in vec4 vertex;
layout (location = 1) in vec4 texCoords;
layout (location = 5) in vec4 in_normal;
layout (location = 6) in vec4 in_tangent;
layout (location = 7) in vec4 in_binormal;

// vertex-shader output variables (passed to fragment-shader)
out vec2 ex_texCoord;

out vec4 ambientColor;
out vec4 diffuseColor;
out vec4 specularColor;

out vec3 lightVec;
out vec3 eyeVec;

void main()
{	
	mat4 ModelMatrixtmp = inverse(osg_ViewMatrix) * gl_ModelViewMatrix;
	mat4 mvpMatrix = gl_ModelViewProjectionMatrix;
	vec4 worldVertex = ModelMatrixtmp * vertex;
	
	gl_Position = mvpMatrix*vertex;	
	ex_texCoord = texCoords.st;
	
	vec4 lightPos = inverse(LightMatrix) * vec4(0.0,0.0,0.0,1.0);
	vec3 lightDir = -normalize(lightPos.xyz);
	lightDir.z *= -1.0;

	mat3 tbnMatrix = mat3(in_tangent.x, in_binormal.x, in_normal.x,
	                      in_tangent.y, in_binormal.y, in_normal.y,
	                      in_tangent.z, in_binormal.z, in_normal.z);
						  
	mat4 invModelMatrix = inverse(ModelMatrixtmp);
	vec3 cameraPos = (inverse(osg_ViewMatrix)*vec4(0.0, 0.0, 0.0, 1.0)).xyz;
	eyeVec = tbnMatrix*normalize((invModelMatrix * vec4(cameraPos.xyz - worldVertex.xyz,1.0)).xyz);
	lightVec = tbnMatrix*(invModelMatrix * vec4(lightDir,1.0)).xyz;

	ambientColor = vec4(1.0) * 0.1;
	diffuseColor = vec4(1.0) * 1.0;
	specularColor = vec4(1.0) * 1.0;
}