#version 330 core
// uniform shader-parameters
//uniform mat4 ModelViewMatrix;
uniform mat4 osg_ViewMatrixInverse;
uniform vec3 v3LightPos;		// The direction vector to the light source
uniform vec3 v3InvWavelength;	// 1 / pow(wavelength, 4) for the red, green, and blue channels

uniform sampler2D color_tex;
uniform sampler2D normal_tex;
uniform sampler2D height_tex;

uniform int id;

// fragment-shader input variables
in vec2 ex_texCoord;
in vec4 ambientColor;
in vec4 diffuseColor;
in vec4 specularColor;
in vec3 lightVec;
in vec3 eyeVec;


// fragment-shader output variable (-> stored in the frame-buffer, i.e. "the pixel you see")
out vec4 out_color;
out vec4 out_color2;

void main()
{   	
	float scale = 0.01;

	vec3 E = normalize(eyeVec);
	vec3 L = normalize(lightVec);	
	
	/*E.xyz = E.xzy;
	E.x *= -1.0;
	E.y *= -1.0;
	
	L.xyz = L.xzy;
	L.x *= -1.0;
	L.y *= -1.0;*/
	
	
	float height = (scale * length(texture(color_tex, ex_texCoord))) - (scale * 0.5);
	vec2 nextTexCoord = (height * E.xy) + ex_texCoord.st;
	
	//Normalmap are converted as following:
	//normalmap(x,y,z) = (x,y,z)/2.0 + 0.5  
	vec4 offsetNormal = texture(normal_tex, nextTexCoord)*vec4(2.0)-vec4(1.0);	
	
	vec4 color;
	vec4 texel;	
	
	color = ambientColor*2.0;
	float NdotL = clamp(dot(offsetNormal.xyz, L), 0.0, 1.0);

	if (NdotL > 0.0) 
	{
		color += diffuseColor * NdotL;
		
		vec3 R = normalize(-reflect(L, offsetNormal.xyz));	
		float EdotR = clamp(dot(E, R), 0.0,1.0);
		color += specularColor * pow(EdotR, 10.0);
	}

	vec4 sampler = texture(color_tex, ex_texCoord.st);	
	out_color =  color*sampler*10.0;			
	out_color.w = sampler.r;		
	out_color2 = vec4(0.0, 0.0, 0.0, out_color.w);
	out_color2.x = id;
}